/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockFenceGate
extends BlockFacingHorizontal {
    public static final MapCodec<BlockFenceGate> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPropertyWood.a.fieldOf("wood_type").forGetter(fenceGateBlock -> fenceGateBlock.H), BlockFenceGate.t()).apply((Applicative)instance, BlockFenceGate::new));
    public static final BlockStateBoolean b = BlockProperties.z;
    public static final BlockStateBoolean c = BlockProperties.B;
    public static final BlockStateBoolean d = BlockProperties.u;
    protected static final VoxelShape e = Block.a(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape f = Block.a(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);
    protected static final VoxelShape g = Block.a(0.0, 0.0, 6.0, 16.0, 13.0, 10.0);
    protected static final VoxelShape h = Block.a(6.0, 0.0, 0.0, 10.0, 13.0, 16.0);
    protected static final VoxelShape i = Block.a(0.0, 0.0, 6.0, 16.0, 24.0, 10.0);
    protected static final VoxelShape j = Block.a(6.0, 0.0, 0.0, 10.0, 24.0, 16.0);
    protected static final VoxelShape k = Block.a(0.0, 5.0, 6.0, 16.0, 24.0, 10.0);
    protected static final VoxelShape l = Block.a(6.0, 5.0, 0.0, 10.0, 24.0, 16.0);
    protected static final VoxelShape m = VoxelShapes.a(Block.a(0.0, 5.0, 7.0, 2.0, 16.0, 9.0), Block.a(14.0, 5.0, 7.0, 16.0, 16.0, 9.0));
    protected static final VoxelShape n = VoxelShapes.a(Block.a(7.0, 5.0, 0.0, 9.0, 16.0, 2.0), Block.a(7.0, 5.0, 14.0, 9.0, 16.0, 16.0));
    protected static final VoxelShape o = VoxelShapes.a(Block.a(0.0, 2.0, 7.0, 2.0, 13.0, 9.0), Block.a(14.0, 2.0, 7.0, 16.0, 13.0, 9.0));
    protected static final VoxelShape G = VoxelShapes.a(Block.a(7.0, 2.0, 0.0, 9.0, 13.0, 2.0), Block.a(7.0, 2.0, 14.0, 9.0, 13.0, 16.0));
    private final BlockPropertyWood H;

    public MapCodec<BlockFenceGate> a() {
        return a;
    }

    public BlockFenceGate(BlockPropertyWood type, BlockBase.Info properties) {
        super(properties.a(type.d()));
        this.H = type;
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, false)).b(c, false)).b(d, false));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        if (state.c(d).booleanValue()) {
            return state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.a ? h : g;
        }
        return state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.a ? f : e;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        EnumDirection.EnumAxis axis = direction.o();
        if (state.c(BlockFacingHorizontal.aF).h().o() != axis) {
            return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }
        boolean flag = this.o(neighborState) || this.o(level.a_(pos.a(direction.g())));
        return (IBlockData)state.b(d, flag);
    }

    @Override
    protected VoxelShape b_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        if (state.c(b).booleanValue()) {
            return VoxelShapes.a();
        }
        return state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.c ? k : l;
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        if (state.c(b).booleanValue()) {
            return VoxelShapes.a();
        }
        return state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.c ? i : j;
    }

    @Override
    protected VoxelShape d_(IBlockData state) {
        if (state.c(d).booleanValue()) {
            return state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.a ? G : o;
        }
        return state.c(BlockFacingHorizontal.aF).o() == EnumDirection.EnumAxis.a ? n : m;
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        switch (pathComputationType) {
            case a: {
                return state.c(b);
            }
            case b: {
                return false;
            }
            case c: {
                return state.c(b);
            }
        }
        return false;
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        World level = context.q();
        BlockPosition clickedPos = context.a();
        boolean hasNeighborSignal = level.C(clickedPos);
        EnumDirection horizontalDirection = context.g();
        EnumDirection.EnumAxis axis = horizontalDirection.o();
        boolean flag = axis == EnumDirection.EnumAxis.c && (this.o(level.a_(clickedPos.h())) || this.o(level.a_(clickedPos.i()))) || axis == EnumDirection.EnumAxis.a && (this.o(level.a_(clickedPos.f())) || this.o(level.a_(clickedPos.g())));
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(BlockFacingHorizontal.aF, horizontalDirection)).b(b, hasNeighborSignal)).b(c, hasNeighborSignal)).b(d, flag);
    }

    private boolean o(IBlockData state) {
        return state.a(TagsBlock.N);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (state.c(b).booleanValue()) {
            state = (IBlockData)state.b(b, false);
            level.a(pos, state, 10);
        } else {
            EnumDirection direction = player.cO();
            if (state.c(BlockFacingHorizontal.aF) == direction.g()) {
                state = (IBlockData)state.b(BlockFacingHorizontal.aF, direction);
            }
            state = (IBlockData)state.b(b, true);
            level.a(pos, state, 10);
        }
        boolean openValue = state.c(b);
        level.a(player, pos, openValue ? this.H.g() : this.H.f(), SoundCategory.e, 1.0f, level.H_().i() * 0.1f + 0.9f);
        level.a((Entity)player, openValue ? GameEvent.h : GameEvent.d, pos);
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
        if (explosion.g() && !state.c(c).booleanValue()) {
            boolean openValue = state.c(b);
            level.b(pos, (IBlockData)state.b(b, !openValue));
            level.a(null, pos, openValue ? this.H.f() : this.H.g(), SoundCategory.e, 1.0f, level.H_().i() * 0.1f + 0.9f);
            level.a(openValue ? GameEvent.d : GameEvent.h, pos, GameEvent.a.a(state));
        }
        super.a(state, level, pos, explosion, dropConsumer);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (!level.C) {
            boolean hasNeighborSignal = level.C(pos);
            boolean oldPowered = state.c(c);
            if (oldPowered != hasNeighborSignal) {
                int newPower = hasNeighborSignal ? 15 : 0;
                int oldPower = oldPowered ? 15 : 0;
                CraftBlock bukkitBlock = CraftBlock.at(level, pos);
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)bukkitBlock, oldPower, newPower);
                level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = hasNeighborSignal = eventRedstone.getNewCurrent() > 0;
            }
            if (state.c(c) != hasNeighborSignal) {
                level.a(pos, (IBlockData)((IBlockData)state.b(c, hasNeighborSignal)).b(b, hasNeighborSignal), 2);
                if (state.c(b) != hasNeighborSignal) {
                    level.a(null, pos, hasNeighborSignal ? this.H.g() : this.H.f(), SoundCategory.e, 1.0f, level.H_().i() * 0.1f + 0.9f);
                    level.a(null, hasNeighborSignal ? GameEvent.h : GameEvent.d, pos);
                }
            }
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.aF, b, c, d);
    }

    public static boolean a(IBlockData state, EnumDirection direction) {
        return state.c(BlockFacingHorizontal.aF).o() == direction.h().o();
    }
}

