/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChestAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockEnderChest
extends BlockChestAbstract<TileEntityEnderChest>
implements IBlockWaterlogged {
    public static final MapCodec<BlockEnderChest> b = BlockEnderChest.b(BlockEnderChest::new);
    public static final BlockStateEnum<EnumDirection> c = BlockFacingHorizontal.aF;
    public static final BlockStateBoolean d = BlockProperties.J;
    protected static final VoxelShape e = Block.a(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    private static final IChatBaseComponent f = IChatBaseComponent.c("container.enderchest");

    @Override
    public MapCodec<BlockEnderChest> a() {
        return b;
    }

    protected BlockEnderChest(BlockBase.Info properties) {
        super(properties, () -> TileEntityTypes.d);
        this.l((IBlockData)((IBlockData)this.F.b().b(c, EnumDirection.c)).b(d, false));
    }

    @Override
    public DoubleBlockFinder.Result<? extends TileEntityChest> a(IBlockData state, World level, BlockPosition pos, boolean override) {
        return DoubleBlockFinder.Combiner::b;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return e;
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        return (IBlockData)((IBlockData)this.m().b(c, context.g().g())).b(d, fluidState.a() == FluidTypes.c);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity;
        InventoryEnderChest enderChestInventory = player.gw();
        if (enderChestInventory != null && (tileEntity = level.c_(pos)) instanceof TileEntityEnderChest) {
            TileEntityEnderChest enderChestBlockEntity = (TileEntityEnderChest)tileEntity;
            BlockPosition blockPos = pos.d();
            if (level.a_(blockPos).d(level, blockPos)) {
                return EnumInteractionResult.a;
            }
            enderChestInventory.a(enderChestBlockEntity);
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                if (player.a(new TileInventory((containerId, playerInventory, player1) -> ContainerChest.a(containerId, playerInventory, enderChestInventory), f)).isPresent()) {
                    player.a(StatisticList.aj);
                    PiglinAI.a(serverLevel, player, true);
                }
            }
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.a;
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityEnderChest(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return level.C ? BlockEnderChest.a(blockEntityType, TileEntityTypes.d, TileEntityEnderChest::a) : null;
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 3; ++i2) {
            int i1 = random.a(2) * 2 - 1;
            int i22 = random.a(2) * 2 - 1;
            double d2 = (double)pos.u() + 0.5 + 0.25 * (double)i1;
            double d1 = (float)pos.v() + random.i();
            double d22 = (double)pos.w() + 0.5 + 0.25 * (double)i22;
            double d3 = random.i() * (float)i1;
            double d4 = ((double)random.i() - 0.5) * 0.125;
            double d5 = random.i() * (float)i22;
            level.a(Particles.ae, d2, d1, d22, d3, d4, d5);
        }
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rot) {
        return (IBlockData)state.b(c, rot.a(state.c(c)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(c)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, d);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(d).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityEnderChest) {
            ((TileEntityEnderChest)blockEntity).b();
        }
    }
}

