/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class BlockEndGateway
extends BlockTileEntity
implements Portal {
    public static final MapCodec<BlockEndGateway> a = BlockEndGateway.b(BlockEndGateway::new);

    public MapCodec<BlockEndGateway> a() {
        return a;
    }

    protected BlockEndGateway(BlockBase.Info properties) {
        super(properties);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityEndGateway(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return BlockEndGateway.a(blockEntityType, TileEntityTypes.w, level.C ? TileEntityEndGateway::a : TileEntityEndGateway::b);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityEndGateway) {
            int particleAmount = ((TileEntityEndGateway)blockEntity).f();
            for (int i2 = 0; i2 < particleAmount; ++i2) {
                double d2 = (double)pos.u() + random.j();
                double d1 = (double)pos.v() + random.j();
                double d22 = (double)pos.w() + random.j();
                double d3 = (random.j() - 0.5) * 0.5;
                double d4 = (random.j() - 0.5) * 0.5;
                double d5 = (random.j() - 0.5) * 0.5;
                int i1 = random.a(2) * 2 - 1;
                if (random.h()) {
                    d22 = (double)pos.w() + 0.5 + 0.25 * (double)i1;
                    d5 = random.i() * 2.0f * (float)i1;
                } else {
                    d2 = (double)pos.u() + 0.5 + 0.25 * (double)i1;
                    d3 = random.i() * 2.0f * (float)i1;
                }
                level.a(Particles.ae, d2, d1, d22, d3, d4, d5);
            }
        }
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return ItemStack.j;
    }

    @Override
    protected boolean a(IBlockData state, FluidType fluid) {
        return false;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        TileEntityEndGateway theEndGatewayBlockEntity;
        TileEntity tileEntity;
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (entity.o(false) && !level.C && (tileEntity = level.c_(pos)) instanceof TileEntityEndGateway && !(theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity).c()) {
            EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)entity.getBukkitEntity(), new Location((org.bukkit.World)level.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w()), PortalType.END_GATEWAY);
            if (!event.callEvent()) {
                return;
            }
            entity.a(this, pos);
            TileEntityEndGateway.c(level, pos, state, theEndGatewayBlockEntity);
        }
    }

    @Override
    @Nullable
    public TeleportTransition a(WorldServer level, net.minecraft.world.entity.Entity entity, BlockPosition pos) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TileEntityEndGateway) {
            TileEntityEndGateway theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity;
            Vec3D portalPosition = theEndGatewayBlockEntity.a(level, pos);
            if (portalPosition == null) {
                return null;
            }
            return entity instanceof EntityEnderPearl ? new TeleportTransition(level, portalPosition, Vec3D.c, 0.0f, 0.0f, Set.of(), TeleportTransition.c, PlayerTeleportEvent.TeleportCause.END_GATEWAY) : new TeleportTransition(level, portalPosition, Vec3D.c, 0.0f, 0.0f, Relative.a(Relative.l, Relative.k), TeleportTransition.c, PlayerTeleportEvent.TeleportCause.END_GATEWAY);
        }
        return null;
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.a;
    }
}

