/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoorHinge;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockDoor
extends Block {
    public static final MapCodec<BlockDoor> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(BlockDoor::b), BlockDoor.t()).apply((Applicative)instance, BlockDoor::new));
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.aF;
    public static final BlockStateBoolean c = BlockProperties.z;
    public static final BlockStateEnum<BlockPropertyDoorHinge> d = BlockProperties.bh;
    public static final BlockStateBoolean e = BlockProperties.B;
    public static final BlockStateEnum<BlockPropertyDoubleBlockHalf> f = BlockProperties.ah;
    protected static final float g = 3.0f;
    protected static final VoxelShape h = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
    protected static final VoxelShape i = Block.a(0.0, 0.0, 13.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape j = Block.a(13.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape k = Block.a(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);
    private final BlockSetType l;

    public MapCodec<? extends BlockDoor> a() {
        return a;
    }

    protected BlockDoor(BlockSetType type, BlockBase.Info properties) {
        super(properties.a(type.g()));
        this.l = type;
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, EnumDirection.c)).b(c, false)).b(d, BlockPropertyDoorHinge.a)).b(e, false)).b(f, BlockPropertyDoubleBlockHalf.b));
    }

    public BlockSetType b() {
        return this.l;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        EnumDirection direction = state.c(b);
        boolean flag = state.c(c) == false;
        boolean flag1 = state.c(d) == BlockPropertyDoorHinge.b;
        return switch (direction) {
            case EnumDirection.d -> {
                if (flag) {
                    yield h;
                }
                if (flag1) {
                    yield k;
                }
                yield j;
            }
            case EnumDirection.e -> {
                if (flag) {
                    yield j;
                }
                if (flag1) {
                    yield h;
                }
                yield i;
            }
            case EnumDirection.c -> {
                if (flag) {
                    yield i;
                }
                if (flag1) {
                    yield j;
                }
                yield k;
            }
            default -> flag ? k : (flag1 ? i : h);
        };
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        BlockPropertyDoubleBlockHalf doubleBlockHalf = state.c(f);
        if (direction.o() != EnumDirection.EnumAxis.b || doubleBlockHalf == BlockPropertyDoubleBlockHalf.b != (direction == EnumDirection.b)) {
            return doubleBlockHalf == BlockPropertyDoubleBlockHalf.b && direction == EnumDirection.a && !state.a(level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }
        return neighborState.b() instanceof BlockDoor && neighborState.c(f) != doubleBlockHalf ? (IBlockData)neighborState.b(f, doubleBlockHalf) : Blocks.a.m();
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
        if (explosion.g() && state.c(f) == BlockPropertyDoubleBlockHalf.b && this.l.d() && !state.c(e).booleanValue()) {
            this.a(null, (World)level, state, pos, !this.n(state));
        }
        super.a(state, level, pos, explosion, dropConsumer);
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (!(level.C || !player.b() && player.d(state))) {
            BlockTallPlant.b(level, pos, state, player);
        }
        return super.a(level, pos, state, player);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return switch (pathComputationType) {
            default -> throw new MatchException(null, null);
            case PathMode.a, PathMode.c -> state.c(c);
            case PathMode.b -> false;
        };
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        BlockPosition clickedPos = context.a();
        World level = context.q();
        if (clickedPos.v() < level.an() && level.a_(clickedPos.d()).a(context)) {
            boolean flag = level.C(clickedPos) || level.C(clickedPos.d());
            return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(b, context.g())).b(d, this.b(context))).b(e, flag)).b(c, flag)).b(f, BlockPropertyDoubleBlockHalf.b);
        }
        return null;
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack stack) {
        level.a(pos.d(), (IBlockData)state.b(f, BlockPropertyDoubleBlockHalf.a), 3);
    }

    private BlockPropertyDoorHinge b(BlockActionContext context) {
        boolean flag1;
        World level = context.q();
        BlockPosition clickedPos = context.a();
        EnumDirection horizontalDirection = context.g();
        BlockPosition blockPos = clickedPos.d();
        EnumDirection counterClockWise = horizontalDirection.i();
        BlockPosition blockPos1 = clickedPos.a(counterClockWise);
        IBlockData blockState = level.a_(blockPos1);
        BlockPosition blockPos2 = blockPos.a(counterClockWise);
        IBlockData blockState1 = level.a_(blockPos2);
        EnumDirection clockWise = horizontalDirection.h();
        BlockPosition blockPos3 = clickedPos.a(clockWise);
        IBlockData blockState2 = level.a_(blockPos3);
        BlockPosition blockPos4 = blockPos.a(clockWise);
        IBlockData blockState3 = level.a_(blockPos4);
        int i2 = (blockState.m(level, blockPos1) ? -1 : 0) + (blockState1.m(level, blockPos2) ? -1 : 0) + (blockState2.m(level, blockPos3) ? 1 : 0) + (blockState3.m(level, blockPos4) ? 1 : 0);
        boolean flag = blockState.b() instanceof BlockDoor && blockState.c(f) == BlockPropertyDoubleBlockHalf.b;
        boolean bl = flag1 = blockState2.b() instanceof BlockDoor && blockState2.c(f) == BlockPropertyDoubleBlockHalf.b;
        if ((!flag || flag1) && i2 <= 0) {
            if ((!flag1 || flag) && i2 >= 0) {
                int stepX = horizontalDirection.j();
                int stepZ = horizontalDirection.l();
                Vec3D clickLocation = context.l();
                double d2 = clickLocation.d - (double)clickedPos.u();
                double d1 = clickLocation.f - (double)clickedPos.w();
                return !(stepX < 0 && d1 < 0.5 || stepX > 0 && d1 > 0.5 || stepZ < 0 && d2 > 0.5 || stepZ > 0 && d2 < 0.5) ? BlockPropertyDoorHinge.a : BlockPropertyDoorHinge.b;
            }
            return BlockPropertyDoorHinge.a;
        }
        return BlockPropertyDoorHinge.b;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (!this.l.c()) {
            return EnumInteractionResult.e;
        }
        state = (IBlockData)state.a(c);
        level.a(pos, state, 10);
        this.a(player, level, pos, (boolean)state.c(c));
        level.a((Entity)player, this.n(state) ? GameEvent.h : GameEvent.d, pos);
        return EnumInteractionResult.a;
    }

    public boolean n(IBlockData state) {
        return state.c(c);
    }

    public void a(@Nullable Entity entity, World level, IBlockData state, BlockPosition pos, boolean _open) {
        if (state.a(this) && state.c(c) != _open) {
            level.a(pos, (IBlockData)state.b(c, _open), 10);
            this.a(entity, level, pos, _open);
            level.a(entity, _open ? GameEvent.h : GameEvent.d, pos);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        int oldPower;
        BlockPosition otherHalf = pos.a(state.c(f) == BlockPropertyDoubleBlockHalf.b ? EnumDirection.b : EnumDirection.a);
        CraftBlock bukkitBlock = CraftBlock.at(level, pos);
        CraftBlock blockTop = CraftBlock.at(level, otherHalf);
        int power = bukkitBlock.getBlockPower();
        int powerTop = blockTop.getBlockPower();
        if (powerTop > power) {
            power = powerTop;
        }
        if ((oldPower = state.c(e) != false ? 15 : 0) == 0 ^ power == 0) {
            boolean flag;
            BlockRedstoneEvent event = new BlockRedstoneEvent((org.bukkit.block.Block)bukkitBlock, oldPower, power);
            event.callEvent();
            boolean bl = flag = event.getNewCurrent() > 0;
            if (flag != state.c(c)) {
                this.a(null, level, pos, flag);
                level.a(null, flag ? GameEvent.h : GameEvent.d, pos);
            }
            level.a(pos, (IBlockData)((IBlockData)state.b(e, flag)).b(c, flag), 2);
        }
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        IBlockData blockState = level.a_(blockPos);
        return state.c(f) == BlockPropertyDoubleBlockHalf.b ? blockState.c((IBlockAccess)level, blockPos, EnumDirection.b) : blockState.a(this);
    }

    private void a(@Nullable Entity source, World level, BlockPosition pos, boolean isOpening) {
        level.a(source, pos, isOpening ? this.l.i() : this.l.h(), SoundCategory.e, 1.0f, level.H_().i() * 0.1f + 0.9f);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return mirror == EnumBlockMirror.a ? state : (IBlockData)state.a(mirror.a(state.c(b))).a(d);
    }

    @Override
    protected long a(IBlockData state, BlockPosition pos) {
        return MathHelper.b(pos.u(), pos.c(state.c(f) == BlockPropertyDoubleBlockHalf.b ? 0 : 1).v(), pos.w());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(f, b, c, d, e);
    }

    public static boolean a(World level, BlockPosition pos) {
        return BlockDoor.o(level.a_(pos));
    }

    public static boolean o(IBlockData state) {
        BlockDoor doorBlock;
        Block block = state.b();
        return block instanceof BlockDoor && (doorBlock = (BlockDoor)block).b().c();
    }
}

