/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.BlockSoil;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;

public class BlockCrops
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockCrops> d = BlockCrops.b(BlockCrops::new);
    public static final int e = 7;
    public static final BlockStateInteger f = BlockProperties.ay;
    private static final VoxelShape[] a = new VoxelShape[]{Block.a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 6.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 10.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 14.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)};

    public MapCodec<? extends BlockCrops> a() {
        return d;
    }

    protected BlockCrops(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.F.b().b(this.b(), 0));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return a[this.h(state)];
    }

    @Override
    protected boolean b(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return state.a(Blocks.cK);
    }

    protected BlockStateInteger b() {
        return f;
    }

    public int c() {
        return 7;
    }

    public int h(IBlockData state) {
        return state.c(this.b());
    }

    public IBlockData b(int age) {
        return (IBlockData)this.m().b(this.b(), age);
    }

    public final boolean i(IBlockData state) {
        return this.h(state) >= this.c();
    }

    @Override
    protected boolean f(IBlockData state) {
        return !this.i(state);
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        int age;
        if (level.b(pos, 0) >= 9 && (age = this.h(state)) < this.c()) {
            float growthSpeed = BlockCrops.a(this, level, pos);
            int modifier = 100;
            if (this == Blocks.lf) {
                modifier = level.spigotConfig.beetrootModifier;
            } else if (this == Blocks.gP) {
                modifier = level.spigotConfig.carrotModifier;
            } else if (this == Blocks.gQ) {
                modifier = level.spigotConfig.potatoModifier;
            } else if (this == Blocks.lc) {
                modifier = level.spigotConfig.torchFlowerModifier;
            } else if (this == Blocks.cJ) {
                modifier = level.spigotConfig.wheatModifier;
            }
            if ((double)random.i() < (double)modifier / (100.0 * Math.floor(25.0f / growthSpeed + 1.0f))) {
                CraftEventFactory.handleBlockGrowEvent(level, pos, this.b(age + 1), 2);
            }
        }
    }

    public void a(World level, BlockPosition pos, IBlockData state) {
        int maxAge;
        int i2 = this.h(state) + this.a(level);
        if (i2 > (maxAge = this.c())) {
            i2 = maxAge;
        }
        CraftEventFactory.handleBlockGrowEvent(level, pos, this.b(i2), 2);
    }

    protected int a(World level) {
        return MathHelper.a(level.A, 2, 5);
    }

    protected static float a(Block block, IBlockAccess level, BlockPosition pos) {
        boolean flag1;
        float f2 = 1.0f;
        BlockPosition blockPos = pos.e();
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int i1 = -1; i1 <= 1; ++i1) {
                float f1 = 0.0f;
                IBlockData blockState = level.a_(blockPos.b(i2, 0, i1));
                if (blockState.a(Blocks.cK)) {
                    f1 = 1.0f;
                    if (blockState.c(BlockSoil.b) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (i2 != 0 || i1 != 0) {
                    f1 /= 4.0f;
                }
                f2 += f1;
            }
        }
        BlockPosition blockPos1 = pos.f();
        BlockPosition blockPos2 = pos.g();
        BlockPosition blockPos3 = pos.h();
        BlockPosition blockPos4 = pos.i();
        boolean flag = level.a_(blockPos3).a(block) || level.a_(blockPos4).a(block);
        boolean bl = flag1 = level.a_(blockPos1).a(block) || level.a_(blockPos2).a(block);
        if (flag && flag1) {
            f2 /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = level.a_(blockPos3.f()).a(block) || level.a_(blockPos4.f()).a(block) || level.a_(blockPos4.g()).a(block) || level.a_(blockPos3.g()).a(block);
            if (flag2) {
                f2 /= 2.0f;
            }
        }
        return f2;
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return BlockCrops.a(level, pos) && super.a(state, level, pos);
    }

    protected static boolean a(IWorldReader level, BlockPosition pos) {
        return level.b(pos, 0) >= 8;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (entity instanceof EntityRavager && CraftEventFactory.callEntityChangeBlockEvent(entity, pos, Blocks.a.m(), !serverLevel.O().b(GameRules.c))) {
                serverLevel.a(pos, true, entity);
            }
        }
        super.a(state, level, pos, entity);
    }

    protected IMaterial d() {
        return Items.qa;
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return new ItemStack(this.d());
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        return !this.i(state);
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        this.a((World)level, pos, state);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{f});
    }
}

