/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;

public class BlockButtonAbstract
extends BlockAttachable {
    public static final MapCodec<BlockButtonAbstract> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(buttonBlock -> buttonBlock.O), (App)Codec.intRange((int)1, (int)1024).fieldOf("ticks_to_stay_pressed").forGetter(buttonBlock -> buttonBlock.P), BlockButtonAbstract.t()).apply((Applicative)instance, BlockButtonAbstract::new));
    public static final BlockStateBoolean b = BlockProperties.B;
    private static final int M = 1;
    private static final int N = 2;
    protected static final int c = 2;
    protected static final int d = 3;
    protected static final VoxelShape e = Block.a(6.0, 14.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape f = Block.a(5.0, 14.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape g = Block.a(6.0, 0.0, 5.0, 10.0, 2.0, 11.0);
    protected static final VoxelShape h = Block.a(5.0, 0.0, 6.0, 11.0, 2.0, 10.0);
    protected static final VoxelShape i = Block.a(5.0, 6.0, 14.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape j = Block.a(5.0, 6.0, 0.0, 11.0, 10.0, 2.0);
    protected static final VoxelShape k = Block.a(14.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape l = Block.a(0.0, 6.0, 5.0, 2.0, 10.0, 11.0);
    protected static final VoxelShape m = Block.a(6.0, 15.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape n = Block.a(5.0, 15.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape o = Block.a(6.0, 0.0, 5.0, 10.0, 1.0, 11.0);
    protected static final VoxelShape G = Block.a(5.0, 0.0, 6.0, 11.0, 1.0, 10.0);
    protected static final VoxelShape H = Block.a(5.0, 6.0, 15.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape I = Block.a(5.0, 6.0, 0.0, 11.0, 10.0, 1.0);
    protected static final VoxelShape J = Block.a(15.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape K = Block.a(0.0, 6.0, 5.0, 1.0, 10.0, 11.0);
    private final BlockSetType O;
    private final int P;

    public MapCodec<BlockButtonAbstract> a() {
        return a;
    }

    protected BlockButtonAbstract(BlockSetType type, int ticksToStayPressed, BlockBase.Info properties) {
        super(properties.a(type.g()));
        this.O = type;
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(BlockFacingHorizontal.aF, EnumDirection.c)).b(b, false)).b(BlockAttachable.L, BlockPropertyAttachPosition.b));
        this.P = ticksToStayPressed;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        EnumDirection direction = state.c(BlockFacingHorizontal.aF);
        boolean poweredValue = state.c(b);
        switch (state.c(BlockAttachable.L)) {
            case a: {
                if (direction.o() == EnumDirection.EnumAxis.a) {
                    return poweredValue ? o : g;
                }
                return poweredValue ? G : h;
            }
            case b: {
                return switch (direction) {
                    default -> throw new MatchException(null, null);
                    case EnumDirection.f -> {
                        if (poweredValue) {
                            yield K;
                        }
                        yield l;
                    }
                    case EnumDirection.e -> {
                        if (poweredValue) {
                            yield J;
                        }
                        yield k;
                    }
                    case EnumDirection.d -> {
                        if (poweredValue) {
                            yield I;
                        }
                        yield j;
                    }
                    case EnumDirection.c, EnumDirection.b, EnumDirection.a -> poweredValue ? H : i;
                };
            }
        }
        if (direction.o() == EnumDirection.EnumAxis.a) {
            return poweredValue ? m : e;
        }
        return poweredValue ? n : f;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (state.c(b).booleanValue()) {
            return EnumInteractionResult.c;
        }
        boolean powered = state.c(b);
        org.bukkit.block.Block block = level.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
        level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0 != !powered) {
            return EnumInteractionResult.a;
        }
        this.a(state, level, pos, player);
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
        if (explosion.g() && !state.c(b).booleanValue()) {
            this.a(state, (World)level, pos, (EntityHuman)null);
        }
        super.a(state, level, pos, explosion, dropConsumer);
    }

    public void a(IBlockData state, World level, BlockPosition pos, @Nullable EntityHuman player) {
        level.a(pos, (IBlockData)state.b(b, true), 3);
        this.e(state, level, pos);
        level.a(pos, (Block)this, this.P);
        this.a(player, (GeneratorAccess)level, pos, true);
        level.a((net.minecraft.world.entity.Entity)player, GameEvent.a, pos);
    }

    protected void a(@Nullable EntityHuman player, GeneratorAccess level, BlockPosition pos, boolean hitByArrow) {
        level.a(hitByArrow ? player : null, pos, this.a(hitByArrow), SoundCategory.e);
    }

    protected SoundEffect a(boolean isOn) {
        return isOn ? this.O.o() : this.O.n();
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData newState, boolean isMoving) {
        if (!isMoving && !state.a(newState.b())) {
            if (state.c(b).booleanValue()) {
                this.e(state, level, pos);
            }
            super.a(state, level, pos, newState, isMoving);
        }
    }

    @Override
    protected int a(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return blockState.c(b) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return blockState.c(b) != false && BlockButtonAbstract.n(blockState) == side ? 15 : 0;
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (state.c(b).booleanValue()) {
            this.d(state, level, pos);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (!level.C && this.O.e() && !state.c(b).booleanValue()) {
            this.d(state, level, pos);
        }
    }

    protected void d(IBlockData state, World level, BlockPosition pos) {
        EntityArrow abstractArrow = this.O.e() ? (EntityArrow)level.a(EntityArrow.class, state.f(level, pos).a().a(pos)).stream().findFirst().orElse(null) : null;
        boolean flag = abstractArrow != null;
        boolean poweredValue = state.c(b);
        if (poweredValue != flag && flag) {
            org.bukkit.block.Block block = level.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            EntityInteractEvent event = new EntityInteractEvent((Entity)abstractArrow.getBukkitEntity(), block);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        if (flag != poweredValue) {
            boolean powered = poweredValue;
            org.bukkit.block.Block block = level.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
            level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (flag && eventRedstone.getNewCurrent() <= 0 || !flag && eventRedstone.getNewCurrent() > 0) {
                return;
            }
            level.a(pos, (IBlockData)state.b(b, flag), 3);
            this.e(state, level, pos);
            this.a(null, (GeneratorAccess)level, pos, flag);
            level.a((net.minecraft.world.entity.Entity)abstractArrow, flag ? GameEvent.a : GameEvent.e, pos);
        }
        if (flag) {
            level.a(new BlockPosition(pos), (Block)this, this.P);
        }
    }

    private void e(IBlockData state, World level, BlockPosition pos) {
        EnumDirection opposite;
        Orientation orientation = ExperimentalRedstoneUtils.a(level, opposite, (opposite = BlockButtonAbstract.n(state).g()).o().d() ? EnumDirection.b : state.c(BlockFacingHorizontal.aF));
        level.a(pos, (Block)this, orientation);
        level.a(pos.a(opposite), (Block)this, orientation);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.aF, b, BlockAttachable.L);
    }
}

