/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBellAttach;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;

public class BlockBell
extends BlockTileEntity {
    public static final MapCodec<BlockBell> a = BlockBell.b(BlockBell::new);
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.aF;
    public static final BlockStateEnum<BlockPropertyBellAttach> c = BlockProperties.Y;
    public static final BlockStateBoolean d = BlockProperties.B;
    private static final VoxelShape f = Block.a(0.0, 0.0, 4.0, 16.0, 16.0, 12.0);
    private static final VoxelShape g = Block.a(4.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    private static final VoxelShape h = Block.a(5.0, 6.0, 5.0, 11.0, 13.0, 11.0);
    private static final VoxelShape i = Block.a(4.0, 4.0, 4.0, 12.0, 6.0, 12.0);
    private static final VoxelShape j = VoxelShapes.a(i, h);
    private static final VoxelShape k = VoxelShapes.a(j, Block.a(7.0, 13.0, 0.0, 9.0, 15.0, 16.0));
    private static final VoxelShape l = VoxelShapes.a(j, Block.a(0.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape m = VoxelShapes.a(j, Block.a(0.0, 13.0, 7.0, 13.0, 15.0, 9.0));
    private static final VoxelShape n = VoxelShapes.a(j, Block.a(3.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape o = VoxelShapes.a(j, Block.a(7.0, 13.0, 0.0, 9.0, 15.0, 13.0));
    private static final VoxelShape G = VoxelShapes.a(j, Block.a(7.0, 13.0, 3.0, 9.0, 15.0, 16.0));
    private static final VoxelShape H = VoxelShapes.a(j, Block.a(7.0, 13.0, 7.0, 9.0, 16.0, 9.0));
    public static final int e = 1;

    public MapCodec<BlockBell> a() {
        return a;
    }

    public BlockBell(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, EnumDirection.c)).b(c, BlockPropertyBellAttach.a)).b(d, false));
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        boolean hasNeighborSignal = level.C(pos);
        if (hasNeighborSignal != state.c(d)) {
            if (hasNeighborSignal) {
                this.a(level, pos, null);
            }
            level.a(pos, (IBlockData)state.b(d, hasNeighborSignal), 3);
        }
    }

    @Override
    protected void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        Entity owner = projectile.p();
        EntityHuman player = owner instanceof EntityHuman ? (EntityHuman)owner : null;
        this.a(level, state, hit, player, true);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        return (EnumInteractionResult)((Object)(this.a(level, state, hitResult, player, true) ? EnumInteractionResult.a : EnumInteractionResult.e));
    }

    public boolean a(World level, IBlockData state, MovingObjectPositionBlock result, @Nullable EntityHuman player, boolean canRingBell) {
        boolean flag;
        EnumDirection direction = result.c();
        BlockPosition blockPos = result.b();
        boolean bl = flag = !canRingBell || this.a(state, direction, result.g().e - (double)blockPos.v());
        if (flag) {
            boolean flag1 = this.a(player, level, blockPos, direction);
            if (flag1 && player != null) {
                player.a(StatisticList.az);
            }
            return true;
        }
        return false;
    }

    private boolean a(IBlockData pos, EnumDirection direction, double distanceY) {
        if (direction.o() != EnumDirection.EnumAxis.b && !(distanceY > (double)0.8124f)) {
            EnumDirection direction1 = pos.c(b);
            BlockPropertyBellAttach bellAttachType = pos.c(c);
            switch (bellAttachType) {
                case a: {
                    return direction1.o() == direction.o();
                }
                case c: 
                case d: {
                    return direction1.o() != direction.o();
                }
                case b: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean a(World level, BlockPosition pos, @Nullable EnumDirection direction) {
        return this.a(null, level, pos, direction);
    }

    public boolean a(@Nullable Entity entity, World level, BlockPosition pos, @Nullable EnumDirection direction) {
        TileEntity blockEntity = level.c_(pos);
        if (!level.C && blockEntity instanceof TileEntityBell) {
            if (direction == null) {
                direction = level.a_(pos).c(b);
            }
            if (!CraftEventFactory.handleBellRingEvent(level, pos, direction, entity)) {
                return false;
            }
            ((TileEntityBell)blockEntity).a(direction);
            level.a(null, pos, SoundEffects.bZ, SoundCategory.e, 2.0f, 1.0f);
            level.a(entity, GameEvent.c, pos);
            return true;
        }
        return false;
    }

    private VoxelShape o(IBlockData state) {
        EnumDirection direction = state.c(b);
        BlockPropertyBellAttach bellAttachType = state.c(c);
        if (bellAttachType == BlockPropertyBellAttach.a) {
            return direction != EnumDirection.c && direction != EnumDirection.d ? g : f;
        }
        if (bellAttachType == BlockPropertyBellAttach.b) {
            return H;
        }
        if (bellAttachType == BlockPropertyBellAttach.d) {
            return direction != EnumDirection.c && direction != EnumDirection.d ? l : k;
        }
        if (direction == EnumDirection.c) {
            return o;
        }
        if (direction == EnumDirection.d) {
            return G;
        }
        return direction == EnumDirection.f ? n : m;
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.o(state);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.o(state);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        EnumDirection clickedFace = context.k();
        BlockPosition clickedPos = context.a();
        World level = context.q();
        EnumDirection.EnumAxis axis = clickedFace.o();
        if (axis == EnumDirection.EnumAxis.b) {
            IBlockData blockState = (IBlockData)((IBlockData)this.m().b(c, clickedFace == EnumDirection.a ? BlockPropertyBellAttach.b : BlockPropertyBellAttach.a)).b(b, context.g());
            if (blockState.a((IWorldReader)context.q(), clickedPos)) {
                return blockState;
            }
        } else {
            boolean flag = axis == EnumDirection.EnumAxis.a && level.a_(clickedPos.h()).c((IBlockAccess)level, clickedPos.h(), EnumDirection.f) && level.a_(clickedPos.i()).c((IBlockAccess)level, clickedPos.i(), EnumDirection.e) || axis == EnumDirection.EnumAxis.c && level.a_(clickedPos.f()).c((IBlockAccess)level, clickedPos.f(), EnumDirection.d) && level.a_(clickedPos.g()).c((IBlockAccess)level, clickedPos.g(), EnumDirection.c);
            IBlockData blockState = (IBlockData)((IBlockData)this.m().b(b, clickedFace.g())).b(c, flag ? BlockPropertyBellAttach.d : BlockPropertyBellAttach.c);
            if (blockState.a((IWorldReader)context.q(), context.a())) {
                return blockState;
            }
            boolean isFaceSturdy = level.a_(clickedPos.e()).c((IBlockAccess)level, clickedPos.e(), EnumDirection.b);
            if ((blockState = (IBlockData)blockState.b(c, isFaceSturdy ? BlockPropertyBellAttach.a : BlockPropertyBellAttach.b)).a((IWorldReader)context.q(), context.a())) {
                return blockState;
            }
        }
        return null;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
        if (explosion.g()) {
            this.a((World)level, pos, null);
        }
        super.a(state, level, pos, explosion, dropConsumer);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        BlockPropertyBellAttach bellAttachType = state.c(c);
        EnumDirection opposite = BlockBell.q(state).g();
        if (opposite == direction && !state.a(level, pos) && bellAttachType != BlockPropertyBellAttach.d) {
            return Blocks.a.m();
        }
        if (direction.o() == state.c(b).o()) {
            if (bellAttachType == BlockPropertyBellAttach.d && !neighborState.c((IBlockAccess)level, neighborPos, direction)) {
                return (IBlockData)((IBlockData)state.b(c, BlockPropertyBellAttach.c)).b(b, direction.g());
            }
            if (bellAttachType == BlockPropertyBellAttach.c && opposite.g() == direction && neighborState.c((IBlockAccess)level, neighborPos, state.c(b))) {
                return (IBlockData)state.b(c, BlockPropertyBellAttach.d);
            }
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        EnumDirection opposite = BlockBell.q(state).g();
        return opposite == EnumDirection.b ? Block.a(level, pos.d(), EnumDirection.a) : BlockAttachable.b(level, pos, opposite);
    }

    private static EnumDirection q(IBlockData state) {
        switch (state.c(c)) {
            case a: {
                return EnumDirection.b;
            }
            case b: {
                return EnumDirection.a;
            }
        }
        return state.c(b).g();
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityBell(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return BlockBell.a(blockEntityType, TileEntityTypes.F, level.C ? TileEntityBell::a : TileEntityBell::b);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }
}

