/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.block.PlayerShearBlockEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.ItemStack;

public class BlockBeehive
extends BlockTileEntity {
    public static final MapCodec<BlockBeehive> a = BlockBeehive.b(BlockBeehive::new);
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.aF;
    public static final BlockStateInteger c = BlockProperties.aQ;
    public static final int d = 5;
    private static final int e = 3;

    public MapCodec<BlockBeehive> a() {
        return a;
    }

    public BlockBeehive(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)this.F.b().b(c, 0)).b(b, EnumDirection.c));
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData blockState, World level, BlockPosition pos) {
        return blockState.c(c);
    }

    @Override
    public void playerDestroy(World level, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity te, net.minecraft.world.item.ItemStack stack, boolean includeDrops, boolean dropExp) {
        super.playerDestroy(level, player, pos, state, te, stack, includeDrops, dropExp);
        if (!level.C && te instanceof TileEntityBeehive) {
            TileEntityBeehive beehiveBlockEntity = (TileEntityBeehive)te;
            if (!EnchantmentManager.a(stack, EnchantmentTags.q)) {
                beehiveBlockEntity.a(player, state, TileEntityBeehive.ReleaseStatus.c);
                level.c(pos, this);
                this.b(level, pos);
            }
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<net.minecraft.world.item.ItemStack, BlockPosition> dropConsumer) {
        super.a(state, level, pos, explosion, dropConsumer);
        this.b(level, pos);
    }

    private void b(World level, BlockPosition pos) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos).c(8.0, 6.0, 8.0);
        List<EntityBee> entitiesOfClass = level.a(EntityBee.class, aabb);
        if (!entitiesOfClass.isEmpty()) {
            List<EntityHuman> entitiesOfClass1 = level.a(EntityHuman.class, aabb);
            if (entitiesOfClass1.isEmpty()) {
                return;
            }
            for (EntityBee bee : entitiesOfClass) {
                if (bee.O_() != null) continue;
                EntityHuman player = SystemUtils.a(entitiesOfClass1, level.A);
                bee.setTarget(player, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
            }
        }
    }

    public static void a(World level, BlockPosition pos) {
        BlockBeehive.a(level, pos, new net.minecraft.world.item.ItemStack(Items.xA, 3));
    }

    @Override
    protected EnumInteractionResult a(net.minecraft.world.item.ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        int honeyLevelValue = state.c(c);
        boolean flag = false;
        if (honeyLevelValue >= 5) {
            Item item = stack.h();
            if (stack.a(Items.sS)) {
                PlayerShearBlockEvent event = new PlayerShearBlockEvent((Player)player.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos), (ItemStack)CraftItemStack.asCraftMirror(stack), CraftEquipmentSlot.getHand(hand), new ArrayList());
                event.getDrops().add(CraftItemStack.asCraftMirror(new net.minecraft.world.item.ItemStack(Items.xA, 3)));
                if (!event.callEvent()) {
                    return EnumInteractionResult.e;
                }
                level.a(player, player.dA(), player.dC(), player.dG(), SoundEffects.bX, SoundCategory.e, 1.0f, 1.0f);
                for (ItemStack itemDrop : event.getDrops()) {
                    BlockBeehive.a(level, pos, CraftItemStack.asNMSCopy(itemDrop));
                }
                stack.a(1, (EntityLiving)player, EntityLiving.d(hand));
                flag = true;
                level.a((Entity)player, GameEvent.M, pos);
            } else if (stack.a(Items.th)) {
                stack.h(1);
                level.a(player, player.dA(), player.dC(), player.dG(), SoundEffects.cC, SoundCategory.e, 1.0f, 1.0f);
                if (stack.f()) {
                    player.a(hand, new net.minecraft.world.item.ItemStack(Items.xD));
                } else if (!player.gi().f(new net.minecraft.world.item.ItemStack(Items.xD))) {
                    player.a(new net.minecraft.world.item.ItemStack(Items.xD), false);
                }
                flag = true;
                level.a((Entity)player, GameEvent.y, pos);
            }
            if (!level.B_() && flag) {
                player.b(StatisticList.c.b(item));
            }
        }
        if (flag) {
            if (!BlockCampfire.a(level, pos)) {
                if (this.c(level, pos)) {
                    this.b(level, pos);
                }
                this.a(level, state, pos, player, TileEntityBeehive.ReleaseStatus.c);
            } else {
                this.a(level, state, pos);
            }
            return EnumInteractionResult.a;
        }
        return super.a(stack, state, level, pos, player, hand, hitResult);
    }

    private boolean c(World level, BlockPosition pos) {
        TileEntityBeehive beehiveBlockEntity;
        TileEntity tileEntity = level.c_(pos);
        return tileEntity instanceof TileEntityBeehive && !(beehiveBlockEntity = (TileEntityBeehive)tileEntity).c();
    }

    public void a(World level, IBlockData state, BlockPosition pos, @Nullable EntityHuman player, TileEntityBeehive.ReleaseStatus beeReleaseStatus) {
        this.a(level, state, pos);
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TileEntityBeehive) {
            TileEntityBeehive beehiveBlockEntity = (TileEntityBeehive)tileEntity;
            beehiveBlockEntity.a(player, state, beeReleaseStatus);
        }
    }

    public void a(World level, IBlockData state, BlockPosition pos) {
        level.a(pos, (IBlockData)state.b(c, 0), 3);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        if (state.c(c) >= 5) {
            for (int i2 = 0; i2 < random.a(1) + 1; ++i2) {
                this.a(level, pos, state);
            }
        }
    }

    private void a(World level, BlockPosition pos, IBlockData state) {
        VoxelShape collisionShape;
        double d2;
        if (state.y().c() && !(level.A.i() < 0.3f) && (d2 = (collisionShape = state.g(level, pos)).c(EnumDirection.EnumAxis.b)) >= 1.0 && !state.a(TagsBlock.ar)) {
            double d1 = collisionShape.b(EnumDirection.EnumAxis.b);
            if (d1 > 0.0) {
                this.a(level, pos, collisionShape, (double)pos.v() + d1 - 0.05);
            } else {
                BlockPosition blockPos = pos.e();
                IBlockData blockState = level.a_(blockPos);
                VoxelShape collisionShape1 = blockState.g(level, blockPos);
                double d22 = collisionShape1.c(EnumDirection.EnumAxis.b);
                if ((d22 < 1.0 || !blockState.m(level, blockPos)) && blockState.y().c()) {
                    this.a(level, pos, collisionShape, (double)pos.v() - 0.05);
                }
            }
        }
    }

    private void a(World level, BlockPosition pos, VoxelShape shape, double y2) {
        this.a(level, (double)pos.u() + shape.b(EnumDirection.EnumAxis.a), (double)pos.u() + shape.c(EnumDirection.EnumAxis.a), (double)pos.w() + shape.b(EnumDirection.EnumAxis.c), (double)pos.w() + shape.c(EnumDirection.EnumAxis.c), y2);
    }

    private void a(World particleData, double x1, double x2, double z1, double z2, double y2) {
        particleData.a(Particles.ax, MathHelper.d(particleData.A.j(), x1, x2), y2, MathHelper.d(particleData.A.j(), z1, z2), 0.0, 0.0, 0.0);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return (IBlockData)this.m().b(b, context.g().g());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, b);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityBeehive(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return level.C ? null : BlockBeehive.a(blockEntityType, TileEntityTypes.I, TileEntityBeehive::a);
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (level instanceof WorldServer) {
            TileEntity tileEntity;
            WorldServer serverLevel = (WorldServer)level;
            if (player.b() && serverLevel.O().b(GameRules.h) && (tileEntity = level.c_(pos)) instanceof TileEntityBeehive) {
                boolean flag;
                TileEntityBeehive beehiveBlockEntity = (TileEntityBeehive)tileEntity;
                int honeyLevelValue = state.c(c);
                boolean bl = flag = !beehiveBlockEntity.c();
                if (flag || honeyLevelValue > 0) {
                    net.minecraft.world.item.ItemStack itemStack = new net.minecraft.world.item.ItemStack(this);
                    itemStack.b(beehiveBlockEntity.q());
                    itemStack.b(DataComponents.am, BlockItemStateProperties.a.a(c, honeyLevelValue));
                    EntityItem itemEntity = new EntityItem(level, pos.u(), pos.v(), pos.w(), itemStack);
                    itemEntity.s();
                    level.b(itemEntity);
                }
            }
        }
        return super.a(level, pos, state, player);
    }

    @Override
    protected List<net.minecraft.world.item.ItemStack> a(IBlockData state, LootParams.a params) {
        TileEntity blockEntity;
        Entity entity = params.b(LootContextParameters.a);
        if ((entity instanceof EntityTNTPrimed || entity instanceof EntityCreeper || entity instanceof EntityWitherSkull || entity instanceof EntityWither || entity instanceof EntityMinecartTNT) && (blockEntity = params.b(LootContextParameters.h)) instanceof TileEntityBeehive) {
            TileEntityBeehive beehiveBlockEntity = (TileEntityBeehive)blockEntity;
            beehiveBlockEntity.a(null, state, TileEntityBeehive.ReleaseStatus.c);
        }
        return super.a(state, params);
    }

    @Override
    protected net.minecraft.world.item.ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        net.minecraft.world.item.ItemStack itemStack = super.a(level, pos, state, includeData);
        if (includeData) {
            itemStack.b(DataComponents.am, BlockItemStateProperties.a.a(c, state.c(c)));
        }
        return itemStack;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        TileEntity tileEntity;
        if (level.a_(neighborPos).b() instanceof BlockFire && (tileEntity = level.c_(pos)) instanceof TileEntityBeehive) {
            TileEntityBeehive beehiveBlockEntity = (TileEntityBeehive)tileEntity;
            beehiveBlockEntity.a(null, state, TileEntityBeehive.ReleaseStatus.c);
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    public void a(net.minecraft.world.item.ItemStack stack, Item.b context, List<IChatBaseComponent> tooltipComponents, TooltipFlag tooltipFlag) {
        super.a(stack, context, tooltipComponents, tooltipFlag);
        BlockItemStateProperties blockItemStateProperties = stack.a(DataComponents.am, BlockItemStateProperties.a);
        int i2 = Objects.requireNonNullElse(blockItemStateProperties.a(c), 0);
        int size = stack.a(DataComponents.an, List.of()).size();
        tooltipComponents.add(IChatBaseComponent.a("container.beehive.bees", size, 3).a(EnumChatFormat.h));
        tooltipComponents.add(IChatBaseComponent.a("container.beehive.honey", i2, 5).a(EnumChatFormat.h));
    }
}

