/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.player.PlayerBedFailEnterEvent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBed;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.entity.Player;

public class BlockBed
extends BlockFacingHorizontal
implements ITileEntity {
    public static final MapCodec<BlockBed> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumColor.q.fieldOf("color").forGetter(BlockBed::b), BlockBed.t()).apply((Applicative)instance, BlockBed::new));
    public static final BlockStateEnum<BlockPropertyBedPart> b = BlockProperties.be;
    public static final BlockStateBoolean c = BlockProperties.y;
    protected static final int d = 9;
    protected static final VoxelShape e = Block.a(0.0, 3.0, 0.0, 16.0, 9.0, 16.0);
    private static final int n = 3;
    protected static final VoxelShape f = Block.a(0.0, 0.0, 0.0, 3.0, 3.0, 3.0);
    protected static final VoxelShape g = Block.a(0.0, 0.0, 13.0, 3.0, 3.0, 16.0);
    protected static final VoxelShape h = Block.a(13.0, 0.0, 0.0, 16.0, 3.0, 3.0);
    protected static final VoxelShape i = Block.a(13.0, 0.0, 13.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape j = VoxelShapes.a(e, f, h);
    protected static final VoxelShape k = VoxelShapes.a(e, g, i);
    protected static final VoxelShape l = VoxelShapes.a(e, f, g);
    protected static final VoxelShape m = VoxelShapes.a(e, h, i);
    private final EnumColor o;

    public MapCodec<BlockBed> a() {
        return a;
    }

    public BlockBed(EnumColor color, BlockBase.Info properties) {
        super(properties);
        this.o = color;
        this.l((IBlockData)((IBlockData)this.F.b().b(b, BlockPropertyBedPart.b)).b(c, false));
    }

    @Nullable
    public static EnumDirection a(IBlockAccess level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos);
        return blockState.b() instanceof BlockBed ? blockState.c(BlockFacingHorizontal.aF) : null;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (level.C) {
            return EnumInteractionResult.b;
        }
        if (state.c(b) != BlockPropertyBedPart.a && !(state = level.a_(pos = pos.a(state.c(BlockFacingHorizontal.aF)))).a(this)) {
            return EnumInteractionResult.c;
        }
        if (state.c(c).booleanValue()) {
            if (!BlockBed.a(level)) {
                return this.explodeBed(state, level, pos);
            }
            if (!this.a(level, pos)) {
                player.a(IChatBaseComponent.c("block.minecraft.bed.occupied"), true);
            }
            return EnumInteractionResult.b;
        }
        IBlockData finalBlockState = state;
        BlockPosition finalBlockPos = pos;
        player.a(pos).ifLeft(bedSleepingProblem -> {
            if (bedSleepingProblem != null) {
                Component message;
                PlayerBedFailEnterEvent event = new PlayerBedFailEnterEvent((Player)player.getBukkitEntity(), PlayerBedFailEnterEvent.FailReason.values()[bedSleepingProblem.ordinal()], (org.bukkit.block.Block)CraftBlock.at(level, finalBlockPos), !level.G_().l(), PaperAdventure.asAdventure(bedSleepingProblem.a()));
                if (!event.callEvent()) {
                    return;
                }
                if (event.getWillExplode()) {
                    this.explodeBed(finalBlockState, level, finalBlockPos);
                } else if (bedSleepingProblem.a() != null && (message = event.getMessage()) != null) {
                    player.a(PaperAdventure.asVanilla(message), true);
                }
            }
        });
        return EnumInteractionResult.b;
    }

    private EnumInteractionResult explodeBed(IBlockData state, World level, BlockPosition pos) {
        BlockState blockState = CraftBlock.at(level, pos).getState();
        level.a(pos, false);
        BlockPosition blockPos = pos.a(state.c(BlockFacingHorizontal.aF).g());
        if (level.a_(blockPos).a(this)) {
            level.a(blockPos, false);
        }
        Vec3D center = pos.b();
        level.a(null, level.ak().a(center).causingBlockSnapshot(blockState), null, center, 5.0f, true, World.a.b);
        return EnumInteractionResult.b;
    }

    public static boolean a(World level) {
        return level.G_().l();
    }

    private boolean a(World level, BlockPosition pos) {
        List<EntityVillager> entitiesOfClass = level.a(EntityVillager.class, new AxisAlignedBB(pos), EntityLiving::fR);
        if (entitiesOfClass.isEmpty()) {
            return false;
        }
        entitiesOfClass.get(0).fS();
        return true;
    }

    @Override
    public void a(World level, IBlockData state, BlockPosition pos, Entity entity, float fallDistance) {
        super.a(level, state, pos, entity, fallDistance * 0.5f);
    }

    @Override
    public void a(IBlockAccess level, Entity entity) {
        if (entity.cf()) {
            super.a(level, entity);
        } else {
            this.a(entity);
        }
    }

    private void a(Entity entity) {
        Vec3D deltaMovement = entity.dy();
        if (deltaMovement.e < 0.0) {
            double d2 = entity instanceof EntityLiving ? 1.0 : 0.8;
            entity.n(deltaMovement.d, -deltaMovement.e * (double)0.66f * d2, deltaMovement.f);
        }
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (direction == BlockBed.a(state.c(b), state.c(BlockFacingHorizontal.aF))) {
            return neighborState.a(this) && neighborState.c(b) != state.c(b) ? (IBlockData)state.b(c, neighborState.c(c)) : Blocks.a.m();
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    private static EnumDirection a(BlockPropertyBedPart part, EnumDirection direction) {
        return part == BlockPropertyBedPart.b ? direction : direction.g();
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        BlockPosition blockPos;
        IBlockData blockState;
        BlockPropertyBedPart bedPart;
        if (!level.C && player.b() && (bedPart = state.c(b)) == BlockPropertyBedPart.b && (blockState = level.a_(blockPos = pos.a(BlockBed.a(bedPart, state.c(BlockFacingHorizontal.aF))))).a(this) && blockState.c(b) == BlockPropertyBedPart.a) {
            level.a(blockPos, Blocks.a.m(), 35);
            level.a(player, 2001, blockPos, Block.j(blockState));
        }
        return super.a(level, pos, state, player);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        EnumDirection horizontalDirection = context.g();
        BlockPosition clickedPos = context.a();
        BlockPosition blockPos = clickedPos.a(horizontalDirection);
        World level = context.q();
        return level.a_(blockPos).a(context) && level.F_().a(blockPos) ? (IBlockData)this.m().b(BlockFacingHorizontal.aF, horizontalDirection) : null;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        EnumDirection opposite = BlockBed.h(state).g();
        switch (opposite) {
            case c: {
                return j;
            }
            case d: {
                return k;
            }
            case e: {
                return l;
            }
        }
        return m;
    }

    public static EnumDirection h(IBlockData state) {
        EnumDirection direction = state.c(BlockFacingHorizontal.aF);
        return state.c(b) == BlockPropertyBedPart.a ? direction.g() : direction;
    }

    public static DoubleBlockFinder.BlockType i(IBlockData state) {
        BlockPropertyBedPart bedPart = state.c(b);
        return bedPart == BlockPropertyBedPart.a ? DoubleBlockFinder.BlockType.b : DoubleBlockFinder.BlockType.c;
    }

    private static boolean b(IBlockAccess level, BlockPosition pos) {
        return level.a_(pos.e()).b() instanceof BlockBed;
    }

    public static Optional<Vec3D> a(EntityTypes<?> entityType, ICollisionAccess collisionGetter, BlockPosition pos, EnumDirection direction, float yRot) {
        EnumDirection direction1;
        EnumDirection clockWise = direction.h();
        EnumDirection enumDirection = direction1 = clockWise.a(yRot) ? clockWise.g() : clockWise;
        if (BlockBed.b(collisionGetter, pos)) {
            return BlockBed.a(entityType, collisionGetter, pos, direction, direction1);
        }
        int[][] ints = BlockBed.a(direction, direction1);
        Optional<Vec3D> optional = BlockBed.a(entityType, collisionGetter, pos, ints, true);
        return optional.isPresent() ? optional : BlockBed.a(entityType, collisionGetter, pos, ints, false);
    }

    private static Optional<Vec3D> a(EntityTypes<?> entityType, ICollisionAccess collisionGetter, BlockPosition pos, EnumDirection stateFacing, EnumDirection entityFacing) {
        int[][] ints = BlockBed.b(stateFacing, entityFacing);
        Optional<Vec3D> optional = BlockBed.a(entityType, collisionGetter, pos, ints, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPosition blockPos = pos.e();
        Optional<Vec3D> optional1 = BlockBed.a(entityType, collisionGetter, blockPos, ints, true);
        if (optional1.isPresent()) {
            return optional1;
        }
        int[][] ints1 = BlockBed.a(stateFacing);
        Optional<Vec3D> optional2 = BlockBed.a(entityType, collisionGetter, pos, ints1, true);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional<Vec3D> optional3 = BlockBed.a(entityType, collisionGetter, pos, ints, false);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional<Vec3D> optional4 = BlockBed.a(entityType, collisionGetter, blockPos, ints, false);
        return optional4.isPresent() ? optional4 : BlockBed.a(entityType, collisionGetter, pos, ints1, false);
    }

    private static Optional<Vec3D> a(EntityTypes<?> entityType, ICollisionAccess collisionGetter, BlockPosition pos, int[][] offsets, boolean simulate) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int[] ints : offsets) {
            mutableBlockPos.d(pos.u() + ints[0], pos.v(), pos.w() + ints[1]);
            Vec3D vec3 = DismountUtil.a(entityType, collisionGetter, mutableBlockPos, simulate);
            if (vec3 == null) continue;
            return Optional.of(vec3);
        }
        return Optional.empty();
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.aF, b, c);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityBed(pos, state, this.o);
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack stack) {
        super.a(level, pos, state, placer, stack);
        if (!level.C) {
            BlockPosition blockPos = pos.a(state.c(BlockFacingHorizontal.aF));
            level.a(blockPos, (IBlockData)state.b(b, BlockPropertyBedPart.a), 3);
            if (level.captureBlockStates) {
                return;
            }
            level.b(pos, Blocks.a);
            state.a((GeneratorAccess)level, pos, 3);
        }
    }

    public EnumColor b() {
        return this.o;
    }

    @Override
    protected long a(IBlockData state, BlockPosition pos) {
        BlockPosition blockPos = pos.a(state.c(BlockFacingHorizontal.aF), state.c(b) == BlockPropertyBedPart.a ? 0 : 1);
        return MathHelper.b(blockPos.u(), pos.v(), blockPos.w());
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    private static int[][] a(EnumDirection firstDir, EnumDirection secondDir) {
        return (int[][])ArrayUtils.addAll((Object[])BlockBed.b(firstDir, secondDir), (Object[])BlockBed.a(firstDir));
    }

    private static int[][] b(EnumDirection firstDir, EnumDirection secondDir) {
        return new int[][]{{secondDir.j(), secondDir.l()}, {secondDir.j() - firstDir.j(), secondDir.l() - firstDir.l()}, {secondDir.j() - firstDir.j() * 2, secondDir.l() - firstDir.l() * 2}, {-firstDir.j() * 2, -firstDir.l() * 2}, {-secondDir.j() - firstDir.j() * 2, -secondDir.l() - firstDir.l() * 2}, {-secondDir.j() - firstDir.j(), -secondDir.l() - firstDir.l()}, {-secondDir.j(), -secondDir.l()}, {-secondDir.j() + firstDir.j(), -secondDir.l() + firstDir.l()}, {firstDir.j(), firstDir.l()}, {secondDir.j() + firstDir.j(), secondDir.l() + firstDir.l()}};
    }

    private static int[][] a(EnumDirection dir) {
        return new int[][]{{0, 0}, {-dir.j(), -dir.l()}};
    }
}

