/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;

public class BlockBamboo
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockBamboo> a = BlockBamboo.b(BlockBamboo::new);
    protected static final float b = 3.0f;
    protected static final float c = 5.0f;
    protected static final float d = 1.5f;
    protected static final VoxelShape e = Block.a(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    protected static final VoxelShape f = Block.a(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    protected static final VoxelShape g = Block.a(6.5, 0.0, 6.5, 9.5, 16.0, 9.5);
    public static final BlockStateInteger h = BlockProperties.at;
    public static final BlockStateEnum<BlockPropertyBambooSize> i = BlockProperties.bn;
    public static final BlockStateInteger j = BlockProperties.aX;
    public static final int k = 16;
    public static final int l = 0;
    public static final int m = 1;
    public static final int n = 0;
    public static final int o = 1;

    public MapCodec<BlockBamboo> a() {
        return a;
    }

    public BlockBamboo(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(h, 0)).b(i, BlockPropertyBambooSize.a)).b(j, 0));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(h, i, j);
    }

    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        VoxelShape voxelShape = state.c(i) == BlockPropertyBambooSize.c ? f : e;
        Vec3D offset = state.a(pos);
        return voxelShape.a(offset.d, offset.e, offset.f);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        Vec3D offset = state.a(pos);
        return g.a(offset.d, offset.e, offset.f);
    }

    @Override
    protected boolean a_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return false;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        if (!fluidState.c()) {
            return null;
        }
        IBlockData blockState = context.q().a_(context.a().e());
        if (blockState.a(TagsBlock.ax)) {
            if (blockState.a(Blocks.nA)) {
                return (IBlockData)this.m().b(h, 0);
            }
            if (blockState.a(Blocks.nB)) {
                int i2 = blockState.c(h) > 0 ? 1 : 0;
                return (IBlockData)this.m().b(h, i2);
            }
            IBlockData blockState1 = context.q().a_(context.a().d());
            return blockState1.a(Blocks.nB) ? (IBlockData)this.m().b(h, blockState1.c(h)) : Blocks.nA.m();
        }
        return null;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (!state.a((IWorldReader)level, pos)) {
            level.b(pos, true);
        }
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.c(j) == 0;
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        int i2;
        if (state.c(j) == 0 && random.i() < (float)level.spigotConfig.bambooModifier / 300.0f && level.u(pos.d()) && level.b(pos.d(), 0) >= 9 && (i2 = this.b(level, pos) + 1) < level.paperConfig().maxGrowthHeight.bamboo.max) {
            this.a(state, (World)level, pos, random, i2);
        }
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return level.a_(pos.e()).a(TagsBlock.ax);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (!state.a(level, pos)) {
            scheduledTickAccess.a(pos, this, 1);
        }
        return direction == EnumDirection.b && neighborState.a(Blocks.nB) && neighborState.c(h) > state.c(h) ? (IBlockData)state.a(h) : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        int heightBelowUpToMax;
        int heightAboveUpToMax = this.a((IBlockAccess)level, pos);
        return heightAboveUpToMax + (heightBelowUpToMax = this.b(level, pos)) + 1 < ((World)level).paperConfig().maxGrowthHeight.bamboo.max && level.a_(pos.b(heightAboveUpToMax)).c(j) != 1;
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        int heightAboveUpToMax = this.a((IBlockAccess)level, pos);
        int heightBelowUpToMax = this.b(level, pos);
        int i2 = heightAboveUpToMax + heightBelowUpToMax + 1;
        int i1 = 1 + random.a(2);
        for (int i22 = 0; i22 < i1; ++i22) {
            BlockPosition blockPos = pos.b(heightAboveUpToMax);
            IBlockData blockState = level.a_(blockPos);
            if (i2 >= level.paperConfig().maxGrowthHeight.bamboo.max || !blockState.a(Blocks.nB) || blockState.c(j) == 1 || !level.u(blockPos.d())) {
                return;
            }
            this.a(blockState, (World)level, blockPos, random, i2);
            ++heightAboveUpToMax;
            ++i2;
        }
    }

    @Override
    protected float a(IBlockData state, EntityHuman player, IBlockAccess level, BlockPosition pos) {
        return player.eZ().h() instanceof ItemSword ? 1.0f : super.a(state, player, level, pos);
    }

    protected void a(IBlockData state, World level, BlockPosition pos, RandomSource random, int age) {
        int i1;
        IBlockData blockState = level.a_(pos.e());
        BlockPosition blockPos = pos.c(2);
        IBlockData blockState1 = level.a_(blockPos);
        BlockPropertyBambooSize bambooLeaves = BlockPropertyBambooSize.a;
        boolean shouldUpdateOthers = false;
        if (age >= 1) {
            if (!blockState.a(Blocks.nB) || blockState.c(i) == BlockPropertyBambooSize.a) {
                bambooLeaves = BlockPropertyBambooSize.b;
            } else if (blockState.a(Blocks.nB) && blockState.c(i) != BlockPropertyBambooSize.a) {
                bambooLeaves = BlockPropertyBambooSize.c;
                if (blockState1.a(Blocks.nB)) {
                    shouldUpdateOthers = true;
                }
            }
        }
        int i2 = state.c(h) != 1 && !blockState1.a(Blocks.nB) ? 0 : 1;
        int n2 = i1 = (age < level.paperConfig().maxGrowthHeight.bamboo.min || random.i() >= 0.25f) && age != level.paperConfig().maxGrowthHeight.bamboo.max - 1 ? 0 : 1;
        if (CraftEventFactory.handleBlockSpreadEvent(level, pos, pos.d(), (IBlockData)((IBlockData)((IBlockData)this.m().b(h, i2)).b(i, bambooLeaves)).b(j, i1), 3) && shouldUpdateOthers) {
            level.a(pos.e(), (IBlockData)blockState.b(i, BlockPropertyBambooSize.b), 3);
            level.a(blockPos, (IBlockData)blockState1.b(i, BlockPropertyBambooSize.a), 3);
        }
    }

    protected int a(IBlockAccess level, BlockPosition pos) {
        int i2;
        for (i2 = 0; i2 < ((World)level).paperConfig().maxGrowthHeight.bamboo.max && level.a_(pos.b(i2 + 1)).a(Blocks.nB); ++i2) {
        }
        return i2;
    }

    protected int b(IBlockAccess level, BlockPosition pos) {
        int i2;
        for (i2 = 0; i2 < ((World)level).paperConfig().maxGrowthHeight.bamboo.max && level.a_(pos.c(i2 + 1)).a(Blocks.nB); ++i2) {
        }
        return i2;
    }
}

