/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class WorldChunkManagerMultiNoise
extends WorldChunkManager {
    private static final MapCodec<Holder<BiomeBase>> d = BiomeBase.c.fieldOf("biome");
    public static final MapCodec<Climate.c<Holder<BiomeBase>>> b = Climate.c.a(d).fieldOf("biomes");
    private static final MapCodec<Holder<MultiNoiseBiomeSourceParameterList>> e = MultiNoiseBiomeSourceParameterList.b.fieldOf("preset").withLifecycle(Lifecycle.stable());
    public static final MapCodec<WorldChunkManagerMultiNoise> c = Codec.mapEither(b, e).xmap(WorldChunkManagerMultiNoise::new, biomeSource -> biomeSource.f);
    private final Either<Climate.c<Holder<BiomeBase>>, Holder<MultiNoiseBiomeSourceParameterList>> f;

    private WorldChunkManagerMultiNoise(Either<Climate.c<Holder<BiomeBase>>, Holder<MultiNoiseBiomeSourceParameterList>> parameters) {
        this.f = parameters;
    }

    public static WorldChunkManagerMultiNoise a(Climate.c<Holder<BiomeBase>> parameters) {
        return new WorldChunkManagerMultiNoise(Either.left(parameters));
    }

    public static WorldChunkManagerMultiNoise a(Holder<MultiNoiseBiomeSourceParameterList> parameters) {
        return new WorldChunkManagerMultiNoise(Either.right(parameters));
    }

    private Climate.c<Holder<BiomeBase>> d() {
        return this.f.map(parameters -> parameters, parameterListHolder -> ((MultiNoiseBiomeSourceParameterList)parameterListHolder.a()).a());
    }

    @Override
    protected Stream<Holder<BiomeBase>> b() {
        return this.d().a().stream().map(Pair::getSecond);
    }

    @Override
    protected MapCodec<? extends WorldChunkManager> a() {
        return c;
    }

    public boolean a(ResourceKey<MultiNoiseBiomeSourceParameterList> resourceKey) {
        Optional<Holder<MultiNoiseBiomeSourceParameterList>> optional = this.f.right();
        return optional.isPresent() && optional.get().a(resourceKey);
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int x2, int y2, int z2, Climate.Sampler sampler) {
        return this.a(sampler.a(x2, y2, z2));
    }

    @VisibleForDebug
    public Holder<BiomeBase> a(Climate.h targetPoint) {
        return this.d().a(targetPoint);
    }

    @Override
    public void a(List<String> info, BlockPosition pos, Climate.Sampler sampler) {
        int quartPosX = QuartPos.a(pos.u());
        int quartPosY = QuartPos.a(pos.v());
        int quartPosZ = QuartPos.a(pos.w());
        Climate.h targetPoint = sampler.a(quartPosX, quartPosY, quartPosZ);
        float f2 = Climate.a(targetPoint.d());
        float f1 = Climate.a(targetPoint.e());
        float f22 = Climate.a(targetPoint.b());
        float f3 = Climate.a(targetPoint.c());
        float f4 = Climate.a(targetPoint.g());
        double d2 = NoiseRouterData.a(f4);
        OverworldBiomeBuilder overworldBiomeBuilder = new OverworldBiomeBuilder();
        info.add("Biome builder PV: " + OverworldBiomeBuilder.a(d2) + " C: " + overworldBiomeBuilder.b(f2) + " E: " + overworldBiomeBuilder.c(f1) + " T: " + overworldBiomeBuilder.d(f22) + " H: " + overworldBiomeBuilder.e(f3));
    }
}

