/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import org.slf4j.Logger;

public class BiomeSettingsMobs {
    private static final Logger d = LogUtils.getLogger();
    private static final float e = 0.1f;
    public static final WeightedRandomList<c> a = WeightedRandomList.c();
    public static final BiomeSettingsMobs b = new a().a();
    public static final MapCodec<BiomeSettingsMobs> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)0.9999999f).optionalFieldOf("creature_spawn_probability", (Object)Float.valueOf(0.1f)).forGetter(settings -> Float.valueOf(settings.f)), (App)Codec.simpleMap(EnumCreatureType.i, (Codec)WeightedRandomList.c(net.minecraft.world.level.biome.BiomeSettingsMobs$c.a).promotePartial(SystemUtils.a("Spawn data: ", arg_0 -> ((Logger)d).error(arg_0))), (Keyable)INamable.a(EnumCreatureType.values())).fieldOf("spawners").forGetter(settings -> settings.g), (App)Codec.simpleMap(BuiltInRegistries.f.q(), net.minecraft.world.level.biome.BiomeSettingsMobs$b.a, BuiltInRegistries.f).fieldOf("spawn_costs").forGetter(settings -> settings.h)).apply((Applicative)instance, BiomeSettingsMobs::new));
    private final float f;
    private final Map<EnumCreatureType, WeightedRandomList<c>> g;
    private final Map<EntityTypes<?>, b> h;

    BiomeSettingsMobs(float creatureGenerationProbability, Map<EnumCreatureType, WeightedRandomList<c>> spawners, Map<EntityTypes<?>, b> mobSpawnCosts) {
        this.f = creatureGenerationProbability;
        this.g = ImmutableMap.copyOf(spawners);
        this.h = ImmutableMap.copyOf(mobSpawnCosts);
    }

    public WeightedRandomList<c> a(EnumCreatureType category) {
        return this.g.getOrDefault(category, a);
    }

    @Nullable
    public b a(EntityTypes<?> entityType) {
        return this.h.get(entityType);
    }

    public float a() {
        return this.f;
    }

    public static final class b
    extends Record {
        private final double b;
        private final double c;
        public static final Codec<b> a = RecordCodecBuilder.create(codec -> codec.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(cost -> cost.b), (App)Codec.DOUBLE.fieldOf("charge").forGetter(cost -> cost.c)).apply((Applicative)codec, b::new));

        public b(double energyBudget, double charge) {
            this.b = energyBudget;
            this.c = charge;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "energyBudget;charge", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "energyBudget;charge", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "energyBudget;charge", "b", "c"}, this, o2);
        }

        public double a() {
            return this.b;
        }

        public double b() {
            return this.c;
        }
    }

    public static class c
    extends WeightedEntry.a {
        public static final Codec<c> a = RecordCodecBuilder.create(codec -> codec.group((App)BuiltInRegistries.f.q().fieldOf("type").forGetter(data -> data.b), (App)Weight.a.fieldOf("weight").forGetter(WeightedEntry.a::a), (App)ExtraCodecs.m.fieldOf("minCount").forGetter(data -> data.c), (App)ExtraCodecs.m.fieldOf("maxCount").forGetter(data -> data.d)).apply((Applicative)codec, c::new)).validate(spawnerData -> spawnerData.c > spawnerData.d ? DataResult.error(() -> "minCount needs to be smaller or equal to maxCount") : DataResult.success((Object)spawnerData));
        public final EntityTypes<?> b;
        public final int c;
        public final int d;

        public c(EntityTypes<?> type, int weight, int minCount, int maxCount) {
            this(type, Weight.a(weight), minCount, maxCount);
        }

        public c(EntityTypes<?> type, Weight weight, int minCount, int maxCount) {
            super(weight);
            this.b = type.f() == EnumCreatureType.h ? EntityTypes.aQ : type;
            this.c = minCount;
            this.d = maxCount;
        }

        public String toString() {
            return String.valueOf(EntityTypes.a(this.b)) + "*(" + this.c + "-" + this.d + "):" + String.valueOf(this.a());
        }
    }

    public static class a {
        private final Map<EnumCreatureType, List<c>> a = (Map)Stream.of(EnumCreatureType.values()).collect(Maps.toImmutableEnumMap(mobCategory -> mobCategory, mobCategory -> new MobList()));
        private final Map<EntityTypes<?>, b> b = Maps.newLinkedHashMap();
        private float c = 0.1f;

        public a a(EnumCreatureType classification, c spawner) {
            this.a.get(classification).add(spawner);
            return this;
        }

        public a a(EntityTypes<?> entityType, double charge, double energyBudget) {
            this.b.put(entityType, new b(energyBudget, charge));
            return this;
        }

        public a a(float probability) {
            this.c = probability;
            return this;
        }

        public BiomeSettingsMobs a() {
            return new BiomeSettingsMobs(this.c, (Map)this.a.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> WeightedRandomList.a((List)entry.getValue()))), (Map<EntityTypes<?>, b>)ImmutableMap.copyOf(this.b));
        }

        public static class MobList
        extends ArrayList<c> {
            Set<c> biomes = new HashSet<c>();

            @Override
            public boolean contains(Object o2) {
                return this.biomes.contains(o2);
            }

            @Override
            public boolean add(c BiomeSettingsMobs2) {
                this.biomes.add(BiomeSettingsMobs2);
                return super.add(BiomeSettingsMobs2);
            }

            @Override
            public c remove(int index) {
                c removed = (c)super.remove(index);
                if (removed != null) {
                    this.biomes.remove(removed);
                }
                return removed;
            }

            @Override
            public void clear() {
                this.biomes.clear();
                super.clear();
            }
        }
    }
}

