/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;

public class BiomeSettingsGeneration {
    private static final Logger c = LogUtils.getLogger();
    public static final BiomeSettingsGeneration a = new BiomeSettingsGeneration(HolderSet.a(new Holder[0]), List.of());
    public static final MapCodec<BiomeSettingsGeneration> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WorldGenCarverWrapper.c.promotePartial(SystemUtils.a("Carver: ", arg_0 -> ((Logger)c).error(arg_0))).fieldOf("carvers").forGetter(biomeGenerationSettings -> biomeGenerationSettings.d), (App)PlacedFeature.d.promotePartial(SystemUtils.a("Features: ", arg_0 -> ((Logger)c).error(arg_0))).fieldOf("features").forGetter(settings -> settings.e)).apply((Applicative)instance, BiomeSettingsGeneration::new));
    private final HolderSet<WorldGenCarverWrapper<?>> d;
    private final List<HolderSet<PlacedFeature>> e;
    private final Supplier<List<WorldGenFeatureConfigured<?, ?>>> f;
    private final Supplier<Set<PlacedFeature>> g;

    BiomeSettingsGeneration(HolderSet<WorldGenCarverWrapper<?>> carvers, List<HolderSet<PlacedFeature>> features) {
        this.d = carvers;
        this.e = features;
        this.f = Suppliers.memoize(() -> (List)features.stream().flatMap(HolderSet::a).map(Holder::a).flatMap(PlacedFeature::a).filter(features1 -> features1.b() == WorldGenerator.g).collect(ImmutableList.toImmutableList()));
        this.g = Suppliers.memoize(() -> features.stream().flatMap(HolderSet::a).map(Holder::a).collect(Collectors.toSet()));
    }

    public Iterable<Holder<WorldGenCarverWrapper<?>>> a() {
        return this.d;
    }

    public List<WorldGenFeatureConfigured<?, ?>> b() {
        return this.f.get();
    }

    public List<HolderSet<PlacedFeature>> c() {
        return this.e;
    }

    public boolean a(PlacedFeature feature) {
        return this.g.get().contains(feature);
    }

    public static class b {
        private final List<Holder<WorldGenCarverWrapper<?>>> a = new ArrayList();
        private final List<List<Holder<PlacedFeature>>> b = new ArrayList<List<Holder<PlacedFeature>>>();

        public b a(WorldGenStage.Decoration decoration, Holder<PlacedFeature> feature) {
            return this.a(decoration.ordinal(), feature);
        }

        public b a(int step, Holder<PlacedFeature> feature) {
            this.a(step);
            this.b.get(step).add(feature);
            return this;
        }

        public b a(Holder<WorldGenCarverWrapper<?>> carver) {
            this.a.add(carver);
            return this;
        }

        private void a(int step) {
            while (this.b.size() <= step) {
                this.b.add(Lists.newArrayList());
            }
        }

        public BiomeSettingsGeneration a() {
            return new BiomeSettingsGeneration(HolderSet.a(this.a), (List)this.b.stream().map(HolderSet::a).collect(ImmutableList.toImmutableList()));
        }
    }

    public static class a
    extends b {
        private final HolderGetter<PlacedFeature> a;
        private final HolderGetter<WorldGenCarverWrapper<?>> b;

        public a(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
            this.a = placedFeatures;
            this.b = worldCarvers;
        }

        public a a(WorldGenStage.Decoration decoration, ResourceKey<PlacedFeature> feature) {
            this.a(decoration.ordinal(), this.a.b(feature));
            return this;
        }

        public a a(ResourceKey<WorldGenCarverWrapper<?>> carver) {
            this.a(this.b.b(carver));
            return this;
        }
    }
}

