/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.INamable;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeParticles;
import net.minecraft.world.level.biome.CaveSound;
import net.minecraft.world.level.biome.CaveSoundSettings;

public class BiomeFog {
    public static final Codec<BiomeFog> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("fog_color").forGetter(effects -> effects.b), (App)Codec.INT.fieldOf("water_color").forGetter(effects -> effects.c), (App)Codec.INT.fieldOf("water_fog_color").forGetter(effects -> effects.d), (App)Codec.INT.fieldOf("sky_color").forGetter(effects -> effects.e), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(effects -> effects.f), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(effects -> effects.g), (App)GrassColor.d.optionalFieldOf("grass_color_modifier", (Object)GrassColor.a).forGetter(effects -> effects.h), (App)BiomeParticles.a.optionalFieldOf("particle").forGetter(effects -> effects.i), (App)SoundEffect.b.optionalFieldOf("ambient_sound").forGetter(effects -> effects.j), (App)CaveSoundSettings.a.optionalFieldOf("mood_sound").forGetter(effects -> effects.k), (App)CaveSound.a.optionalFieldOf("additions_sound").forGetter(effects -> effects.l), (App)SimpleWeightedRandomList.a(Music.a).optionalFieldOf("music").forGetter(effects -> effects.m), (App)Codec.FLOAT.fieldOf("music_volume").orElse((Object)Float.valueOf(1.0f)).forGetter(effects -> Float.valueOf(effects.n))).apply((Applicative)instance, BiomeFog::new));
    private final int b;
    private final int c;
    private final int d;
    private final int e;
    private final Optional<Integer> f;
    private final Optional<Integer> g;
    private final GrassColor h;
    private final Optional<BiomeParticles> i;
    private final Optional<Holder<SoundEffect>> j;
    private final Optional<CaveSoundSettings> k;
    private final Optional<CaveSound> l;
    private final Optional<SimpleWeightedRandomList<Music>> m;
    private final float n;

    BiomeFog(int fogColor, int waterColor, int waterFogColor, int skyColor, Optional<Integer> foliageColorOverride, Optional<Integer> grassColorOverride, GrassColor grassColorModifier, Optional<BiomeParticles> ambientParticleSettings, Optional<Holder<SoundEffect>> ambientLoopSoundEvent, Optional<CaveSoundSettings> ambientMoodSettings, Optional<CaveSound> ambientAdditionsSettings, Optional<SimpleWeightedRandomList<Music>> backgroundMusic, float backgroundMusicVolume) {
        this.b = fogColor;
        this.c = waterColor;
        this.d = waterFogColor;
        this.e = skyColor;
        this.f = foliageColorOverride;
        this.g = grassColorOverride;
        this.h = grassColorModifier;
        this.i = ambientParticleSettings;
        this.j = ambientLoopSoundEvent;
        this.k = ambientMoodSettings;
        this.l = ambientAdditionsSettings;
        this.m = backgroundMusic;
        this.n = backgroundMusicVolume;
    }

    public int a() {
        return this.b;
    }

    public int b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    public int d() {
        return this.e;
    }

    public Optional<Integer> e() {
        return this.f;
    }

    public Optional<Integer> f() {
        return this.g;
    }

    public GrassColor g() {
        return this.h;
    }

    public Optional<BiomeParticles> h() {
        return this.i;
    }

    public Optional<Holder<SoundEffect>> i() {
        return this.j;
    }

    public Optional<CaveSoundSettings> j() {
        return this.k;
    }

    public Optional<CaveSound> k() {
        return this.l;
    }

    public Optional<SimpleWeightedRandomList<Music>> l() {
        return this.m;
    }

    public float m() {
        return this.n;
    }

    public static abstract sealed class GrassColor
    extends Enum<GrassColor>
    implements INamable {
        public static final /* enum */ GrassColor a = new GrassColor("none"){

            @Override
            public int a(double x2, double z2, int grassColor) {
                return grassColor;
            }
        };
        public static final /* enum */ GrassColor b = new GrassColor("dark_forest"){

            @Override
            public int a(double x2, double z2, int grassColor) {
                return (grassColor & 0xFEFEFE) + 2634762 >> 1;
            }
        };
        public static final /* enum */ GrassColor c = new GrassColor("swamp"){

            @Override
            public int a(double x2, double z2, int grassColor) {
                double value = BiomeBase.e.a(x2 * 0.0225, z2 * 0.0225, false);
                return value < -0.1 ? 5011004 : 6975545;
            }
        };
        private final String e;
        public static final Codec<GrassColor> d;
        private static final /* synthetic */ GrassColor[] f;

        public static GrassColor[] values() {
            return (GrassColor[])f.clone();
        }

        public static GrassColor valueOf(String name) {
            return Enum.valueOf(GrassColor.class, name);
        }

        public abstract int a(double var1, double var3, int var5);

        private GrassColor(String name) {
            this.e = name;
        }

        public String a() {
            return this.e;
        }

        @Override
        public String c() {
            return this.e;
        }

        private static /* synthetic */ GrassColor[] b() {
            return new GrassColor[]{a, b, c};
        }

        static {
            f = GrassColor.b();
            d = INamable.a(GrassColor::values);
        }
    }

    public static class a {
        private OptionalInt a = OptionalInt.empty();
        private OptionalInt b = OptionalInt.empty();
        private OptionalInt c = OptionalInt.empty();
        private OptionalInt d = OptionalInt.empty();
        private Optional<Integer> e = Optional.empty();
        private Optional<Integer> f = Optional.empty();
        private GrassColor g = GrassColor.a;
        private Optional<BiomeParticles> h = Optional.empty();
        private Optional<Holder<SoundEffect>> i = Optional.empty();
        private Optional<CaveSoundSettings> j = Optional.empty();
        private Optional<CaveSound> k = Optional.empty();
        private Optional<SimpleWeightedRandomList<Music>> l = Optional.empty();
        private float m = 1.0f;

        public a a(int fogColor) {
            this.a = OptionalInt.of(fogColor);
            return this;
        }

        public a b(int waterColor) {
            this.b = OptionalInt.of(waterColor);
            return this;
        }

        public a c(int waterFogColor) {
            this.c = OptionalInt.of(waterFogColor);
            return this;
        }

        public a d(int skyColor) {
            this.d = OptionalInt.of(skyColor);
            return this;
        }

        public a e(int foliageColorOverride) {
            this.e = Optional.of(foliageColorOverride);
            return this;
        }

        public a f(int grassColorOverride) {
            this.f = Optional.of(grassColorOverride);
            return this;
        }

        public a a(GrassColor grassColorModifier) {
            this.g = grassColorModifier;
            return this;
        }

        public a a(BiomeParticles ambientParticle) {
            this.h = Optional.of(ambientParticle);
            return this;
        }

        public a a(Holder<SoundEffect> ambientLoopSoundEvent) {
            this.i = Optional.of(ambientLoopSoundEvent);
            return this;
        }

        public a a(CaveSoundSettings ambientMoodSettings) {
            this.j = Optional.of(ambientMoodSettings);
            return this;
        }

        public a a(CaveSound ambientAdditionsSettings) {
            this.k = Optional.of(ambientAdditionsSettings);
            return this;
        }

        public a a(@Nullable Music backgroundMusic) {
            if (backgroundMusic == null) {
                this.l = Optional.empty();
                return this;
            }
            this.l = Optional.of(SimpleWeightedRandomList.a(backgroundMusic));
            return this;
        }

        public a a() {
            return this.a(SimpleWeightedRandomList.b()).a(0.0f);
        }

        public a a(SimpleWeightedRandomList<Music> backgroundMusic) {
            this.l = Optional.of(backgroundMusic);
            return this;
        }

        public a a(float backgroundMusicVolume) {
            this.m = backgroundMusicVolume;
            return this;
        }

        public BiomeFog b() {
            return new BiomeFog(this.a.orElseThrow(() -> new IllegalStateException("Missing 'fog' color.")), this.b.orElseThrow(() -> new IllegalStateException("Missing 'water' color.")), this.c.orElseThrow(() -> new IllegalStateException("Missing 'water fog' color.")), this.d.orElseThrow(() -> new IllegalStateException("Missing 'sky' color.")), this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l, this.m);
        }
    }
}

