/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.util.MCUtil;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public abstract class MobSpawnerAbstract {
    public static final String b = "SpawnData";
    private static final Logger a = LogUtils.getLogger();
    private static final int c = 1;
    public int d = 20;
    public SimpleWeightedRandomList<MobSpawnerData> e = SimpleWeightedRandomList.b();
    @Nullable
    public MobSpawnerData f;
    private double g;
    private double h;
    public int i = 200;
    public int j = 800;
    public int k = 4;
    @Nullable
    private Entity l;
    public int m = 6;
    public int n = 16;
    public int o = 4;
    private int tickDelay = 0;

    public void a(EntityTypes<?> type, @Nullable World level, RandomSource random, BlockPosition pos) {
        this.a(level, random, pos).a().a("id", BuiltInRegistries.f.b(type).toString());
        this.e = SimpleWeightedRandomList.b();
    }

    public boolean c(World level, BlockPosition pos) {
        return level.hasNearbyAlivePlayerThatAffectsSpawning((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, this.n);
    }

    public void a(World level, BlockPosition pos) {
        if (!this.c(level, pos)) {
            this.h = this.g;
        } else if (this.l != null) {
            RandomSource random = level.H_();
            double d2 = (double)pos.u() + random.j();
            double d1 = (double)pos.v() + random.j();
            double d22 = (double)pos.w() + random.j();
            level.a(Particles.ag, d2, d1, d22, 0.0, 0.0, 0.0);
            level.a(Particles.F, d2, d1, d22, 0.0, 0.0, 0.0);
            if (this.d > 0) {
                --this.d;
            }
            this.h = this.g;
            this.g = (this.g + (double)(1000.0f / ((float)this.d + 200.0f))) % 360.0;
        }
    }

    public void a(WorldServer serverLevel, BlockPosition pos) {
        if (this.k <= 0 || this.m <= 0) {
            return;
        }
        if (this.d > 0 && --this.tickDelay > 0) {
            return;
        }
        this.tickDelay = serverLevel.paperConfig().tickRates.mobSpawner;
        if (this.tickDelay == -1) {
            return;
        }
        if (this.c(serverLevel, pos)) {
            if (this.d < -this.tickDelay) {
                this.d(serverLevel, pos);
            }
            if (this.d > 0) {
                this.d -= this.tickDelay;
            } else {
                boolean flag = false;
                RandomSource random = serverLevel.H_();
                MobSpawnerData nextSpawnData = this.a((World)serverLevel, random, pos);
                for (int i2 = 0; i2 < this.k; ++i2) {
                    MobSpawnerData.a customSpawnRules;
                    double d2;
                    NBTTagCompound entityToSpawn = nextSpawnData.a();
                    Optional<EntityTypes<?>> optional = EntityTypes.a(entityToSpawn);
                    if (optional.isEmpty()) {
                        this.d(serverLevel, pos);
                        return;
                    }
                    NBTTagList list = entityToSpawn.c("Pos", 6);
                    int size = list.size();
                    double d3 = size >= 1 ? list.h(0) : (double)pos.u() + (random.j() - random.j()) * (double)this.o + 0.5;
                    double d1 = size >= 2 ? list.h(1) : (double)(pos.v() + random.a(3) - 1);
                    double d4 = d2 = size >= 3 ? list.h(2) : (double)pos.w() + (random.j() - random.j()) * (double)this.o + 0.5;
                    if (!serverLevel.b(optional.get().a(d3, d1, d2))) continue;
                    BlockPosition blockPos = BlockPosition.a(d3, d1, d2);
                    if (!nextSpawnData.b().isPresent() ? !EntityPositionTypes.a(optional.get(), serverLevel, EntitySpawnReason.c, blockPos, serverLevel.H_()) : !optional.get().f().d() && serverLevel.am() == EnumDifficulty.a || !(customSpawnRules = nextSpawnData.b().get()).a(blockPos, serverLevel)) continue;
                    PreSpawnerSpawnEvent event = new PreSpawnerSpawnEvent(MCUtil.toLocation(serverLevel, d3, d1, d2), CraftEntityType.minecraftToBukkit(optional.get()), MCUtil.toLocation(serverLevel, pos));
                    if (!event.callEvent()) {
                        flag = true;
                        if (!event.shouldAbortSpawn()) continue;
                        break;
                    }
                    Entity entity = EntityTypes.a(entityToSpawn, (World)serverLevel, EntitySpawnReason.c, (Entity entity1) -> {
                        entity1.b(d3, d1, d2, entity1.dL(), entity1.dN());
                        return entity1;
                    });
                    if (entity == null) {
                        this.d(serverLevel, pos);
                        return;
                    }
                    int size1 = serverLevel.a(EntityTypeTest.b(entity.getClass()), new AxisAlignedBB(pos.u(), pos.v(), pos.w(), pos.u() + 1, pos.v() + 1, pos.w() + 1).g(this.o), IEntitySelector.f).size();
                    if (size1 >= this.m) {
                        this.d(serverLevel, pos);
                        return;
                    }
                    entity.preserveMotion = true;
                    entity.b(entity.dA(), entity.dC(), entity.dG(), random.i() * 360.0f, 0.0f);
                    if (entity instanceof EntityInsentient) {
                        boolean flag1;
                        EntityInsentient mob = (EntityInsentient)entity;
                        if (nextSpawnData.b().isEmpty() && !mob.a((GeneratorAccess)serverLevel, EntitySpawnReason.c) || !mob.a((IWorldReader)serverLevel)) continue;
                        boolean bl = flag1 = nextSpawnData.a().f() == 1 && nextSpawnData.a().b("id", 8);
                        if (flag1) {
                            ((EntityInsentient)entity).a((WorldAccess)serverLevel, serverLevel.d_(entity.dv()), EntitySpawnReason.c, null);
                        }
                        nextSpawnData.c().ifPresent(mob::a);
                        if (mob.dV().spigotConfig.nerfSpawnerMobs) {
                            mob.aware = false;
                        }
                    }
                    entity.spawnedViaMobSpawner = true;
                    entity.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                    flag = true;
                    if (CraftEventFactory.callSpawnerSpawnEvent(entity, pos).isCancelled()) continue;
                    if (!serverLevel.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                        this.d(serverLevel, pos);
                        return;
                    }
                    serverLevel.c(2004, pos, 0);
                    serverLevel.a(entity, GameEvent.t, blockPos);
                    if (!(entity instanceof EntityInsentient)) continue;
                    ((EntityInsentient)entity).V();
                }
                if (flag) {
                    this.d(serverLevel, pos);
                }
            }
        }
    }

    public void d(World level, BlockPosition pos) {
        RandomSource randomSource = level.A;
        this.d = this.j <= this.i ? this.i : this.i + randomSource.a(this.j - this.i);
        this.e.b(randomSource).ifPresent(data -> this.a(level, pos, (MobSpawnerData)data.b()));
        this.a(level, pos, 1);
    }

    public void a(@Nullable World level, BlockPosition pos, NBTTagCompound tag) {
        boolean flag1;
        this.d = tag.e("Paper.Delay") ? tag.h("Paper.Delay") : (int)tag.g("Delay");
        boolean flag = tag.b(b, 10);
        if (flag) {
            MobSpawnerData spawnData = MobSpawnerData.b.parse((DynamicOps)DynamicOpsNBT.a, (Object)tag.p(b)).resultOrPartial(data -> a.warn("Invalid SpawnData: {}", data)).orElseGet(MobSpawnerData::new);
            this.a(level, pos, spawnData);
        }
        if (flag1 = tag.b("SpawnPotentials", 9)) {
            NBTTagList list = tag.c("SpawnPotentials", 10);
            this.e = MobSpawnerData.c.parse((DynamicOps)DynamicOpsNBT.a, (Object)list).resultOrPartial(potentials -> a.warn("Invalid SpawnPotentials list: {}", potentials)).orElseGet(SimpleWeightedRandomList::b);
        } else {
            this.e = SimpleWeightedRandomList.a(this.f != null ? this.f : new MobSpawnerData());
        }
        if (tag.b("Paper.MinSpawnDelay", 99)) {
            this.i = tag.h("Paper.MinSpawnDelay");
            this.j = tag.h("Paper.MaxSpawnDelay");
            this.k = tag.g("SpawnCount");
        } else if (tag.b("MinSpawnDelay", 99)) {
            this.i = tag.h("MinSpawnDelay");
            this.j = tag.h("MaxSpawnDelay");
            this.k = tag.g("SpawnCount");
        }
        if (tag.b("MaxNearbyEntities", 99)) {
            this.m = tag.g("MaxNearbyEntities");
            this.n = tag.g("RequiredPlayerRange");
        }
        if (tag.b("SpawnRange", 99)) {
            this.o = tag.g("SpawnRange");
        }
        this.l = null;
    }

    public NBTTagCompound a(NBTTagCompound tag) {
        if (this.d > Short.MAX_VALUE) {
            tag.a("Paper.Delay", this.d);
        }
        tag.a("Delay", (short)Math.min(Short.MAX_VALUE, this.d));
        if (this.i > Short.MAX_VALUE || this.j > Short.MAX_VALUE) {
            tag.a("Paper.MinSpawnDelay", this.i);
            tag.a("Paper.MaxSpawnDelay", this.j);
        }
        tag.a("MinSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.i));
        tag.a("MaxSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.j));
        tag.a("SpawnCount", (short)this.k);
        tag.a("MaxNearbyEntities", (short)this.m);
        tag.a("RequiredPlayerRange", (short)this.n);
        tag.a("SpawnRange", (short)this.o);
        if (this.f != null) {
            tag.a(b, (NBTBase)MobSpawnerData.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.f).getOrThrow(string -> new IllegalStateException("Invalid SpawnData: " + string)));
        }
        tag.a("SpawnPotentials", (NBTBase)MobSpawnerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, this.e).getOrThrow());
        return tag;
    }

    @Nullable
    public Entity b(World level, BlockPosition pos) {
        if (this.l == null) {
            NBTTagCompound entityToSpawn = this.a(level, level.H_(), pos).a();
            if (!entityToSpawn.b("id", 8)) {
                return null;
            }
            this.l = EntityTypes.a(entityToSpawn, level, EntitySpawnReason.c, Function.identity());
            if (entityToSpawn.f() != 1 || this.l instanceof EntityInsentient) {
                // empty if block
            }
        }
        return this.l;
    }

    public boolean a(World level, int id) {
        if (id == 1) {
            if (level.C) {
                this.d = this.i;
            }
            return true;
        }
        return false;
    }

    public void a(@Nullable World level, BlockPosition pos, MobSpawnerData nextSpawnData) {
        this.f = nextSpawnData;
    }

    private MobSpawnerData a(@Nullable World level, RandomSource random, BlockPosition pos) {
        if (this.f != null) {
            return this.f;
        }
        this.a(level, pos, this.e.b(random).map(WeightedEntry.b::b).orElseGet(MobSpawnerData::new));
        return this.f;
    }

    public abstract void a(World var1, BlockPosition var2, int var3);

    public double a() {
        return this.g;
    }

    public double b() {
        return this.h;
    }
}

