/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;

public interface IBlockAccess
extends LevelHeightAccessor {
    public static final int g = 16;

    @Nullable
    public TileEntity c_(BlockPosition var1);

    default public <T extends TileEntity> Optional<T> a(BlockPosition pos, TileEntityTypes<T> blockEntityType) {
        TileEntity blockEntity = this.c_(pos);
        return blockEntity != null && blockEntity.p() == blockEntityType ? Optional.of(blockEntity) : Optional.empty();
    }

    public IBlockData a_(BlockPosition var1);

    @Nullable
    public IBlockData getBlockStateIfLoaded(BlockPosition var1);

    @Nullable
    default public Block getBlockIfLoaded(BlockPosition blockposition) {
        IBlockData type = this.getBlockStateIfLoaded(blockposition);
        return type == null ? null : type.b();
    }

    @Nullable
    public Fluid getFluidIfLoaded(BlockPosition var1);

    public Fluid b_(BlockPosition var1);

    default public int i(BlockPosition pos) {
        return this.a_(pos).k();
    }

    default public Stream<IBlockData> a(AxisAlignedBB area) {
        return BlockPosition.b(area).map(this::a_);
    }

    default public MovingObjectPositionBlock a(ClipBlockStateContext context) {
        return IBlockAccess.a(context.b(), context.a(), context, (traverseContext, traversePos) -> {
            IBlockData blockState = this.a_((BlockPosition)traversePos);
            Vec3D vec3 = traverseContext.b().d(traverseContext.a());
            return traverseContext.c().test(blockState) ? new MovingObjectPositionBlock(traverseContext.a(), EnumDirection.a(vec3.d, vec3.e, vec3.f), BlockPosition.a(traverseContext.a()), false) : null;
        }, failContext -> {
            Vec3D vec3 = failContext.b().d(failContext.a());
            return MovingObjectPositionBlock.a(failContext.a(), EnumDirection.a(vec3.d, vec3.e, vec3.f), BlockPosition.a(failContext.a()));
        });
    }

    default public MovingObjectPositionBlock clip(RayTrace traverseContext, BlockPosition traversePos) {
        return this.clip(traverseContext, traversePos, null);
    }

    default public MovingObjectPositionBlock clip(RayTrace traverseContext, BlockPosition traversePos, Predicate<? super org.bukkit.block.Block> canCollide) {
        GeneratorAccess levelAccessor;
        IBlockAccess iBlockAccess;
        IBlockData blockState = this.getBlockStateIfLoaded(traversePos);
        if (blockState == null) {
            Vec3D vec3d = traverseContext.b().d(traverseContext.a());
            return MovingObjectPositionBlock.a(traverseContext.a(), EnumDirection.a(vec3d.d, vec3d.e, vec3d.f), BlockPosition.a(traverseContext.a()));
        }
        if (blockState.l() || canCollide != null && (iBlockAccess = this) instanceof GeneratorAccess && !canCollide.test(CraftBlock.at(levelAccessor = (GeneratorAccess)iBlockAccess, traversePos))) {
            return null;
        }
        Fluid fluidState = blockState.y();
        Vec3D from = traverseContext.b();
        Vec3D to = traverseContext.a();
        VoxelShape blockShape = traverseContext.a(blockState, this, traversePos);
        MovingObjectPositionBlock blockHitResult = this.a(from, to, traversePos, blockShape, blockState);
        VoxelShape fluidShape = traverseContext.a(fluidState, this, traversePos);
        MovingObjectPositionBlock blockHitResult1 = fluidShape.a(from, to, traversePos);
        double d2 = blockHitResult == null ? Double.MAX_VALUE : traverseContext.b().g(blockHitResult.g());
        double d1 = blockHitResult1 == null ? Double.MAX_VALUE : traverseContext.b().g(blockHitResult1.g());
        return d2 <= d1 ? blockHitResult : blockHitResult1;
    }

    default public MovingObjectPositionBlock a(RayTrace context) {
        return this.clip(context, (Predicate<? super org.bukkit.block.Block>)null);
    }

    default public MovingObjectPositionBlock clip(RayTrace context, Predicate<? super org.bukkit.block.Block> canCollide) {
        return IBlockAccess.a(context.b(), context.a(), context, (raytrace1, blockposition) -> this.clip((RayTrace)raytrace1, (BlockPosition)blockposition, canCollide), failContext -> {
            Vec3D vec3 = failContext.b().d(failContext.a());
            return MovingObjectPositionBlock.a(failContext.a(), EnumDirection.a(vec3.d, vec3.e, vec3.f), BlockPosition.a(failContext.a()));
        });
    }

    @Nullable
    default public MovingObjectPositionBlock a(Vec3D startVec, Vec3D endVec, BlockPosition pos, VoxelShape shape, IBlockData state) {
        MovingObjectPositionBlock blockHitResult1;
        MovingObjectPositionBlock blockHitResult = shape.a(startVec, endVec, pos);
        if (blockHitResult != null && (blockHitResult1 = state.i(this, pos).a(startVec, endVec, pos)) != null && blockHitResult1.g().d(startVec).h() < blockHitResult.g().d(startVec).h()) {
            return blockHitResult.a(blockHitResult1.c());
        }
        return blockHitResult;
    }

    default public double a(VoxelShape shape, Supplier<VoxelShape> belowShapeSupplier) {
        if (!shape.c()) {
            return shape.c(EnumDirection.EnumAxis.b);
        }
        double d2 = belowShapeSupplier.get().c(EnumDirection.EnumAxis.b);
        return d2 >= 1.0 ? d2 - 1.0 : Double.NEGATIVE_INFINITY;
    }

    default public double j(BlockPosition pos) {
        return this.a(this.a_(pos).g(this, pos), () -> {
            BlockPosition blockPos = pos.e();
            return this.a_(blockPos).g(this, blockPos);
        });
    }

    public static <T, C> T a(Vec3D from, Vec3D to, C context, BiFunction<C, BlockPosition, T> tester, Function<C, T> onFail) {
        int floor2;
        int floor1;
        if (from.equals(to)) {
            return onFail.apply(context);
        }
        double d2 = MathHelper.d(-1.0E-7, to.d, from.d);
        double d1 = MathHelper.d(-1.0E-7, to.e, from.e);
        double d22 = MathHelper.d(-1.0E-7, to.f, from.f);
        double d3 = MathHelper.d(-1.0E-7, from.d, to.d);
        double d4 = MathHelper.d(-1.0E-7, from.e, to.e);
        double d5 = MathHelper.d(-1.0E-7, from.f, to.f);
        int floor = MathHelper.a(d3);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(floor, floor1 = MathHelper.a(d4), floor2 = MathHelper.a(d5));
        T object = tester.apply(context, mutableBlockPos);
        if (object != null) {
            return object;
        }
        double d6 = d2 - d3;
        double d7 = d1 - d4;
        double d8 = d22 - d5;
        int i2 = MathHelper.j(d6);
        int i1 = MathHelper.j(d7);
        int i22 = MathHelper.j(d8);
        double d9 = i2 == 0 ? Double.MAX_VALUE : (double)i2 / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = i22 == 0 ? Double.MAX_VALUE : (double)i22 / d8;
        double d12 = d9 * (i2 > 0 ? 1.0 - MathHelper.e(d3) : MathHelper.e(d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - MathHelper.e(d4) : MathHelper.e(d4));
        double d14 = d11 * (i22 > 0 ? 1.0 - MathHelper.e(d5) : MathHelper.e(d5));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T object1;
            if (d12 < d13) {
                if (d12 < d14) {
                    floor += i2;
                    d12 += d9;
                } else {
                    floor2 += i22;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                floor1 += i1;
                d13 += d10;
            } else {
                floor2 += i22;
                d14 += d11;
            }
            if ((object1 = tester.apply(context, mutableBlockPos.d(floor, floor1, floor2))) == null) continue;
            return object1;
        }
        return onFail.apply(context);
    }

    public static Iterable<BlockPosition> a(Vec3D oldPosition, Vec3D position, AxisAlignedBB boundingBox) {
        Vec3D vec3 = position.d(oldPosition);
        Iterable<BlockPosition> iterable = BlockPosition.a(boundingBox);
        if (vec3.h() < (double)MathHelper.l(0.99999f)) {
            return iterable;
        }
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet();
        Vec3D minPosition = boundingBox.h();
        Vec3D vec31 = minPosition.d(vec3);
        IBlockAccess.a((Set<BlockPosition>)set, vec31, minPosition, boundingBox);
        for (BlockPosition blockPos : iterable) {
            set.add(blockPos.j());
        }
        return set;
    }

    private static void a(Set<BlockPosition> output, Vec3D start, Vec3D end, AxisAlignedBB boundingBox) {
        Vec3D vec3 = end.d(start);
        int floor = MathHelper.a(start.d);
        int floor1 = MathHelper.a(start.e);
        int floor2 = MathHelper.a(start.f);
        int i2 = MathHelper.j(vec3.d);
        int i1 = MathHelper.j(vec3.e);
        int i22 = MathHelper.j(vec3.f);
        double d2 = i2 == 0 ? Double.MAX_VALUE : (double)i2 / vec3.d;
        double d1 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / vec3.e;
        double d22 = i22 == 0 ? Double.MAX_VALUE : (double)i22 / vec3.f;
        double d3 = d2 * (i2 > 0 ? 1.0 - MathHelper.e(start.d) : MathHelper.e(start.d));
        double d4 = d1 * (i1 > 0 ? 1.0 - MathHelper.e(start.e) : MathHelper.e(start.e));
        double d5 = d22 * (i22 > 0 ? 1.0 - MathHelper.e(start.f) : MathHelper.e(start.f));
        int i3 = 0;
        while (d3 <= 1.0 || d4 <= 1.0 || d5 <= 1.0) {
            if (d3 < d4) {
                if (d3 < d5) {
                    floor += i2;
                    d3 += d2;
                } else {
                    floor2 += i22;
                    d5 += d22;
                }
            } else if (d4 < d5) {
                floor1 += i1;
                d4 += d1;
            } else {
                floor2 += i22;
                d5 += d22;
            }
            if (i3++ > 16) break;
            Optional<Vec3D> optional = AxisAlignedBB.a(floor, floor1, floor2, floor + 1, floor1 + 1, floor2 + 1, start, end);
            if (optional.isEmpty()) continue;
            Vec3D vec31 = optional.get();
            double d6 = MathHelper.a(vec31.d, (double)((float)floor + 1.0E-5f), (double)floor + 1.0 - (double)1.0E-5f);
            double d7 = MathHelper.a(vec31.e, (double)((float)floor1 + 1.0E-5f), (double)floor1 + 1.0 - (double)1.0E-5f);
            double d8 = MathHelper.a(vec31.f, (double)((float)floor2 + 1.0E-5f), (double)floor2 + 1.0 - (double)1.0E-5f);
            int floor3 = MathHelper.a(d6 + boundingBox.b());
            int floor4 = MathHelper.a(d7 + boundingBox.c());
            int floor5 = MathHelper.a(d8 + boundingBox.d());
            for (int i4 = floor; i4 <= floor3; ++i4) {
                for (int i5 = floor1; i5 <= floor4; ++i5) {
                    for (int i6 = floor2; i6 <= floor5; ++i6) {
                        output.add(new BlockPosition(i4, i5, i6));
                    }
                }
            }
        }
    }
}

