/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicLike;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import org.bukkit.GameRule;
import org.slf4j.Logger;

public class GameRules {
    private static final boolean DISABLE_LIMITS = Boolean.getBoolean("paper.disableGameRuleLimits");
    public static final int a = 3;
    static final Logger ac = LogUtils.getLogger();
    private static final Map<GameRuleKey<?>, GameRuleDefinition<?>> ad = Maps.newTreeMap(Comparator.comparing(entry -> entry.a));
    public static final GameRuleKey<GameRuleBoolean> b = GameRules.a("doFireTick", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> c = GameRules.a("mobGriefing", GameRuleCategory.b, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> d = GameRules.a("keepInventory", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> e = GameRules.a("doMobSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> f = GameRules.a("doMobLoot", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> g = GameRules.a("projectilesCanBreakBlocks", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> h = GameRules.a("doTileDrops", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> i = GameRules.a("doEntityDrops", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> j = GameRules.a("commandBlockOutput", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> k = GameRules.a("naturalRegeneration", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> l = GameRules.a("doDaylightCycle", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> m = GameRules.a("logAdminCommands", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> n = GameRules.a("showDeathMessages", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> o = GameRules.a("randomTickSpeed", GameRuleCategory.e, GameRuleInt.a(3));
    public static final GameRuleKey<GameRuleBoolean> p = GameRules.a("sendCommandFeedback", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> q = GameRules.a("reducedDebugInfo", GameRuleCategory.g, GameRuleBoolean.a(false, (WorldServer level, GameRuleBoolean value) -> {
        byte b2 = (byte)(value.a() ? 22 : 23);
        for (EntityPlayer serverPlayer : level.z()) {
            serverPlayer.f.b(new PacketPlayOutEntityStatus(serverPlayer, b2));
        }
    }));
    public static final GameRuleKey<GameRuleBoolean> r = GameRules.a("spectatorsGenerateChunks", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> s = GameRules.a("spawnRadius", GameRuleCategory.a, GameRuleInt.a(10));
    public static final GameRuleKey<GameRuleBoolean> t = GameRules.a("disablePlayerMovementCheck", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> u = GameRules.a("disableElytraMovementCheck", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> v = GameRules.a("maxEntityCramming", GameRuleCategory.b, GameRuleInt.a(24));
    public static final GameRuleKey<GameRuleBoolean> w = GameRules.a("doWeatherCycle", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> x = GameRules.a("doLimitedCrafting", GameRuleCategory.a, GameRuleBoolean.a(false, (WorldServer level, GameRuleBoolean value) -> {
        for (EntityPlayer serverPlayer : level.z()) {
            serverPlayer.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.n, value.a() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleInt> y = GameRules.a("maxCommandChainLength", GameRuleCategory.g, GameRuleInt.a(65536));
    public static final GameRuleKey<GameRuleInt> z = GameRules.a("maxCommandForkCount", GameRuleCategory.g, GameRuleInt.a(65536));
    public static final GameRuleKey<GameRuleInt> A = GameRules.a("commandModificationBlockLimit", GameRuleCategory.g, GameRuleInt.a(32768));
    public static final GameRuleKey<GameRuleBoolean> B = GameRules.a("announceAdvancements", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> C = GameRules.a("disableRaids", GameRuleCategory.b, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> D = GameRules.a("doInsomnia", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> E = GameRules.a("doImmediateRespawn", GameRuleCategory.a, GameRuleBoolean.a(false, (WorldServer level, GameRuleBoolean value) -> {
        for (EntityPlayer serverPlayer : level.z()) {
            serverPlayer.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.m, value.a() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleInt> F = GameRules.a("playersNetherPortalDefaultDelay", GameRuleCategory.a, GameRuleInt.a(80));
    public static final GameRuleKey<GameRuleInt> G = GameRules.a("playersNetherPortalCreativeDelay", GameRuleCategory.a, GameRuleInt.a(0));
    public static final GameRuleKey<GameRuleBoolean> H = GameRules.a("drowningDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> I = GameRules.a("fallDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> J = GameRules.a("fireDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> K = GameRules.a("freezeDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> L = GameRules.a("doPatrolSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> M = GameRules.a("doTraderSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> N = GameRules.a("doWardenSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> O = GameRules.a("forgiveDeadPlayers", GameRuleCategory.b, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> P = GameRules.a("universalAnger", GameRuleCategory.b, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> Q = GameRules.a("playersSleepingPercentage", GameRuleCategory.a, GameRuleInt.a(100));
    public static final GameRuleKey<GameRuleBoolean> R = GameRules.a("blockExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> S = GameRules.a("mobExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> T = GameRules.a("tntExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> U = GameRules.a("snowAccumulationHeight", GameRuleCategory.e, GameRuleInt.a(1));
    public static final GameRuleKey<GameRuleBoolean> V = GameRules.a("waterSourceConversion", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> W = GameRules.a("lavaSourceConversion", GameRuleCategory.e, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> X = GameRules.a("globalSoundEvents", GameRuleCategory.g, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> Y = GameRules.a("doVinesSpread", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> Z = GameRules.a("enderPearlsVanishOnDeath", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> aa = GameRules.a("minecartMaxSpeed", GameRuleCategory.g, GameRuleInt.a(8, 1, GameRules.limit(1000, Integer.MAX_VALUE), FeatureFlagSet.a(FeatureFlags.d), (server, value) -> {}));
    public static final GameRuleKey<GameRuleInt> ab = GameRules.a("spawnChunkRadius", GameRuleCategory.g, GameRuleInt.a(2, 0, GameRules.limit(32, Integer.MAX_VALUE), FeatureFlagSet.a(), (level, value) -> {
        WorldServer serverLevel = level;
        serverLevel.a(serverLevel.Z(), serverLevel.aa());
    }));
    private final Map<GameRuleKey<?>, GameRuleValue<?>> ae;
    private final FeatureFlagSet af;
    private final GameRuleValue<?>[] gameruleArray;

    private static int limit(int limit, int unlimited) {
        return DISABLE_LIMITS ? unlimited : limit;
    }

    private static <T extends GameRuleValue<T>> GameRuleKey<T> a(String name, GameRuleCategory category, GameRuleDefinition<T> type) {
        GameRuleKey key = new GameRuleKey(name, category);
        GameRuleDefinition<T> type1 = ad.put(key, type);
        if (type1 != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + name);
        }
        return key;
    }

    public GameRules(FeatureFlagSet enabledFeatures, DynamicLike<?> tag) {
        this(enabledFeatures);
        this.a(tag);
    }

    public GameRules(FeatureFlagSet enabledFeatures) {
        this((Map)GameRules.b(enabledFeatures).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((GameRuleDefinition)entry.getValue()).a())), enabledFeatures);
    }

    private static Stream<Map.Entry<GameRuleKey<?>, GameRuleDefinition<?>>> b(FeatureFlagSet enabledFeatures) {
        return ad.entrySet().stream().filter(entry -> ((GameRuleDefinition)entry.getValue()).e.a(enabledFeatures));
    }

    private GameRules(Map<GameRuleKey<?>, GameRuleValue<?>> rules, FeatureFlagSet enabledFeatures) {
        this.ae = rules;
        this.af = enabledFeatures;
        int arraySize = GameRuleKey.lastGameRuleIndex + 1;
        GameRuleValue[] values = new GameRuleValue[arraySize];
        for (Map.Entry<GameRuleKey<?>, GameRuleValue<?>> entry : rules.entrySet()) {
            values[entry.getKey().gameRuleIndex] = entry.getValue();
        }
        this.gameruleArray = values;
    }

    public <T extends GameRuleValue<T>> T a(GameRuleKey<T> key) {
        GameRuleValue<?> value;
        GameRuleValue<?> gameRuleValue = value = key == null ? null : this.gameruleArray[key.gameRuleIndex];
        if (value == null) {
            throw new IllegalArgumentException("Tried to access invalid game rule");
        }
        return (T)value;
    }

    public NBTTagCompound a() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.ae.forEach((key, value) -> compoundTag.a(key.a, value.b()));
        return compoundTag;
    }

    private void a(DynamicLike<?> dynamic) {
        this.ae.forEach((key, value) -> dynamic.get(key.a).asString().ifSuccess(value::a));
    }

    public GameRules a(FeatureFlagSet enabledFeatures) {
        return new GameRules((Map)GameRules.b(enabledFeatures).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.ae.containsKey(entry.getKey()) ? this.ae.get(entry.getKey()) : ((GameRuleDefinition)entry.getValue()).a())), enabledFeatures);
    }

    public void a(GameRuleVisitor visitor) {
        ad.forEach((key, type) -> this.a(visitor, (GameRuleKey<?>)key, (GameRuleDefinition<?>)type));
    }

    private <T extends GameRuleValue<T>> void a(GameRuleVisitor visitor, GameRuleKey<?> key, GameRuleDefinition<?> type) {
        if (type.e.a(this.af)) {
            visitor.a(key, type);
            type.a(visitor, key);
        }
    }

    public void assignFrom(GameRules rules, @Nullable WorldServer level) {
        rules.ae.keySet().forEach(key -> this.assignCap((GameRuleKey)key, rules, level));
    }

    private <T extends GameRuleValue<T>> void assignCap(GameRuleKey<T> key, GameRules rules, @Nullable WorldServer level) {
        T rule = rules.a(key);
        ((GameRuleValue)this.a(key)).setFrom(rule, level);
    }

    public boolean b(GameRuleKey<GameRuleBoolean> key) {
        return this.a(key).a();
    }

    public int c(GameRuleKey<GameRuleInt> key) {
        return this.a(key).a();
    }

    public static final class GameRuleKey<T extends GameRuleValue<T>> {
        public static int lastGameRuleIndex = 0;
        public final int gameRuleIndex = lastGameRuleIndex++;
        final String a;
        private final GameRuleCategory b;

        public GameRuleKey(String id, GameRuleCategory category) {
            this.a = id;
            this.b = category;
        }

        public String toString() {
            return this.a;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof GameRuleKey && ((GameRuleKey)other).a.equals(this.a);
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public String a() {
            return this.a;
        }

        public String b() {
            return "gamerule." + this.a;
        }

        public GameRuleCategory c() {
            return this.b;
        }
    }

    public static final class GameRuleCategory
    extends Enum<GameRuleCategory> {
        public static final /* enum */ GameRuleCategory a = new GameRuleCategory("gamerule.category.player");
        public static final /* enum */ GameRuleCategory b = new GameRuleCategory("gamerule.category.mobs");
        public static final /* enum */ GameRuleCategory c = new GameRuleCategory("gamerule.category.spawning");
        public static final /* enum */ GameRuleCategory d = new GameRuleCategory("gamerule.category.drops");
        public static final /* enum */ GameRuleCategory e = new GameRuleCategory("gamerule.category.updates");
        public static final /* enum */ GameRuleCategory f = new GameRuleCategory("gamerule.category.chat");
        public static final /* enum */ GameRuleCategory g = new GameRuleCategory("gamerule.category.misc");
        private final String h;
        private static final /* synthetic */ GameRuleCategory[] i;

        public static GameRuleCategory[] values() {
            return (GameRuleCategory[])i.clone();
        }

        public static GameRuleCategory valueOf(String name) {
            return Enum.valueOf(GameRuleCategory.class, name);
        }

        private GameRuleCategory(String descriptionId) {
            this.h = descriptionId;
        }

        public String a() {
            return this.h;
        }

        private static /* synthetic */ GameRuleCategory[] b() {
            return new GameRuleCategory[]{a, b, c, d, e, f, g};
        }

        static {
            i = GameRuleCategory.b();
        }
    }

    public static class GameRuleDefinition<T extends GameRuleValue<T>> {
        final Supplier<ArgumentType<?>> a;
        private final Function<GameRuleDefinition<T>, T> b;
        final BiConsumer<WorldServer, T> c;
        private final h<T> d;
        final FeatureFlagSet e;

        GameRuleDefinition(Supplier<ArgumentType<?>> argument, Function<GameRuleDefinition<T>, T> constructor, BiConsumer<WorldServer, T> callback, h<T> visitorCaller, FeatureFlagSet requiredFeature) {
            this.a = argument;
            this.b = constructor;
            this.c = callback;
            this.d = visitorCaller;
            this.e = requiredFeature;
        }

        public RequiredArgumentBuilder<CommandListenerWrapper, ?> a(String name) {
            return CommandDispatcher.a(name, this.a.get());
        }

        public T a() {
            return (T)((GameRuleValue)this.b.apply(this));
        }

        public void a(GameRuleVisitor visitor, GameRuleKey<T> key) {
            this.d.call(visitor, key, this);
        }

        public FeatureFlagSet b() {
            return this.e;
        }
    }

    public static abstract class GameRuleValue<T extends GameRuleValue<T>> {
        protected final GameRuleDefinition<T> a;

        public GameRuleValue(GameRuleDefinition<T> type) {
            this.a = type;
        }

        protected abstract void updateFromArgument(CommandContext<CommandListenerWrapper> var1, String var2, GameRuleKey<T> var3);

        public void setFromArgument(CommandContext<CommandListenerWrapper> context, String paramName, GameRuleKey<T> gameRuleKey) {
            this.updateFromArgument(context, paramName, gameRuleKey);
            this.onChanged(((CommandListenerWrapper)context.getSource()).e());
        }

        public void onChanged(@Nullable WorldServer level) {
            if (level != null) {
                this.a.c.accept(level, (WorldServer)this.g());
            }
        }

        public abstract void a(String var1);

        public abstract String b();

        public String toString() {
            return this.b();
        }

        public abstract int c();

        protected abstract T g();

        protected abstract T f();

        public abstract void setFrom(T var1, @Nullable WorldServer var2);
    }

    public static interface GameRuleVisitor {
        default public <T extends GameRuleValue<T>> void a(GameRuleKey<T> key, GameRuleDefinition<T> type) {
        }

        default public void b(GameRuleKey<GameRuleBoolean> key, GameRuleDefinition<GameRuleBoolean> type) {
        }

        default public void c(GameRuleKey<GameRuleInt> key, GameRuleDefinition<GameRuleInt> type) {
        }
    }

    public static class GameRuleBoolean
    extends GameRuleValue<GameRuleBoolean> {
        private boolean b;

        static GameRuleDefinition<GameRuleBoolean> a(boolean defaultValue, BiConsumer<WorldServer, GameRuleBoolean> changeListener) {
            return new GameRuleDefinition<GameRuleBoolean>(BoolArgumentType::bool, type -> new GameRuleBoolean((GameRuleDefinition<GameRuleBoolean>)type, defaultValue), changeListener, GameRuleVisitor::b, FeatureFlagSet.a());
        }

        static GameRuleDefinition<GameRuleBoolean> a(boolean defaultValue) {
            return GameRuleBoolean.a(defaultValue, (WorldServer key, GameRuleBoolean value) -> {});
        }

        public GameRuleBoolean(GameRuleDefinition<GameRuleBoolean> type, boolean value) {
            super(type);
            this.b = value;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandListenerWrapper> context, String paramName, GameRuleKey<GameRuleBoolean> gameRuleKey) {
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(((CommandListenerWrapper)context.getSource()).getBukkitWorld(), ((CommandListenerWrapper)context.getSource()).getBukkitSender(), GameRule.getByName((String)gameRuleKey.toString()), String.valueOf(BoolArgumentType.getBool(context, (String)paramName)));
            if (!event.callEvent()) {
                return;
            }
            this.b = Boolean.parseBoolean(event.getValue());
        }

        public boolean a() {
            return this.b;
        }

        public void set(boolean value, @Nullable WorldServer level) {
            this.b = value;
            this.onChanged(level);
        }

        @Override
        public String b() {
            return Boolean.toString(this.b);
        }

        @Override
        public void a(String value) {
            this.b = Boolean.parseBoolean(value);
        }

        @Override
        public int c() {
            return this.b ? 1 : 0;
        }

        protected GameRuleBoolean d() {
            return this;
        }

        protected GameRuleBoolean e() {
            return new GameRuleBoolean(this.a, this.b);
        }

        @Override
        public void setFrom(GameRuleBoolean value, @Nullable WorldServer level) {
            this.b = value.b;
            this.onChanged(level);
        }
    }

    public static class GameRuleInt
    extends GameRuleValue<GameRuleInt> {
        private int b;

        private static GameRuleDefinition<GameRuleInt> a(int defaultValue, BiConsumer<WorldServer, GameRuleInt> changeListener) {
            return new GameRuleDefinition<GameRuleInt>(IntegerArgumentType::integer, type -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)type, defaultValue), changeListener, GameRuleVisitor::c, FeatureFlagSet.a());
        }

        static GameRuleDefinition<GameRuleInt> a(int defaultValue, int min, int max, FeatureFlagSet requiredFeatures, BiConsumer<WorldServer, GameRuleInt> changeListener) {
            return new GameRuleDefinition<GameRuleInt>(() -> IntegerArgumentType.integer((int)min, (int)max), type -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)type, defaultValue), changeListener, GameRuleVisitor::c, requiredFeatures);
        }

        static GameRuleDefinition<GameRuleInt> a(int defaultValue) {
            return GameRuleInt.a(defaultValue, (WorldServer minecraftServer, GameRuleInt integerValue) -> {});
        }

        public GameRuleInt(GameRuleDefinition<GameRuleInt> type, int value) {
            super(type);
            this.b = value;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandListenerWrapper> context, String paramName, GameRuleKey<GameRuleInt> gameRuleKey) {
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(((CommandListenerWrapper)context.getSource()).getBukkitWorld(), ((CommandListenerWrapper)context.getSource()).getBukkitSender(), GameRule.getByName((String)gameRuleKey.toString()), String.valueOf(IntegerArgumentType.getInteger(context, (String)paramName)));
            if (!event.callEvent()) {
                return;
            }
            this.b = Integer.parseInt(event.getValue());
        }

        public int a() {
            return this.b;
        }

        public void set(int value, @Nullable WorldServer level) {
            this.b = value;
            this.onChanged(level);
        }

        @Override
        public String b() {
            return Integer.toString(this.b);
        }

        @Override
        public void a(String value) {
            this.b = GameRuleInt.c(value);
        }

        public boolean b(String name) {
            try {
                StringReader stringReader = new StringReader(name);
                this.b = (Integer)this.a.a.get().parse(stringReader);
                return !stringReader.canRead();
            }
            catch (CommandSyntaxException var3) {
                return false;
            }
        }

        private static int c(String strValue) {
            if (!strValue.isEmpty()) {
                try {
                    return Integer.parseInt(strValue);
                }
                catch (NumberFormatException var2) {
                    ac.warn("Failed to parse integer {}", (Object)strValue);
                }
            }
            return 0;
        }

        @Override
        public int c() {
            return this.b;
        }

        protected GameRuleInt d() {
            return this;
        }

        protected GameRuleInt e() {
            return new GameRuleInt(this.a, this.b);
        }

        @Override
        public void setFrom(GameRuleInt value, @Nullable WorldServer level) {
            this.b = value.b;
            this.onChanged(level);
        }
    }

    static interface h<T extends GameRuleValue<T>> {
        public void call(GameRuleVisitor var1, GameRuleKey<T> var2, GameRuleDefinition<T> var3);
    }
}

