/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3D;

public final class SpawnParticlesEffect
extends Record
implements EnchantmentEntityEffect {
    private final ParticleParam d;
    private final a e;
    private final a f;
    private final c g;
    private final c h;
    private final FloatProvider i;
    public static final MapCodec<SpawnParticlesEffect> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Particles.bi.fieldOf("particle").forGetter(SpawnParticlesEffect::c), (App)net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect$a.a.fieldOf("horizontal_position").forGetter(SpawnParticlesEffect::d), (App)net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect$a.a.fieldOf("vertical_position").forGetter(SpawnParticlesEffect::e), (App)c.a.fieldOf("horizontal_velocity").forGetter(SpawnParticlesEffect::f), (App)c.a.fieldOf("vertical_velocity").forGetter(SpawnParticlesEffect::g), (App)FloatProvider.c.optionalFieldOf("speed", (Object)ConstantFloat.a).forGetter(SpawnParticlesEffect::h)).apply((Applicative)instance, SpawnParticlesEffect::new));

    public SpawnParticlesEffect(ParticleParam particle, a horizontalPosition, a verticalPosition, c horizontalVelocity, c verticalVelocity, FloatProvider speed) {
        this.d = particle;
        this.e = horizontalPosition;
        this.f = verticalPosition;
        this.g = horizontalVelocity;
        this.h = verticalVelocity;
        this.i = speed;
    }

    public static a a(float offset) {
        return new a(b.a, offset, 1.0f);
    }

    public static a b() {
        return new a(b.b, 0.0f, 1.0f);
    }

    public static c b(float movementScale) {
        return new c(movementScale, ConstantFloat.a);
    }

    public static c a(FloatProvider velocity) {
        return new c(0.0f, velocity);
    }

    @Override
    public void a(WorldServer level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3D origin) {
        RandomSource random = entity.dY();
        Vec3D knownMovement = entity.ah();
        float bbWidth = entity.dq();
        float bbHeight = entity.dr();
        level.sendParticlesSource(entity, this.d, false, false, this.e.a(origin.a(), origin.a(), bbWidth, random), this.f.a(origin.b(), origin.b() + (double)(bbHeight / 2.0f), bbHeight, random), this.e.a(origin.c(), origin.c(), bbWidth, random), 0, this.g.a(knownMovement.a(), random), this.h.a(knownMovement.b(), random), this.g.a(knownMovement.c(), random), this.i.a(random));
    }

    public MapCodec<SpawnParticlesEffect> a() {
        return a;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpawnParticlesEffect.class, "particle;horizontalPosition;verticalPosition;horizontalVelocity;verticalVelocity;speed", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpawnParticlesEffect.class, "particle;horizontalPosition;verticalPosition;horizontalVelocity;verticalVelocity;speed", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpawnParticlesEffect.class, "particle;horizontalPosition;verticalPosition;horizontalVelocity;verticalVelocity;speed", "d", "e", "f", "g", "h", "i"}, this, o2);
    }

    public ParticleParam c() {
        return this.d;
    }

    public a d() {
        return this.e;
    }

    public a e() {
        return this.f;
    }

    public c f() {
        return this.g;
    }

    public c g() {
        return this.h;
    }

    public FloatProvider h() {
        return this.i;
    }

    public static final class a
    extends Record {
        private final b b;
        private final float c;
        private final float d;
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect$b.c.fieldOf("type").forGetter(a::a), (App)Codec.FLOAT.optionalFieldOf("offset", (Object)Float.valueOf(0.0f)).forGetter(a::b), (App)ExtraCodecs.o.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(a::c)).apply((Applicative)instance, a::new)).validate(sourceType -> sourceType.a() == net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect$b.a && sourceType.c() != 1.0f ? DataResult.error(() -> "Cannot scale an entity position coordinate source") : DataResult.success((Object)sourceType));

        public a(b type, float offset, float scale) {
            this.b = type;
            this.c = offset;
            this.d = scale;
        }

        public double a(double position, double center, float size, RandomSource random) {
            return this.b.a(position, center, size * this.d, random) + (double)this.c;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "type;offset;scale", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "type;offset;scale", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "type;offset;scale", "b", "c", "d"}, this, o2);
        }

        public b a() {
            return this.b;
        }

        public float b() {
            return this.c;
        }

        public float c() {
            return this.d;
        }
    }

    public static final class c
    extends Record {
        private final float b;
        private final FloatProvider c;
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("movement_scale", (Object)Float.valueOf(0.0f)).forGetter(c::a), (App)FloatProvider.c.optionalFieldOf("base", (Object)ConstantFloat.a).forGetter(c::b)).apply((Applicative)instance, c::new));

        public c(float movementScale, FloatProvider base) {
            this.b = movementScale;
            this.c = base;
        }

        public double a(double scale, RandomSource random) {
            return scale * (double)this.b + (double)this.c.a(random);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "movementScale;base", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "movementScale;base", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "movementScale;base", "b", "c"}, this, o2);
        }

        public float a() {
            return this.b;
        }

        public FloatProvider b() {
            return this.c;
        }
    }

    public static final class b
    extends Enum<b>
    implements INamable {
        public static final /* enum */ b a = new b("entity_position", (position, center, size, random) -> position);
        public static final /* enum */ b b = new b("in_bounding_box", (position, center, size, random) -> center + (random.j() - 0.5) * (double)size);
        public static final Codec<b> c;
        private final String d;
        private final a e;
        private static final /* synthetic */ b[] f;

        public static b[] values() {
            return (b[])f.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private b(String id, a source) {
            this.d = id;
            this.e = source;
        }

        public double a(double position, double center, float size, RandomSource random) {
            return this.e.getCoordinate(position, center, size, random);
        }

        @Override
        public String c() {
            return this.d;
        }

        private static /* synthetic */ b[] a() {
            return new b[]{a, b};
        }

        static {
            f = net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect$b.a();
            c = INamable.a(b::values);
        }

        @FunctionalInterface
        static interface a {
            public double getCoordinate(double var1, double var3, float var5, RandomSource var6);
        }
    }
}

