/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.enchantment.Enchantment;

public class ItemEnchantments
implements TooltipProvider {
    private static final Comparator<Holder<Enchantment>> ENCHANTMENT_ORDER = Comparator.comparing(Holder::g);
    public static final ItemEnchantments a = new ItemEnchantments((Object2IntAVLTreeMap<Holder<Enchantment>>)new Object2IntAVLTreeMap(ENCHANTMENT_ORDER), true);
    private static final Codec<Integer> d = Codec.intRange((int)1, (int)255);
    private static final Codec<Object2IntAVLTreeMap<Holder<Enchantment>>> e = Codec.unboundedMap(Enchantment.c, d).xmap(m2 -> {
        Object2IntAVLTreeMap map = new Object2IntAVLTreeMap(ENCHANTMENT_ORDER);
        map.putAll(m2);
        return map;
    }, Function.identity());
    private static final Codec<ItemEnchantments> f = RecordCodecBuilder.create(instance -> instance.group((App)e.fieldOf("levels").forGetter(itemEnchantments -> itemEnchantments.enchantments), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(itemEnchantments -> itemEnchantments.h)).apply((Applicative)instance, ItemEnchantments::new));
    public static final Codec<ItemEnchantments> b = Codec.withAlternative(f, e, map -> new ItemEnchantments((Object2IntAVLTreeMap<Holder<Enchantment>>)map, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEnchantments> c = StreamCodec.a(ByteBufCodecs.a((int v2) -> new Object2IntAVLTreeMap(ENCHANTMENT_ORDER), Enchantment.d, ByteBufCodecs.h), itemEnchantments -> itemEnchantments.enchantments, ByteBufCodecs.b, itemEnchantments -> itemEnchantments.h, ItemEnchantments::new);
    final Object2IntAVLTreeMap<Holder<Enchantment>> enchantments;
    public final boolean h;

    ItemEnchantments(Object2IntAVLTreeMap<Holder<Enchantment>> enchantments, boolean showInTooltip) {
        this.enchantments = enchantments;
        this.h = showInTooltip;
        for (Object2IntMap.Entry entry : enchantments.object2IntEntrySet()) {
            int intValue = entry.getIntValue();
            if (intValue >= 0 && intValue <= 255) continue;
            throw new IllegalArgumentException("Enchantment " + String.valueOf(entry.getKey()) + " has invalid level " + intValue);
        }
    }

    public int a(Holder<Enchantment> enchantment) {
        return this.enchantments.getInt(enchantment);
    }

    @Override
    public void a(Item.b context, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag tooltipFlag) {
        if (this.h) {
            HolderLookup.a provider = context.a();
            HolderSet<Enchantment> tagOrEmpty = ItemEnchantments.a(provider, Registries.aO, EnchantmentTags.a);
            for (Holder holder : tagOrEmpty) {
                int _int = this.enchantments.getInt((Object)holder);
                if (_int <= 0) continue;
                tooltipAdder.accept(Enchantment.a((Holder<Enchantment>)holder, _int));
            }
            for (Object2IntMap.Entry entry : this.enchantments.object2IntEntrySet()) {
                Holder holder1 = (Holder)entry.getKey();
                if (tagOrEmpty.a(holder1)) continue;
                tooltipAdder.accept(Enchantment.a((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue()));
            }
        }
    }

    private static <T> HolderSet<T> a(@Nullable HolderLookup.a registries, ResourceKey<IRegistry<T>> registryKey, TagKey<T> key) {
        Optional<HolderSet.Named<T>> optional;
        if (registries != null && (optional = registries.d(registryKey).a(key)).isPresent()) {
            return optional.get();
        }
        return HolderSet.a(new Holder[0]);
    }

    public ItemEnchantments a(boolean showInTooltip) {
        return new ItemEnchantments(this.enchantments, showInTooltip);
    }

    public Set<Holder<Enchantment>> a() {
        return Collections.unmodifiableSet(this.enchantments.keySet());
    }

    public Set<Object2IntMap.Entry<Holder<Enchantment>>> b() {
        return Collections.unmodifiableSet(this.enchantments.object2IntEntrySet());
    }

    public int c() {
        return this.enchantments.size();
    }

    public boolean d() {
        return this.enchantments.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ItemEnchantments)) return false;
        ItemEnchantments itemEnchantments = (ItemEnchantments)other;
        if (this.h != itemEnchantments.h) return false;
        if (!this.enchantments.equals(itemEnchantments.enchantments)) return false;
        return true;
    }

    public int hashCode() {
        int hashCode = this.enchantments.hashCode();
        return 31 * hashCode + (this.h ? 1 : 0);
    }

    public String toString() {
        return "ItemEnchantments{enchantments=" + String.valueOf(this.enchantments) + ", showInTooltip=" + this.h + "}";
    }

    public static class a {
        private final Object2IntAVLTreeMap<Holder<Enchantment>> enchantments = new Object2IntAVLTreeMap(ENCHANTMENT_ORDER);
        public boolean b;

        public a(ItemEnchantments enchantments) {
            this.enchantments.putAll(enchantments.enchantments);
            this.b = enchantments.h;
        }

        public void a(Holder<Enchantment> enchantment, int level) {
            if (level <= 0) {
                this.enchantments.removeInt(enchantment);
            } else {
                this.enchantments.put(enchantment, Math.min(level, 255));
            }
        }

        public void b(Holder<Enchantment> enchantment, int level) {
            if (level > 0) {
                this.enchantments.merge(enchantment, Math.min(level, 255), Integer::max);
            }
        }

        public void a(Predicate<Holder<Enchantment>> predicate) {
            this.enchantments.keySet().removeIf(predicate);
        }

        public int a(Holder<Enchantment> enchantment) {
            return this.enchantments.getOrDefault(enchantment, 0);
        }

        public Set<Holder<Enchantment>> a() {
            return this.enchantments.keySet();
        }

        public ItemEnchantments b() {
            return new ItemEnchantments(this.enchantments, this.b);
        }
    }
}

