/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftSmithingTrimRecipe;
import org.bukkit.inventory.Recipe;

public class SmithingTrimRecipe
implements SmithingRecipe {
    final Optional<RecipeItemStack> c;
    final Optional<RecipeItemStack> d;
    final Optional<RecipeItemStack> e;
    @Nullable
    private PlacementInfo f;
    final boolean copyDataComponents;

    public SmithingTrimRecipe(Optional<RecipeItemStack> template, Optional<RecipeItemStack> base, Optional<RecipeItemStack> addition) {
        this(template, base, addition, true);
    }

    public SmithingTrimRecipe(Optional<RecipeItemStack> template, Optional<RecipeItemStack> base, Optional<RecipeItemStack> addition, boolean copyDataComponents) {
        this.copyDataComponents = copyDataComponents;
        this.c = template;
        this.d = base;
        this.e = addition;
    }

    @Override
    public ItemStack a(SmithingRecipeInput input, HolderLookup.a registries) {
        return SmithingTrimRecipe.applyTrim(registries, input.d(), input.e(), input.c(), this.copyDataComponents);
    }

    public static ItemStack a(HolderLookup.a registries, ItemStack base, ItemStack addition, ItemStack template) {
        return SmithingTrimRecipe.applyTrim(registries, base, addition, template, true);
    }

    public static ItemStack applyTrim(HolderLookup.a registries, ItemStack base, ItemStack addition, ItemStack template, boolean copyDataComponents) {
        Optional<Holder.c<TrimMaterial>> fromIngredient = TrimMaterials.a(registries, addition);
        Optional<Holder.c<TrimPattern>> fromTemplate = TrimPatterns.a(registries, template);
        if (fromIngredient.isPresent() && fromTemplate.isPresent()) {
            ArmorTrim armorTrim = base.a(DataComponents.U);
            if (armorTrim != null && armorTrim.a((Holder<TrimPattern>)fromTemplate.get(), (Holder<TrimMaterial>)fromIngredient.get())) {
                return ItemStack.j;
            }
            ItemStack itemStack = copyDataComponents ? base.c(1) : new ItemStack(base.h(), 1);
            itemStack.b(DataComponents.U, new ArmorTrim((Holder<TrimMaterial>)fromIngredient.get(), (Holder<TrimPattern>)fromTemplate.get()));
            return itemStack;
        }
        return ItemStack.j;
    }

    @Override
    public Optional<RecipeItemStack> c() {
        return this.c;
    }

    @Override
    public Optional<RecipeItemStack> f() {
        return this.d;
    }

    @Override
    public Optional<RecipeItemStack> k() {
        return this.e;
    }

    @Override
    public RecipeSerializer<SmithingTrimRecipe> a() {
        return RecipeSerializer.u;
    }

    @Override
    public PlacementInfo ao_() {
        if (this.f == null) {
            this.f = PlacementInfo.a(List.of(this.c, this.d, this.e));
        }
        return this.f;
    }

    @Override
    public List<RecipeDisplay> g() {
        SlotDisplay slotDisplay = RecipeItemStack.a(this.d);
        SlotDisplay slotDisplay1 = RecipeItemStack.a(this.e);
        SlotDisplay slotDisplay2 = RecipeItemStack.a(this.c);
        return List.of(new SmithingRecipeDisplay(slotDisplay2, slotDisplay, slotDisplay1, new SlotDisplay.g(slotDisplay, slotDisplay1, slotDisplay2), new SlotDisplay.d(Items.xq)));
    }

    @Override
    public Recipe toBukkitRecipe(NamespacedKey id) {
        return new CraftSmithingTrimRecipe(id, CraftRecipe.toBukkit(this.c), CraftRecipe.toBukkit(this.d), CraftRecipe.toBukkit(this.e), this.copyDataComponents);
    }

    public static class a
    implements RecipeSerializer<SmithingTrimRecipe> {
        private static final MapCodec<SmithingTrimRecipe> x = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecipeItemStack.d.optionalFieldOf("template").forGetter(recipe -> recipe.c), (App)RecipeItemStack.d.optionalFieldOf("base").forGetter(recipe -> recipe.d), (App)RecipeItemStack.d.optionalFieldOf("addition").forGetter(recipe -> recipe.e)).apply((Applicative)instance, SmithingTrimRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> w = StreamCodec.a(RecipeItemStack.b, recipe -> recipe.c, RecipeItemStack.b, recipe -> recipe.d, RecipeItemStack.b, recipe -> recipe.e, SmithingTrimRecipe::new);

        @Override
        public MapCodec<SmithingTrimRecipe> a() {
            return x;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> b() {
            return w;
        }
    }
}

