/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.World;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftShapelessRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class ShapelessRecipes
implements RecipeCrafting {
    final String c;
    final CraftingBookCategory d;
    final ItemStack e;
    final List<RecipeItemStack> f;
    @Nullable
    private PlacementInfo g;

    public ShapelessRecipes(String group, CraftingBookCategory category, ItemStack result, List<RecipeItemStack> ingredients) {
        this.c = group;
        this.d = category;
        this.e = result;
        this.f = ingredients;
    }

    public ShapelessRecipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.e);
        CraftShapelessRecipe recipe = new CraftShapelessRecipe(id, result, this);
        recipe.setGroup(this.c);
        recipe.setCategory(CraftRecipe.getCategory(this.c()));
        for (RecipeItemStack list : this.f) {
            recipe.addIngredient(CraftRecipe.toBukkit(list));
        }
        return recipe;
    }

    @Override
    public RecipeSerializer<ShapelessRecipes> a() {
        return RecipeSerializer.b;
    }

    @Override
    public String j() {
        return this.c;
    }

    @Override
    public CraftingBookCategory c() {
        return this.d;
    }

    @Override
    public PlacementInfo ao_() {
        if (this.g == null) {
            this.g = PlacementInfo.b(this.f);
        }
        return this.g;
    }

    @Override
    public boolean a(CraftingInput input, World level) {
        if (input.e() != this.f.size()) {
            return false;
        }
        if (input.a() == 1 && this.f.size() == 1) {
            return this.f.getFirst().a(input.a(0));
        }
        input.c().initializeExtras(this, input);
        boolean canCraft = input.c().a(this, null);
        input.c().resetExtras();
        return canCraft;
    }

    @Override
    public ItemStack a(CraftingInput input, HolderLookup.a registries) {
        return this.e.v();
    }

    @Override
    public List<RecipeDisplay> g() {
        return List.of(new ShapelessCraftingRecipeDisplay(this.f.stream().map(RecipeItemStack::c).toList(), new SlotDisplay.f(this.e), new SlotDisplay.d(Items.fc)));
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        private static final MapCodec<ShapelessRecipes> x = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.c), (App)CraftingBookCategory.e.fieldOf("category").orElse((Object)CraftingBookCategory.d).forGetter(recipe -> recipe.d), (App)ItemStack.c.fieldOf("result").forGetter(recipe -> recipe.e), (App)RecipeItemStack.d.listOf(1, 9).fieldOf("ingredients").forGetter(recipe -> recipe.f)).apply((Applicative)instance, ShapelessRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipes> w = StreamCodec.a(ByteBufCodecs.o, recipe -> recipe.c, CraftingBookCategory.g, recipe -> recipe.d, ItemStack.h, recipe -> recipe.e, RecipeItemStack.a.a(ByteBufCodecs.a()), recipe -> recipe.f, ShapelessRecipes::new);

        @Override
        public MapCodec<ShapelessRecipes> a() {
            return x;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipes> b() {
            return w;
        }
    }
}

