/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.World;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftShapedRecipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ShapedRecipes
implements RecipeCrafting {
    final ShapedRecipePattern c;
    final ItemStack d;
    final String e;
    final CraftingBookCategory f;
    final boolean g;
    @Nullable
    private PlacementInfo h;

    public ShapedRecipes(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        this.e = group;
        this.f = category;
        this.c = pattern;
        this.d = result;
        this.g = showNotification;
    }

    public ShapedRecipes(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result) {
        this(group, category, pattern, result, true);
    }

    @Override
    public RecipeSerializer<? extends ShapedRecipes> a() {
        return RecipeSerializer.a;
    }

    @Override
    public String j() {
        return this.e;
    }

    @Override
    public CraftingBookCategory c() {
        return this.f;
    }

    @VisibleForTesting
    public List<Optional<RecipeItemStack>> f() {
        return this.c.c();
    }

    @Override
    public PlacementInfo ao_() {
        if (this.h == null) {
            this.h = PlacementInfo.a(this.c.c());
        }
        return this.h;
    }

    @Override
    public boolean i() {
        return this.g;
    }

    @Override
    public boolean a(CraftingInput input, World level) {
        return this.c.a(input);
    }

    @Override
    public ItemStack a(CraftingInput input, HolderLookup.a registries) {
        return this.d.v();
    }

    public int k() {
        return this.c.a();
    }

    public int l() {
        return this.c.b();
    }

    @Override
    public List<RecipeDisplay> g() {
        return List.of(new ShapedCraftingRecipeDisplay(this.c.a(), this.c.b(), this.c.c().stream().map(optional -> optional.map(RecipeItemStack::c).orElse(SlotDisplay.c.c)).toList(), new SlotDisplay.f(this.d), new SlotDisplay.d(Items.fc)));
    }

    public ShapedRecipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.d);
        CraftShapedRecipe recipe = new CraftShapedRecipe(id, result, this);
        recipe.setGroup(this.e);
        recipe.setCategory(CraftRecipe.getCategory(this.c()));
        block0 : switch (this.c.b()) {
            case 1: {
                switch (this.c.a()) {
                    case 1: {
                        recipe.shape(new String[]{"a"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc"});
                    }
                }
                break;
            }
            case 2: {
                switch (this.c.a()) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def"});
                    }
                }
                break;
            }
            case 3: {
                switch (this.c.a()) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b", "c"});
                        break block0;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd", "ef"});
                        break block0;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def", "ghi"});
                    }
                }
            }
        }
        char c2 = 'a';
        for (Optional<RecipeItemStack> list : this.c.c()) {
            RecipeChoice choice = CraftRecipe.toBukkit(list);
            if (choice != RecipeChoice.empty()) {
                recipe.setIngredient(c2, choice);
            }
            c2 = (char)(c2 + 1);
        }
        return recipe;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipes> {
        public static final MapCodec<ShapedRecipes> w = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapedRecipe -> shapedRecipe.e), (App)CraftingBookCategory.e.fieldOf("category").orElse((Object)CraftingBookCategory.d).forGetter(shapedRecipe -> shapedRecipe.f), (App)ShapedRecipePattern.b.forGetter(shapedRecipe -> shapedRecipe.c), (App)ItemStack.c.fieldOf("result").forGetter(shapedRecipe -> shapedRecipe.d), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(shapedRecipe -> shapedRecipe.g)).apply((Applicative)instance, ShapedRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipes> x = StreamCodec.a(Serializer::a, Serializer::a);

        @Override
        public MapCodec<ShapedRecipes> a() {
            return w;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapedRecipes> b() {
            return x;
        }

        private static ShapedRecipes a(RegistryFriendlyByteBuf buffer) {
            String utf = buffer.p();
            CraftingBookCategory craftingBookCategory = buffer.b(CraftingBookCategory.class);
            ShapedRecipePattern shapedRecipePattern = (ShapedRecipePattern)ShapedRecipePattern.c.decode(buffer);
            ItemStack itemStack = (ItemStack)ItemStack.h.decode(buffer);
            boolean _boolean = buffer.readBoolean();
            return new ShapedRecipes(utf, craftingBookCategory, shapedRecipePattern, itemStack, _boolean);
        }

        private static void a(RegistryFriendlyByteBuf buffer, ShapedRecipes recipe) {
            buffer.a(recipe.e);
            buffer.a(recipe.f);
            ShapedRecipePattern.c.encode(buffer, recipe.c);
            ItemStack.h.encode(buffer, recipe.d);
            buffer.a(recipe.g);
        }
    }
}

