/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeSingleItem;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.level.World;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class CraftingManager
extends ResourceDataAbstract<RecipeMap>
implements RecipeAccess {
    private static final Logger a = LogUtils.getLogger();
    private static final Map<ResourceKey<RecipePropertySet>, c> b = Map.of(RecipePropertySet.d, recipe -> {
        Optional<Object> optional;
        if (recipe instanceof SmithingRecipe) {
            SmithingRecipe smithingRecipe = (SmithingRecipe)recipe;
            optional = smithingRecipe.k();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.b, recipe -> {
        Optional<Object> optional;
        if (recipe instanceof SmithingRecipe) {
            SmithingRecipe smithingRecipe = (SmithingRecipe)recipe;
            optional = smithingRecipe.f();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.c, recipe -> {
        Optional<Object> optional;
        if (recipe instanceof SmithingRecipe) {
            SmithingRecipe smithingRecipe = (SmithingRecipe)recipe;
            optional = smithingRecipe.c();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.e, CraftingManager.b(Recipes.b), RecipePropertySet.f, CraftingManager.b(Recipes.c), RecipePropertySet.g, CraftingManager.b(Recipes.d), RecipePropertySet.h, CraftingManager.b(Recipes.e));
    private static final FileToIdConverter c = FileToIdConverter.a(Registries.bk);
    private final HolderLookup.a d;
    public RecipeMap e = RecipeMap.a;
    private Map<ResourceKey<RecipePropertySet>, RecipePropertySet> f = Map.of();
    private SelectableRecipe.b<RecipeStonecutting> g = SelectableRecipe.b.a();
    private List<d> h = List.of();
    private Map<ResourceKey<IRecipe<?>>, List<d>> i = Map.of();
    private FeatureFlagSet featureflagset;

    public CraftingManager(HolderLookup.a registries) {
        this.d = registries;
    }

    protected RecipeMap a(IResourceManager resourceManager, GameProfilerFiller profiler) {
        TreeMap<MinecraftKey, IRecipe> map = new TreeMap<MinecraftKey, IRecipe>();
        ResourceDataJson.a(resourceManager, c, this.d.a(JsonOps.INSTANCE), IRecipe.a, map);
        ArrayList list = new ArrayList(map.size());
        map.forEach((location, recipe) -> {
            ResourceKey<IRecipe<?>> resourceKey = ResourceKey.a(Registries.bk, location);
            RecipeHolder<IRecipe> recipeHolder = new RecipeHolder<IRecipe>(resourceKey, (IRecipe)recipe);
            list.add(recipeHolder);
        });
        return RecipeMap.a(list);
    }

    @Override
    protected void a(RecipeMap object, IResourceManager resourceManager, GameProfilerFiller profiler) {
        this.e = object;
        a.info("Loaded {} recipes", (Object)object.a().size());
    }

    public void addRecipe(RecipeHolder<?> holder) {
        AsyncCatcher.catchOp("Recipe Add");
        this.e.addRecipe(holder);
        this.finalizeRecipeLoading();
    }

    public void finalizeRecipeLoading() {
        if (this.featureflagset != null) {
            this.a(this.featureflagset);
            MinecraftServer.getServer().ag().reloadRecipes();
        }
    }

    public void a(FeatureFlagSet enabledFeatures) {
        this.featureflagset = enabledFeatures;
        ArrayList list = new ArrayList();
        List<b> list1 = b.entrySet().stream().map(entry -> new b((ResourceKey)entry.getKey(), (c)entry.getValue())).toList();
        this.e.a().forEach(recipe -> {
            Object recipe1 = recipe.b();
            if (!recipe1.ap_() && recipe1.ao_().c()) {
                a.warn("Recipe {} can't be placed due to empty ingredients and will be ignored", (Object)recipe.a().a());
            } else {
                RecipeStonecutting stonecutterRecipe;
                list1.forEach(collector -> collector.a((IRecipe<?>)recipe1));
                if (recipe1 instanceof RecipeStonecutting && CraftingManager.a(enabledFeatures, (stonecutterRecipe = (RecipeStonecutting)recipe1).k()) && stonecutterRecipe.c().a(enabledFeatures)) {
                    list.add(new SelectableRecipe.a(stonecutterRecipe.k(), new SelectableRecipe(stonecutterRecipe.c(), Optional.of(recipe))));
                }
            }
        });
        this.f = list1.stream().collect(Collectors.toUnmodifiableMap(collector -> collector.a, collector -> collector.a(enabledFeatures)));
        this.g = new SelectableRecipe.b(list);
        this.h = CraftingManager.a(this.e.a(), enabledFeatures);
        this.i = this.h.stream().collect(Collectors.groupingBy(displayInfo -> displayInfo.b.a(), IdentityHashMap::new, Collectors.toList()));
    }

    static List<RecipeItemStack> a(FeatureFlagSet enabledFeatures, List<RecipeItemStack> ingredients) {
        ingredients.removeIf(ingredient -> !CraftingManager.a(enabledFeatures, ingredient));
        return ingredients;
    }

    private static boolean a(FeatureFlagSet enabledFeatures, RecipeItemStack ingredient) {
        return ingredient.a().allMatch(item -> ((Item)item.a()).a(enabledFeatures));
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> recipeType, I input, World level, @Nullable ResourceKey<IRecipe<?>> recipe) {
        RecipeHolder<T> recipeHolder = recipe != null ? this.a(recipeType, recipe) : null;
        return this.a(recipeType, input, level, recipeHolder);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> recipeType, I input, World level, @Nullable RecipeHolder<T> lastRecipe) {
        return lastRecipe != null && lastRecipe.b().a(input, level) ? Optional.of(lastRecipe) : this.a(recipeType, input, level);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> recipeType, I input, World level) {
        List<RecipeHolder<T>> list = this.e.a(recipeType, input, level).toList();
        return list.isEmpty() ? Optional.empty() : Optional.of(list.getLast());
    }

    public Optional<RecipeHolder<?>> b(ResourceKey<IRecipe<?>> key) {
        return Optional.ofNullable(this.e.a(key));
    }

    @Nullable
    private <T extends IRecipe<?>> RecipeHolder<T> a(Recipes<T> type, ResourceKey<IRecipe<?>> key) {
        RecipeHolder<?> recipeHolder = this.e.a(key);
        return recipeHolder != null && recipeHolder.b().b().equals(type) ? recipeHolder : null;
    }

    public Map<ResourceKey<RecipePropertySet>, RecipePropertySet> b() {
        return this.f;
    }

    public SelectableRecipe.b<RecipeStonecutting> d() {
        return this.g;
    }

    @Override
    public RecipePropertySet a(ResourceKey<RecipePropertySet> propertySet) {
        return this.f.getOrDefault(propertySet, RecipePropertySet.j);
    }

    @Override
    public SelectableRecipe.b<RecipeStonecutting> a() {
        return this.g;
    }

    public Collection<RecipeHolder<?>> e() {
        return this.e.a();
    }

    @Nullable
    public d a(RecipeDisplayId display) {
        return this.h.get(display.a());
    }

    public void a(ResourceKey<IRecipe<?>> recipe, Consumer<RecipeDisplayEntry> output) {
        List<d> list = this.i.get(recipe);
        if (list != null) {
            list.forEach(displayInfo -> output.accept(displayInfo.a));
        }
    }

    @VisibleForTesting
    protected static RecipeHolder<?> a(ResourceKey<IRecipe<?>> recipe, JsonObject json, HolderLookup.a registries) {
        IRecipe recipe1 = (IRecipe)IRecipe.a.parse(registries.a(JsonOps.INSTANCE), (Object)json).getOrThrow(JsonParseException::new);
        return new RecipeHolder<IRecipe>(recipe, recipe1);
    }

    public boolean removeRecipe(ResourceKey<IRecipe<?>> mcKey) {
        boolean removed = this.e.removeRecipe(mcKey);
        if (removed) {
            this.finalizeRecipeLoading();
        }
        return removed;
    }

    public void clearRecipes() {
        this.e = RecipeMap.a(Collections.emptyList());
        this.finalizeRecipeLoading();
    }

    public static <I extends RecipeInput, T extends IRecipe<I>> a<I, T> a(final Recipes<T> recipeType) {
        return new a<I, T>(){
            @Nullable
            private ResourceKey<IRecipe<?>> b;

            @Override
            public Optional<RecipeHolder<T>> a(I input, WorldServer level) {
                CraftingManager recipeManager = level.t();
                Optional recipeFor = recipeManager.a(recipeType, input, (World)level, this.b);
                if (recipeFor.isPresent()) {
                    RecipeHolder recipeHolder = recipeFor.get();
                    this.b = recipeHolder.a();
                    return Optional.of(recipeHolder);
                }
                return Optional.empty();
            }
        };
    }

    private static List<d> a(Iterable<RecipeHolder<?>> recipes, FeatureFlagSet enabledFeatures) {
        ArrayList<d> list = new ArrayList<d>();
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (RecipeHolder<?> recipeHolder : recipes) {
            Object recipe = recipeHolder.b();
            OptionalInt optionalInt = recipe.j().isEmpty() ? OptionalInt.empty() : OptionalInt.of(map.computeIfAbsent((Object)recipe.j(), arg_0 -> CraftingManager.a((Object2IntMap)map, arg_0)));
            Optional<Object> optional = recipe.ap_() ? Optional.empty() : Optional.of(recipe.ao_().b());
            for (RecipeDisplay recipeDisplay : recipe.g()) {
                if (!recipeDisplay.a(enabledFeatures)) continue;
                int size = list.size();
                RecipeDisplayId recipeDisplayId = new RecipeDisplayId(size);
                RecipeDisplayEntry recipeDisplayEntry = new RecipeDisplayEntry(recipeDisplayId, recipeDisplay, optionalInt, recipe.h(), optional);
                list.add(new d(recipeDisplayEntry, recipeHolder));
            }
        }
        return list;
    }

    private static c b(Recipes<? extends RecipeSingleItem> recipeType) {
        return recipe -> {
            Optional<Object> optional;
            if (recipe.b() == recipeType && recipe instanceof RecipeSingleItem) {
                RecipeSingleItem singleItemRecipe = (RecipeSingleItem)recipe;
                optional = Optional.of(singleItemRecipe.k());
            } else {
                optional = Optional.empty();
            }
            return optional;
        };
    }

    private static /* synthetic */ int a(Object2IntMap map, Object object) {
        return map.size();
    }

    public record d(RecipeDisplayEntry a, RecipeHolder<?> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "display;parent", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "display;parent", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "display;parent", "a", "b"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface c {
        public Optional<RecipeItemStack> apply(IRecipe<?> var1);
    }

    public static class b
    implements Consumer<IRecipe<?>> {
        final ResourceKey<RecipePropertySet> a;
        private final c b;
        private final List<RecipeItemStack> c = new ArrayList<RecipeItemStack>();

        protected b(ResourceKey<RecipePropertySet> key, c extractor) {
            this.a = key;
            this.b = extractor;
        }

        public void a(IRecipe<?> recipe) {
            this.b.apply(recipe).ifPresent(this.c::add);
        }

        public RecipePropertySet a(FeatureFlagSet enabledFeatures) {
            return RecipePropertySet.a(CraftingManager.a(enabledFeatures, this.c));
        }
    }

    public static interface a<I extends RecipeInput, T extends IRecipe<I>> {
        public Optional<RecipeHolder<T>> a(I var1, WorldServer var2);
    }
}

