/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public final class ItemAttributeModifiers
extends Record {
    private final List<b> e;
    private final boolean f;
    public static final ItemAttributeModifiers a = new ItemAttributeModifiers(List.of(), true);
    private static final Codec<ItemAttributeModifiers> g = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.world.item.component.ItemAttributeModifiers$b.a.listOf().fieldOf("modifiers").forGetter(ItemAttributeModifiers::b), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(ItemAttributeModifiers::c)).apply((Applicative)instance, ItemAttributeModifiers::new));
    public static final Codec<ItemAttributeModifiers> b = Codec.withAlternative(g, (Codec)net.minecraft.world.item.component.ItemAttributeModifiers$b.a.listOf(), entries -> new ItemAttributeModifiers((List<b>)entries, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAttributeModifiers> c = StreamCodec.a(net.minecraft.world.item.component.ItemAttributeModifiers$b.b.a(ByteBufCodecs.a()), ItemAttributeModifiers::b, ByteBufCodecs.b, ItemAttributeModifiers::c, ItemAttributeModifiers::new);
    public static final DecimalFormat d = SystemUtils.a(new DecimalFormat("#.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public ItemAttributeModifiers(List<b> modifiers, boolean showInTooltip) {
        this.e = modifiers;
        this.f = showInTooltip;
    }

    public ItemAttributeModifiers a(boolean showInTooltip) {
        return new ItemAttributeModifiers(this.e, showInTooltip);
    }

    public static a a() {
        return new a();
    }

    public ItemAttributeModifiers a(Holder<AttributeBase> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.e.size() + 1));
        for (b entry : this.e) {
            if (entry.a(attribute, modifier.b())) continue;
            builder.add((Object)entry);
        }
        builder.add((Object)new b(attribute, modifier, slot));
        return new ItemAttributeModifiers((List<b>)builder.build(), this.f);
    }

    public void a(EquipmentSlotGroup slotGroup, BiConsumer<Holder<AttributeBase>, AttributeModifier> action) {
        for (b entry : this.e) {
            if (!entry.e.equals(slotGroup)) continue;
            action.accept(entry.c, entry.d);
        }
    }

    public void a(EnumItemSlot equipmentSlot, BiConsumer<Holder<AttributeBase>, AttributeModifier> action) {
        for (b entry : this.e) {
            if (!entry.e.b(equipmentSlot)) continue;
            action.accept(entry.c, entry.d);
        }
    }

    public double a(double baseValue, EnumItemSlot equipmentSlot) {
        double d2 = baseValue;
        for (b entry : this.e) {
            if (!entry.e.b(equipmentSlot)) continue;
            double amount = entry.d.c();
            d2 += (switch (entry.d.d()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.a -> amount;
                case AttributeModifier.Operation.b -> amount * baseValue;
                case AttributeModifier.Operation.c -> amount * d2;
            });
        }
        return d2;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemAttributeModifiers.class, "modifiers;showInTooltip", "e", "f"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemAttributeModifiers.class, "modifiers;showInTooltip", "e", "f"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemAttributeModifiers.class, "modifiers;showInTooltip", "e", "f"}, this, o2);
    }

    public List<b> b() {
        return this.e;
    }

    public boolean c() {
        return this.f;
    }

    public static class a {
        private final ImmutableList.Builder<b> a = ImmutableList.builder();

        a() {
        }

        public a a(Holder<AttributeBase> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
            this.a.add((Object)new b(attribute, modifier, slot));
            return this;
        }

        public ItemAttributeModifiers a() {
            return new ItemAttributeModifiers((List<b>)this.a.build(), true);
        }
    }

    public static final class b
    extends Record {
        private final Holder<AttributeBase> c;
        private final AttributeModifier d;
        private final EquipmentSlotGroup e;
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)AttributeBase.a.fieldOf("type").forGetter(b::a), (App)AttributeModifier.a.forGetter(b::b), (App)EquipmentSlotGroup.l.optionalFieldOf("slot", (Object)EquipmentSlotGroup.a).forGetter(b::c)).apply((Applicative)instance, b::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, b> b = StreamCodec.a(AttributeBase.b, b::a, AttributeModifier.c, b::b, EquipmentSlotGroup.m, b::c, b::new);

        public b(Holder<AttributeBase> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
            this.c = attribute;
            this.d = modifier;
            this.e = slot;
        }

        public boolean a(Holder<AttributeBase> attribute, MinecraftKey id) {
            return attribute.equals(this.c) && this.d.a(id);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "attribute;modifier;slot", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "attribute;modifier;slot", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "attribute;modifier;slot", "c", "d", "e"}, this, o2);
        }

        public Holder<AttributeBase> a() {
            return this.c;
        }

        public AttributeModifier b() {
            return this.d;
        }

        public EquipmentSlotGroup c() {
            return this.e;
        }
    }
}

