/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public final class DyedItemColor
extends Record
implements TooltipProvider {
    private final int d;
    private final boolean e;
    private static final Codec<DyedItemColor> f = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("rgb").forGetter(DyedItemColor::a), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(DyedItemColor::b)).apply((Applicative)instance, DyedItemColor::new));
    public static final Codec<DyedItemColor> a = Codec.withAlternative(f, (Codec)Codec.INT, color -> new DyedItemColor((int)color, true));
    public static final StreamCodec<ByteBuf, DyedItemColor> b = StreamCodec.a(ByteBufCodecs.g, DyedItemColor::a, ByteBufCodecs.b, DyedItemColor::b, DyedItemColor::new);
    public static final int c = -6265536;

    public DyedItemColor(int rgb, boolean showInTooltip) {
        this.d = rgb;
        this.e = showInTooltip;
    }

    public static int a(ItemStack stack, int defaultValue) {
        DyedItemColor dyedItemColor = stack.a(DataComponents.J);
        return dyedItemColor != null ? ARGB.f(dyedItemColor.a()) : defaultValue;
    }

    public static ItemStack a(ItemStack stack, List<ItemDye> dyes) {
        int i10;
        int i7;
        int i6;
        if (!stack.a(TagsItem.bO)) {
            return ItemStack.j;
        }
        ItemStack itemStack = stack.c(1);
        int i2 = 0;
        int i1 = 0;
        int i22 = 0;
        int i3 = 0;
        int i4 = 0;
        DyedItemColor dyedItemColor = itemStack.a(DataComponents.J);
        if (dyedItemColor != null) {
            int i5 = ARGB.b(dyedItemColor.a());
            i6 = ARGB.c(dyedItemColor.a());
            i7 = ARGB.d(dyedItemColor.a());
            i3 += Math.max(i5, Math.max(i6, i7));
            i2 += i5;
            i1 += i6;
            i22 += i7;
            ++i4;
        }
        for (ItemDye dyeItem : dyes) {
            i7 = dyeItem.b().d();
            int i8 = ARGB.b(i7);
            int i9 = ARGB.c(i7);
            i10 = ARGB.d(i7);
            i3 += Math.max(i8, Math.max(i9, i10));
            i2 += i8;
            i1 += i9;
            i22 += i10;
            ++i4;
        }
        int i5 = i2 / i4;
        i6 = i1 / i4;
        i7 = i22 / i4;
        float f2 = (float)i3 / (float)i4;
        float f1 = Math.max(i5, Math.max(i6, i7));
        i5 = (int)((float)i5 * f2 / f1);
        i6 = (int)((float)i6 * f2 / f1);
        i7 = (int)((float)i7 * f2 / f1);
        i10 = ARGB.a(0, i5, i6, i7);
        boolean flag = dyedItemColor == null || dyedItemColor.b();
        itemStack.b(DataComponents.J, new DyedItemColor(i10, flag));
        return itemStack;
    }

    @Override
    public void a(Item.b context, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag tooltipFlag) {
        if (this.e) {
            if (tooltipFlag.a()) {
                tooltipAdder.accept(IChatBaseComponent.a("item.color", new Object[]{String.format(Locale.ROOT, "#%06X", this.d)}).a(EnumChatFormat.h));
            } else {
                tooltipAdder.accept(IChatBaseComponent.c("item.dyed").a(EnumChatFormat.h, EnumChatFormat.u));
            }
        }
    }

    public DyedItemColor a(boolean showInTooltip) {
        return new DyedItemColor(this.d, showInTooltip);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DyedItemColor.class, "rgb;showInTooltip", "d", "e"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DyedItemColor.class, "rgb;showInTooltip", "d", "e"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DyedItemColor.class, "rgb;showInTooltip", "d", "e"}, this, o2);
    }

    public int a() {
        return this.d;
    }

    public boolean b() {
        return this.e;
    }
}

