/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class MobBucketItem
extends ItemBucket {
    private static final MapCodec<EntityTropicalFish.d> a = EntityTropicalFish.d.a.fieldOf("BucketVariantTag");
    private final EntityTypes<? extends EntityInsentient> b;
    private final SoundEffect c;

    public MobBucketItem(EntityTypes<? extends EntityInsentient> type, FluidType content, SoundEffect emptySound, Item.Info properties) {
        super(content, properties);
        this.b = type;
        this.c = emptySound;
    }

    @Override
    public void a(@Nullable EntityHuman player, World level, ItemStack containerStack, BlockPosition pos) {
        if (level instanceof WorldServer) {
            this.a((WorldServer)level, containerStack, pos);
            level.a((Entity)player, GameEvent.t, pos);
        }
    }

    @Override
    protected void a(@Nullable EntityHuman player, GeneratorAccess level, BlockPosition pos) {
        level.a(player, pos, this.c, SoundCategory.g, 1.0f, 1.0f);
    }

    private void a(WorldServer serverLevel, ItemStack bucketedMobStack, BlockPosition pos) {
        EntityInsentient mob = this.b.b(serverLevel, EntityTypes.a(serverLevel, bucketedMobStack, null), pos, EntitySpawnReason.l, true, false);
        if (mob instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)((Object)mob);
            CustomData customData = bucketedMobStack.a(DataComponents.X, CustomData.a);
            bucketable.h(customData.d());
            bucketable.x(true);
        }
        if (mob != null) {
            serverLevel.addFreshEntityWithPassengers(mob, CreatureSpawnEvent.SpawnReason.BUCKET);
            mob.U();
        }
    }

    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.b == EntityTypes.bz) {
            CustomData customData = stack.a(DataComponents.X, CustomData.a);
            if (customData.c()) {
                return;
            }
            Optional optional = customData.a(a).result();
            if (optional.isPresent()) {
                EntityTropicalFish.d variant = (EntityTropicalFish.d)optional.get();
                EnumChatFormat[] chatFormattings = new EnumChatFormat[]{EnumChatFormat.u, EnumChatFormat.h};
                String string = "color.minecraft." + String.valueOf(variant.c());
                String string1 = "color.minecraft." + String.valueOf(variant.d());
                int index = EntityTropicalFish.b.indexOf(variant);
                if (index != -1) {
                    tooltipComponents.add(IChatBaseComponent.c(EntityTropicalFish.b(index)).a(chatFormattings));
                    return;
                }
                tooltipComponents.add(variant.b().d().e().a(chatFormattings));
                IChatMutableComponent mutableComponent = IChatBaseComponent.c(string);
                if (!string.equals(string1)) {
                    mutableComponent.f(", ").b(IChatBaseComponent.c(string1));
                }
                mutableComponent.a(chatFormattings);
                tooltipComponents.add(mutableComponent);
            }
        }
    }
}

