/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import io.papermc.paper.event.entity.EntityAttemptSmashAttackEvent;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class MaceItem
extends Item {
    private static final int c = 5;
    private static final float d = -3.4f;
    public static final float a = 1.5f;
    private static final float m = 5.0f;
    public static final float b = 3.5f;
    private static final float n = 0.7f;

    public MaceItem(Item.Info properties) {
        super(properties);
    }

    public static ItemAttributeModifiers b() {
        return ItemAttributeModifiers.a().a(GenericAttributes.c, new AttributeModifier(Item.g, 5.0, AttributeModifier.Operation.a), EquipmentSlotGroup.b).a(GenericAttributes.e, new AttributeModifier(Item.h, -3.4f, AttributeModifier.Operation.a), EquipmentSlotGroup.b).a();
    }

    public static Tool c() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean a(IBlockData state, World level, BlockPosition pos, EntityHuman player) {
        return !player.b();
    }

    @Override
    public boolean a(ItemStack stack, EntityLiving target, EntityLiving attacker) {
        boolean canSmashAttack = MaceItem.b(attacker);
        EntityAttemptSmashAttackEvent event = new EntityAttemptSmashAttackEvent((LivingEntity)attacker.getBukkitLivingEntity(), (LivingEntity)target.getBukkitLivingEntity(), stack.asBukkitCopy(), canSmashAttack);
        event.callEvent();
        Event.Result result = event.getResult();
        if (result == Event.Result.ALLOW || canSmashAttack && result == Event.Result.DEFAULT) {
            EntityPlayer serverPlayer;
            WorldServer serverLevel = (WorldServer)attacker.dV();
            attacker.i(attacker.dy().a(EnumDirection.EnumAxis.b, (double)0.01f));
            if (attacker instanceof EntityPlayer) {
                serverPlayer = (EntityPlayer)attacker;
                serverPlayer.cy = this.a(serverPlayer);
                serverPlayer.x(true);
                serverPlayer.f.b(new PacketPlayOutEntityVelocity(serverPlayer));
            }
            if (target.aJ()) {
                if (attacker instanceof EntityPlayer) {
                    serverPlayer = (EntityPlayer)attacker;
                    serverPlayer.b(true);
                }
                SoundEffect soundEvent = attacker.Z > 5.0f ? SoundEffects.oO : SoundEffects.oN;
                serverLevel.a(null, attacker.dA(), attacker.dC(), attacker.dG(), soundEvent, attacker.dm(), 1.0f, 1.0f);
            } else {
                serverLevel.a(null, attacker.dA(), attacker.dC(), attacker.dG(), SoundEffects.oM, attacker.dm(), 1.0f, 1.0f);
            }
            MaceItem.a((World)serverLevel, (Entity)attacker, (Entity)target);
        }
        return true;
    }

    private Vec3D a(EntityPlayer player) {
        return player.gN() && player.cy != null && player.cy.e <= player.dt().e ? player.cy : player.dt();
    }

    @Override
    public void b(ItemStack stack, EntityLiving target, EntityLiving attacker) {
        stack.a(1, attacker, EnumItemSlot.a);
        if (MaceItem.b(attacker)) {
            attacker.k();
        }
    }

    @Override
    public float a(Entity target, float damage, DamageSource damageSource) {
        Entity entity = damageSource.c();
        if (entity instanceof EntityLiving) {
            float f2;
            EntityLiving livingEntity = (EntityLiving)entity;
            if (!MaceItem.b(livingEntity)) {
                return 0.0f;
            }
            float f3 = 3.0f;
            float f1 = 8.0f;
            float f22 = livingEntity.Z;
            float f32 = f22 <= 3.0f ? 4.0f * f22 : (f22 <= 8.0f ? 12.0f + 2.0f * (f22 - 3.0f) : 22.0f + f22 - 8.0f);
            World world = livingEntity.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                f2 = f32 + EnchantmentManager.b(serverLevel, livingEntity.dZ(), target, damageSource, 0.0f) * f22;
            } else {
                f2 = f32;
            }
            return f2;
        }
        return 0.0f;
    }

    private static void a(World level, Entity attacker, Entity target) {
        level.c(2013, target.aR(), 750);
        level.a(EntityLiving.class, target.cR().g(3.5), MaceItem.a(attacker, target)).forEach(livingEntity -> {
            Vec3D vec3 = livingEntity.dt().d(target.dt());
            double knockbackPower = MaceItem.a(attacker, livingEntity, vec3);
            Vec3D vec31 = vec3.d().c(knockbackPower);
            if (knockbackPower > 0.0) {
                livingEntity.j(vec31.d, 0.7f, vec31.f);
                if (livingEntity instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)livingEntity;
                    serverPlayer.f.b(new PacketPlayOutEntityVelocity(serverPlayer));
                }
            }
        });
    }

    private static Predicate<EntityLiving> a(Entity attacker, Entity target) {
        return livingEntity -> {
            EntityArmorStand armorStand;
            EntityTameableAnimal tamableAnimal;
            boolean flag = !livingEntity.Z_();
            boolean flag1 = livingEntity != attacker && livingEntity != target;
            boolean flag2 = !attacker.s((Entity)livingEntity);
            boolean flag3 = !(livingEntity instanceof EntityTameableAnimal && (tamableAnimal = (EntityTameableAnimal)livingEntity).p() && attacker.cG().equals(tamableAnimal.aa_()));
            boolean flag4 = !(livingEntity instanceof EntityArmorStand && (armorStand = (EntityArmorStand)livingEntity).x());
            boolean flag5 = target.g((Entity)livingEntity) <= Math.pow(3.5, 2.0);
            return flag && flag1 && flag2 && flag3 && flag4 && flag5;
        };
    }

    private static double a(Entity attacker, EntityLiving entity, Vec3D offset) {
        return (3.5 - offset.g()) * (double)0.7f * (double)(attacker.Z > 5.0f ? 2 : 1) * (1.0 - entity.h(GenericAttributes.p));
    }

    public static boolean b(EntityLiving entity) {
        return entity.Z > 1.5f && !entity.fJ();
    }

    @Override
    @Nullable
    public DamageSource a(EntityLiving entity) {
        return MaceItem.b(entity) ? entity.dW().f(entity) : super.a(entity);
    }
}

