/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.papermc.paper.event.entity.EntityDamageItemEvent;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import io.papermc.paper.util.ItemComponentSanitizer;
import io.papermc.paper.util.ItemObfuscationSession;
import io.papermc.paper.util.SafeAutoClosable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.NullOps;
import net.minecraft.util.Unit;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBed;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R3.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    private static final List<IChatBaseComponent> k = List.of(IChatBaseComponent.c("item.op_warning.line1").a(EnumChatFormat.m, EnumChatFormat.r), IChatBaseComponent.c("item.op_warning.line2").a(EnumChatFormat.m), IChatBaseComponent.c("item.op_warning.line3").a(EnumChatFormat.m));
    public static final Codec<ItemStack> a = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)Item.e.fieldOf("id").forGetter(ItemStack::i), (App)ExtraCodecs.a(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::M), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(stack -> stack.q.g())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> b = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)Item.e.fieldOf("id").forGetter(ItemStack::i), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(stack -> stack.q.g())).apply((Applicative)instance, (item, components) -> new ItemStack((Holder<Item>)item, 1, (DataComponentPatch)components))));
    public static final Codec<ItemStack> c = a.validate(ItemStack::c);
    public static final Codec<ItemStack> d = b.validate(ItemStack::c);
    public static final Codec<ItemStack> e = ExtraCodecs.g(a).xmap(optional -> optional.orElse(j), stack -> stack.f() ? Optional.empty() : Optional.of(stack));
    public static final Codec<ItemStack> f = Item.e.xmap(ItemStack::new, ItemStack::i);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> g = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> a = ByteBufCodecs.b(Registries.K);

        public ItemStack a(RegistryFriendlyByteBuf buffer) {
            int varInt = buffer.l();
            if (varInt <= 0) {
                return j;
            }
            Holder holder = (Holder)a.decode(buffer);
            DataComponentPatch dataComponentPatch = (DataComponentPatch)DataComponentPatch.c.decode(buffer);
            ItemStack stack = new ItemStack(holder, varInt, dataComponentPatch);
            return stack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void a(RegistryFriendlyByteBuf buffer, ItemStack value) {
            if (value.f() || value.h() == null) {
                buffer.c(0);
            } else {
                buffer.c(ItemComponentSanitizer.sanitizeCount(ItemObfuscationSession.currentSession(), value, value.M()));
                a.encode(buffer, value.i());
                boolean prev = ComponentSerialization.DONT_RENDER_TRANSLATABLES.get();
                try (SafeAutoClosable ignored = ItemObfuscationSession.withContext(c2 -> c2.itemStack(value));){
                    ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(true);
                    DataComponentPatch.c.encode(buffer, value.q.g());
                }
                finally {
                    ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(prev);
                }
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> h = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        public ItemStack a(RegistryFriendlyByteBuf buffer) {
            ItemStack itemStack = (ItemStack)g.decode(buffer);
            if (itemStack.f()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return itemStack;
        }

        public void a(RegistryFriendlyByteBuf buffer, ItemStack value) {
            if (value.f()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            g.encode(buffer, value);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> i = g.a(ByteBufCodecs.a(NonNullList::a));
    private static final Logger l = LogUtils.getLogger();
    public static final ItemStack j = new ItemStack((Void)null);
    private static final IChatBaseComponent m = IChatBaseComponent.c("item.disabled").a(EnumChatFormat.m);
    private int n;
    private int o;
    @Deprecated
    @Nullable
    private Item p;
    PatchedDataComponentMap q;
    @Nullable
    private net.minecraft.world.entity.Entity r;
    private CraftItemStack bukkitStack;

    private static DataResult<ItemStack> c(ItemStack stack) {
        DataResult<Unit> dataResult = ItemStack.a(stack.a());
        if (dataResult.isError()) {
            return dataResult.map(unit -> stack);
        }
        return stack.M() > stack.k() ? DataResult.error(() -> "Item stack with stack size of " + stack.M() + " was larger than maximum: " + stack.k()) : DataResult.success((Object)stack);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> a(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> codec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack a(RegistryFriendlyByteBuf buffer) {
                ItemStack itemStack = (ItemStack)codec.decode(buffer);
                if (!itemStack.f()) {
                    RegistryOps<Unit> registryOps = buffer.H().a(NullOps.a);
                    a.encodeStart(registryOps, (Object)itemStack).getOrThrow(DecoderException::new);
                }
                return itemStack;
            }

            public void a(RegistryFriendlyByteBuf buffer, ItemStack value) {
                codec.encode(buffer, value);
            }
        };
    }

    public Optional<TooltipComponent> b() {
        return this.h().k(this);
    }

    @Override
    public DataComponentMap a() {
        return !this.f() ? this.q : DataComponentMap.a;
    }

    public DataComponentMap c() {
        return !this.f() ? this.h().g() : DataComponentMap.a;
    }

    public DataComponentPatch d() {
        return !this.f() ? this.q.g() : DataComponentPatch.a;
    }

    public DataComponentMap e() {
        return !this.f() ? this.q.i() : DataComponentMap.a;
    }

    public boolean c(DataComponentType<?> component) {
        return !this.f() && this.q.d(component);
    }

    public ItemStack(IMaterial item) {
        this(item, 1);
    }

    public ItemStack(Holder<Item> tag) {
        this(tag.a(), 1);
    }

    public ItemStack(Holder<Item> tag, int count, DataComponentPatch components) {
        this(tag.a(), count, PatchedDataComponentMap.a(tag.a().g(), components));
    }

    public ItemStack(Holder<Item> item, int count) {
        this(item.a(), count);
    }

    public ItemStack(IMaterial item, int count) {
        this(item, count, new PatchedDataComponentMap(item.j().g()));
    }

    private ItemStack(IMaterial item, int count, PatchedDataComponentMap components) {
        this.p = item.j();
        this.n = count;
        this.q = components;
        this.h().l(this);
    }

    private ItemStack(@Nullable Void unused) {
        this.p = null;
        this.q = new PatchedDataComponentMap(DataComponentMap.a);
    }

    public static DataResult<Unit> a(DataComponentMap components) {
        if (components.b(DataComponents.d) && components.a(DataComponents.c, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemContainerContents = components.a(DataComponents.al, ItemContainerContents.a);
        for (ItemStack itemStack : itemContainerContents.d()) {
            int maxStackSize;
            int count = itemStack.M();
            if (count <= (maxStackSize = itemStack.k())) continue;
            return DataResult.error(() -> "Item stack with count of " + count + " was larger than maximum: " + maxStackSize);
        }
        return DataResult.success((Object)((Object)Unit.a));
    }

    public static Optional<ItemStack> a(HolderLookup.a lookupProvider, NBTBase tag) {
        return a.parse(lookupProvider.a(DynamicOpsNBT.a), (Object)tag).resultOrPartial(itemId -> l.error("Tried to load invalid item: '{}'", itemId));
    }

    public static ItemStack a(HolderLookup.a lookupProvider, NBTTagCompound tag) {
        return tag.g() ? j : ItemStack.a(lookupProvider, (NBTBase)tag).orElse(j);
    }

    public boolean f() {
        return this == j || this.p == Items.a || this.n <= 0;
    }

    public boolean a(FeatureFlagSet enabledFlags) {
        return this.f() || this.h().a(enabledFlags);
    }

    public ItemStack a(int amount) {
        int min = Math.min(amount, this.M());
        ItemStack itemStack = this.c(min);
        this.h(min);
        return itemStack;
    }

    public ItemStack g() {
        if (this.f()) {
            return j;
        }
        ItemStack itemStack = this.v();
        this.e(0);
        return itemStack;
    }

    public Item h() {
        return this.f() ? Items.a : this.p;
    }

    public Holder<Item> i() {
        return this.h().f();
    }

    public boolean a(TagKey<Item> tag) {
        return this.h().f().a(tag);
    }

    public boolean a(Item item) {
        return this.h() == item;
    }

    public boolean a(Predicate<Holder<Item>> item) {
        return item.test(this.h().f());
    }

    public boolean a(Holder<Item> item) {
        return this.h().f() == item;
    }

    public boolean a(HolderSet<Item> item) {
        return item.a(this.i());
    }

    public Stream<TagKey<Item>> j() {
        return this.h().f().c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumInteractionResult a(ItemActionContext context) {
        EnumInteractionResult.d success;
        EnumInteractionResult interactionResult;
        EntityHuman player = context.o();
        BlockPosition clickedPos = context.a();
        if (player != null && !player.gj().e && !this.a(new ShapeDetectorBlock(context.q(), clickedPos, false))) {
            return EnumInteractionResult.e;
        }
        Item item = this.h();
        DataComponentPatch previousPatch = this.q.g();
        int oldCount = this.M();
        WorldServer serverLevel = (WorldServer)context.q();
        if (!(item instanceof ItemBucket)) {
            serverLevel.captureBlockStates = true;
            if (item == Items.sv) {
                serverLevel.captureTreeGeneration = true;
            }
        }
        try {
            interactionResult = item.a(context);
        }
        finally {
            serverLevel.captureBlockStates = false;
        }
        DataComponentPatch newPatch = this.q.g();
        int newCount = this.M();
        this.e(oldCount);
        this.restorePatch(previousPatch);
        if (interactionResult.a() && serverLevel.captureTreeGeneration && !serverLevel.capturedBlockStates.isEmpty()) {
            serverLevel.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(clickedPos, (World)serverLevel.getWorld());
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(serverLevel.capturedBlockStates.values());
            serverLevel.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.h() == Items.sv;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (Player)player.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(serverLevel, clickedPos), (Player)player.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.M() == oldCount && Objects.equals(this.q.g(), previousPatch)) {
                    this.restorePatch(newPatch);
                    this.e(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    CapturedBlockState.setBlockState(blockstate);
                    serverLevel.checkCapturedTreeStateForObserverNotify(clickedPos, blockstate);
                }
                player.b(StatisticList.c.b(item));
            }
            ItemSign.openSign = null;
            return interactionResult;
        }
        serverLevel.captureTreeGeneration = false;
        if (player != null && interactionResult instanceof EnumInteractionResult.d && (success = (EnumInteractionResult.d)interactionResult).c()) {
            EnumHand hand = context.p();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(serverLevel.capturedBlockStates.values());
            serverLevel.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(serverLevel, player, hand, blocks, clickedPos.u(), clickedPos.v(), clickedPos.w());
            } else if (blocks.size() == 1 && item != Items.ri) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(serverLevel, player, hand, (BlockState)blocks.getFirst(), clickedPos.u(), clickedPos.v(), clickedPos.w());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                interactionResult = EnumInteractionResult.d;
                placeEvent.getPlayer().updateInventory();
                serverLevel.capturedTileEntities.clear();
                serverLevel.preventPoiUpdated = true;
                serverLevel.isBlockPlaceCancelled = true;
                for (BlockState blockstate : blocks) {
                    blockstate.update(true, false);
                }
                serverLevel.isBlockPlaceCancelled = false;
                serverLevel.preventPoiUpdated = false;
                ItemSign.openSign = null;
            } else {
                BlockPosition position;
                IBlockData blockData;
                TileEntity te;
                if (this.M() == oldCount && Objects.equals(this.q.g(), previousPatch)) {
                    this.restorePatch(newPatch);
                    this.e(newCount);
                }
                for (Map.Entry<BlockPosition, TileEntity> e2 : serverLevel.capturedTileEntities.entrySet()) {
                    serverLevel.a(e2.getValue());
                }
                for (BlockState blockstate : blocks) {
                    int updateFlag = ((CraftBlockState)blockstate).getFlag();
                    IBlockData oldBlock = ((CraftBlockState)blockstate).getHandle();
                    BlockPosition newPos = ((CraftBlockState)blockstate).getPosition();
                    IBlockData block = serverLevel.a_(newPos);
                    if (!(block.b() instanceof BlockTileEntity)) {
                        block.onPlace(serverLevel, newPos, oldBlock, true, context);
                    }
                    serverLevel.notifyAndUpdatePhysics(newPos, null, oldBlock, block, serverLevel.a_(newPos), updateFlag, 512);
                }
                if (this.p == Items.vl) {
                    BlockPosition bp = clickedPos;
                    if (!serverLevel.a_(clickedPos).v()) {
                        bp = !serverLevel.a_(clickedPos).e() ? null : bp.a(context.k());
                    }
                    if (bp != null && (te = serverLevel.c_(bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)serverLevel, bp, (TileEntitySkull)te);
                    }
                }
                if (this.p instanceof ItemSign && ItemSign.openSign != null) {
                    try {
                        te = serverLevel.c_(ItemSign.openSign);
                        if (te instanceof TileEntitySign) {
                            TileEntitySign blockEntity = (TileEntitySign)te;
                            Block updateFlag = serverLevel.a_(ItemSign.openSign).b();
                            if (updateFlag instanceof BlockSign) {
                                BlockSign signBlock = (BlockSign)updateFlag;
                                signBlock.openTextEdit(player, blockEntity, true, PlayerOpenSignEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (placeEvent != null && this.p instanceof ItemBed && (blockData = serverLevel.a_(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).b() instanceof BlockBed) {
                    serverLevel.b(position, Blocks.a);
                    blockData.a((GeneratorAccess)serverLevel, position, 3);
                }
                if (this.p instanceof ItemBlock) {
                    position = new BlockActionContext(context).a();
                    blockData = serverLevel.a_(position);
                    SoundEffectType soundeffecttype = blockData.A();
                    serverLevel.a(player, clickedPos, soundeffecttype.e(), SoundCategory.e, (soundeffecttype.a() + 1.0f) / 2.0f, soundeffecttype.b() * 0.8f);
                }
                player.b(StatisticList.c.b(item));
            }
        }
        serverLevel.capturedTileEntities.clear();
        serverLevel.capturedBlockStates.clear();
        return interactionResult;
    }

    public float a(IBlockData state) {
        return this.h().a(this, state);
    }

    public EnumInteractionResult a(net.minecraft.world.level.World level, EntityHuman player, EnumHand hand) {
        EnumInteractionResult.d success;
        ItemStack itemStack = this.v();
        boolean flag = this.a(player) <= 0;
        EnumInteractionResult interactionResult = this.h().a(level, player, hand);
        return flag && interactionResult instanceof EnumInteractionResult.d ? success.a((success = (EnumInteractionResult.d)interactionResult).d() == null ? this.a((EntityLiving)player, itemStack) : success.d().a((EntityLiving)player, itemStack)) : interactionResult;
    }

    public ItemStack a(net.minecraft.world.level.World level, EntityLiving livingEntity) {
        ItemStack itemStack = this.v();
        ItemStack itemStack1 = this.h().a(this, level, livingEntity);
        return itemStack1.a(livingEntity, itemStack);
    }

    private ItemStack a(EntityLiving entity, ItemStack stack) {
        UseRemainder useRemainder = stack.a(DataComponents.y);
        UseCooldown useCooldown = stack.a(DataComponents.z);
        int count = stack.M();
        ItemStack itemStack = this;
        if (useRemainder != null) {
            itemStack = useRemainder.a(this, count, entity.fV(), entity::b);
        }
        if (useCooldown != null) {
            useCooldown.a(stack, entity);
        }
        return itemStack;
    }

    public NBTBase b(HolderLookup.a levelRegistryAccess, NBTBase outputTag) {
        if (this.f()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)a.encode((Object)this, levelRegistryAccess.a(DynamicOpsNBT.a), (Object)outputTag).getOrThrow();
    }

    public NBTBase a(HolderLookup.a levelRegistryAccess) {
        if (this.f()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)a.encodeStart(levelRegistryAccess.a(DynamicOpsNBT.a), (Object)this).getOrThrow();
    }

    public NBTBase b(HolderLookup.a levelRegistryAccess) {
        return this.f() ? new NBTTagCompound() : this.b(levelRegistryAccess, new NBTTagCompound());
    }

    public int k() {
        return this.a(DataComponents.c, Integer.valueOf(1));
    }

    public boolean l() {
        return this.k() > 1 && (!this.m() || !this.n());
    }

    public boolean m() {
        return this.b(DataComponents.d) && !this.b(DataComponents.f) && this.b(DataComponents.e);
    }

    public boolean n() {
        return this.m() && this.o() > 0;
    }

    public int o() {
        return MathHelper.a((int)this.a(DataComponents.e, Integer.valueOf(0)), 0, this.p());
    }

    public void b(int damage) {
        this.b(DataComponents.e, Integer.valueOf(MathHelper.a(damage, 0, this.p())));
    }

    public int p() {
        return this.a(DataComponents.d, Integer.valueOf(0));
    }

    public boolean q() {
        return this.m() && this.o() >= this.p();
    }

    public boolean r() {
        return this.m() && this.o() >= this.p() - 1;
    }

    public void hurtAndBreak(int damage, WorldServer level, @Nullable EntityLiving player, Consumer<Item> onBreak) {
        this.hurtAndBreak(damage, level, player, onBreak, false);
    }

    public void hurtAndBreak(int damage, WorldServer level, @Nullable EntityLiving player, Consumer<Item> onBreak, boolean force) {
        int originalDamage = damage;
        int i2 = this.processDurabilityChange(damage, level, player, force);
        if (i2 > 0 && player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), i2, originalDamage);
            event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
            if (i2 != event.getDamage() || event.isCancelled()) {
                event.getPlayer().updateInventory();
            }
            if (event.isCancelled()) {
                return;
            }
            i2 = event.getDamage();
        } else if (i2 > 0 && player != null) {
            EntityDamageItemEvent event = new EntityDamageItemEvent((Entity)player.getBukkitLivingEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), i2);
            if (!event.callEvent()) {
                return;
            }
            i2 = event.getDamage();
        }
        if (i2 != 0) {
            this.applyDamage(this.o() + i2, player, onBreak);
        }
    }

    private int processDurabilityChange(int damage, WorldServer level, @Nullable EntityLiving player) {
        return this.processDurabilityChange(damage, level, player, false);
    }

    private int processDurabilityChange(int damage, WorldServer level, @Nullable EntityLiving player, boolean force) {
        if (!this.m()) {
            return 0;
        }
        if (player instanceof EntityPlayer && player.fV() && !force) {
            return 0;
        }
        return damage > 0 ? EnchantmentManager.a(level, this, damage) : damage;
    }

    private void applyDamage(int damage, @Nullable EntityLiving player, Consumer<Item> onBreak) {
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            CriterionTriggers.u.a(serverPlayer, this, damage);
        }
        this.b(damage);
        if (this.q()) {
            Item item = this.h();
            if (this.n == 1 && player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                CraftEventFactory.callPlayerItemBreakEvent(serverPlayer, this);
            }
            this.h(1);
            onBreak.accept(item);
        }
    }

    public void a(int damage, EntityHuman player) {
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            int i2 = this.processDurabilityChange(damage, serverPlayer.y(), serverPlayer);
            if (i2 == 0) {
                return;
            }
            int min = Math.min(this.o() + i2, this.p() - 1);
            if (min - this.o() > 0) {
                PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), min - this.o(), damage);
                if (!event.callEvent() || event.getDamage() == 0) {
                    return;
                }
                min = Math.min(this.o() + event.getDamage(), this.p() - 1);
            }
            this.applyDamage(min, serverPlayer, item -> {});
        }
    }

    public void a(int amount, EntityLiving entity, EnumItemSlot slot) {
        this.hurtAndBreak(amount, entity, slot, false);
    }

    public void hurtAndBreak(int amount, EntityLiving entity, EnumItemSlot slot, boolean force) {
        net.minecraft.world.level.World world = entity.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.hurtAndBreak(amount, serverLevel, entity, item -> {
                if (slot != null) {
                    entity.a((Item)item, slot);
                }
            }, force);
        }
    }

    public ItemStack a(int amount, IMaterial item, EntityLiving entity, EnumItemSlot slot) {
        this.a(amount, entity, slot);
        if (this.f()) {
            ItemStack itemStack = this.b(item, 1);
            if (itemStack.m()) {
                itemStack.b(0);
            }
            return itemStack;
        }
        return this;
    }

    public boolean s() {
        return this.h().d(this);
    }

    public int t() {
        return this.h().e(this);
    }

    public int u() {
        return this.h().f(this);
    }

    public boolean a(Slot slot, ClickAction action, EntityHuman player) {
        return this.h().a(this, slot, action, player);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction action, EntityHuman player, SlotAccess access) {
        return this.h().a(this, stack, slot, action, player, access);
    }

    public boolean a(EntityLiving enemy, EntityLiving attacker) {
        Item item = this.h();
        if (item.a(this, enemy, attacker)) {
            if (attacker instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)attacker;
                player.b(StatisticList.c.b(item));
            }
            return true;
        }
        return false;
    }

    public void b(EntityLiving enemy, EntityLiving attacker) {
        this.h().b(this, enemy, attacker);
    }

    public void a(net.minecraft.world.level.World level, IBlockData state, BlockPosition pos, EntityHuman player) {
        Item item = this.h();
        if (item.a(this, level, state, pos, player)) {
            player.b(StatisticList.c.b(item));
        }
    }

    public boolean b(IBlockData state) {
        return this.h().b(this, state);
    }

    public EnumInteractionResult a(EntityHuman player, EntityLiving entity, EnumHand usedHand) {
        return this.h().a(this, player, entity, usedHand);
    }

    public ItemStack v() {
        return this.copy(false);
    }

    public ItemStack copy(boolean originalItem) {
        if (!originalItem && this.f()) {
            return j;
        }
        ItemStack itemStack = new ItemStack(originalItem ? this.p : this.h(), this.n, this.q.h());
        itemStack.d(this.L());
        return itemStack;
    }

    public ItemStack c(int count) {
        if (this.f()) {
            return j;
        }
        ItemStack itemStack = this.v();
        itemStack.e(count);
        return itemStack;
    }

    public ItemStack a(IMaterial item) {
        return this.a(item, this.M());
    }

    public ItemStack a(IMaterial item, int count) {
        return this.f() ? j : this.b(item, count);
    }

    private ItemStack b(IMaterial item, int count) {
        return new ItemStack(item.j().f(), count, this.q.g());
    }

    public static boolean a(ItemStack stack, ItemStack other) {
        return stack == other || stack.M() == other.M() && ItemStack.c(stack, other);
    }

    @Deprecated
    public static boolean a(List<ItemStack> list, List<ItemStack> other) {
        if (list.size() != other.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (ItemStack.a(list.get(i2), other.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean b(ItemStack stack, ItemStack other) {
        return stack.a(other.h());
    }

    public static boolean c(ItemStack stack, ItemStack other) {
        return stack.a(other.h()) && (stack.f() && other.f() || Objects.equals(stack.q, other.q));
    }

    public static MapCodec<ItemStack> a(String fieldName) {
        return a.lenientOptionalFieldOf(fieldName).xmap(optional -> optional.orElse(j), stack -> stack.f() ? Optional.empty() : Optional.of(stack));
    }

    public static int a(@Nullable ItemStack stack) {
        if (stack != null) {
            int i2 = 31 + stack.h().hashCode();
            return 31 * i2 + stack.a().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int a(List<ItemStack> list) {
        int i2 = 0;
        for (ItemStack itemStack : list) {
            i2 = i2 * 31 + ItemStack.a(itemStack);
        }
        return i2;
    }

    public String toString() {
        return this.M() + " " + String.valueOf(this.h());
    }

    public void a(net.minecraft.world.level.World level, net.minecraft.world.entity.Entity entity, int inventorySlot, boolean isCurrentItem) {
        if (this.o > 0) {
            --this.o;
        }
        if (this.h() != null) {
            this.h().a(this, level, entity, inventorySlot, isCurrentItem);
        }
    }

    public void a(net.minecraft.world.level.World level, EntityHuman player, int amount) {
        player.a(StatisticList.b.b(this.h()), amount);
        this.h().a(this, level, player);
    }

    public void a(net.minecraft.world.level.World level) {
        this.h().a(this, level);
    }

    public int a(EntityLiving entity) {
        return this.h().a(this, entity);
    }

    public ItemUseAnimation w() {
        return this.h().b(this);
    }

    public void a(net.minecraft.world.level.World level, EntityLiving livingEntity, int timeLeft) {
        ItemStack itemStack1;
        ItemStack itemStack = this.v();
        if (this.h().a(this, level, livingEntity, timeLeft) && (itemStack1 = this.a(livingEntity, itemStack)) != this) {
            livingEntity.a(livingEntity.fA(), itemStack1);
        }
    }

    public boolean x() {
        return this.h().d_(this);
    }

    public void restorePatch(DataComponentPatch datacomponentpatch) {
        this.q.b(datacomponentpatch);
    }

    @Nullable
    public <T> T b(DataComponentType<? super T> component, @Nullable T value) {
        return this.q.b(component, value);
    }

    @Nullable
    public <T, U> T a(DataComponentType<T> component, T defaultValue, U updateValue, BiFunction<T, U, T> updater) {
        return this.b(component, updater.apply(this.a(component, defaultValue), updateValue));
    }

    @Nullable
    public <T> T a(DataComponentType<T> component, T defaultValue, UnaryOperator<T> updater) {
        T orDefault = this.a(component, defaultValue);
        return this.b(component, updater.apply(orDefault));
    }

    @Nullable
    public <T> T d(DataComponentType<? extends T> component) {
        return this.q.e(component);
    }

    public void a(DataComponentPatch components) {
        DataComponentPatch patch = this.q.g();
        this.q.a(components);
        Optional optional = ItemStack.c(this).error();
        if (optional.isPresent()) {
            l.error("Failed to apply component patch '{}' to item: '{}'", (Object)components, (Object)((DataResult.Error)optional.get()).message());
            this.q.b(patch);
        } else {
            this.h().l(this);
        }
    }

    public org.bukkit.inventory.ItemStack asBukkitMirror() {
        return CraftItemStack.asCraftMirror(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitCopy() {
        return CraftItemStack.asCraftMirror(this.v());
    }

    public static ItemStack fromBukkitCopy(org.bukkit.inventory.ItemStack itemstack) {
        return CraftItemStack.asNMSCopy(itemstack);
    }

    public org.bukkit.inventory.ItemStack getBukkitStack() {
        if (this.bukkitStack == null || this.bukkitStack.handle != this) {
            this.bukkitStack = CraftItemStack.asCraftMirror(this);
        }
        return this.bukkitStack;
    }

    public void b(DataComponentPatch components) {
        this.q.a(components);
        this.h().l(this);
    }

    public void b(DataComponentMap components) {
        this.q.a(components);
        this.h().l(this);
    }

    public IChatBaseComponent y() {
        IChatBaseComponent customName = this.z();
        return customName != null ? customName : this.A();
    }

    @Nullable
    public IChatBaseComponent z() {
        String string;
        IChatBaseComponent component = this.a(DataComponents.g);
        if (component != null) {
            return component;
        }
        WrittenBookContent writtenBookContent = this.a(DataComponents.T);
        if (writtenBookContent != null && !UtilColor.h(string = writtenBookContent.d().a())) {
            return IChatBaseComponent.b(string);
        }
        return null;
    }

    public IChatBaseComponent A() {
        return this.h().a(this);
    }

    public IChatBaseComponent B() {
        IChatMutableComponent mutableComponent = IChatBaseComponent.i().b(this.y()).a(this.D().a());
        if (this.b(DataComponents.g)) {
            mutableComponent.a(EnumChatFormat.u);
        }
        return mutableComponent;
    }

    private <T extends TooltipProvider> void a(DataComponentType<T> component, Item.b context, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag tooltipFlag) {
        TooltipProvider tooltipProvider = (TooltipProvider)this.a(component);
        if (tooltipProvider != null) {
            tooltipProvider.a(context, tooltipAdder, tooltipFlag);
        }
    }

    public List<IChatBaseComponent> a(Item.b tooltipContext, @Nullable EntityHuman player, TooltipFlag tooltipFlag) {
        AdventureModePredicate adventureModePredicate1;
        MapId mapId;
        boolean shouldPrintOpWarning = this.h().a(this, player);
        if (!tooltipFlag.b() && this.b(DataComponents.r)) {
            return shouldPrintOpWarning ? k : List.of();
        }
        ArrayList list = Lists.newArrayList();
        list.add(this.B());
        if (!tooltipFlag.a() && !this.b(DataComponents.g) && (mapId = this.a(DataComponents.L)) != null) {
            list.add(ItemWorldMap.a(mapId));
        }
        Consumer<IChatBaseComponent> consumer = list::add;
        if (!this.b(DataComponents.q)) {
            this.h().a(this, tooltipContext, list, tooltipFlag);
        }
        this.a(DataComponents.ab, tooltipContext, consumer, tooltipFlag);
        this.a(DataComponents.U, tooltipContext, consumer, tooltipFlag);
        this.a(DataComponents.I, tooltipContext, consumer, tooltipFlag);
        this.a(DataComponents.l, tooltipContext, consumer, tooltipFlag);
        this.a(DataComponents.J, tooltipContext, consumer, tooltipFlag);
        this.a(DataComponents.j, tooltipContext, consumer, tooltipFlag);
        this.a(consumer, player);
        this.a(DataComponents.f, tooltipContext, consumer, tooltipFlag);
        this.a(DataComponents.aa, tooltipContext, consumer, tooltipFlag);
        this.a(DataComponents.R, tooltipContext, consumer, tooltipFlag);
        AdventureModePredicate adventureModePredicate = this.a(DataComponents.n);
        if (adventureModePredicate != null && adventureModePredicate.a()) {
            consumer.accept(CommonComponents.a);
            consumer.accept(AdventureModePredicate.c);
            adventureModePredicate.a(consumer);
        }
        if ((adventureModePredicate1 = this.a(DataComponents.m)) != null && adventureModePredicate1.a()) {
            consumer.accept(CommonComponents.a);
            consumer.accept(AdventureModePredicate.d);
            adventureModePredicate1.a(consumer);
        }
        if (tooltipFlag.a()) {
            if (this.n()) {
                list.add(IChatBaseComponent.a("item.durability", this.p() - this.o(), this.p()));
            }
            list.add(IChatBaseComponent.b(BuiltInRegistries.g.b(this.h()).toString()).a(EnumChatFormat.i));
            int size = this.q.d();
            if (size > 0) {
                list.add(IChatBaseComponent.a("item.components", size).a(EnumChatFormat.i));
            }
        }
        if (player != null && !this.h().a(player.dV().K())) {
            list.add(m);
        }
        if (shouldPrintOpWarning) {
            list.addAll(k);
        }
        return list;
    }

    private void a(Consumer<IChatBaseComponent> tooltipAdder, @Nullable EntityHuman player) {
        ItemAttributeModifiers itemAttributeModifiers = this.a(DataComponents.o, ItemAttributeModifiers.a);
        if (itemAttributeModifiers.c()) {
            for (EquipmentSlotGroup equipmentSlotGroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableBoolean = new MutableBoolean(true);
                this.a(equipmentSlotGroup, (Holder<AttributeBase> attribute, AttributeModifier modifier) -> {
                    if (mutableBoolean.isTrue()) {
                        tooltipAdder.accept(CommonComponents.a);
                        tooltipAdder.accept(IChatBaseComponent.c("item.modifiers." + equipmentSlotGroup.c()).a(EnumChatFormat.h));
                        mutableBoolean.setFalse();
                    }
                    this.a(tooltipAdder, player, (Holder<AttributeBase>)attribute, (AttributeModifier)modifier);
                });
            }
        }
    }

    private void a(Consumer<IChatBaseComponent> tooltipAdder, @Nullable EntityHuman player, Holder<AttributeBase> attribute, AttributeModifier modifier) {
        double amount = modifier.c();
        boolean flag = false;
        if (player != null) {
            if (modifier.a(Item.g)) {
                amount += player.i(GenericAttributes.c);
                flag = true;
            } else if (modifier.a(Item.h)) {
                amount += player.i(GenericAttributes.e);
                flag = true;
            }
        }
        double d2 = modifier.d() == AttributeModifier.Operation.b || modifier.d() == AttributeModifier.Operation.c ? amount * 100.0 : (attribute.a(GenericAttributes.p) ? amount * 10.0 : amount);
        if (flag) {
            tooltipAdder.accept(CommonComponents.a().b(IChatBaseComponent.a("attribute.modifier.equals." + modifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(d2), IChatBaseComponent.c(attribute.a().c())})).a(EnumChatFormat.c));
        } else if (amount > 0.0) {
            tooltipAdder.accept(IChatBaseComponent.a("attribute.modifier.plus." + modifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(d2), IChatBaseComponent.c(attribute.a().c())}).a(attribute.a().b(true)));
        } else if (amount < 0.0) {
            tooltipAdder.accept(IChatBaseComponent.a("attribute.modifier.take." + modifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(-d2), IChatBaseComponent.c(attribute.a().c())}).a(attribute.a().b(false)));
        }
    }

    public boolean C() {
        Boolean _boolean = this.a(DataComponents.u);
        return _boolean != null ? _boolean.booleanValue() : this.h().c_(this);
    }

    public EnumItemRarity D() {
        EnumItemRarity rarity = this.a(DataComponents.k, EnumItemRarity.a);
        if (!this.F()) {
            return rarity;
        }
        return switch (rarity) {
            case EnumItemRarity.a, EnumItemRarity.b -> EnumItemRarity.c;
            case EnumItemRarity.c -> EnumItemRarity.d;
            default -> rarity;
        };
    }

    public boolean E() {
        if (!this.b(DataComponents.C)) {
            return false;
        }
        ItemEnchantments itemEnchantments = this.a(DataComponents.l);
        return itemEnchantments != null && itemEnchantments.d();
    }

    public void a(Holder<Enchantment> enchantment, int level) {
        EnchantmentManager.a(this, (ItemEnchantments.a enchantments) -> enchantments.b(enchantment, level));
    }

    public boolean F() {
        return !this.a(DataComponents.l, ItemEnchantments.a).d();
    }

    public ItemEnchantments G() {
        return this.a(DataComponents.l, ItemEnchantments.a);
    }

    public boolean H() {
        return this.r instanceof EntityItemFrame;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity) {
        if (!this.f()) {
            this.r = entity;
        }
    }

    @Nullable
    public EntityItemFrame I() {
        return this.r instanceof EntityItemFrame ? (EntityItemFrame)this.J() : null;
    }

    @Nullable
    public net.minecraft.world.entity.Entity J() {
        return !this.f() ? this.r : null;
    }

    public void a(EquipmentSlotGroup slotGroup, BiConsumer<Holder<AttributeBase>, AttributeModifier> action) {
        ItemAttributeModifiers itemAttributeModifiers = this.a(DataComponents.o, ItemAttributeModifiers.a);
        itemAttributeModifiers.a(slotGroup, action);
        EnchantmentManager.a(this, slotGroup, action);
    }

    public void a(EnumItemSlot equipmentSLot, BiConsumer<Holder<AttributeBase>, AttributeModifier> action) {
        ItemAttributeModifiers itemAttributeModifiers = this.a(DataComponents.o, ItemAttributeModifiers.a);
        itemAttributeModifiers.a(equipmentSLot, action);
        EnchantmentManager.a(this, equipmentSLot, action);
    }

    @Deprecated
    public void setItem(Item item) {
        this.bukkitStack = null;
        this.p = item;
        DataComponentPatch patch = this.d();
        this.q = new PatchedDataComponentMap(this.p.g());
        this.b(patch);
    }

    public IChatBaseComponent K() {
        IChatMutableComponent mutableComponent = IChatBaseComponent.i().b(this.y());
        if (this.b(DataComponents.g)) {
            mutableComponent.a(EnumChatFormat.u);
        }
        IChatMutableComponent mutableComponent1 = ChatComponentUtils.a(mutableComponent);
        if (!this.f()) {
            mutableComponent1.a(this.D().a()).a(style -> style.a(new ChatHoverable(ChatHoverable.EnumHoverAction.b, new ChatHoverable.c(this))));
        }
        return mutableComponent1;
    }

    public boolean a(ShapeDetectorBlock block) {
        AdventureModePredicate adventureModePredicate = this.a(DataComponents.m);
        return adventureModePredicate != null && adventureModePredicate.a(block);
    }

    public boolean b(ShapeDetectorBlock block) {
        AdventureModePredicate adventureModePredicate = this.a(DataComponents.n);
        return adventureModePredicate != null && adventureModePredicate.a(block);
    }

    public int L() {
        return this.o;
    }

    public void d(int popTime) {
        this.o = popTime;
    }

    public int M() {
        return this.f() ? 0 : this.n;
    }

    public void e(int count) {
        this.n = count;
    }

    public void f(int maxSize) {
        if (!this.f() && this.M() > maxSize) {
            this.e(maxSize);
        }
    }

    public void g(int increment) {
        this.e(this.M() + increment);
    }

    public void h(int decrement) {
        this.g(-decrement);
    }

    public void a(int amount, @Nullable EntityLiving entity) {
        if (!(entity != null && entity.fV() || this == j)) {
            this.h(amount);
        }
    }

    public ItemStack b(int amount, @Nullable EntityLiving entity) {
        ItemStack itemStack = this.c(amount);
        this.a(amount, entity);
        return itemStack;
    }

    public void b(net.minecraft.world.level.World level, EntityLiving livingEntity, int remainingUseDuration) {
        Consumable consumable = this.a(DataComponents.x);
        if (consumable != null && consumable.a(remainingUseDuration)) {
            consumable.a(livingEntity.dY(), livingEntity, this, 5);
        }
        this.h().a(level, livingEntity, this, remainingUseDuration);
    }

    public void a(EntityItem itemEntity) {
        this.h().a(itemEntity);
    }

    public SoundEffect N() {
        return this.h().a();
    }

    public boolean a(DamageSource damageSource) {
        DamageResistant damageResistant = this.a(DataComponents.A);
        return damageResistant == null || !damageResistant.a(damageSource);
    }

    public boolean b(ItemStack item) {
        Repairable repairable = this.a(DataComponents.E);
        return repairable != null && repairable.a(item);
    }
}

