/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class ItemMonsterEgg
extends Item {
    private static final Map<EntityTypes<? extends EntityInsentient>, ItemMonsterEgg> a = Maps.newIdentityHashMap();
    private final EntityTypes<?> b;

    public ItemMonsterEgg(EntityTypes<? extends EntityInsentient> defaultType, Item.Info properties) {
        super(properties);
        this.b = defaultType;
        a.put(defaultType, this);
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        World level = context.q();
        if (level.C) {
            return EnumInteractionResult.a;
        }
        ItemStack itemInHand = context.n();
        BlockPosition clickedPos = context.a();
        EnumDirection clickedFace = context.k();
        IBlockData blockState = level.a_(clickedPos);
        TileEntity tileEntity = level.c_(clickedPos);
        if (tileEntity instanceof Spawner) {
            Spawner spawner = (Spawner)((Object)tileEntity);
            if (level.paperConfig().entities.spawning.disableMobSpawnerSpawnEggTransformation) {
                return EnumInteractionResult.d;
            }
            EntityTypes<?> type = this.a(level.K_(), itemInHand);
            spawner.a(type, level.H_());
            level.a(clickedPos, blockState, blockState, 3);
            level.a((Entity)context.o(), GameEvent.c, clickedPos);
            itemInHand.h(1);
            return EnumInteractionResult.a;
        }
        BlockPosition blockPos = blockState.g(level, clickedPos).c() ? clickedPos : clickedPos.a(clickedFace);
        EntityTypes<?> type = this.a(level.K_(), itemInHand);
        if (type.a((WorldServer)level, itemInHand, context.o(), blockPos, EntitySpawnReason.m, true, !Objects.equals(clickedPos, blockPos) && clickedFace == EnumDirection.b) != null) {
            itemInHand.h(1);
            level.a((Entity)context.o(), GameEvent.t, clickedPos);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        MovingObjectPositionBlock playerPovHitResult = ItemMonsterEgg.a(level, player, RayTrace.FluidCollisionOption.b);
        if (playerPovHitResult.d() != MovingObjectPosition.EnumMovingObjectType.b) {
            return EnumInteractionResult.e;
        }
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            BlockPosition blockPos = playerPovHitResult.b();
            if (!(level.a_(blockPos).b() instanceof BlockFluids)) {
                return EnumInteractionResult.e;
            }
            if (level.a(player, blockPos) && player.a(blockPos, playerPovHitResult.c(), itemInHand)) {
                EntityTypes<?> type = this.a(serverLevel.K_(), itemInHand);
                Object entity = type.a(serverLevel, itemInHand, player, blockPos, EntitySpawnReason.m, false, false);
                if (entity == null) {
                    return EnumInteractionResult.e;
                }
                itemInHand.a(1, (EntityLiving)player);
                player.b(StatisticList.c.b(this));
                level.a((Entity)player, GameEvent.t, ((Entity)entity).dt());
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.d;
        }
        return EnumInteractionResult.a;
    }

    public boolean a(HolderLookup.a registries, ItemStack stack, EntityTypes<?> entityType) {
        return Objects.equals(this.a(registries, stack), entityType);
    }

    @Nullable
    public static ItemMonsterEgg a(@Nullable EntityTypes<?> type) {
        return a.get(type);
    }

    public static Iterable<ItemMonsterEgg> b() {
        return Iterables.unmodifiableIterable(a.values());
    }

    public EntityTypes<?> a(HolderLookup.a registries, ItemStack provider) {
        EntityTypes<?> entityType;
        CustomData customData = provider.a(DataComponents.W, CustomData.a);
        if (!customData.c() && (entityType = customData.a(registries, Registries.z)) != null) {
            return entityType;
        }
        return this.b;
    }

    @Override
    public FeatureFlagSet i() {
        return this.b.i();
    }

    public Optional<EntityInsentient> a(EntityHuman player, EntityInsentient mob, EntityTypes<? extends EntityInsentient> entityType, WorldServer serverLevel, Vec3D pos, ItemStack stack) {
        if (!this.a(serverLevel.K_(), stack, entityType)) {
            return Optional.empty();
        }
        EntityInsentient breedOffspring = mob instanceof EntityAgeable ? ((EntityAgeable)mob).a(serverLevel, (EntityAgeable)mob) : entityType.a(serverLevel, EntitySpawnReason.m);
        if (breedOffspring == null) {
            return Optional.empty();
        }
        breedOffspring.a(true);
        if (!breedOffspring.e_()) {
            return Optional.empty();
        }
        breedOffspring.b(pos.a(), pos.b(), pos.c(), 0.0f, 0.0f);
        serverLevel.addFreshEntityWithPassengers(breedOffspring, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        breedOffspring.b(stack.a(DataComponents.g));
        stack.a(1, (EntityLiving)player);
        return Optional.of(breedOffspring);
    }

    @Override
    public boolean a(ItemStack stack, @Nullable EntityHuman player) {
        CustomData customData;
        if (player != null && player.G() >= 2 && (customData = stack.a(DataComponents.W)) != null) {
            EntityTypes<?> entityType = customData.a(player.dV().K_(), Registries.z);
            return entityType != null && entityType.s();
        }
        return false;
    }
}

