/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class ItemLeash
extends Item {
    public ItemLeash(Item.Info properties) {
        super(properties);
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        BlockPosition clickedPos;
        World level = context.q();
        IBlockData blockState = level.a_(clickedPos = context.a());
        if (blockState.a(TagsBlock.U)) {
            EntityHuman player = context.o();
            if (!level.C && player != null) {
                return ItemLeash.bindPlayerMobs(player, level, clickedPos, context.p());
            }
        }
        return EnumInteractionResult.e;
    }

    public static EnumInteractionResult bindPlayerMobs(EntityHuman player, World level, BlockPosition pos, EnumHand interactionHand) {
        Entity leashFenceKnotEntity = null;
        List<Leashable> list = ItemLeash.a(level, pos, (Leashable leashable1) -> leashable1.D() == player);
        Iterator<Leashable> iterator = list.iterator();
        while (iterator.hasNext()) {
            Entity leashed;
            Leashable leashable = iterator.next();
            if (leashFenceKnotEntity == null) {
                leashFenceKnotEntity = EntityLeash.a(level, pos);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(interactionHand);
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)leashFenceKnotEntity.getBukkitEntity(), player != null ? (Player)player.getBukkitEntity() : null, (Block)CraftBlock.at(level, pos), BlockFace.SELF, hand);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    leashFenceKnotEntity.discard(null);
                    return EnumInteractionResult.e;
                }
                ((EntityLeash)leashFenceKnotEntity).s();
            }
            if (leashable instanceof Entity && CraftEventFactory.callPlayerLeashEntityEvent(leashed = (Entity)((Object)leashable), leashFenceKnotEntity, player, interactionHand).isCancelled()) {
                iterator.remove();
                continue;
            }
            leashable.b(leashFenceKnotEntity, true);
        }
        if (!list.isEmpty()) {
            level.a(GameEvent.b, pos, GameEvent.a.a(player));
            return EnumInteractionResult.b;
        }
        if (leashFenceKnotEntity != null) {
            leashFenceKnotEntity.discard(null);
        }
        return EnumInteractionResult.e;
    }

    public static EnumInteractionResult a(EntityHuman player, World world, BlockPosition pos) {
        return ItemLeash.bindPlayerMobs(player, world, pos, EnumHand.a);
    }

    public static List<Leashable> a(World level, BlockPosition pos, Predicate<Leashable> predicate) {
        double d2 = 7.0;
        int x2 = pos.u();
        int y2 = pos.v();
        int z2 = pos.w();
        AxisAlignedBB aabb = new AxisAlignedBB((double)x2 - 7.0, (double)y2 - 7.0, (double)z2 - 7.0, (double)x2 + 7.0, (double)y2 + 7.0, (double)z2 + 7.0);
        return level.a(Entity.class, aabb, (? super T entity) -> {
            Leashable leashable;
            return entity instanceof Leashable && predicate.test(leashable = (Leashable)((Object)entity));
        }).stream().map(Leashable.class::cast).toList();
    }
}

