/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class ItemHanging
extends Item {
    private static final IChatBaseComponent a = IChatBaseComponent.c("painting.random").a(EnumChatFormat.h);
    private final EntityTypes<? extends EntityHanging> b;

    public ItemHanging(EntityTypes<? extends EntityHanging> type, Item.Info properties) {
        super(properties);
        this.b = type;
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        EntityHanging hangingEntity;
        BlockPosition clickedPos = context.a();
        EnumDirection clickedFace = context.k();
        BlockPosition blockPos = clickedPos.a(clickedFace);
        EntityHuman player = context.o();
        ItemStack itemInHand = context.n();
        if (player != null && !this.a(player, clickedFace, itemInHand, blockPos)) {
            return EnumInteractionResult.d;
        }
        World level = context.q();
        if (this.b == EntityTypes.aK) {
            Optional<EntityPainting> optional = EntityPainting.a(level, blockPos, clickedFace);
            if (optional.isEmpty()) {
                return EnumInteractionResult.c;
            }
            hangingEntity = optional.get();
        } else if (this.b == EntityTypes.as) {
            hangingEntity = new EntityItemFrame(level, blockPos, clickedFace);
        } else {
            if (this.b != EntityTypes.af) {
                return EnumInteractionResult.a;
            }
            hangingEntity = new GlowItemFrame(level, blockPos, clickedFace);
        }
        CustomData customData = itemInHand.a(DataComponents.W, CustomData.a);
        if (!customData.c()) {
            EntityTypes.a(level, player, hangingEntity, customData);
        }
        if (hangingEntity.m()) {
            if (!level.C) {
                Player who = player == null ? null : (Player)player.getBukkitEntity();
                CraftBlock blockClicked = CraftBlock.at(level, blockPos);
                BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(context.p());
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)hangingEntity.getBukkitEntity(), who, (Block)blockClicked, blockFace, hand, CraftItemStack.asBukkitCopy(itemInHand));
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    if (player != null) {
                        player.cd.b();
                    }
                    return EnumInteractionResult.d;
                }
                hangingEntity.z();
                level.a((Entity)player, GameEvent.t, hangingEntity.dt());
                level.b(hangingEntity);
            }
            itemInHand.h(1);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.c;
    }

    protected boolean a(EntityHuman player, EnumDirection direction, ItemStack hangingEntityStack, BlockPosition pos) {
        return !direction.o().b() && player.a(pos, direction, hangingEntityStack);
    }

    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltipComponents, TooltipFlag tooltipFlag) {
        super.a(stack, context, tooltipComponents, tooltipFlag);
        HolderLookup.a provider = context.a();
        if (provider != null && this.b == EntityTypes.aK) {
            CustomData customData = stack.a(DataComponents.W, CustomData.a);
            if (!customData.c()) {
                customData.a((DynamicOps<NBTBase>)provider.a(DynamicOpsNBT.a), EntityPainting.d).result().ifPresentOrElse(holder -> {
                    ((PaintingVariant)holder.a()).e().ifPresent(tooltipComponents::add);
                    ((PaintingVariant)holder.a()).f().ifPresent(tooltipComponents::add);
                    tooltipComponents.add(IChatBaseComponent.a("painting.dimensions", ((PaintingVariant)holder.a()).b(), ((PaintingVariant)holder.a()).c()));
                }, () -> tooltipComponents.add(a));
            } else if (tooltipFlag.b()) {
                tooltipComponents.add(a);
            }
        }
    }
}

