/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class InstrumentItem
extends Item {
    private final TagKey<Instrument> a;

    public InstrumentItem(TagKey<Instrument> instruments, Item.Info properties) {
        super(properties);
        this.a = instruments;
    }

    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltipComponents, TooltipFlag tooltipFlag) {
        Optional<Holder<Instrument>> instrument;
        super.a(stack, context, tooltipComponents, tooltipFlag);
        HolderLookup.a provider = context.a();
        if (provider != null && (instrument = this.a(stack, provider)).isPresent()) {
            IChatMutableComponent mutableComponent = instrument.get().a().d().f();
            ChatComponentUtils.a(mutableComponent, ChatModifier.a.a(EnumChatFormat.h));
            tooltipComponents.add(mutableComponent);
        }
    }

    public static ItemStack a(Item item, Holder<Instrument> instrument) {
        ItemStack itemStack = new ItemStack(item);
        itemStack.b(DataComponents.Z, instrument);
        return itemStack;
    }

    @Override
    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        Optional<Holder<Instrument>> instrument = this.a(itemInHand, player.dX());
        if (instrument.isPresent()) {
            Instrument instrument1 = instrument.get().a();
            player.c(hand);
            InstrumentItem.a(level, player, instrument1);
            player.gE().a(itemInHand, MathHelper.d(instrument1.b() * 20.0f));
            player.b(StatisticList.c.b(this));
            return EnumInteractionResult.c;
        }
        return EnumInteractionResult.d;
    }

    @Override
    public int a(ItemStack stack, EntityLiving entity) {
        Optional<Holder<Instrument>> instrument = this.a(stack, entity.dX());
        return instrument.map(holder -> MathHelper.d(((Instrument)holder.a()).b() * 20.0f)).orElse(0);
    }

    private Optional<Holder<Instrument>> a(ItemStack stack, HolderLookup.a registries) {
        Iterator iterator;
        Holder<Instrument> holder = stack.a(DataComponents.Z);
        if (holder != null) {
            return Optional.of(holder);
        }
        Optional<HolderSet.Named<Instrument>> optional = registries.d(Registries.I).a(this.a);
        if (optional.isPresent() && (iterator = optional.get().iterator()).hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    @Override
    public ItemUseAnimation b(ItemStack stack) {
        return ItemUseAnimation.i;
    }

    private static void a(World level, EntityHuman player, Instrument instrument) {
        SoundEffect soundEvent = instrument.a().a();
        float f2 = instrument.c() / 16.0f;
        level.a(player, player, soundEvent, SoundCategory.c, f2, 1.0f);
        level.a(GameEvent.B, player.dt(), GameEvent.a.a(player));
    }
}

