/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.World;
import org.apache.commons.lang3.math.Fraction;

public class BundleItem
extends Item {
    public static final int a = 4;
    public static final int b = 3;
    public static final int c = 12;
    public static final int d = 11;
    private static final int m = ARGB.a(1.0f, 1.0f, 0.33f, 0.33f);
    private static final int n = ARGB.a(1.0f, 0.44f, 0.53f, 1.0f);
    private static final int o = 10;
    private static final int p = 2;
    private static final int q = 200;

    public BundleItem(Item.Info properties) {
        super(properties);
    }

    public static float c(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return bundleContents.f().floatValue();
    }

    @Override
    public boolean a(ItemStack stack, Slot slot, ClickAction action, EntityHuman player) {
        BundleContents bundleContents = stack.a(DataComponents.P);
        if (bundleContents == null) {
            return false;
        }
        ItemStack item = slot.g();
        BundleContents.a mutable = new BundleContents.a(bundleContents);
        if (action == ClickAction.a && !item.f()) {
            if (mutable.a(slot, player) > 0) {
                BundleItem.b(player);
            } else {
                BundleItem.c(player);
            }
            stack.b(DataComponents.P, mutable.d());
            this.a(player);
            return true;
        }
        if (action == ClickAction.b && item.f()) {
            ItemStack itemStack = mutable.b();
            if (itemStack != null) {
                ItemStack itemStack1 = slot.d(itemStack);
                if (itemStack1.M() > 0) {
                    mutable.a(itemStack1);
                } else {
                    BundleItem.a(player);
                }
            }
            stack.b(DataComponents.P, mutable.d());
            this.a(player);
            return true;
        }
        return false;
    }

    @Override
    public boolean a(ItemStack stack, ItemStack other, Slot slot, ClickAction action, EntityHuman player, SlotAccess access) {
        if (action == ClickAction.a && other.f()) {
            BundleItem.a(stack, -1);
            return false;
        }
        BundleContents bundleContents = stack.a(DataComponents.P);
        if (bundleContents == null) {
            return false;
        }
        BundleContents.a mutable = new BundleContents.a(bundleContents);
        if (action == ClickAction.a && !other.f()) {
            if (slot.b(player) && mutable.a(other) > 0) {
                BundleItem.b(player);
            } else {
                BundleItem.c(player);
            }
            stack.b(DataComponents.P, mutable.d());
            this.a(player);
            return true;
        }
        if (action == ClickAction.b && other.f()) {
            ItemStack itemStack;
            if (slot.b(player) && (itemStack = mutable.b()) != null) {
                BundleItem.a(player);
                access.a(itemStack);
            }
            stack.b(DataComponents.P, mutable.d());
            this.a(player);
            return true;
        }
        BundleItem.a(stack, -1);
        return false;
    }

    @Override
    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        player.c(hand);
        return EnumInteractionResult.a;
    }

    private void a(World level, EntityHuman player, ItemStack stack) {
        if (this.b(stack, player)) {
            BundleItem.a(level, player);
            player.b(StatisticList.c.b(this));
        }
    }

    @Override
    public boolean d(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return bundleContents.f().compareTo(Fraction.ZERO) > 0;
    }

    @Override
    public int e(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return Math.min(1 + MathHelper.a(bundleContents.f(), 12), 13);
    }

    @Override
    public int f(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return bundleContents.f().compareTo(Fraction.ONE) >= 0 ? m : n;
    }

    public static void a(ItemStack bundle, int selectedItem) {
        BundleContents bundleContents = bundle.a(DataComponents.P);
        if (bundleContents != null) {
            BundleContents.a mutable = new BundleContents.a(bundleContents);
            mutable.a(selectedItem);
            bundle.b(DataComponents.P, mutable.d());
        }
    }

    public static boolean g(ItemStack bundle) {
        BundleContents bundleContents = bundle.a(DataComponents.P);
        return bundleContents != null && bundleContents.h() != -1;
    }

    public static int h(ItemStack bundle) {
        BundleContents bundleContents = bundle.a(DataComponents.P, BundleContents.a);
        return bundleContents.h();
    }

    public static ItemStack i(ItemStack bundle) {
        BundleContents bundleContents = bundle.a(DataComponents.P);
        return bundleContents != null && bundleContents.h() != -1 ? bundleContents.a(bundleContents.h()) : ItemStack.j;
    }

    public static int j(ItemStack bundle) {
        BundleContents bundleContents = bundle.a(DataComponents.P, BundleContents.a);
        return bundleContents.a();
    }

    private boolean b(ItemStack stack, EntityHuman player) {
        BundleContents bundleContents = stack.a(DataComponents.P);
        if (bundleContents != null && !bundleContents.g()) {
            Optional<ItemStack> optional = BundleItem.a(stack, player, bundleContents);
            if (optional.isPresent()) {
                player.a(optional.get(), true);
                return true;
            }
            return false;
        }
        return false;
    }

    private static Optional<ItemStack> a(ItemStack stack, EntityHuman player, BundleContents bundleContents) {
        BundleContents.a mutable = new BundleContents.a(bundleContents);
        ItemStack itemStack = mutable.b();
        if (itemStack != null) {
            BundleItem.a(player);
            stack.b(DataComponents.P, mutable.d());
            return Optional.of(itemStack);
        }
        return Optional.empty();
    }

    @Override
    public void a(World level, EntityLiving livingEntity, ItemStack stack, int remainingUseDuration) {
        if (livingEntity instanceof EntityHuman) {
            boolean flag;
            EntityHuman player = (EntityHuman)livingEntity;
            int useDuration = this.a(stack, livingEntity);
            boolean bl = flag = remainingUseDuration == useDuration;
            if (flag || remainingUseDuration < useDuration - 10 && remainingUseDuration % 2 == 0) {
                this.a(level, player, stack);
            }
        }
    }

    @Override
    public int a(ItemStack stack, EntityLiving entity) {
        return 200;
    }

    @Override
    public ItemUseAnimation b(ItemStack stack) {
        return ItemUseAnimation.k;
    }

    @Override
    public Optional<TooltipComponent> k(ItemStack stack) {
        return !stack.b(DataComponents.r) && !stack.b(DataComponents.q) ? Optional.ofNullable(stack.a(DataComponents.P)).map(BundleTooltip::new) : Optional.empty();
    }

    @Override
    public void a(EntityItem itemEntity) {
        BundleContents bundleContents = itemEntity.l().a(DataComponents.P);
        if (bundleContents != null) {
            itemEntity.l().b(DataComponents.P, BundleContents.a);
            ItemLiquidUtil.a(itemEntity, bundleContents.d());
        }
    }

    public static List<BundleItem> b() {
        return Stream.of(Items.rB, Items.rC, Items.rD, Items.rE, Items.rF, Items.rG, Items.rH, Items.rI, Items.rJ, Items.rK, Items.rL, Items.rR, Items.rO, Items.rP, Items.rQ, Items.rN, Items.rM).map(item -> (BundleItem)item).toList();
    }

    public static Item a(EnumColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case EnumColor.a -> Items.rC;
            case EnumColor.b -> Items.rD;
            case EnumColor.c -> Items.rE;
            case EnumColor.d -> Items.rF;
            case EnumColor.e -> Items.rG;
            case EnumColor.f -> Items.rH;
            case EnumColor.g -> Items.rI;
            case EnumColor.h -> Items.rJ;
            case EnumColor.i -> Items.rK;
            case EnumColor.j -> Items.rL;
            case EnumColor.l -> Items.rN;
            case EnumColor.m -> Items.rO;
            case EnumColor.n -> Items.rP;
            case EnumColor.o -> Items.rQ;
            case EnumColor.p -> Items.rR;
            case EnumColor.k -> Items.rM;
        };
    }

    private static void a(Entity entity) {
        entity.a(SoundEffects.ds, 0.8f, 0.8f + entity.dV().H_().i() * 0.4f);
    }

    private static void b(Entity entity) {
        entity.a(SoundEffects.dq, 0.8f, 0.8f + entity.dV().H_().i() * 0.4f);
    }

    private static void c(Entity entity) {
        entity.a(SoundEffects.dr, 1.0f, 1.0f);
    }

    private static void a(World level, Entity entity) {
        level.a(null, entity.dv(), SoundEffects.dp, SoundCategory.h, 0.8f, 0.8f + entity.dV().H_().i() * 0.4f);
    }

    private void a(EntityHuman player) {
        Container abstractContainerMenu = player.cd;
        if (abstractContainerMenu != null) {
            abstractContainerMenu.a(player.gi());
        }
    }
}

