/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;

public class AdventureModePredicate {
    private static final Codec<AdventureModePredicate> e = CriterionConditionBlock.a.flatComapMap(blockPredicate -> new AdventureModePredicate(List.of(blockPredicate), true), adventureModePredicate -> DataResult.error(() -> "Cannot encode"));
    private static final Codec<AdventureModePredicate> f = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.b(CriterionConditionBlock.a.listOf()).fieldOf("predicates").forGetter(adventureModePredicate -> adventureModePredicate.h), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(AdventureModePredicate::a)).apply((Applicative)instance, AdventureModePredicate::new));
    public static final Codec<AdventureModePredicate> a = Codec.withAlternative(f, e);
    public static final StreamCodec<RegistryFriendlyByteBuf, AdventureModePredicate> b = StreamCodec.a(CriterionConditionBlock.b.a(ByteBufCodecs.a()), adventureModePredicate -> adventureModePredicate.h, ByteBufCodecs.b, AdventureModePredicate::a, AdventureModePredicate::new);
    public static final IChatBaseComponent c = IChatBaseComponent.c("item.canBreak").a(EnumChatFormat.h);
    public static final IChatBaseComponent d = IChatBaseComponent.c("item.canPlace").a(EnumChatFormat.h);
    private static final IChatBaseComponent g = IChatBaseComponent.c("item.canUse.unknown").a(EnumChatFormat.h);
    public final List<CriterionConditionBlock> h;
    private final boolean i;
    @Nullable
    private List<IChatBaseComponent> j;
    @Nullable
    private ShapeDetectorBlock k;
    private boolean l;
    private boolean m;

    public AdventureModePredicate(List<CriterionConditionBlock> predicates, boolean showInTooltip) {
        this.h = predicates;
        this.i = showInTooltip;
    }

    private static boolean a(ShapeDetectorBlock first, @Nullable ShapeDetectorBlock second, boolean checkNbt) {
        if (second == null || first.a() != second.a()) {
            return false;
        }
        if (!checkNbt) {
            return true;
        }
        if (first.b() == null && second.b() == null) {
            return true;
        }
        if (first.b() != null && second.b() != null) {
            IRegistryCustom registryAccess = first.c().K_();
            return Objects.equals(first.b().c(registryAccess), second.b().c(registryAccess));
        }
        return false;
    }

    public boolean a(ShapeDetectorBlock block) {
        if (AdventureModePredicate.a(block, this.k, this.m)) {
            return this.l;
        }
        this.k = block;
        this.m = false;
        for (CriterionConditionBlock blockPredicate : this.h) {
            if (!blockPredicate.a(block)) continue;
            this.m |= blockPredicate.a();
            this.l = true;
            return true;
        }
        this.l = false;
        return false;
    }

    private List<IChatBaseComponent> b() {
        if (this.j == null) {
            this.j = AdventureModePredicate.a(this.h);
        }
        return this.j;
    }

    public void a(Consumer<IChatBaseComponent> tooltipAdder) {
        this.b().forEach(tooltipAdder);
    }

    public AdventureModePredicate a(boolean showInTooltip) {
        return new AdventureModePredicate(this.h, showInTooltip);
    }

    private static List<IChatBaseComponent> a(List<CriterionConditionBlock> predicates) {
        for (CriterionConditionBlock blockPredicate : predicates) {
            if (!blockPredicate.b().isEmpty()) continue;
            return List.of(g);
        }
        return predicates.stream().flatMap(blockPredicate1 -> blockPredicate1.b().orElseThrow().a()).distinct().map(holder -> ((Block)holder.a()).f().a(EnumChatFormat.i)).toList();
    }

    public boolean a() {
        return this.i;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof AdventureModePredicate)) return false;
        AdventureModePredicate adventureModePredicate = (AdventureModePredicate)other;
        if (!this.h.equals(adventureModePredicate.h)) return false;
        if (this.i != adventureModePredicate.i) return false;
        return true;
    }

    public int hashCode() {
        return this.h.hashCode() * 31 + (this.i ? 1 : 0);
    }

    public String toString() {
        return "AdventureModePredicate{predicates=" + String.valueOf(this.h) + ", showInTooltip=" + this.i + "}";
    }
}

