/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.collect.ImmutableList;
import io.papermc.paper.event.player.PlayerLoomPatternSelectEvent;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BannerPatternTags;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemBannerPattern;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R3.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftInventoryLoom;
import org.bukkit.craftbukkit.v1_21_R3.inventory.view.CraftLoomView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.LoomInventory;

public class ContainerLoom
extends Container {
    private static final int m = -1;
    private static final int n = 4;
    private static final int o = 31;
    private static final int p = 31;
    private static final int q = 40;
    private final ContainerAccess r;
    final ContainerProperty s = ContainerProperty.a();
    private List<Holder<EnumBannerPatternType>> t = List.of();
    Runnable u = () -> {};
    private final HolderGetter<EnumBannerPatternType> v;
    final Slot w;
    final Slot x;
    private final Slot y;
    private final Slot z;
    long A;
    private final IInventory B;
    private final IInventory C;
    private CraftLoomView bukkitEntity = null;
    private Player player;

    @Override
    public CraftLoomView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryLoom inventory = new CraftInventoryLoom(this.B, this.C);
        this.bukkitEntity = new CraftLoomView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public ContainerLoom(int containerId, PlayerInventory playerInventory) {
        this(containerId, playerInventory, ContainerAccess.a);
    }

    public ContainerLoom(int containerId, PlayerInventory playerInventory, final ContainerAccess access) {
        super(Containers.s, containerId);
        this.r = access;
        this.B = new InventorySubcontainer(this.createBlockHolder(access), 3){

            @Override
            public void e() {
                super.e();
                ContainerLoom.this.a(this);
                ContainerLoom.this.u.run();
            }
        };
        this.C = new InventorySubcontainer(this.createBlockHolder(access), 1){

            @Override
            public void e() {
                super.e();
                ContainerLoom.this.u.run();
            }

            @Override
            public Location getLocation() {
                return access.getLocation();
            }
        };
        this.w = this.a(new Slot(this, this.B, 0, 13, 26){

            @Override
            public boolean a(ItemStack stack) {
                return stack.h() instanceof ItemBanner;
            }
        });
        this.x = this.a(new Slot(this, this.B, 1, 33, 26){

            @Override
            public boolean a(ItemStack stack) {
                return stack.h() instanceof ItemDye;
            }
        });
        this.y = this.a(new Slot(this, this.B, 2, 23, 45){

            @Override
            public boolean a(ItemStack stack) {
                return stack.h() instanceof ItemBannerPattern;
            }
        });
        this.z = this.a(new Slot(this.C, 0, 143, 57){

            @Override
            public boolean a(ItemStack stack) {
                return false;
            }

            @Override
            public void a(EntityHuman player, ItemStack stack) {
                ContainerLoom.this.w.a(1);
                ContainerLoom.this.x.a(1);
                if (!ContainerLoom.this.w.h() || !ContainerLoom.this.x.h()) {
                    ContainerLoom.this.s.a(-1);
                }
                access.a((World level, BlockPosition pos) -> {
                    long gameTime = level.ad();
                    if (ContainerLoom.this.A != gameTime) {
                        level.a(null, (BlockPosition)pos, SoundEffects.Bh, SoundCategory.e, 1.0f, 1.0f);
                        ContainerLoom.this.A = gameTime;
                    }
                });
                super.a(player, stack);
            }
        });
        this.c(playerInventory, 8, 84);
        this.a(this.s);
        this.v = playerInventory.k.dX().e(Registries.d);
        this.player = (Player)playerInventory.k.getBukkitEntity();
    }

    @Override
    public boolean b(EntityHuman player) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerLoom.a(this.r, player, Blocks.ov);
    }

    @Override
    public boolean a(EntityHuman player, int id) {
        if (id >= 0 && id < this.t.size()) {
            int selectablePatternIndex = id;
            PlayerLoomPatternSelectEvent event = new PlayerLoomPatternSelectEvent((Player)player.getBukkitEntity(), (LoomInventory)((CraftInventoryLoom)this.getBukkitView().getTopInventory()), CraftPatternType.minecraftHolderToBukkit(this.t.get(selectablePatternIndex)));
            if (!event.callEvent()) {
                player.cd.b();
                return false;
            }
            Holder<EnumBannerPatternType> eventPattern = CraftPatternType.bukkitToMinecraftHolder(event.getPatternType());
            Holder<EnumBannerPatternType> selectedPattern = null;
            for (int i2 = 0; i2 < this.t.size(); ++i2) {
                Holder<EnumBannerPatternType> holder = this.t.get(i2);
                if (!eventPattern.equals(holder)) continue;
                selectablePatternIndex = i2;
                selectedPattern = holder;
                break;
            }
            if (selectedPattern == null) {
                selectedPattern = eventPattern;
                selectablePatternIndex = -1;
            }
            player.cd.b();
            this.s.a(selectablePatternIndex);
            this.a(Objects.requireNonNull(selectedPattern, "selectedPattern was null, this is unexpected"));
            return true;
        }
        return false;
    }

    private List<Holder<EnumBannerPatternType>> c(ItemStack stack) {
        List list;
        if (stack.f()) {
            return (List)this.v.a(BannerPatternTags.a).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        Item item = stack.h();
        if (item instanceof ItemBannerPattern) {
            ItemBannerPattern bannerPatternItem = (ItemBannerPattern)item;
            list = (List)this.v.a(bannerPatternItem.b()).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        } else {
            list = List.of();
        }
        return list;
    }

    private boolean e(int index) {
        return index >= 0 && index < this.t.size();
    }

    @Override
    public void a(IInventory inventory) {
        ItemStack item = this.w.g();
        ItemStack item1 = this.x.g();
        ItemStack item2 = this.y.g();
        if (!item.f() && !item1.f()) {
            Holder<EnumBannerPatternType> holder;
            int i2 = this.s.b();
            boolean isValidPatternIndex = this.e(i2);
            List<Holder<EnumBannerPatternType>> list = this.t;
            this.t = this.c(item2);
            if (this.t.size() == 1) {
                this.s.a(0);
                holder = this.t.get(0);
            } else if (!isValidPatternIndex) {
                this.s.a(-1);
                holder = null;
            } else {
                Holder<EnumBannerPatternType> holder1 = list.get(i2);
                int index = this.t.indexOf(holder1);
                if (index != -1) {
                    holder = holder1;
                    this.s.a(index);
                } else {
                    holder = null;
                    this.s.a(-1);
                }
            }
            if (holder != null) {
                boolean flag;
                BannerPatternLayers bannerPatternLayers = item.a(DataComponents.ai, BannerPatternLayers.a);
                boolean bl = flag = bannerPatternLayers.b().size() >= 6;
                if (flag) {
                    this.s.a(-1);
                    this.z.f(ItemStack.j);
                } else {
                    this.a(holder);
                }
            } else {
                this.z.f(ItemStack.j);
            }
            CraftEventFactory.callPrepareResultEvent(this, 3);
        } else {
            this.z.f(ItemStack.j);
            this.t = List.of();
            this.s.a(-1);
        }
    }

    public List<Holder<EnumBannerPatternType>> l() {
        return this.t;
    }

    public int m() {
        return this.s.b();
    }

    public void a(Runnable listener) {
        this.u = listener;
    }

    @Override
    public ItemStack b(EntityHuman player, int index) {
        ItemStack itemStack = ItemStack.j;
        Slot slot = this.k.get(index);
        if (slot != null && slot.h()) {
            ItemStack item = slot.g();
            itemStack = item.v();
            if (index == this.z.d) {
                if (!this.a(item, 4, 40, true)) {
                    return ItemStack.j;
                }
                slot.b(item, itemStack);
            } else if (index != this.x.d && index != this.w.d && index != this.y.d ? (item.h() instanceof ItemBanner ? !this.a(item, this.w.d, this.w.d + 1, false) : (item.h() instanceof ItemDye ? !this.a(item, this.x.d, this.x.d + 1, false) : (item.h() instanceof ItemBannerPattern ? !this.a(item, this.y.d, this.y.d + 1, false) : (index >= 4 && index < 31 ? !this.a(item, 31, 40, false) : index >= 31 && index < 40 && !this.a(item, 4, 31, false))))) : !this.a(item, 4, 40, false)) {
                return ItemStack.j;
            }
            if (item.f()) {
                slot.e(ItemStack.j);
            } else {
                slot.c();
            }
            if (item.M() == itemStack.M()) {
                return ItemStack.j;
            }
            slot.a(player, item);
        }
        return itemStack;
    }

    @Override
    public void a(EntityHuman player) {
        super.a(player);
        this.r.a((World level, BlockPosition blockPos) -> this.a(player, this.B));
    }

    private void a(Holder<EnumBannerPatternType> pattern) {
        ItemStack item = this.w.g();
        ItemStack item1 = this.x.g();
        ItemStack itemStack = ItemStack.j;
        if (!item.f() && !item1.f()) {
            itemStack = item.c(1);
            EnumColor dyeColor = ((ItemDye)item1.h()).b();
            itemStack.a(DataComponents.ai, BannerPatternLayers.a, bannerPatternLayers -> {
                if (bannerPatternLayers.b().size() > 20) {
                    bannerPatternLayers = new BannerPatternLayers(List.copyOf(bannerPatternLayers.b().subList(0, 20)));
                }
                return new BannerPatternLayers.a().a((BannerPatternLayers)bannerPatternLayers).a(pattern, dyeColor).a();
            });
        }
        if (!ItemStack.a(itemStack, this.z.g())) {
            this.z.f(itemStack);
        }
    }

    public Slot n() {
        return this.w;
    }

    public Slot o() {
        return this.x;
    }

    public Slot p() {
        return this.y;
    }

    public Slot q() {
        return this.z;
    }
}

