/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public abstract class Container {
    private static final Logger m = LogUtils.getLogger();
    public static final int a = -999;
    public static final int b = 0;
    public static final int c = 1;
    public static final int d = 2;
    public static final int e = 0;
    public static final int f = 1;
    public static final int g = 2;
    public static final int h = Integer.MAX_VALUE;
    public static final int i = 9;
    public static final int j = 18;
    public NonNullList<net.minecraft.world.item.ItemStack> n = NonNullList.a();
    public NonNullList<Slot> k = NonNullList.a();
    public List<ContainerProperty> o = Lists.newArrayList();
    private net.minecraft.world.item.ItemStack p = net.minecraft.world.item.ItemStack.j;
    public NonNullList<net.minecraft.world.item.ItemStack> q = NonNullList.a();
    public IntList r = new IntArrayList();
    private net.minecraft.world.item.ItemStack s = net.minecraft.world.item.ItemStack.j;
    private int t;
    @Nullable
    private final Containers<?> u;
    public final int l;
    public int v = -1;
    public int w;
    public final Set<Slot> x = Sets.newHashSet();
    private final List<ICrafting> y = Lists.newArrayList();
    @Nullable
    private ContainerSynchronizer z;
    private boolean A;
    public boolean checkReachable = true;
    private IChatBaseComponent title;

    public abstract InventoryView getBukkitView();

    public void transferTo(Container other, CraftHumanEntity player) {
        InventoryView source = this.getBukkitView();
        InventoryView destination = other.getBukkitView();
        ((CraftInventory)source.getTopInventory()).getInventory().onClose(player);
        ((CraftInventory)source.getBottomInventory()).getInventory().onClose(player);
        ((CraftInventory)destination.getTopInventory()).getInventory().onOpen(player);
        ((CraftInventory)destination.getBottomInventory()).getInventory().onOpen(player);
    }

    public final IChatBaseComponent getTitle() {
        if (this.title == null) {
            return IChatBaseComponent.b("");
        }
        return this.title;
    }

    public final void setTitle(IChatBaseComponent title) {
        Preconditions.checkState((this.title == null ? 1 : 0) != 0, (Object)"Title already set");
        this.title = title;
    }

    public void startOpen() {
    }

    protected Container(@Nullable Containers<?> menuType, int containerId) {
        this.u = menuType;
        this.l = containerId;
    }

    protected void a(IInventory container, int x2, int y2) {
        for (int i2 = 0; i2 < 9; ++i2) {
            this.a(new Slot(container, i2, x2 + i2 * 18, y2));
        }
    }

    protected void b(IInventory container, int x2, int y2) {
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.a(new Slot(container, i1 + (i2 + 1) * 9, x2 + i1 * 18, y2 + i2 * 18));
            }
        }
    }

    protected void c(IInventory container, int x2, int y2) {
        this.b(container, x2, y2);
        int i2 = 4;
        int i1 = 58;
        this.a(container, x2, y2 + 58);
    }

    protected static boolean a(ContainerAccess access, EntityHuman player, Block targetBlock) {
        return access.a((World level, BlockPosition blockPos) -> !level.a_((BlockPosition)blockPos).a(targetBlock) ? false : player.a((BlockPosition)blockPos, 4.0), true);
    }

    public Containers<?> a() {
        if (this.u == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.u;
    }

    protected static void a(IInventory container, int minSize) {
        int containerSize = container.b();
        if (containerSize < minSize) {
            throw new IllegalArgumentException("Container size " + containerSize + " is smaller than expected " + minSize);
        }
    }

    protected static void a(IContainerProperties intArray, int minSize) {
        int count = intArray.a();
        if (count < minSize) {
            throw new IllegalArgumentException("Container data count " + count + " is smaller than expected " + minSize);
        }
    }

    public boolean a(int slotIndex) {
        return slotIndex == -1 || slotIndex == -999 || slotIndex < this.k.size();
    }

    protected Slot a(Slot slot) {
        slot.d = this.k.size();
        this.k.add(slot);
        this.n.add(net.minecraft.world.item.ItemStack.j);
        this.q.add(net.minecraft.world.item.ItemStack.j);
        return slot;
    }

    protected ContainerProperty a(ContainerProperty intValue) {
        this.o.add(intValue);
        this.r.add(0);
        return intValue;
    }

    protected void a(IContainerProperties array) {
        for (int i2 = 0; i2 < array.a(); ++i2) {
            this.a(ContainerProperty.a(array, i2));
        }
    }

    public void a(ICrafting listener) {
        if (!this.y.contains(listener)) {
            this.y.add(listener);
            this.d();
        }
    }

    public void a(ContainerSynchronizer synchronizer) {
        this.z = synchronizer;
        this.b();
    }

    public void b() {
        int i2;
        int size = this.k.size();
        for (i2 = 0; i2 < size; ++i2) {
            this.q.set(i2, this.k.get(i2).g().v());
        }
        this.s = this.g().v();
        size = this.o.size();
        for (i2 = 0; i2 < size; ++i2) {
            this.r.set(i2, this.o.get(i2).b());
        }
        if (this.z != null) {
            this.z.a(this, this.q, this.s, this.r.toIntArray());
            this.z.sendOffHandSlotChange();
        }
    }

    public void broadcastCarriedItem() {
        this.s = this.g().v();
        if (this.z != null) {
            this.z.a(this, this.s);
        }
    }

    public void b(ICrafting listener) {
        this.y.remove(listener);
    }

    public NonNullList<net.minecraft.world.item.ItemStack> c() {
        NonNullList<net.minecraft.world.item.ItemStack> list = NonNullList.a();
        for (Slot slot : this.k) {
            list.add(slot.g());
        }
        return list;
    }

    public void d() {
        int i2;
        for (i2 = 0; i2 < this.k.size(); ++i2) {
            net.minecraft.world.item.ItemStack item = this.k.get(i2).g();
            com.google.common.base.Supplier supplier = Suppliers.memoize(item::v);
            this.a(i2, item, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
            this.b(i2, item, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
        }
        this.l();
        for (i2 = 0; i2 < this.o.size(); ++i2) {
            ContainerProperty dataSlot = this.o.get(i2);
            int i1 = dataSlot.b();
            if (dataSlot.c()) {
                this.d(i2, i1);
            }
            this.e(i2, i1);
        }
    }

    public void e() {
        int i2;
        for (i2 = 0; i2 < this.k.size(); ++i2) {
            net.minecraft.world.item.ItemStack item = this.k.get(i2).g();
            this.a(i2, item, item::v);
        }
        for (i2 = 0; i2 < this.o.size(); ++i2) {
            ContainerProperty dataSlot = this.o.get(i2);
            if (!dataSlot.c()) continue;
            this.d(i2, dataSlot.b());
        }
        this.b();
    }

    private void d(int slotIndex, int value) {
        for (ICrafting containerListener : this.y) {
            containerListener.a(this, slotIndex, value);
        }
    }

    private void a(int slotIndex, net.minecraft.world.item.ItemStack stack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        net.minecraft.world.item.ItemStack itemStack = this.n.get(slotIndex);
        if (!net.minecraft.world.item.ItemStack.a(itemStack, stack)) {
            net.minecraft.world.item.ItemStack itemStack1 = supplier.get();
            this.n.set(slotIndex, itemStack1);
            for (ICrafting containerListener : this.y) {
                containerListener.slotChanged(this, slotIndex, itemStack, itemStack1);
            }
        }
    }

    private void b(int slotIndex, net.minecraft.world.item.ItemStack stack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        net.minecraft.world.item.ItemStack itemStack;
        if (!this.A && !net.minecraft.world.item.ItemStack.a(itemStack = this.q.get(slotIndex), stack)) {
            net.minecraft.world.item.ItemStack itemStack1 = supplier.get();
            this.q.set(slotIndex, itemStack1);
            if (this.z != null) {
                this.z.a(this, slotIndex, itemStack1);
            }
        }
    }

    private void e(int slotIndex, int value) {
        int _int;
        if (!this.A && (_int = this.r.getInt(slotIndex)) != value) {
            this.r.set(slotIndex, value);
            if (this.z != null) {
                this.z.a(this, slotIndex, value);
            }
        }
    }

    private void l() {
        if (!this.A && !net.minecraft.world.item.ItemStack.a(this.g(), this.s)) {
            this.s = this.g().v();
            if (this.z != null) {
                this.z.a(this, this.s);
            }
        }
    }

    public void a(int slot, net.minecraft.world.item.ItemStack stack) {
        this.q.set(slot, stack.v());
    }

    public void b(int slot, net.minecraft.world.item.ItemStack stack) {
        if (slot >= 0 && slot < this.q.size()) {
            this.q.set(slot, stack);
        } else {
            m.debug("Incorrect slot index: {} available slots: {}", (Object)slot, (Object)this.q.size());
        }
    }

    public void a(net.minecraft.world.item.ItemStack remoteCarried) {
        this.s = remoteCarried.v();
    }

    public boolean a(EntityHuman player, int id) {
        return false;
    }

    public Slot b(int slotId) {
        return this.k.get(slotId);
    }

    public abstract net.minecraft.world.item.ItemStack b(EntityHuman var1, int var2);

    public void a(int slotIndex, int bundleItemIndex) {
        if (slotIndex >= 0 && slotIndex < this.k.size()) {
            net.minecraft.world.item.ItemStack item = this.k.get(slotIndex).g();
            BundleItem.a(item, bundleItemIndex);
        }
    }

    public void a(int slotId, int button, InventoryClickType clickType, EntityHuman player) {
        try {
            this.b(slotId, button, clickType, player);
        }
        catch (Exception var8) {
            CrashReport crashReport = CrashReport.a(var8, "Container click");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Click info");
            crashReportCategory.a("Menu Type", () -> this.u != null ? BuiltInRegistries.p.b(this.u).toString() : "<no type>");
            crashReportCategory.a("Menu Class", () -> this.getClass().getCanonicalName());
            crashReportCategory.a("Slot Count", this.k.size());
            crashReportCategory.a("Slot", slotId);
            crashReportCategory.a("Button", button);
            crashReportCategory.a("Type", (Object)clickType);
            throw new ReportedException(crashReport);
        }
    }

    private void b(int slotId, int button, InventoryClickType clickType, EntityHuman player) {
        block48: {
            block61: {
                int i1;
                block60: {
                    block56: {
                        net.minecraft.world.item.ItemStack carried;
                        Slot slot;
                        net.minecraft.world.item.ItemStack item;
                        PlayerInventory inventory;
                        block59: {
                            block58: {
                                block57: {
                                    block53: {
                                        ClickAction clickAction;
                                        block55: {
                                            block54: {
                                                block52: {
                                                    block46: {
                                                        block51: {
                                                            net.minecraft.world.item.ItemStack carried2;
                                                            block50: {
                                                                block49: {
                                                                    block47: {
                                                                        inventory = player.gi();
                                                                        if (clickType != InventoryClickType.f) break block46;
                                                                        int i2 = this.w;
                                                                        this.w = Container.d(button);
                                                                        if (i2 == 1 && this.w == 2 || i2 == this.w) break block47;
                                                                        this.f();
                                                                        break block48;
                                                                    }
                                                                    if (!this.g().f()) break block49;
                                                                    this.f();
                                                                    break block48;
                                                                }
                                                                if (this.w != 0) break block50;
                                                                this.v = Container.c(button);
                                                                if (Container.a(this.v, player)) {
                                                                    this.w = 1;
                                                                    this.x.clear();
                                                                } else {
                                                                    this.f();
                                                                }
                                                                break block48;
                                                            }
                                                            if (this.w != 1) break block51;
                                                            if (slotId < 0) {
                                                                return;
                                                            }
                                                            Slot slot2 = this.k.get(slotId);
                                                            if (!Container.a(slot2, carried2 = this.g(), true) || !slot2.a(carried2) || this.v != 2 && carried2.M() <= this.x.size() || !this.b(slot2)) break block48;
                                                            this.x.add(slot2);
                                                            break block48;
                                                        }
                                                        if (this.w == 2) {
                                                            if (!this.x.isEmpty()) {
                                                                boolean needsUpdate;
                                                                if (this.x.size() == 1) {
                                                                    int i12 = this.x.iterator().next().d;
                                                                    this.f();
                                                                    this.b(i12, this.v, InventoryClickType.a, player);
                                                                    return;
                                                                }
                                                                net.minecraft.world.item.ItemStack itemStack = this.g().v();
                                                                if (itemStack.f()) {
                                                                    this.f();
                                                                    return;
                                                                }
                                                                int count = this.g().M();
                                                                HashMap<Integer, net.minecraft.world.item.ItemStack> draggedSlots = new HashMap<Integer, net.minecraft.world.item.ItemStack>();
                                                                for (Slot slot1 : this.x) {
                                                                    net.minecraft.world.item.ItemStack carried1 = this.g();
                                                                    if (slot1 == null || !Container.a(slot1, carried1, true) || !slot1.a(carried1) || this.v != 2 && carried1.M() < this.x.size() || !this.b(slot1)) continue;
                                                                    int i2 = slot1.h() ? slot1.g().M() : 0;
                                                                    int min = Math.min(itemStack.k(), slot1.a_(itemStack));
                                                                    int min1 = Math.min(Container.a(this.x, this.v, itemStack) + i2, min);
                                                                    count -= min1 - i2;
                                                                    draggedSlots.put(slot1.d, itemStack.c(min1));
                                                                }
                                                                InventoryView view = this.getBukkitView();
                                                                CraftItemStack newcursor = CraftItemStack.asCraftMirror(itemStack);
                                                                newcursor.setAmount(count);
                                                                HashMap<Integer, ItemStack> eventmap = new HashMap<Integer, ItemStack>();
                                                                for (Map.Entry ditem : draggedSlots.entrySet()) {
                                                                    eventmap.put((Integer)ditem.getKey(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ditem.getValue()));
                                                                }
                                                                net.minecraft.world.item.ItemStack oldCursor = this.g();
                                                                this.b(CraftItemStack.asNMSCopy(newcursor));
                                                                InventoryDragEvent event = new InventoryDragEvent(view, (ItemStack)(newcursor.getType() != Material.AIR ? newcursor : null), CraftItemStack.asBukkitCopy(oldCursor), this.v == 1, eventmap);
                                                                player.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                                                                boolean bl = needsUpdate = event.getResult() != Event.Result.DEFAULT;
                                                                if (event.getResult() != Event.Result.DENY) {
                                                                    for (Map.Entry dslot : draggedSlots.entrySet()) {
                                                                        view.setItem(((Integer)dslot.getKey()).intValue(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)dslot.getValue()));
                                                                    }
                                                                    if (this.g() != null) {
                                                                        this.b(CraftItemStack.asNMSCopy(event.getCursor()));
                                                                        needsUpdate = true;
                                                                    }
                                                                } else {
                                                                    this.b(oldCursor);
                                                                }
                                                                if (needsUpdate && player instanceof EntityPlayer) {
                                                                    this.b();
                                                                }
                                                            }
                                                            this.f();
                                                        } else {
                                                            this.f();
                                                        }
                                                        break block48;
                                                    }
                                                    if (this.w == 0) break block52;
                                                    this.f();
                                                    break block48;
                                                }
                                                if (clickType != InventoryClickType.a && clickType != InventoryClickType.b || button != 0 && button != 1) break block53;
                                                ClickAction clickAction2 = clickAction = button == 0 ? ClickAction.a : ClickAction.b;
                                                if (slotId != -999) break block54;
                                                if (this.g().f()) break block48;
                                                if (clickAction == ClickAction.a) {
                                                    net.minecraft.world.item.ItemStack carried3 = this.g();
                                                    this.b(net.minecraft.world.item.ItemStack.j);
                                                    player.a(carried3, true);
                                                } else {
                                                    player.a(this.g().a(1), true);
                                                }
                                                break block48;
                                            }
                                            if (clickType != InventoryClickType.b) break block55;
                                            if (slotId < 0) {
                                                return;
                                            }
                                            Slot slot3 = this.k.get(slotId);
                                            if (!slot3.a(player)) {
                                                return;
                                            }
                                            net.minecraft.world.item.ItemStack carried4 = this.b(player, slotId);
                                            while (!carried4.f() && net.minecraft.world.item.ItemStack.b(slot3.g(), carried4)) {
                                                carried4 = this.b(player, slotId);
                                            }
                                            break block48;
                                        }
                                        if (slotId < 0) {
                                            return;
                                        }
                                        Slot slot4 = this.k.get(slotId);
                                        net.minecraft.world.item.ItemStack carried5 = slot4.g();
                                        net.minecraft.world.item.ItemStack carried2 = this.g();
                                        player.a(carried2, slot4.g(), clickAction);
                                        if (!this.a(player, clickAction, slot4, carried5, carried2)) {
                                            if (carried5.f()) {
                                                if (!carried2.f()) {
                                                    int i3 = clickAction == ClickAction.a ? carried2.M() : 1;
                                                    this.b(slot4.b(carried2, i3));
                                                }
                                            } else if (slot4.a(player)) {
                                                if (carried2.f()) {
                                                    int i3 = clickAction == ClickAction.a ? carried5.M() : (carried5.M() + 1) / 2;
                                                    Optional<net.minecraft.world.item.ItemStack> optional = slot4.a(i3, Integer.MAX_VALUE, player);
                                                    optional.ifPresent(stack -> {
                                                        this.b((net.minecraft.world.item.ItemStack)stack);
                                                        slot4.a(player, (net.minecraft.world.item.ItemStack)stack);
                                                    });
                                                } else if (slot4.a(carried2)) {
                                                    if (net.minecraft.world.item.ItemStack.c(carried5, carried2)) {
                                                        int i3 = clickAction == ClickAction.a ? carried2.M() : 1;
                                                        this.b(slot4.b(carried2, i3));
                                                    } else if (carried2.M() <= slot4.a_(carried2)) {
                                                        this.b(carried5);
                                                        slot4.e(carried2);
                                                    }
                                                } else if (net.minecraft.world.item.ItemStack.c(carried5, carried2)) {
                                                    Optional<net.minecraft.world.item.ItemStack> optional1 = slot4.a(carried5.M(), carried2.k() - carried2.M(), player);
                                                    optional1.ifPresent(stack -> {
                                                        carried2.g(stack.M());
                                                        slot4.a(player, (net.minecraft.world.item.ItemStack)stack);
                                                    });
                                                }
                                            }
                                        }
                                        slot4.c();
                                        if (!(player instanceof EntityPlayer)) break block48;
                                        EntityPlayer serverPlayer = (EntityPlayer)player;
                                        if (slot4.a() != 64) {
                                            serverPlayer.f.b(new PacketPlayOutSetSlot(this.l, this.k(), slot4.d, slot4.g()));
                                            if (this.getBukkitView().getType() == InventoryType.WORKBENCH || this.getBukkitView().getType() == InventoryType.CRAFTING) {
                                                serverPlayer.f.b(new PacketPlayOutSetSlot(this.l, this.k(), 0, this.b(0).g()));
                                            }
                                        }
                                        break block48;
                                    }
                                    if (clickType != InventoryClickType.c || (button < 0 || button >= 9) && button != 40) break block56;
                                    if (slotId < 0) {
                                        return;
                                    }
                                    item = inventory.a(button);
                                    slot = this.k.get(slotId);
                                    carried = slot.g();
                                    if (item.f() && carried.f()) break block48;
                                    if (!item.f()) break block57;
                                    if (!slot.a(player)) break block48;
                                    inventory.a(button, carried);
                                    slot.b(carried.M());
                                    slot.e(net.minecraft.world.item.ItemStack.j);
                                    slot.a(player, carried);
                                    break block48;
                                }
                                if (!carried.f()) break block58;
                                if (!slot.a(item)) break block48;
                                int maxStackSize = slot.a_(item);
                                if (item.M() > maxStackSize) {
                                    slot.e(item.a(maxStackSize));
                                } else {
                                    inventory.a(button, net.minecraft.world.item.ItemStack.j);
                                    slot.e(item);
                                }
                                break block48;
                            }
                            if (!slot.a(player) || !slot.a(item)) break block48;
                            int maxStackSize = slot.a_(item);
                            if (item.M() <= maxStackSize) break block59;
                            slot.e(item.a(maxStackSize));
                            slot.a(player, carried);
                            if (inventory.f(carried)) break block48;
                            player.a(carried, true);
                            break block48;
                        }
                        inventory.a(button, carried);
                        slot.e(item);
                        slot.a(player, carried);
                        break block48;
                    }
                    if (clickType != InventoryClickType.d || !player.fV() || !this.g().f() || slotId < 0) break block60;
                    Slot slot2 = this.k.get(slotId);
                    if (!slot2.h()) break block48;
                    net.minecraft.world.item.ItemStack itemStack = slot2.g();
                    this.b(itemStack.c(itemStack.k()));
                    break block48;
                }
                if (clickType != InventoryClickType.e || !this.g().f() || slotId < 0) break block61;
                Slot slot2 = this.k.get(slotId);
                int n2 = i1 = button == 0 ? 1 : slot2.g().M();
                if (!player.gl()) {
                    return;
                }
                net.minecraft.world.item.ItemStack carried = slot2.b(i1, Integer.MAX_VALUE, player);
                player.a(carried, true);
                player.g(carried);
                if (button != 1) break block48;
                while (!carried.f() && net.minecraft.world.item.ItemStack.b(slot2.g(), carried)) {
                    if (!player.gl()) {
                        return;
                    }
                    carried = slot2.b(i1, Integer.MAX_VALUE, player);
                    player.a(carried, true);
                    player.g(carried);
                }
                break block48;
            }
            if (clickType == InventoryClickType.g && slotId >= 0) {
                Slot slot2x = this.k.get(slotId);
                net.minecraft.world.item.ItemStack itemStack = this.g();
                if (!(itemStack.f() || slot2x.h() && slot2x.a(player))) {
                    int count = button == 0 ? 0 : this.k.size() - 1;
                    int maxStackSize = button == 0 ? 1 : -1;
                    for (int i3 = 0; i3 < 2; ++i3) {
                        for (int i4 = count; i4 >= 0 && i4 < this.k.size() && itemStack.M() < itemStack.k(); i4 += maxStackSize) {
                            Slot slot3 = this.k.get(i4);
                            if (!slot3.h() || !Container.a(slot3, itemStack, true) || !slot3.a(player) || !this.a(itemStack, slot3)) continue;
                            net.minecraft.world.item.ItemStack item1 = slot3.g();
                            if (i3 == 0 && item1.M() == item1.k()) continue;
                            net.minecraft.world.item.ItemStack itemStack1 = slot3.b(item1.M(), itemStack.k() - itemStack.M(), player);
                            itemStack.g(itemStack1.M());
                        }
                    }
                }
            }
        }
    }

    private boolean a(EntityHuman player, ClickAction action, Slot slot, net.minecraft.world.item.ItemStack clickedItem, net.minecraft.world.item.ItemStack carriedItem) {
        FeatureFlagSet featureFlagSet = player.dV().K();
        return carriedItem.a(featureFlagSet) && carriedItem.a(slot, action, player) || clickedItem.a(featureFlagSet) && clickedItem.a(carriedItem, slot, action, player, this.m());
    }

    private SlotAccess m() {
        return new SlotAccess(){

            @Override
            public net.minecraft.world.item.ItemStack a() {
                return Container.this.g();
            }

            @Override
            public boolean a(net.minecraft.world.item.ItemStack carried) {
                Container.this.b(carried);
                return true;
            }
        };
    }

    public boolean a(net.minecraft.world.item.ItemStack stack, Slot slot) {
        return true;
    }

    public void a(EntityHuman player) {
        net.minecraft.world.item.ItemStack carried;
        if (player instanceof EntityPlayer && !(carried = this.g()).f()) {
            this.b(net.minecraft.world.item.ItemStack.j);
            Container.a(player, carried);
        }
    }

    private static void a(EntityHuman player, net.minecraft.world.item.ItemStack stack) {
        EntityPlayer serverPlayer;
        boolean flag1;
        boolean flag = player.dQ() && player.dR() != Entity.RemovalReason.e;
        boolean bl = flag1 = player instanceof EntityPlayer && (serverPlayer = (EntityPlayer)player).u();
        if (flag || flag1) {
            player.a(stack, false);
        } else if (player instanceof EntityPlayer) {
            player.gi().g(stack);
        }
    }

    protected void a(EntityHuman player, IInventory container) {
        for (int i2 = 0; i2 < container.b(); ++i2) {
            Container.a(player, container.b(i2));
        }
    }

    public void a(IInventory container) {
        this.d();
    }

    public void a(int slotId, int stateId, net.minecraft.world.item.ItemStack stack) {
        this.b(slotId).f(stack);
        this.t = stateId;
    }

    public void a(int stateId, List<net.minecraft.world.item.ItemStack> items, net.minecraft.world.item.ItemStack carried) {
        for (int i2 = 0; i2 < items.size(); ++i2) {
            this.b(i2).f(items.get(i2));
        }
        this.p = carried;
        this.t = stateId;
    }

    public void b(int id, int data) {
        this.o.get(id).a(data);
    }

    public abstract boolean b(EntityHuman var1);

    protected boolean a(net.minecraft.world.item.ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.moveItemStackTo(stack, startIndex, endIndex, reverseDirection, false);
    }

    protected boolean moveItemStackTo(net.minecraft.world.item.ItemStack stack, int startIndex, int endIndex, boolean reverseDirection, boolean isCheck) {
        int i1;
        if (isCheck) {
            stack = stack.v();
        }
        boolean flag = false;
        int i2 = startIndex;
        if (reverseDirection) {
            i2 = endIndex - 1;
        }
        if (stack.l()) {
            while (!stack.f() && (reverseDirection ? i2 >= startIndex : i2 < endIndex)) {
                Slot slot = this.k.get(i2);
                net.minecraft.world.item.ItemStack item = slot.g();
                if (isCheck) {
                    item = item.v();
                }
                if (!item.f() && net.minecraft.world.item.ItemStack.c(stack, item)) {
                    int maxStackSize;
                    i1 = item.M() + stack.M();
                    if (i1 <= (maxStackSize = slot.a_(item))) {
                        stack.e(0);
                        item.e(i1);
                        if (!isCheck) {
                            slot.c();
                        }
                        flag = true;
                    } else if (item.M() < maxStackSize) {
                        stack.h(maxStackSize - item.M());
                        item.e(maxStackSize);
                        if (!isCheck) {
                            slot.c();
                        }
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i2;
                    continue;
                }
                ++i2;
            }
        }
        if (!stack.f()) {
            i2 = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i2 >= startIndex : i2 < endIndex) {
                Slot slotx = this.k.get(i2);
                net.minecraft.world.item.ItemStack itemx = slotx.g();
                if (isCheck) {
                    itemx = itemx.v();
                }
                if (itemx.f() && slotx.a(stack)) {
                    i1 = slotx.a_(stack);
                    if (isCheck) {
                        stack.h(Math.min(stack.M(), i1));
                    } else {
                        slotx.e(stack.a(Math.min(stack.M(), i1)));
                        slotx.c();
                    }
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i2;
                    continue;
                }
                ++i2;
            }
        }
        return flag;
    }

    public static int c(int eventButton) {
        return eventButton >> 2 & 3;
    }

    public static int d(int clickedButton) {
        return clickedButton & 3;
    }

    public static int c(int quickCraftingHeader, int quickCraftingType) {
        return quickCraftingHeader & 3 | (quickCraftingType & 3) << 2;
    }

    public static boolean a(int dragMode, EntityHuman player) {
        return dragMode == 0 || dragMode == 1 || dragMode == 2 && player.fV();
    }

    public void f() {
        this.w = 0;
        this.x.clear();
    }

    public static boolean a(@Nullable Slot slot, net.minecraft.world.item.ItemStack stack, boolean stackSizeMatters) {
        boolean flag;
        boolean bl = flag = slot == null || !slot.h();
        return !flag && net.minecraft.world.item.ItemStack.c(stack, slot.g()) ? slot.g().M() + (stackSizeMatters ? 0 : stack.M()) <= stack.k() : flag;
    }

    public static int a(Set<Slot> slots, int type, net.minecraft.world.item.ItemStack stack) {
        return switch (type) {
            case 0 -> MathHelper.d((float)stack.M() / (float)slots.size());
            case 1 -> 1;
            case 2 -> stack.k();
            default -> stack.M();
        };
    }

    public boolean b(Slot slot) {
        return true;
    }

    public static int a(@Nullable TileEntity blockEntity) {
        return blockEntity instanceof IInventory ? Container.b((IInventory)((Object)blockEntity)) : 0;
    }

    public static int b(@Nullable IInventory container) {
        if (container == null) {
            return 0;
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < container.b(); ++i2) {
            net.minecraft.world.item.ItemStack item = container.a(i2);
            if (item.f()) continue;
            f2 += (float)item.M() / (float)container.e_(item);
        }
        return MathHelper.b(f2 /= (float)container.b(), 0, 15);
    }

    public void b(net.minecraft.world.item.ItemStack stack) {
        this.p = stack;
    }

    public net.minecraft.world.item.ItemStack g() {
        if (this.p.f()) {
            this.b(net.minecraft.world.item.ItemStack.j);
        }
        return this.p;
    }

    public void h() {
        this.A = true;
    }

    public void i() {
        this.A = false;
    }

    public void a(Container menu) {
        Slot slot;
        int i2;
        HashBasedTable table = HashBasedTable.create();
        for (i2 = 0; i2 < menu.k.size(); ++i2) {
            slot = menu.k.get(i2);
            table.put((Object)slot.c, (Object)slot.i(), (Object)i2);
        }
        for (i2 = 0; i2 < this.k.size(); ++i2) {
            slot = this.k.get(i2);
            Integer integer = (Integer)table.get((Object)slot.c, (Object)slot.i());
            if (integer == null) continue;
            this.n.set(i2, menu.n.get(integer));
            this.q.set(i2, menu.q.get(integer));
        }
    }

    public OptionalInt b(IInventory container, int slotIndex) {
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            Slot slot = this.k.get(i2);
            if (slot.c != container || slotIndex != slot.i()) continue;
            return OptionalInt.of(i2);
        }
        return OptionalInt.empty();
    }

    public int j() {
        return this.t;
    }

    public int k() {
        this.t = this.t + 1 & Short.MAX_VALUE;
        return this.t;
    }

    protected final Supplier<BlockInventoryHolder> createBlockHolder(ContainerAccess context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context was null");
        return () -> context.createBlockHolder(this);
    }
}

