/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.food.FoodConstants;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class FoodMetaData {
    public int a = 20;
    public float b = 5.0f;
    public float c;
    private int d;
    public int saturatedRegenRate = 10;
    public int unsaturatedRegenRate = 80;
    public int starvationRate = 80;

    private void b(int foodLevel, float saturationLevel) {
        this.a = MathHelper.a(foodLevel + this.a, 0, 20);
        this.b = MathHelper.a(saturationLevel + this.b, 0.0f, (float)this.a);
    }

    public void a(int foodLevelModifier, float saturationLevelModifier) {
        this.b(foodLevelModifier, FoodConstants.a(foodLevelModifier, saturationLevelModifier));
    }

    public void a(FoodInfo foodProperties) {
        this.b(foodProperties.a(), foodProperties.b());
    }

    public void eat(FoodInfo foodProperties, ItemStack stack, EntityPlayer serverPlayer) {
        int oldFoodLevel = this.a;
        FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(serverPlayer, foodProperties.a() + oldFoodLevel, stack);
        if (!event.isCancelled()) {
            this.b(event.getFoodLevel() - oldFoodLevel, foodProperties.b());
        }
        serverPlayer.getBukkitEntity().sendHealthUpdate();
    }

    public void a(EntityPlayer player) {
        boolean _boolean;
        WorldServer serverLevel = player.y();
        EnumDifficulty difficulty = serverLevel.am();
        if (this.c > 4.0f) {
            this.c -= 4.0f;
            if (this.b > 0.0f) {
                this.b = Math.max(this.b - 1.0f, 0.0f);
            } else if (difficulty != EnumDifficulty.a) {
                FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(player, Math.max(this.a - 1, 0));
                if (!event.isCancelled()) {
                    this.a = event.getFoodLevel();
                }
                player.f.b(new PacketPlayOutUpdateHealth(player.getBukkitEntity().getScaledHealth(), this.a, this.b));
            }
        }
        if ((_boolean = serverLevel.O().b(GameRules.k)) && this.b > 0.0f && player.gu() && this.a >= 20) {
            ++this.d;
            if (this.d >= this.saturatedRegenRate) {
                float min = Math.min(this.b, 6.0f);
                player.heal(min / 6.0f, EntityRegainHealthEvent.RegainReason.SATIATED, true);
                player.causeFoodExhaustion(min, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.d = 0;
            }
        } else if (_boolean && this.a >= 18 && player.gu()) {
            ++this.d;
            if (this.d >= this.unsaturatedRegenRate) {
                player.heal(1.0f, EntityRegainHealthEvent.RegainReason.SATIATED);
                player.causeFoodExhaustion(player.dV().spigotConfig.regenExhaustion, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.d = 0;
            }
        } else if (this.a <= 0) {
            ++this.d;
            if (this.d >= this.starvationRate) {
                if (player.eD() > 10.0f || difficulty == EnumDifficulty.d || player.eD() > 1.0f && difficulty == EnumDifficulty.c) {
                    player.a(serverLevel, player.dW().j(), 1.0f);
                }
                this.d = 0;
            }
        } else {
            this.d = 0;
        }
    }

    public void a(NBTTagCompound compoundTag) {
        if (compoundTag.b("foodLevel", 99)) {
            this.a = compoundTag.h("foodLevel");
            this.d = compoundTag.h("foodTickTimer");
            this.b = compoundTag.j("foodSaturationLevel");
            this.c = compoundTag.j("foodExhaustionLevel");
        }
    }

    public void b(NBTTagCompound compoundTag) {
        compoundTag.a("foodLevel", this.a);
        compoundTag.a("foodTickTimer", this.d);
        compoundTag.a("foodSaturationLevel", this.b);
        compoundTag.a("foodExhaustionLevel", this.c);
    }

    public int a() {
        return this.a;
    }

    public boolean b() {
        return this.a < 20;
    }

    public void a(float exhaustion) {
        this.c = Math.min(this.c + exhaustion, 40.0f);
    }

    public float c() {
        return this.b;
    }

    public void a(int foodLevel) {
        this.a = foodLevel;
    }

    public void b(float saturationLevel) {
        this.b = saturationLevel;
    }
}

