/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityMinecartTNT
extends EntityMinecartAbstract {
    private static final byte b = 10;
    private static final String c = "explosion_power";
    private static final String d = "explosion_speed_factor";
    private static final String h = "fuse";
    private static final float i = 4.0f;
    private static final float j = 1.0f;
    public int k = -1;
    public float l = 4.0f;
    public float m = 1.0f;
    public boolean isIncendiary = false;

    public EntityMinecartTNT(EntityTypes<? extends EntityMinecartTNT> entityType, World level) {
        super(entityType, level);
    }

    @Override
    public IBlockData w() {
        return Blocks.cr.m();
    }

    @Override
    public void h() {
        double d2;
        super.h();
        if (this.k > 0) {
            if (this.dV().paperConfig().fixes.tntEntityHeightNerf.test(v2 -> this.dC() > (double)v2)) {
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            --this.k;
            this.dV().a(Particles.ag, this.dA(), this.dC() + 0.5, this.dG(), 0.0, 0.0, 0.0);
        } else if (this.k == 0) {
            this.h(this.dy().j());
        }
        if (this.P && (d2 = this.dy().j()) >= (double)0.01f) {
            this.h(d2);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        IProjectile projectile;
        Entity entity = damageSource.c();
        if (entity instanceof IProjectile && (projectile = (IProjectile)entity).bY()) {
            DamageSource damageSource1 = this.dW().d(this, damageSource.d());
            this.a(damageSource1, projectile.dy().h());
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public void a(WorldServer level, DamageSource damageSource) {
        double d2 = this.dy().j();
        if (!EntityMinecartTNT.e(damageSource) && !(d2 >= (double)0.01f)) {
            this.a(level, this.u());
        } else if (this.k < 0) {
            this.v();
            this.k = this.ae.a(20) + this.ae.a(20);
        }
    }

    @Override
    protected Item u() {
        return Items.or;
    }

    @Override
    public ItemStack dI() {
        return new ItemStack(Items.or);
    }

    public void h(double radiusModifier) {
        this.a((DamageSource)null, radiusModifier);
    }

    protected void a(@Nullable DamageSource damageSource, double radiusModifier) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            double min = Math.min(Math.sqrt(radiusModifier), 5.0);
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)((double)this.l + (double)this.m * this.ae.j() * 1.5 * min), this.isIncendiary);
            if (!event.callEvent()) {
                this.k = -1;
                return;
            }
            serverLevel.a(this, damageSource, null, this.dA(), this.dC(), this.dG(), event.getRadius(), event.getFire(), World.a.d);
            this.discard(EntityRemoveEvent.Cause.EXPLODE);
        }
    }

    @Override
    public boolean a(float fallDistance, float multiplier, DamageSource source) {
        if (fallDistance >= 3.0f) {
            float f2 = fallDistance / 10.0f;
            this.h((double)(f2 * f2));
        }
        return super.a(fallDistance, multiplier, source);
    }

    @Override
    public void a(int x2, int y2, int z2, boolean receivingPower) {
        if (receivingPower && this.k < 0) {
            this.v();
        }
    }

    @Override
    public void b(byte id) {
        if (id == 10) {
            this.v();
        } else {
            super.b(id);
        }
    }

    public void v() {
        this.k = 80;
        if (!this.dV().C) {
            this.dV().a((Entity)this, (byte)10);
            if (!this.bb()) {
                this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.Am, SoundCategory.e, 1.0f, 1.0f);
            }
        }
    }

    public int x() {
        return this.k;
    }

    public boolean D() {
        return this.k > -1;
    }

    @Override
    public float a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData blockState, Fluid fluidState, float explosionPower) {
        return !this.D() || !blockState.a(TagsBlock.P) && !level.a_(pos.d()).a(TagsBlock.P) ? super.a(explosion, level, pos, blockState, fluidState, explosionPower) : 0.0f;
    }

    @Override
    public boolean a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData blockState, float explosionPower) {
        return (!this.D() || !blockState.a(TagsBlock.P) && !level.a_(pos.d()).a(TagsBlock.P)) && super.a(explosion, level, pos, blockState, explosionPower);
    }

    @Override
    protected void a(NBTTagCompound compound) {
        super.a(compound);
        if (compound.b(h, 99)) {
            this.k = compound.h(h);
        }
        if (compound.b(c, 99)) {
            this.l = MathHelper.a(compound.j(c), 0.0f, 128.0f);
        }
        if (compound.b(d, 99)) {
            this.m = MathHelper.a(compound.j(d), 0.0f, 128.0f);
        }
    }

    @Override
    protected void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a(h, this.k);
        if (this.l != 4.0f) {
            compound.a(c, this.l);
        }
        if (this.m != 1.0f) {
            compound.a(d, this.m);
        }
    }

    @Override
    boolean a(DamageSource source) {
        return EntityMinecartTNT.e(source);
    }

    private static boolean e(DamageSource source) {
        return source.a(DamageTypeTags.i) || source.a(DamageTypeTags.l);
    }
}

