/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class DismountUtil {
    public static int[][] a(EnumDirection direction) {
        EnumDirection clockWise = direction.h();
        EnumDirection opposite = clockWise.g();
        EnumDirection opposite1 = direction.g();
        return new int[][]{{clockWise.j(), clockWise.l()}, {opposite.j(), opposite.l()}, {opposite1.j() + clockWise.j(), opposite1.l() + clockWise.l()}, {opposite1.j() + opposite.j(), opposite1.l() + opposite.l()}, {direction.j() + clockWise.j(), direction.l() + clockWise.l()}, {direction.j() + opposite.j(), direction.l() + opposite.l()}, {opposite1.j(), opposite1.l()}, {direction.j(), direction.l()}};
    }

    public static boolean a(double distance) {
        return !Double.isInfinite(distance) && distance < 1.0;
    }

    public static boolean a(ICollisionAccess level, EntityLiving passenger, AxisAlignedBB boundingBox) {
        for (VoxelShape voxelShape : level.e(passenger, boundingBox)) {
            if (voxelShape.c()) continue;
            return false;
        }
        return level.F_().a(boundingBox);
    }

    public static boolean a(ICollisionAccess level, Vec3D offset, EntityLiving passenger, EntityPose pose) {
        return DismountUtil.a(level, passenger, passenger.f(pose).c(offset));
    }

    public static VoxelShape a(IBlockAccess level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos);
        return !blockState.a(TagsBlock.aS) && (!(blockState.b() instanceof BlockTrapdoor) || blockState.c(BlockTrapdoor.b) == false) ? blockState.g(level, pos) : VoxelShapes.a();
    }

    public static double a(BlockPosition pos, int ceiling, Function<BlockPosition, VoxelShape> shapeForPos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        for (int i2 = 0; i2 < ceiling; ++i2) {
            VoxelShape voxelShape = shapeForPos.apply(mutableBlockPos);
            if (!voxelShape.c()) {
                return (double)(pos.v() + i2) + voxelShape.b(EnumDirection.EnumAxis.b);
            }
            mutableBlockPos.c(EnumDirection.b);
        }
        return Double.POSITIVE_INFINITY;
    }

    @Nullable
    public static Vec3D a(EntityTypes<?> entityType, ICollisionAccess level, BlockPosition pos, boolean onlySafePositions) {
        if (onlySafePositions && entityType.a(level.a_(pos))) {
            return null;
        }
        double blockFloorHeight = level.a(DismountUtil.a((IBlockAccess)level, pos), () -> DismountUtil.a((IBlockAccess)level, pos.e()));
        if (!DismountUtil.a(blockFloorHeight)) {
            return null;
        }
        if (onlySafePositions && blockFloorHeight <= 0.0 && entityType.a(level.a_(pos.e()))) {
            return null;
        }
        Vec3D vec3 = Vec3D.a(pos, blockFloorHeight);
        AxisAlignedBB aabb = entityType.n().a(vec3);
        for (VoxelShape voxelShape : level.e(null, aabb)) {
            if (voxelShape.c()) continue;
            return null;
        }
        if (entityType != EntityTypes.bR || !level.a_(pos).a(TagsBlock.ct) && !level.a_(pos.d()).a(TagsBlock.ct)) {
            return !level.F_().a(aabb) ? null : vec3;
        }
        return null;
    }
}

