/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;

public abstract class AbstractBoat
extends VehicleEntity
implements Leashable {
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> i = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> j = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.b);
    public static final int a = 0;
    public static final int b = 1;
    private static final int k = 60;
    private static final float l = 0.3926991f;
    public static final double c = 0.7853981852531433;
    public static final int d = 60;
    private final float[] m = new float[2];
    private float n;
    private float o;
    private float p;
    private int q;
    private double r;
    private double s;
    private double t;
    private double u;
    private double ay;
    private boolean az;
    private boolean aA;
    private boolean aB;
    private boolean aC;
    private double aD;
    private float aE;
    public EnumStatus aF;
    private EnumStatus aG;
    private double aH;
    private boolean aI;
    private boolean aJ;
    private float aK;
    private float aL;
    private float aM;
    @Nullable
    private Leashable.a aN;
    private final Supplier<Item> aO;
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    public AbstractBoat(EntityTypes<? extends AbstractBoat> entityType, World level, Supplier<Item> dropItem) {
        super(entityType, level);
        this.aO = dropItem;
        this.I = true;
    }

    public void p(double x2, double y2, double z2) {
        this.a_(x2, y2, z2);
        this.K = x2;
        this.L = y2;
        this.M = z2;
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(h, false);
        builder.a(i, false);
        builder.a(j, 0);
    }

    @Override
    public boolean i(Entity entity) {
        return AbstractBoat.a(this, entity);
    }

    public static boolean a(Entity first, Entity second) {
        return (second.bN() || second.bI()) && !first.z(second);
    }

    @Override
    public boolean bN() {
        return true;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return EntityLiving.k(super.a(axis, portal));
    }

    protected abstract double b(EntitySize var1);

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        float singlePassengerXOffset = this.s();
        if (this.cY().size() > 1) {
            int index = this.cY().indexOf(entity);
            singlePassengerXOffset = index == 0 ? 0.2f : -0.6f;
            if (entity instanceof EntityAnimal) {
                singlePassengerXOffset += 0.2f;
            }
        }
        return new Vec3D(0.0, this.b(dimensions), singlePassengerXOffset).b(-this.dL() * ((float)Math.PI / 180));
    }

    @Override
    public void l(boolean downwards) {
        if (!this.dV().C) {
            this.aI = true;
            this.aJ = downwards;
            if (this.R() == 0) {
                this.m(60);
            }
        }
        this.dV().a(Particles.ao, this.dA() + (double)this.ae.i(), this.dC() + 0.7, this.dG() + (double)this.ae.i(), 0.0, 0.0, 0.0);
        if (this.ae.a(20) == 0) {
            this.dV().a(this.dA(), this.dC(), this.dG(), this.aW(), this.dm(), 1.0f, 0.8f + 0.4f * this.ae.i(), false);
            this.a(GameEvent.O, (Entity)this.cW());
        }
    }

    @Override
    public void h(Entity entity) {
        if (!this.dV().paperConfig().collisions.allowVehicleCollisions && this.dV().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
            return;
        }
        if (entity instanceof AbstractBoat) {
            if (entity.cR().b < this.cR().e) {
                VehicleEntityCollisionEvent event;
                if (!this.z(entity) && !(event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity())).callEvent()) {
                    return;
                }
                super.h(entity);
            }
        } else if (entity.cR().b <= this.cR().b) {
            VehicleEntityCollisionEvent event;
            if (!this.z(entity) && !(event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity())).callEvent()) {
                return;
            }
            super.h(entity);
        }
    }

    @Override
    public void p(float yaw) {
        this.l(-this.O());
        this.d(10);
        this.b(this.L() * 11.0f);
    }

    @Override
    public boolean bH() {
        return !this.dQ();
    }

    @Override
    public void f_() {
        this.q = 0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yRot, float xRot, int steps) {
        this.r = x2;
        this.s = y2;
        this.t = z2;
        this.u = yRot;
        this.ay = xRot;
        this.q = steps;
    }

    @Override
    public double R_() {
        return this.q > 0 ? this.r : this.dA();
    }

    @Override
    public double S_() {
        return this.q > 0 ? this.s : this.dC();
    }

    @Override
    public double g_() {
        return this.q > 0 ? this.t : this.dG();
    }

    @Override
    public float r_() {
        return this.q > 0 ? (float)this.ay : this.dN();
    }

    @Override
    public float h_() {
        return this.q > 0 ? (float)this.u : this.dL();
    }

    @Override
    public EnumDirection cP() {
        return this.cO().h();
    }

    @Override
    public void h() {
        this.aG = this.aF;
        this.aF = this.I();
        this.o = this.aF != EnumStatus.b && this.aF != EnumStatus.c ? 0.0f : (this.o += 1.0f);
        if (!this.dV().C && this.o >= 60.0f) {
            this.bP();
        }
        if (this.N() > 0) {
            this.d(this.N() - 1);
        }
        if (this.L() > 0.0f) {
            this.b(this.L() - 1.0f);
        }
        super.h();
        this.H();
        if (this.dh()) {
            if (!(this.cZ() instanceof EntityHuman)) {
                this.a(false, false);
            }
            this.P();
            if (this.dV().C) {
                this.Q();
                this.dV().a(new PacketPlayInBoatMove(this.c(0), this.c(1)));
            }
            this.a(EnumMoveType.a, this.dy());
        } else {
            this.i(Vec3D.c);
        }
        Location to = CraftLocation.toBukkit(this.dt(), (org.bukkit.World)this.dV().getWorld(), this.dL(), this.dN());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        new VehicleUpdateEvent(vehicle).callEvent();
        if (this.lastLocation != null && !this.lastLocation.equals((Object)to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            event.callEvent();
        }
        this.lastLocation = vehicle.getLocation();
        this.aK();
        this.aK();
        this.G();
        for (int i2 = 0; i2 <= 1; ++i2) {
            if (this.c(i2)) {
                SoundEffect paddleSound;
                if (!this.bb() && this.m[i2] % ((float)Math.PI * 2) <= 0.7853982f && (this.m[i2] + 0.3926991f) % ((float)Math.PI * 2) >= 0.7853982f && (paddleSound = this.l()) != null) {
                    Vec3D viewVector = this.g(1.0f);
                    double d2 = i2 == 1 ? -viewVector.f : viewVector.f;
                    double d1 = i2 == 1 ? viewVector.d : -viewVector.d;
                    this.dV().a(null, this.dA() + d2, this.dC(), this.dG() + d1, paddleSound, this.dm(), 1.0f, 0.8f + 0.4f * this.ae.i());
                }
                this.m[i2] = this.m[i2] + 0.3926991f;
                continue;
            }
            this.m[i2] = 0.0f;
        }
        List<Entity> entities = this.dV().a((Entity)this, this.cR().c(0.2f, -0.01f, 0.2f), IEntitySelector.a(this));
        if (!entities.isEmpty()) {
            boolean flag = !this.dV().C && !(this.cW() instanceof EntityHuman);
            for (Entity entity : entities) {
                if (entity.y(this)) continue;
                if (flag && this.cY().size() < this.t() && !entity.bZ() && this.b(entity) && entity instanceof EntityLiving && !(entity instanceof EntityWaterAnimal) && !(entity instanceof EntityHuman) && !(entity instanceof Creaking)) {
                    entity.n(this);
                    continue;
                }
                this.h(entity);
            }
        }
    }

    private void G() {
        if (this.dV().C) {
            int bubbleTime = this.R();
            this.aK = bubbleTime > 0 ? (this.aK += 0.05f) : (this.aK -= 0.1f);
            this.aK = MathHelper.a(this.aK, 0.0f, 1.0f);
            this.aM = this.aL;
            this.aL = 10.0f * (float)Math.sin(0.5f * (float)this.dV().ad()) * this.aK;
        } else {
            int bubbleTime;
            if (!this.aI) {
                this.m(0);
            }
            if ((bubbleTime = this.R()) > 0) {
                this.m(--bubbleTime);
                int i2 = 60 - bubbleTime - 1;
                if (i2 > 0 && bubbleTime == 0) {
                    this.m(0);
                    Vec3D deltaMovement = this.dy();
                    if (this.aJ) {
                        this.i(deltaMovement.b(0.0, -0.7, 0.0));
                        this.bP();
                    } else {
                        this.n(deltaMovement.d, this.a((Entity entity) -> entity instanceof EntityHuman) ? 2.7 : 0.6, deltaMovement.f);
                    }
                }
                this.aI = false;
            }
        }
    }

    @Nullable
    protected SoundEffect l() {
        switch (this.I().ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return SoundEffects.cm;
            }
            case 3: {
                return SoundEffects.cl;
            }
        }
        return null;
    }

    @Override
    private void H() {
        if (this.q > 0) {
            this.a(this.q, this.r, this.s, this.t, this.u, this.ay);
            --this.q;
        }
    }

    public void a(boolean left, boolean right) {
        this.al.a(h, left);
        this.al.a(i, right);
    }

    public float a(int side, float partialTick) {
        return this.c(side) ? MathHelper.b(this.m[side] - 0.3926991f, this.m[side], partialTick) : 0.0f;
    }

    @Override
    @Nullable
    public Leashable.a T_() {
        return this.aN;
    }

    @Override
    public void a(@Nullable Leashable.a leashData) {
        this.aN = leashData;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.88f * this.cS(), this.dq() * 0.64f);
    }

    @Override
    public void b(Entity leashHolder, float distance) {
        Vec3D vec3 = leashHolder.dt().d(this.dt()).d().c((double)distance - 6.0);
        Vec3D deltaMovement = this.dy();
        boolean flag = deltaMovement.b(vec3) > 0.0;
        this.i(deltaMovement.e(vec3.c(flag ? (double)0.15f : (double)0.2f)));
    }

    public EnumStatus I() {
        EnumStatus status = this.K();
        if (status != null) {
            this.aD = this.cR().e;
            return status;
        }
        if (this.J()) {
            return EnumStatus.a;
        }
        float groundFriction = this.p();
        if (groundFriction > 0.0f) {
            this.aE = groundFriction;
            return EnumStatus.d;
        }
        return EnumStatus.e;
    }

    public float m() {
        AxisAlignedBB boundingBox = this.cR();
        int floor = MathHelper.a(boundingBox.a);
        int ceil = MathHelper.c(boundingBox.d);
        int floor1 = MathHelper.a(boundingBox.e);
        int ceil1 = MathHelper.c(boundingBox.e - this.aH);
        int floor2 = MathHelper.a(boundingBox.c);
        int ceil2 = MathHelper.c(boundingBox.f);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        block0: for (int i2 = floor1; i2 < ceil1; ++i2) {
            float f2 = 0.0f;
            for (int i1 = floor; i1 < ceil; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i1, i2, i22);
                    Fluid fluidState = this.dV().b_(mutableBlockPos);
                    if (fluidState.a(TagsFluid.a)) {
                        f2 = Math.max(f2, fluidState.a(this.dV(), mutableBlockPos));
                    }
                    if (f2 >= 1.0f) continue block0;
                }
            }
            if (!(f2 < 1.0f)) continue;
            return (float)mutableBlockPos.v() + f2;
        }
        return ceil1 + 1;
    }

    public float p() {
        AxisAlignedBB boundingBox = this.cR();
        AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.a, boundingBox.b - 0.001, boundingBox.c, boundingBox.d, boundingBox.b, boundingBox.f);
        int i2 = MathHelper.a(aabb.a) - 1;
        int i1 = MathHelper.c(aabb.d) + 1;
        int i22 = MathHelper.a(aabb.b) - 1;
        int i3 = MathHelper.c(aabb.e) + 1;
        int i4 = MathHelper.a(aabb.c) - 1;
        int i5 = MathHelper.c(aabb.f) + 1;
        VoxelShape voxelShape = VoxelShapes.a(aabb);
        float f2 = 0.0f;
        int i6 = 0;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i7 = i2; i7 < i1; ++i7) {
            for (int i8 = i4; i8 < i5; ++i8) {
                int i9 = (i7 != i2 && i7 != i1 - 1 ? 0 : 1) + (i8 != i4 && i8 != i5 - 1 ? 0 : 1);
                if (i9 == 2) continue;
                for (int i10 = i22; i10 < i3; ++i10) {
                    if (i9 > 0 && (i10 == i22 || i10 == i3 - 1)) continue;
                    mutableBlockPos.d(i7, i10, i8);
                    IBlockData blockState = this.dV().a_(mutableBlockPos);
                    if (blockState.b() instanceof BlockWaterLily || !VoxelShapes.c(blockState.g(this.dV(), mutableBlockPos).a(i7, (double)i10, (double)i8), voxelShape, OperatorBoolean.i)) continue;
                    f2 += blockState.b().g();
                    ++i6;
                }
            }
        }
        return f2 / (float)i6;
    }

    private boolean J() {
        AxisAlignedBB boundingBox = this.cR();
        int floor = MathHelper.a(boundingBox.a);
        int ceil = MathHelper.c(boundingBox.d);
        int floor1 = MathHelper.a(boundingBox.b);
        int ceil1 = MathHelper.c(boundingBox.b + 0.001);
        int floor2 = MathHelper.a(boundingBox.c);
        int ceil2 = MathHelper.c(boundingBox.f);
        boolean flag = false;
        this.aD = -1.7976931348623157E308;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = floor; i2 < ceil; ++i2) {
            for (int i1 = floor1; i1 < ceil1; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i2, i1, i22);
                    Fluid fluidState = this.dV().b_(mutableBlockPos);
                    if (!fluidState.a(TagsFluid.a)) continue;
                    float f2 = (float)i1 + fluidState.a(this.dV(), mutableBlockPos);
                    this.aD = Math.max((double)f2, this.aD);
                    flag |= boundingBox.b < (double)f2;
                }
            }
        }
        return flag;
    }

    @Nullable
    private EnumStatus K() {
        AxisAlignedBB boundingBox = this.cR();
        double d2 = boundingBox.e + 0.001;
        int floor = MathHelper.a(boundingBox.a);
        int ceil = MathHelper.c(boundingBox.d);
        int floor1 = MathHelper.a(boundingBox.e);
        int ceil1 = MathHelper.c(d2);
        int floor2 = MathHelper.a(boundingBox.c);
        int ceil2 = MathHelper.c(boundingBox.f);
        boolean flag = false;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = floor; i2 < ceil; ++i2) {
            for (int i1 = floor1; i1 < ceil1; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i2, i1, i22);
                    Fluid fluidState = this.dV().b_(mutableBlockPos);
                    if (!fluidState.a(TagsFluid.a) || !(d2 < (double)((float)mutableBlockPos.v() + fluidState.a(this.dV(), mutableBlockPos)))) continue;
                    if (!fluidState.b()) {
                        return EnumStatus.c;
                    }
                    flag = true;
                }
            }
        }
        return flag ? EnumStatus.b : null;
    }

    @Override
    protected double bd() {
        return 0.04;
    }

    private void P() {
        double d2 = -this.be();
        double d1 = 0.0;
        this.n = 0.05f;
        if (this.aG == EnumStatus.e && this.aF != EnumStatus.e && this.aF != EnumStatus.d) {
            this.aD = this.e(1.0);
            double d22 = (double)(this.m() - this.dr()) + 0.101;
            if (this.dV().a((Entity)this, this.cR().d(0.0, d22 - this.dC(), 0.0))) {
                this.a(EnumMoveType.a, new Vec3D(0.0, d22 - this.dC(), 0.0));
                this.i(this.dy().d(1.0, 0.0, 1.0));
                this.aH = 0.0;
            }
            this.aF = EnumStatus.a;
        } else {
            if (this.aF == EnumStatus.a) {
                d1 = (this.aD - this.dC()) / (double)this.dr();
                this.n = 0.9f;
            } else if (this.aF == EnumStatus.c) {
                d2 = -7.0E-4;
                this.n = 0.9f;
            } else if (this.aF == EnumStatus.b) {
                d1 = 0.01f;
                this.n = 0.45f;
            } else if (this.aF == EnumStatus.e) {
                this.n = 0.9f;
            } else if (this.aF == EnumStatus.d) {
                this.n = this.aE;
                if (this.cW() instanceof EntityHuman) {
                    this.aE /= 2.0f;
                }
            }
            Vec3D deltaMovement = this.dy();
            this.n(deltaMovement.d * (double)this.n, deltaMovement.e + d2, deltaMovement.f * (double)this.n);
            this.p *= this.n;
            if (d1 > 0.0) {
                Vec3D deltaMovement1 = this.dy();
                this.n(deltaMovement1.d, (deltaMovement1.e + d1 * (this.bd() / 0.65)) * 0.75, deltaMovement1.f);
            }
        }
    }

    private void Q() {
        if (this.ca()) {
            float f2 = 0.0f;
            if (this.az) {
                this.p -= 1.0f;
            }
            if (this.aA) {
                this.p += 1.0f;
            }
            if (this.aA != this.az && !this.aB && !this.aC) {
                f2 += 0.005f;
            }
            this.v(this.dL() + this.p);
            if (this.aB) {
                f2 += 0.04f;
            }
            if (this.aC) {
                f2 -= 0.005f;
            }
            this.i(this.dy().b(MathHelper.a(-this.dL() * ((float)Math.PI / 180)) * f2, 0.0, MathHelper.b(this.dL() * ((float)Math.PI / 180)) * f2));
            this.a(this.aA && !this.az || this.aB, this.az && !this.aA || this.aB);
        }
    }

    protected float s() {
        return 0.0f;
    }

    public boolean b(Entity entity) {
        return entity.dq() < this.dq();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (!passenger.aq().a(TagsEntity.s)) {
            passenger.v(passenger.dL() + this.p);
            passenger.q(passenger.cA() + this.p);
            this.c(passenger);
            if (passenger instanceof EntityAnimal && this.cY().size() == this.t()) {
                int i2 = passenger.ar() % 2 == 0 ? 90 : 270;
                passenger.r(((EntityAnimal)passenger).aX + (float)i2);
                passenger.q(passenger.cA() + (float)i2);
            }
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D collisionHorizontalEscapeVector = AbstractBoat.a(this.dq() * MathHelper.g, (double)passenger.dq(), passenger.dL());
        double d2 = this.dA() + collisionHorizontalEscapeVector.d;
        double d1 = this.dG() + collisionHorizontalEscapeVector.f;
        BlockPosition blockPos = BlockPosition.a(d2, this.cR().e, d1);
        BlockPosition blockPos1 = blockPos.e();
        if (!this.dV().z(blockPos1)) {
            double blockFloorHeight1;
            ArrayList list = Lists.newArrayList();
            double blockFloorHeight = this.dV().j(blockPos);
            if (DismountUtil.a(blockFloorHeight)) {
                list.add(new Vec3D(d2, (double)blockPos.v() + blockFloorHeight, d1));
            }
            if (DismountUtil.a(blockFloorHeight1 = this.dV().j(blockPos1))) {
                list.add(new Vec3D(d2, (double)blockPos1.v() + blockFloorHeight1, d1));
            }
            for (EntityPose pose : passenger.fO()) {
                for (Vec3D vec3 : list) {
                    if (!DismountUtil.a(this.dV(), vec3, passenger, pose)) continue;
                    passenger.b(pose);
                    return vec3;
                }
            }
        }
        return super.b(passenger);
    }

    protected void c(Entity entity) {
        entity.r(this.dL());
        float f2 = MathHelper.h(entity.dL() - this.dL());
        float f1 = MathHelper.a(f2, -105.0f, 105.0f);
        entity.N += f1 - f2;
        entity.v(entity.dL() + f1 - f2);
        entity.q(entity.dL());
    }

    @Override
    public void k(Entity entityToUpdate) {
        this.c(entityToUpdate);
    }

    @Override
    protected void b(NBTTagCompound tag) {
        this.a(tag, this.aN);
    }

    @Override
    protected void a(NBTTagCompound tag) {
        this.c(tag);
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.a(player, hand);
        if (interactionResult != EnumInteractionResult.e) {
            return interactionResult;
        }
        return (EnumInteractionResult)((Object)(player.fY() || !(this.o < 60.0f) || !this.dV().C && !player.n(this) ? EnumInteractionResult.e : EnumInteractionResult.a));
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason reason, EntityRemoveEvent.Cause eventCause) {
        if (!this.dV().C && reason.a() && this.P_()) {
            this.z();
        }
        super.remove(reason, eventCause);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        this.aH = this.dy().e;
        if (!this.bZ()) {
            if (onGround) {
                this.k();
            } else if (!this.dV().b_(this.dv().e()).a(TagsFluid.a) && y2 < 0.0) {
                this.Z -= (float)y2;
            }
        }
    }

    public boolean c(int side) {
        return this.al.a(side == 0 ? h : i) != false && this.cW() != null;
    }

    private void m(int bubbleTime) {
        this.al.a(j, bubbleTime);
    }

    private int R() {
        return this.al.a(j);
    }

    public float a(float partialTick) {
        return MathHelper.h(partialTick, this.aM, this.aL);
    }

    @Override
    protected boolean r(Entity passenger) {
        return this.cY().size() < this.t() && !this.a(TagsFluid.a);
    }

    protected int t() {
        return 2;
    }

    @Override
    @Nullable
    public EntityLiving cW() {
        EntityLiving livingEntity;
        Entity entity = this.cZ();
        return entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : super.cW();
    }

    public void a(boolean left, boolean right, boolean up, boolean down) {
        this.az = left;
        this.aA = right;
        this.aB = up;
        this.aC = down;
    }

    @Override
    public boolean bo() {
        return this.aF == EnumStatus.b || this.aF == EnumStatus.c;
    }

    @Override
    public final Item u() {
        return this.aO.get();
    }

    @Override
    public final ItemStack dI() {
        return new ItemStack(this.aO.get());
    }

    public static final class EnumStatus
    extends Enum<EnumStatus> {
        public static final /* enum */ EnumStatus a = new EnumStatus();
        public static final /* enum */ EnumStatus b = new EnumStatus();
        public static final /* enum */ EnumStatus c = new EnumStatus();
        public static final /* enum */ EnumStatus d = new EnumStatus();
        public static final /* enum */ EnumStatus e = new EnumStatus();
        private static final /* synthetic */ EnumStatus[] f;

        public static EnumStatus[] values() {
            return (EnumStatus[])f.clone();
        }

        public static EnumStatus valueOf(String name) {
            return Enum.valueOf(EnumStatus.class, name);
        }

        private static /* synthetic */ EnumStatus[] a() {
            return new EnumStatus[]{a, b, c, d, e};
        }

        static {
            f = EnumStatus.a();
        }
    }
}

