/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossBattle;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.raid.RaidStopEvent;

public class Raid {
    public static final SpawnPlacementType a = EntityPositionTypes.a(EntityTypes.aY);
    private static final int i = 7;
    private static final int j = 2;
    private static final int k = 32;
    private static final int l = 48000;
    private static final int m = 5;
    private static final IChatBaseComponent n = IChatBaseComponent.c("block.minecraft.ominous_banner");
    private static final String o = "event.minecraft.raid.raiders_remaining";
    public static final int b = 16;
    private static final int p = 40;
    private static final int q = 300;
    public static final int c = 2400;
    public static final int d = 600;
    private static final int r = 30;
    public static final int e = 24000;
    public static final int f = 5;
    private static final int s = 2;
    private static final IChatBaseComponent t = IChatBaseComponent.c("event.minecraft.raid");
    private static final IChatBaseComponent u = IChatBaseComponent.c("event.minecraft.raid.victory.full");
    private static final IChatBaseComponent v = IChatBaseComponent.c("event.minecraft.raid.defeat.full");
    private static final int w = 48000;
    private static final int x = 96;
    public static final int g = 9216;
    public static final int h = 12544;
    private final Map<Integer, EntityRaider> y = Maps.newHashMap();
    private final Map<Integer, Set<EntityRaider>> z = Maps.newHashMap();
    public final Set<UUID> A = Sets.newHashSet();
    public long B;
    private BlockPosition C;
    private final WorldServer D;
    private boolean E;
    private final int F;
    public float G;
    public int H;
    private boolean I;
    private int J;
    public final BossBattleServer K = new BossBattleServer(t, BossBattle.BarColor.c, BossBattle.BarStyle.c);
    private int L;
    private int M;
    private final RandomSource N = RandomSource.a();
    public final int O;
    private Status P;
    private int Q;
    private Optional<BlockPosition> R = Optional.empty();
    private static final String PDC_NBT_KEY = "BukkitValues";
    private static final CraftPersistentDataTypeRegistry PDC_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(PDC_TYPE_REGISTRY);

    public Raid(int id, WorldServer level, BlockPosition center) {
        this.F = id;
        this.D = level;
        this.I = true;
        this.M = 300;
        this.K.a(0.0f);
        this.C = center;
        this.O = this.a(level.am());
        this.P = Status.a;
    }

    public Raid(WorldServer level, NBTTagCompound compound) {
        this.D = level;
        this.F = compound.h("Id");
        this.E = compound.q("Started");
        this.I = compound.q("Active");
        this.B = compound.i("TicksActive");
        this.H = compound.h("BadOmenLevel");
        this.J = compound.h("GroupsSpawned");
        this.M = compound.h("PreRaidTicks");
        this.L = compound.h("PostRaidTicks");
        this.G = compound.j("TotalHealth");
        this.C = new BlockPosition(compound.h("CX"), compound.h("CY"), compound.h("CZ"));
        this.O = compound.h("NumGroups");
        this.P = Status.a(compound.l("Status"));
        this.A.clear();
        if (compound.b("HeroesOfTheVillage", 9)) {
            for (NBTBase tag : compound.c("HeroesOfTheVillage", 11)) {
                this.A.add(GameProfileSerializer.a(tag));
            }
        }
        if (compound.b(PDC_NBT_KEY, 10)) {
            this.persistentDataContainer.putAll(compound.p(PDC_NBT_KEY));
        }
    }

    public boolean a() {
        return this.e() || this.f();
    }

    public boolean b() {
        return this.c() && this.r() == 0 && this.M > 0;
    }

    public boolean c() {
        return this.J > 0;
    }

    public boolean d() {
        return this.P == Status.d;
    }

    public boolean e() {
        return this.P == Status.b;
    }

    public boolean f() {
        return this.P == Status.c;
    }

    public boolean isInProgress() {
        return this.P == Status.a;
    }

    public float g() {
        return this.G;
    }

    public Set<EntityRaider> h() {
        HashSet set = Sets.newHashSet();
        for (Set<EntityRaider> set1 : this.z.values()) {
            set.addAll(set1);
        }
        return set;
    }

    public World i() {
        return this.D;
    }

    public boolean j() {
        return this.E;
    }

    public int k() {
        return this.J;
    }

    private Predicate<EntityPlayer> w() {
        return player -> {
            BlockPosition blockPos = player.dv();
            return player.bL() && this.D.d(blockPos) == this;
        };
    }

    private void x() {
        HashSet set = Sets.newHashSet(this.K.g());
        List<EntityPlayer> players = this.D.a(this.w());
        for (EntityPlayer serverPlayer : players) {
            if (set.contains(serverPlayer)) continue;
            this.K.a(serverPlayer);
        }
        for (EntityPlayer serverPlayerx : set) {
            if (players.contains(serverPlayerx)) continue;
            this.K.b(serverPlayerx);
        }
    }

    public int l() {
        return 5;
    }

    public int m() {
        return this.H;
    }

    public void a(int raidOmenLevel) {
        this.H = raidOmenLevel;
    }

    public boolean a(EntityPlayer player) {
        MobEffect effect = player.c(MobEffects.I);
        if (effect == null) {
            return false;
        }
        this.H = this.H + effect.e() + 1;
        this.H = MathHelper.a(this.H, 0, this.l());
        if (!this.c()) {
            player.a(StatisticList.aA);
            CriterionTriggers.J.a(player);
        }
        return true;
    }

    public void n() {
        this.I = false;
        this.K.b();
        this.P = Status.d;
    }

    public void o() {
        if (!this.d()) {
            if (this.P == Status.a) {
                boolean flag = this.I;
                this.I = this.D.B(this.C);
                if (this.D.am() == EnumDifficulty.a) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.PEACE);
                    this.n();
                    return;
                }
                if (flag != this.I) {
                    this.K.d(this.I);
                }
                if (!this.I) {
                    return;
                }
                if (!this.D.c(this.C)) {
                    this.y();
                }
                if (!this.D.c(this.C)) {
                    if (this.J > 0) {
                        this.P = Status.c;
                        CraftEventFactory.callRaidFinishEvent(this, new ArrayList<Player>());
                    } else {
                        CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.NOT_IN_VILLAGE);
                        this.n();
                    }
                }
                ++this.B;
                if (this.B >= 48000L) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.TIMEOUT);
                    this.n();
                    return;
                }
                int totalRaidersAlive = this.r();
                if (totalRaidersAlive == 0 && this.A()) {
                    if (this.M <= 0) {
                        if (this.M == 0 && this.J > 0) {
                            this.M = 300;
                            this.K.a(t);
                            return;
                        }
                    } else {
                        boolean flag1;
                        boolean isPresent = this.R.isPresent();
                        boolean bl = flag1 = !isPresent && this.M % 5 == 0;
                        if (isPresent && !this.D.f(this.R.get())) {
                            flag1 = true;
                        }
                        if (flag1) {
                            this.R = this.z();
                        }
                        if (this.M == 300 || this.M % 20 == 0) {
                            this.x();
                        }
                        --this.M;
                        this.K.a(MathHelper.a((float)(300 - this.M) / 300.0f, 0.0f, 1.0f));
                    }
                }
                if (this.B % 20L == 0L) {
                    this.x();
                    this.F();
                    if (totalRaidersAlive > 0) {
                        if (totalRaidersAlive <= 2) {
                            this.K.a(t.f().f(" - ").b(IChatBaseComponent.a(o, totalRaidersAlive)));
                        } else {
                            this.K.a(t);
                        }
                    } else {
                        this.K.a(t);
                    }
                }
                boolean isPresentx = false;
                int i2 = 0;
                while (this.G()) {
                    BlockPosition blockPos = this.R.orElseGet(() -> this.d(20));
                    if (blockPos != null) {
                        this.E = true;
                        this.b(blockPos);
                        if (!isPresentx) {
                            this.a(blockPos);
                            isPresentx = true;
                        }
                    } else {
                        ++i2;
                    }
                    if (i2 <= 5) continue;
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.UNSPAWNABLE);
                    this.n();
                    break;
                }
                if (this.j() && !this.A() && totalRaidersAlive == 0) {
                    if (this.L < 40) {
                        ++this.L;
                    } else {
                        this.P = Status.b;
                        ArrayList<Player> winners = new ArrayList<Player>();
                        for (UUID uuid : this.A) {
                            Entity entity = this.D.a(uuid);
                            if (!(entity instanceof EntityLiving)) continue;
                            EntityLiving livingEntity = (EntityLiving)entity;
                            if (entity.Z_()) continue;
                            livingEntity.a(new MobEffect(MobEffects.F, 48000, this.H - 1, false, false, true));
                            if (!(livingEntity instanceof EntityPlayer)) continue;
                            EntityPlayer serverPlayer = (EntityPlayer)livingEntity;
                            serverPlayer.a(StatisticList.aB);
                            CriterionTriggers.I.a(serverPlayer);
                            winners.add(serverPlayer.getBukkitEntity());
                        }
                        CraftEventFactory.callRaidFinishEvent(this, winners);
                    }
                }
                this.H();
            } else if (this.a()) {
                ++this.Q;
                if (this.Q >= 600) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.FINISHED);
                    this.n();
                    return;
                }
                if (this.Q % 20 == 0) {
                    this.x();
                    this.K.d(true);
                    if (this.e()) {
                        this.K.a(0.0f);
                        this.K.a(u);
                    } else {
                        this.K.a(v);
                    }
                }
            }
        }
    }

    private void y() {
        Stream<SectionPosition> stream = SectionPosition.a(SectionPosition.a(this.C), 2);
        stream.filter(this.D::a).map(SectionPosition::k).min(Comparator.comparingDouble(blockPos -> blockPos.j(this.C))).ifPresent(this::c);
    }

    private Optional<BlockPosition> z() {
        BlockPosition blockPos = this.d(8);
        return blockPos != null ? Optional.of(blockPos) : Optional.empty();
    }

    private boolean A() {
        return this.C() ? !this.D() : !this.B();
    }

    private boolean B() {
        return this.k() == this.O;
    }

    private boolean C() {
        return this.H > 1;
    }

    private boolean D() {
        return this.k() > this.O;
    }

    private boolean E() {
        return this.B() && this.r() == 0 && this.C();
    }

    private void F() {
        Iterator<Set<EntityRaider>> iterator = this.z.values().iterator();
        HashSet set = Sets.newHashSet();
        while (iterator.hasNext()) {
            Set<EntityRaider> set1 = iterator.next();
            for (EntityRaider raider : set1) {
                BlockPosition blockPos = raider.dv();
                if (raider.dQ() || raider.dV().ai() != this.D.ai() || this.C.j(blockPos) >= 12544.0) {
                    set.add(raider);
                    continue;
                }
                if (raider.af <= 600) continue;
                if (this.D.a(raider.cG()) == null) {
                    set.add(raider);
                }
                if (!this.D.c(blockPos) && raider.et() > 2400) {
                    raider.c(raider.gL() + 1);
                }
                if (raider.gL() < 30) continue;
                set.add(raider);
            }
        }
        for (EntityRaider raider1 : set) {
            this.a(raider1, true);
            if (!raider1.gv()) continue;
            this.c(raider1.gJ());
        }
    }

    private void a(BlockPosition pos) {
        float f2 = 13.0f;
        int i2 = 64;
        Collection<EntityPlayer> players = this.K.g();
        long randomLong = this.N.g();
        for (EntityPlayer serverPlayer : this.D.z()) {
            Vec3D vec3 = serverPlayer.dt();
            Vec3D vec31 = Vec3D.b(pos);
            double squareRoot = Math.sqrt((vec31.d - vec3.d) * (vec31.d - vec3.d) + (vec31.f - vec3.f) * (vec31.f - vec3.f));
            double d2 = vec3.d + 13.0 / squareRoot * (vec31.d - vec3.d);
            double d1 = vec3.f + 13.0 / squareRoot * (vec31.f - vec3.f);
            if (!(squareRoot <= 64.0) && !players.contains(serverPlayer)) continue;
            serverPlayer.f.b(new PacketPlayOutNamedSoundEffect(SoundEffects.vC, SoundCategory.g, d2, serverPlayer.dC(), d1, 64.0f, 1.0f, randomLong));
        }
    }

    private void b(BlockPosition pos) {
        int i2;
        boolean flag = false;
        int wave = i2 = this.J + 1;
        this.G = 0.0f;
        DifficultyDamageScaler currentDifficultyAt = this.D.d_(pos);
        boolean shouldSpawnBonusGroup = this.E();
        for (Wave raiderType : Wave.f) {
            EntityRaider raider;
            int i1 = this.a(raiderType, i2, shouldSpawnBonusGroup) + this.a(raiderType, this.N, i2, currentDifficultyAt, shouldSpawnBonusGroup);
            int i22 = 0;
            for (int i3 = 0; i3 < i1 && (raider = raiderType.g.a(this.D, EntitySpawnReason.h)) != null; ++i3) {
                if (!flag && raider.gs()) {
                    raider.x(true);
                    this.a(i2, raider);
                    flag = true;
                }
                this.a(i2, raider, pos, false);
                if (raiderType.g != EntityTypes.aY) continue;
                EntityRaider raider1 = null;
                if (i2 == this.a(EnumDifficulty.c)) {
                    raider1 = EntityTypes.aT.a(this.D, EntitySpawnReason.h);
                } else if (i2 >= this.a(EnumDifficulty.d)) {
                    raider1 = i22 == 0 ? (EntityRaider)EntityTypes.S.a(this.D, EntitySpawnReason.h) : (EntityRaider)EntityTypes.bD.a(this.D, EntitySpawnReason.h);
                }
                ++i22;
                if (raider1 == null) continue;
                this.a(i2, raider1, pos, false);
                raider1.a(pos, 0.0f, 0.0f);
                raider1.n(raider);
            }
        }
        this.R = Optional.empty();
        ++this.J;
        this.p();
        this.H();
        CraftEventFactory.callRaidSpawnWaveEvent(this, Objects.requireNonNull(this.b(wave)), this.z.get(wave));
    }

    public void a(int wave, EntityRaider raider, @Nullable BlockPosition pos, boolean isRecruited) {
        boolean flag = this.b(wave, raider);
        if (flag) {
            raider.a(this);
            raider.b(wave);
            raider.A(true);
            raider.c(0);
            if (!isRecruited && pos != null) {
                raider.a_((double)pos.u() + 0.5, (double)pos.v() + 1.0, (double)pos.w() + 0.5);
                raider.a((WorldAccess)this.D, this.D.d_(pos), EntitySpawnReason.h, null);
                raider.a(this.D, wave, false);
                raider.d(true);
                this.D.addFreshEntityWithPassengers(raider, CreatureSpawnEvent.SpawnReason.RAID);
            }
        }
    }

    public void p() {
        this.K.a(MathHelper.a(this.q() / this.G, 0.0f, 1.0f));
    }

    public float q() {
        float f2 = 0.0f;
        for (Set<EntityRaider> set : this.z.values()) {
            for (EntityRaider raider : set) {
                f2 += raider.eD();
            }
        }
        return f2;
    }

    private boolean G() {
        return this.M == 0 && (this.J < this.O || this.E()) && this.r() == 0;
    }

    public int r() {
        return this.z.values().stream().mapToInt(Set::size).sum();
    }

    public void a(EntityRaider raider, boolean wanderedOutOfRaid) {
        boolean flag;
        Set<EntityRaider> set = this.z.get(raider.gJ());
        if (set != null && (flag = set.remove(raider))) {
            if (wanderedOutOfRaid) {
                this.G -= raider.eD();
            }
            raider.a((Raid)null);
            this.p();
            this.H();
        }
    }

    private void H() {
        this.D.B().c();
    }

    public static ItemStack a(HolderGetter<EnumBannerPatternType> patternRegistry) {
        ItemStack itemStack = new ItemStack(Items.vP);
        BannerPatternLayers bannerPatternLayers = new BannerPatternLayers.a().a(patternRegistry, BannerPatterns.z, EnumColor.j).a(patternRegistry, BannerPatterns.f, EnumColor.i).a(patternRegistry, BannerPatterns.j, EnumColor.h).a(patternRegistry, BannerPatterns.E, EnumColor.i).a(patternRegistry, BannerPatterns.k, EnumColor.p).a(patternRegistry, BannerPatterns.B, EnumColor.i).a(patternRegistry, BannerPatterns.y, EnumColor.i).a(patternRegistry, BannerPatterns.E, EnumColor.p).a();
        itemStack.b(DataComponents.ai, bannerPatternLayers);
        itemStack.b(DataComponents.q, Unit.a);
        itemStack.b(DataComponents.h, n);
        itemStack.b(DataComponents.k, EnumItemRarity.b);
        return itemStack;
    }

    @Nullable
    public EntityRaider b(int wave) {
        return this.y.get(wave);
    }

    @Nullable
    private BlockPosition d(int attempts) {
        int i2 = this.M / 20;
        float f2 = 0.22f * (float)i2 - 0.24f;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        float f1 = this.D.A.i() * ((float)Math.PI * 2);
        for (int i1 = 0; i1 < attempts; ++i1) {
            int i3;
            float f22 = f1 + (float)Math.PI * (float)i1 / 8.0f;
            int i22 = this.C.u() + MathHelper.d(MathHelper.b(f22) * 32.0f * f2) + this.D.A.a(3) * MathHelper.d(f2);
            int height = this.D.a(HeightMap.Type.b, i22, i3 = this.C.w() + MathHelper.d(MathHelper.a(f22) * 32.0f * f2) + this.D.A.a(3) * MathHelper.d(f2));
            if (MathHelper.a(height - this.C.v()) > 96) continue;
            mutableBlockPos.d(i22, height, i3);
            if (this.D.c(mutableBlockPos) && i2 > 7) continue;
            int i4 = 10;
            if (!this.D.b(mutableBlockPos.u() - 10, mutableBlockPos.w() - 10, mutableBlockPos.u() + 10, mutableBlockPos.w() + 10) || !this.D.f(mutableBlockPos) || !a.isSpawnPositionOk(this.D, mutableBlockPos, EntityTypes.aY) && (!this.D.a_(mutableBlockPos.e()).a(Blocks.ea) || !this.D.a_(mutableBlockPos).l())) continue;
            return mutableBlockPos;
        }
        return null;
    }

    private boolean b(int wave, EntityRaider raider) {
        return this.a(wave, raider, true);
    }

    public boolean a(int wave, EntityRaider raider, boolean isRecruited) {
        this.z.computeIfAbsent(wave, integer -> Sets.newHashSet());
        Set<EntityRaider> set = this.z.get(wave);
        EntityRaider raider1 = null;
        for (EntityRaider raider2 : set) {
            if (!raider2.cG().equals(raider.cG())) continue;
            raider1 = raider2;
            break;
        }
        if (raider1 != null) {
            set.remove(raider1);
            set.add(raider);
        }
        set.add(raider);
        if (isRecruited) {
            this.G += raider.eD();
        }
        this.p();
        this.H();
        return true;
    }

    public void a(int wave, EntityRaider raider) {
        this.y.put(wave, raider);
        raider.a(EnumItemSlot.f, Raid.a(raider.dX().e(Registries.d)));
        raider.a(EnumItemSlot.f, 2.0f);
    }

    public void c(int wave) {
        this.y.remove(wave);
    }

    public BlockPosition s() {
        return this.C;
    }

    private void c(BlockPosition center) {
        this.C = center;
    }

    public int t() {
        return this.F;
    }

    private int a(Wave raiderType, int wave, boolean shouldSpawnBonusGroup) {
        return shouldSpawnBonusGroup ? raiderType.h[this.O] : raiderType.h[wave];
    }

    private int a(Wave raiderType, RandomSource random, int wave, DifficultyDamageScaler difficulty, boolean shouldSpawnBonusGroup) {
        int i2;
        EnumDifficulty difficulty1 = difficulty.a();
        boolean flag = difficulty1 == EnumDifficulty.b;
        boolean flag1 = difficulty1 == EnumDifficulty.c;
        switch (raiderType.ordinal()) {
            case 0: 
            case 2: {
                if (flag) {
                    i2 = random.a(2);
                    break;
                }
                if (flag1) {
                    i2 = 1;
                    break;
                }
                i2 = 2;
                break;
            }
            default: {
                return 0;
            }
            case 3: {
                if (flag || wave <= 2 || wave == 4) {
                    return 0;
                }
                i2 = 1;
                break;
            }
            case 4: {
                i2 = !flag && shouldSpawnBonusGroup ? 1 : 0;
            }
        }
        return i2 > 0 ? random.a(i2 + 1) : 0;
    }

    public boolean u() {
        return this.I;
    }

    public NBTTagCompound a(NBTTagCompound compound) {
        compound.a("Id", this.F);
        compound.a("Started", this.E);
        compound.a("Active", this.I);
        compound.a("TicksActive", this.B);
        compound.a("BadOmenLevel", this.H);
        compound.a("GroupsSpawned", this.J);
        compound.a("PreRaidTicks", this.M);
        compound.a("PostRaidTicks", this.L);
        compound.a("TotalHealth", this.G);
        compound.a("NumGroups", this.O);
        compound.a("Status", this.P.a());
        compound.a("CX", this.C.u());
        compound.a("CY", this.C.v());
        compound.a("CZ", this.C.w());
        NBTTagList listTag = new NBTTagList();
        for (UUID uuid : this.A) {
            listTag.add(GameProfileSerializer.a(uuid));
        }
        compound.a("HeroesOfTheVillage", listTag);
        if (!this.persistentDataContainer.isEmpty()) {
            compound.a(PDC_NBT_KEY, this.persistentDataContainer.toTagCompound());
        }
        return compound;
    }

    public int a(EnumDifficulty difficulty) {
        switch (difficulty) {
            case b: {
                return 3;
            }
            case c: {
                return 5;
            }
            case d: {
                return 7;
            }
        }
        return 0;
    }

    public float v() {
        int raidOmenLevel = this.m();
        if (raidOmenLevel == 2) {
            return 0.1f;
        }
        if (raidOmenLevel == 3) {
            return 0.25f;
        }
        if (raidOmenLevel == 4) {
            return 0.5f;
        }
        return raidOmenLevel == 5 ? 0.75f : 0.0f;
    }

    public void a(Entity player) {
        this.A.add(player.cG());
    }

    public Collection<EntityRaider> getRaiders() {
        return this.z.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status a = new Status();
        public static final /* enum */ Status b = new Status();
        public static final /* enum */ Status c = new Status();
        public static final /* enum */ Status d = new Status();
        private static final Status[] e;
        private static final /* synthetic */ Status[] f;

        public static Status[] values() {
            return (Status[])f.clone();
        }

        public static Status valueOf(String name) {
            return Enum.valueOf(Status.class, name);
        }

        static Status a(String name) {
            for (Status raidStatus : e) {
                if (!name.equalsIgnoreCase(raidStatus.name())) continue;
                return raidStatus;
            }
            return a;
        }

        public String a() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        private static /* synthetic */ Status[] b() {
            return new Status[]{a, b, c, d};
        }

        static {
            f = Status.b();
            e = Status.values();
        }
    }

    static final class Wave
    extends Enum<Wave> {
        public static final /* enum */ Wave a = new Wave(EntityTypes.bD, new int[]{0, 0, 2, 0, 1, 4, 2, 5});
        public static final /* enum */ Wave b = new Wave(EntityTypes.S, new int[]{0, 0, 0, 0, 0, 1, 1, 2});
        public static final /* enum */ Wave c = new Wave(EntityTypes.aT, new int[]{0, 4, 3, 3, 4, 4, 4, 2});
        public static final /* enum */ Wave d = new Wave(EntityTypes.bH, new int[]{0, 0, 0, 0, 3, 0, 0, 1});
        public static final /* enum */ Wave e = new Wave(EntityTypes.aY, new int[]{0, 0, 0, 1, 0, 1, 0, 2});
        static final Wave[] f;
        final EntityTypes<? extends EntityRaider> g;
        final int[] h;
        private static final /* synthetic */ Wave[] i;

        public static Wave[] values() {
            return (Wave[])i.clone();
        }

        public static Wave valueOf(String name) {
            return Enum.valueOf(Wave.class, name);
        }

        private Wave(EntityTypes<? extends EntityRaider> entityType, int[] spawnsPerWaveBeforeBonus) {
            this.g = entityType;
            this.h = spawnsPerWaveBeforeBonus;
        }

        private static /* synthetic */ Wave[] a() {
            return new Wave[]{a, b, c, d, e};
        }

        static {
            i = Wave.a();
            f = Wave.values();
        }
    }
}

