/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;

public class PersistentRaid
extends PersistentBase {
    private static final String a = "raids";
    public final Map<Integer, Raid> b = Maps.newHashMap();
    private final WorldServer c;
    private int d;
    private int e;

    public static PersistentBase.a<PersistentRaid> a(WorldServer level) {
        return new PersistentBase.a<PersistentRaid>(() -> new PersistentRaid(level), (compoundTag, provider) -> PersistentRaid.a(level, compoundTag), DataFixTypes.l);
    }

    public PersistentRaid(WorldServer level) {
        this.c = level;
        this.d = 1;
        this.c();
    }

    public Raid a(int id) {
        return this.b.get(id);
    }

    public void a() {
        ++this.e;
        Iterator<Raid> iterator = this.b.values().iterator();
        while (iterator.hasNext()) {
            Raid raid = iterator.next();
            if (this.c.O().b(GameRules.C)) {
                raid.n();
            }
            if (raid.d()) {
                iterator.remove();
                this.c();
                continue;
            }
            raid.o();
        }
        if (this.e % 200 == 0) {
            this.c();
        }
        PacketDebug.a(this.c, this.b.values());
    }

    public static boolean a(EntityRaider raider, Raid raid) {
        return raider != null && raid != null && raid.i() != null && raider.bL() && raider.gE() && raider.et() <= 2400 && raider.dV().G_() == raid.i().G_();
    }

    @Nullable
    public Raid a(EntityPlayer player, BlockPosition pos) {
        BlockPosition blockPos;
        if (player.Z_()) {
            return null;
        }
        if (this.c.O().b(GameRules.C)) {
            return null;
        }
        DimensionManager dimensionType = player.dV().G_();
        if (!dimensionType.c()) {
            return null;
        }
        List<VillagePlaceRecord> list = this.c.A().c(holder -> holder.a(PoiTypeTags.b), pos, 64, VillagePlace.Occupancy.b).toList();
        int i2 = 0;
        Vec3D vec3 = Vec3D.c;
        for (VillagePlaceRecord poiRecord : list) {
            BlockPosition pos1 = poiRecord.g();
            vec3 = vec3.b(pos1.u(), pos1.v(), pos1.w());
            ++i2;
        }
        if (i2 > 0) {
            vec3 = vec3.c(1.0 / (double)i2);
            blockPos = BlockPosition.a(vec3);
        } else {
            blockPos = pos;
        }
        Raid raid = this.a(player.y(), blockPos);
        if (!raid.j() || raid.isInProgress() && raid.m() < raid.l()) {
            if (!CraftEventFactory.callRaidTriggerEvent(raid, player)) {
                player.e(MobEffects.I);
                return null;
            }
            if (!raid.j() && !this.b.containsKey(raid.t())) {
                this.b.put(raid.t(), raid);
            }
            raid.a(player);
        }
        this.c();
        return raid;
    }

    private Raid a(WorldServer serverLevel, BlockPosition pos) {
        Raid raidAt = serverLevel.d(pos);
        return raidAt != null ? raidAt : new Raid(this.b(), serverLevel, pos);
    }

    public static PersistentRaid a(WorldServer level, NBTTagCompound tag) {
        PersistentRaid raids = new PersistentRaid(level);
        raids.d = tag.h("NextAvailableID");
        raids.e = tag.h("Tick");
        NBTTagList list = tag.c("Raids", 10);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            NBTTagCompound compound = list.a(i2);
            Raid raid = new Raid(level, compound);
            raids.b.put(raid.t(), raid);
        }
        return raids;
    }

    @Override
    public NBTTagCompound a(NBTTagCompound tag, HolderLookup.a registries) {
        tag.a("NextAvailableID", this.d);
        tag.a("Tick", this.e);
        NBTTagList listTag = new NBTTagList();
        for (Raid raid : this.b.values()) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            raid.a(compoundTag);
            listTag.add(compoundTag);
        }
        tag.a("Raids", listTag);
        return tag;
    }

    public static String a(Holder<DimensionManager> dimensionTypeHolder) {
        return dimensionTypeHolder.a(BuiltinDimensionTypes.c) ? "raids_end" : a;
    }

    private int b() {
        return ++this.d;
    }

    @Nullable
    public Raid a(BlockPosition pos, int distance) {
        Raid raid = null;
        double d2 = distance;
        for (Raid raid1 : this.b.values()) {
            double d1 = raid1.s().j(pos);
            if (!raid1.u() || !(d1 < d2)) continue;
            raid = raid1;
            d2 = d1;
        }
        return raid;
    }
}

