/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRaid;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public abstract class EntityRaider
extends EntityMonsterPatrolling {
    protected static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityRaider.class, DataWatcherRegistry.k);
    static final Predicate<EntityItem> a = item -> !item.v() && item.bL() && ItemStack.a(item.l(), Raid.a(item.dX().e(Registries.d)));
    @Nullable
    protected Raid d;
    private int b;
    private boolean bY;
    private int bZ;

    protected EntityRaider(EntityTypes<? extends EntityRaider> entityType, World level) {
        super((EntityTypes<? extends EntityMonsterPatrolling>)entityType, level);
    }

    @Override
    protected void E() {
        super.E();
        this.bS.a(1, new b(this, this));
        this.bS.a(3, new PathfinderGoalRaid<EntityRaider>(this));
        this.bS.a(4, new d(this, 1.05f, 1));
        this.bS.a(5, new c(this));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, false);
    }

    public abstract void a(WorldServer var1, int var2, boolean var3);

    public boolean gE() {
        return this.bY;
    }

    public void A(boolean canJoinRaid) {
        this.bY = canJoinRaid;
    }

    @Override
    public void d_() {
        if (this.dV() instanceof WorldServer && this.bL()) {
            Raid currentRaid = this.gF();
            if (this.gE()) {
                if (currentRaid == null) {
                    Raid raidAt;
                    if (this.dV().ad() % 20L == 0L && (raidAt = ((WorldServer)this.dV()).d(this.dv())) != null && PersistentRaid.a(this, raidAt)) {
                        raidAt.a(raidAt.k(), this, null, true);
                    }
                } else {
                    EntityLiving target = this.O_();
                    if (target != null && (target.aq() == EntityTypes.bR || target.aq() == EntityTypes.ap)) {
                        this.bf = 0;
                    }
                }
            }
        }
        super.d_();
    }

    @Override
    protected void gw() {
        this.bf += 2;
    }

    @Override
    public void a(DamageSource cause) {
        if (this.dV() instanceof WorldServer) {
            Entity entity = cause.d();
            Raid currentRaid = this.gF();
            if (currentRaid != null) {
                if (this.gv()) {
                    currentRaid.c(this.gJ());
                }
                if (entity != null && entity.aq() == EntityTypes.bR) {
                    currentRaid.a(entity);
                }
                currentRaid.a(this, false);
            }
        }
        super.a(cause);
    }

    @Override
    public boolean gy() {
        return !this.gI();
    }

    public void a(@Nullable Raid raid) {
        this.d = raid;
    }

    @Nullable
    public Raid gF() {
        return this.d;
    }

    public boolean gG() {
        ItemStack itemBySlot = this.a(EnumItemSlot.f);
        boolean flag = !itemBySlot.f() && ItemStack.a(itemBySlot, Raid.a(this.dX().e(Registries.d)));
        boolean isPatrolLeader = this.gv();
        return flag && isPatrolLeader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean gH() {
        World world = this.dV();
        if (!(world instanceof WorldServer)) return false;
        WorldServer serverLevel = (WorldServer)world;
        if (this.gF() != null) return true;
        if (serverLevel.d(this.dv()) == null) return false;
        return true;
    }

    public boolean gI() {
        return this.gF() != null && this.gF().u();
    }

    public void b(int wave) {
        this.b = wave;
    }

    public int gJ() {
        return this.b;
    }

    public boolean gK() {
        return this.al.a(c);
    }

    public void B(boolean celebrating) {
        this.al.a(c, celebrating);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Wave", this.b);
        compound.a("CanJoinRaid", this.bY);
        if (this.d != null) {
            compound.a("RaidId", this.d.t());
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.b = compound.h("Wave");
        this.bY = compound.q("CanJoinRaid");
        if (compound.b("RaidId", 3)) {
            if (this.dV() instanceof WorldServer) {
                this.d = ((WorldServer)this.dV()).B().a(compound.h("RaidId"));
            }
            if (this.d != null) {
                this.d.a(this.b, this, false);
                if (this.gv()) {
                    this.d.a(this.b, this);
                }
            }
        }
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        boolean flag;
        ItemStack item = entity.l();
        boolean bl = flag = this.gI() && this.gF().b(this.gJ()) != null;
        if (this.gI() && !flag && ItemStack.a(item, Raid.a(this.dX().e(Registries.d)))) {
            if (CraftEventFactory.callEntityPickupItemEvent(this, entity, 0, false).isCancelled()) {
                return;
            }
            EnumItemSlot equipmentSlot = EnumItemSlot.f;
            ItemStack itemBySlot = this.a(equipmentSlot);
            double d2 = this.h(equipmentSlot);
            if (!itemBySlot.f() && (double)Math.max(this.ae.i() - 0.1f, 0.0f) < d2) {
                this.forceDrops = true;
                this.a(level, itemBySlot);
                this.forceDrops = false;
            }
            this.a(entity);
            this.a(equipmentSlot, item);
            this.a((Entity)entity, item.M());
            entity.discard(EntityRemoveEvent.Cause.PICKUP);
            this.gF().a(this.gJ(), this);
            this.x(true);
        } else {
            super.a(level, entity);
        }
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return this.gF() == null && super.h(distanceToClosestPlayer);
    }

    @Override
    public boolean aa() {
        return super.aa() || this.gF() != null;
    }

    public int gL() {
        return this.bZ;
    }

    public void c(int ticksOutsideRaid) {
        this.bZ = ticksOutsideRaid;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.gI()) {
            this.gF().p();
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.A(this.aq() != EntityTypes.bH || spawnReason != EntitySpawnReason.a);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public abstract SoundEffect aj_();

    public static class b<T extends EntityRaider>
    extends PathfinderGoal {
        private final T b;
        private Int2LongOpenHashMap c = new Int2LongOpenHashMap();
        @Nullable
        private PathEntity d;
        @Nullable
        private EntityItem e;
        final /* synthetic */ EntityRaider a;

        public b(T mob) {
            this.a = this$0;
            this.b = mob;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (this.h()) {
                return false;
            }
            Int2LongOpenHashMap map = new Int2LongOpenHashMap();
            double attributeValue = this.a.h(GenericAttributes.m);
            for (EntityItem itemEntity : ((Entity)this.b).dV().a(EntityItem.class, ((Entity)this.b).cR().c(attributeValue, 8.0, attributeValue), a)) {
                long orDefault = this.c.getOrDefault(itemEntity.ar(), Long.MIN_VALUE);
                if (this.a.dV().ad() < orDefault) {
                    map.put(itemEntity.ar(), orDefault);
                    continue;
                }
                PathEntity path = ((EntityInsentient)this.b).P().a((Entity)itemEntity, 1);
                if (path != null && path.j()) {
                    this.d = path;
                    this.e = itemEntity;
                    return true;
                }
                map.put(itemEntity.ar(), this.a.dV().ad() + 600L);
            }
            this.c = map;
            return false;
        }

        @Override
        public boolean c() {
            return this.e != null && this.d != null && !this.e.dQ() && !this.d.c() && !this.h();
        }

        private boolean h() {
            if (!net.minecraft.world.entity.raid.EntityRaider$b.a(this.b).O().b(GameRules.c) || !((EntityInsentient)this.b).fN()) {
                return false;
            }
            if (!((EntityRaider)this.b).gI()) {
                return true;
            }
            if (((EntityRaider)this.b).gF().a()) {
                return true;
            }
            if (!((EntityMonsterPatrolling)this.b).gs()) {
                return true;
            }
            if (ItemStack.a(((EntityInsentient)this.b).a(EnumItemSlot.f), Raid.a(((Entity)this.b).dX().e(Registries.d)))) {
                return true;
            }
            EntityRaider leader = this.a.d.b(((EntityRaider)this.b).gJ());
            return leader != null && leader.bL();
        }

        @Override
        public void d() {
            ((EntityInsentient)this.b).P().a(this.d, (double)1.15f);
        }

        @Override
        public void e() {
            this.d = null;
            this.e = null;
        }

        @Override
        public void a() {
            if (this.e != null && this.e.a((Entity)this.b, 1.414)) {
                ((EntityRaider)this.b).a(net.minecraft.world.entity.raid.EntityRaider$b.a(this.a.dV()), this.e);
            }
        }
    }

    static class d
    extends PathfinderGoal {
        private final EntityRaider a;
        private final double b;
        private BlockPosition c;
        private final List<BlockPosition> d = Lists.newArrayList();
        private final int e;
        private boolean f;

        public d(EntityRaider raider, double speedModifier, int distanceToPoi) {
            this.a = raider;
            this.b = speedModifier;
            this.e = distanceToPoi;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            this.k();
            return this.h() && this.i() && this.a.O_() == null;
        }

        private boolean h() {
            return this.a.gI() && !this.a.gF().a();
        }

        private boolean i() {
            WorldServer serverLevel = (WorldServer)this.a.dV();
            BlockPosition blockPos = this.a.dv();
            Optional<BlockPosition> random = serverLevel.A().a(poi -> poi.a(PoiTypes.n), this::a, VillagePlace.Occupancy.c, blockPos, 48, this.a.ae);
            if (random.isEmpty()) {
                return false;
            }
            this.c = random.get().j();
            return true;
        }

        @Override
        public boolean c() {
            return !this.a.P().k() && this.a.O_() == null && !this.c.a(this.a.dt(), (double)(this.a.dq() + (float)this.e)) && !this.f;
        }

        @Override
        public void e() {
            if (this.c.a(this.a.dt(), (double)this.e)) {
                this.d.add(this.c);
            }
        }

        @Override
        public void d() {
            super.d();
            this.a.n(0);
            this.a.P().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), this.b);
            this.f = false;
        }

        @Override
        public void a() {
            if (this.a.P().k()) {
                Vec3D vec3 = Vec3D.c(this.c);
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 7, vec3, 0.3141592741012573);
                if (posTowards == null) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3, 1.5707963705062866);
                }
                if (posTowards == null) {
                    this.f = true;
                    return;
                }
                this.a.P().a(posTowards.d, posTowards.e, posTowards.f, this.b);
            }
        }

        private boolean a(BlockPosition pos) {
            for (BlockPosition blockPos : this.d) {
                if (!Objects.equals(pos, blockPos)) continue;
                return false;
            }
            return true;
        }

        private void k() {
            if (this.d.size() > 2) {
                this.d.remove(0);
            }
        }
    }

    public class c
    extends PathfinderGoal {
        private final EntityRaider b;

        c(EntityRaider mob) {
            this.b = mob;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            Raid currentRaid = this.b.gF();
            return this.b.bL() && this.b.O_() == null && currentRaid != null && currentRaid.f();
        }

        @Override
        public void d() {
            this.b.B(true);
            super.d();
        }

        @Override
        public void e() {
            this.b.B(false);
            super.e();
        }

        @Override
        public void a() {
            if (!this.b.bb() && this.b.ae.a(this.a(100)) == 0) {
                EntityRaider.this.b(EntityRaider.this.aj_());
            }
            if (!this.b.bZ() && this.b.ae.a(this.a(50)) == 0) {
                this.b.O().a();
            }
            super.a();
        }
    }

    public static class a
    extends PathfinderGoal {
        private final EntityRaider b;
        private final float c;
        public final PathfinderTargetCondition a = PathfinderTargetCondition.b().a(8.0).d().e();

        public a(EntityIllagerAbstract mob, float radius) {
            this.b = mob;
            this.c = radius * radius;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving lastHurtByMob = this.b.ep();
            return this.b.gF() == null && this.b.gA() && this.b.O_() != null && !this.b.gh() && (lastHurtByMob == null || lastHurtByMob.aq() != EntityTypes.bR);
        }

        @Override
        public void d() {
            super.d();
            this.b.P().m();
            for (EntityRaider raider : net.minecraft.world.entity.raid.EntityRaider$a.a(this.b).a(EntityRaider.class, this.a, this.b, this.b.cR().c(8.0, 8.0, 8.0))) {
                raider.setTarget(this.b.O_(), EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
            }
        }

        @Override
        public void e() {
            super.e();
            EntityLiving target = this.b.O_();
            if (target != null) {
                for (EntityRaider raider : net.minecraft.world.entity.raid.EntityRaider$a.a(this.b).a(EntityRaider.class, this.a, this.b, this.b.cR().c(8.0, 8.0, 8.0))) {
                    raider.setTarget(target, EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
                    raider.w(true);
                }
                this.b.w(true);
            }
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = this.b.O_();
            if (target != null) {
                if (this.b.g((Entity)target) > (double)this.c) {
                    this.b.L().a(target, 30.0f, 30.0f);
                    if (this.b.ae.a(50) == 0) {
                        this.b.U();
                    }
                } else {
                    this.b.w(true);
                }
                super.a();
            }
        }
    }
}

