/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public final class ProjectileHelper {
    private static final float a = 0.3f;

    public static MovingObjectPosition a(Entity projectile, Predicate<Entity> filter) {
        Vec3D deltaMovement = projectile.dy();
        World level = projectile.dV();
        Vec3D vec3 = projectile.dt();
        return ProjectileHelper.a(vec3, projectile, filter, deltaMovement, level, 0.3f, RayTrace.BlockCollisionOption.a);
    }

    public static MovingObjectPosition a(Entity projectile, Predicate<Entity> filter, RayTrace.BlockCollisionOption clipContext) {
        Vec3D deltaMovement = projectile.dy();
        World level = projectile.dV();
        Vec3D vec3 = projectile.dt();
        return ProjectileHelper.a(vec3, projectile, filter, deltaMovement, level, 0.3f, clipContext);
    }

    public static MovingObjectPosition a(Entity projectile, Predicate<Entity> filter, double scale) {
        Vec3D vec3 = projectile.g(0.0f).c(scale);
        World level = projectile.dV();
        Vec3D eyePosition = projectile.bF();
        return ProjectileHelper.a(eyePosition, projectile, filter, vec3, level, 0.0f, RayTrace.BlockCollisionOption.a);
    }

    private static MovingObjectPosition a(Vec3D pos, Entity projectile, Predicate<Entity> filter, Vec3D deltaMovement, World level, float margin, RayTrace.BlockCollisionOption clipContext) {
        MovingObjectPositionEntity entityHitResult;
        Vec3D vec3 = pos.e(deltaMovement);
        MovingObjectPosition hitResult = level.b(new RayTrace(pos, vec3, clipContext, RayTrace.FluidCollisionOption.a, projectile));
        if (((MovingObjectPosition)hitResult).d() != MovingObjectPosition.EnumMovingObjectType.a) {
            vec3 = hitResult.g();
        }
        if ((entityHitResult = ProjectileHelper.a(level, projectile, pos, vec3, projectile.cR().b(deltaMovement).g(1.0), filter, margin)) != null) {
            hitResult = entityHitResult;
        }
        return hitResult;
    }

    @Nullable
    public static MovingObjectPositionEntity a(Entity shooter, Vec3D startVec, Vec3D endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, double distance) {
        World level = shooter.dV();
        double d2 = distance;
        Entity entity = null;
        Vec3D vec3 = null;
        for (Entity entity1 : level.a(shooter, boundingBox, filter)) {
            Vec3D vec31;
            double d1;
            AxisAlignedBB aabb = entity1.cR().g(entity1.bS());
            Optional<Vec3D> optional = aabb.b(startVec, endVec);
            if (aabb.d(startVec)) {
                if (!(d2 >= 0.0)) continue;
                entity = entity1;
                vec3 = optional.orElse(startVec);
                d2 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.g(vec31 = optional.get())) < d2) && d2 != 0.0) continue;
            if (entity1.df() == shooter.df()) {
                if (d2 != 0.0) continue;
                entity = entity1;
                vec3 = vec31;
                continue;
            }
            entity = entity1;
            vec3 = vec31;
            d2 = d1;
        }
        return entity == null ? null : new MovingObjectPositionEntity(entity, vec3);
    }

    @Nullable
    public static MovingObjectPositionEntity a(World level, Entity projectile, Vec3D startVec, Vec3D endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter) {
        return ProjectileHelper.a(level, projectile, startVec, endVec, boundingBox, filter, 0.3f);
    }

    @Nullable
    public static MovingObjectPositionEntity a(World level, Entity projectile, Vec3D startVec, Vec3D endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, float inflationAmount) {
        double d2 = Double.MAX_VALUE;
        Optional<Object> optional = Optional.empty();
        Entity entity = null;
        for (Entity entity1 : level.a(projectile, boundingBox, filter)) {
            double d1;
            AxisAlignedBB aabb = entity1.cR().g(inflationAmount);
            Optional<Vec3D> optional1 = aabb.b(startVec, endVec);
            if (!optional1.isPresent() || !((d1 = startVec.g(optional1.get())) < d2)) continue;
            entity = entity1;
            d2 = d1;
            optional = optional1;
        }
        return entity == null ? null : new MovingObjectPositionEntity(entity, (Vec3D)optional.get());
    }

    public static void a(Entity projectile, float rotationSpeed) {
        Vec3D deltaMovement = projectile.dy();
        if (deltaMovement.h() != 0.0) {
            double d2 = deltaMovement.i();
            projectile.v((float)(MathHelper.d(deltaMovement.f, deltaMovement.d) * 180.0 / 3.1415927410125732) + 90.0f);
            projectile.w((float)(MathHelper.d(d2, deltaMovement.e) * 180.0 / 3.1415927410125732) - 90.0f);
            while (projectile.dN() - projectile.O < -180.0f) {
                projectile.O -= 360.0f;
            }
            while (projectile.dN() - projectile.O >= 180.0f) {
                projectile.O += 360.0f;
            }
            while (projectile.dL() - projectile.N < -180.0f) {
                projectile.N -= 360.0f;
            }
            while (projectile.dL() - projectile.N >= 180.0f) {
                projectile.N += 360.0f;
            }
            projectile.w(MathHelper.h(rotationSpeed, projectile.O, projectile.dN()));
            projectile.v(MathHelper.h(rotationSpeed, projectile.N, projectile.dL()));
        }
    }

    public static EnumHand a(EntityLiving shooter, Item weapon) {
        return shooter.eZ().a(weapon) ? EnumHand.a : EnumHand.b;
    }

    public static EntityArrow a(EntityLiving shooter, ItemStack arrow, float velocity, @Nullable ItemStack weapon) {
        ItemArrow arrowItem = (ItemArrow)(arrow.h() instanceof ItemArrow ? arrow.h() : Items.pb);
        EntityArrow abstractArrow = arrowItem.a(shooter.dV(), arrow, shooter, weapon);
        abstractArrow.a(velocity);
        return abstractArrow;
    }
}

