/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    @Nullable
    public UUID a;
    @Nullable
    public Entity b;
    public boolean c;
    public boolean d;
    @Nullable
    private Entity e;
    protected boolean hitCancelled = false;

    IProjectile(EntityTypes<? extends IProjectile> entityType, World level) {
        super(entityType, level);
    }

    public void c(@Nullable Entity owner) {
        if (owner != null) {
            this.a = owner.cG();
            this.b = owner;
        } else {
            this.a = null;
            this.b = null;
            this.projectileSource = null;
        }
        this.refreshProjectileSource(false);
    }

    public void refreshProjectileSource(boolean fillCache) {
        CraftEntity craftEntity;
        if (fillCache) {
            this.p();
        }
        if (this.b != null && !this.b.dQ() && this.projectileSource == null && (craftEntity = this.b.getBukkitEntity()) instanceof ProjectileSource) {
            ProjectileSource projSource;
            this.projectileSource = projSource = (ProjectileSource)craftEntity;
        }
    }

    @Override
    @Nullable
    public Entity p() {
        if (this.b != null && !this.b.dQ()) {
            this.refreshProjectileSource(false);
            return this.b;
        }
        if (this.a != null) {
            this.b = this.b(this.a);
            this.refreshProjectileSource(false);
            return this.b;
        }
        return null;
    }

    @Nullable
    protected Entity b(UUID entityUuid) {
        Entity entity;
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            entity = serverLevel.a(entityUuid);
        } else {
            entity = null;
        }
        return entity;
    }

    public Entity E() {
        return (Entity)MoreObjects.firstNonNull((Object)this.p(), (Object)this);
    }

    @Override
    protected void b(NBTTagCompound compound) {
        if (this.a != null) {
            compound.a("Owner", this.a);
        }
        if (this.c) {
            compound.a("LeftOwner", true);
        }
        compound.a("HasBeenShot", this.d);
    }

    protected boolean e(Entity entity) {
        return entity.cG().equals(this.a);
    }

    @Override
    protected void a(NBTTagCompound compound) {
        if (compound.b("Owner")) {
            this.c(compound.a("Owner"));
            if (this instanceof EntityEnderPearl && this.dV().paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && this.dV().paperConfig().misc.legacyEnderPearlBehavior) {
                this.a = null;
            }
        }
        this.c = compound.q("LeftOwner");
        this.d = compound.q("HasBeenShot");
    }

    protected void c(UUID uuid) {
        if (this.a != uuid) {
            this.a = uuid;
            this.b = this.b(uuid);
        }
    }

    @Override
    public void x(Entity entity) {
        super.x(entity);
        if (entity instanceof IProjectile) {
            IProjectile projectile = (IProjectile)entity;
            this.a = projectile.a;
            this.b = projectile.b;
        }
    }

    @Override
    public void h() {
        if (!this.d) {
            this.a(GameEvent.K, this.p());
            this.d = true;
        }
        if (!this.c) {
            this.c = this.m();
        }
        super.h();
    }

    private boolean m() {
        Entity owner = this.p();
        if (owner != null) {
            AxisAlignedBB aabb = this.cR().b(this.dy()).g(1.0);
            return owner.df().da().filter(IEntitySelector.h).noneMatch(entity -> aabb.c(entity.cR()));
        }
        return true;
    }

    public Vec3D d(double x2, double y2, double z2, float velocity, float inaccuracy) {
        return new Vec3D(x2, y2, z2).d().b(this.ae.a(0.0, 0.0172275 * (double)inaccuracy), this.ae.a(0.0, 0.0172275 * (double)inaccuracy), this.ae.a(0.0, 0.0172275 * (double)inaccuracy)).c((double)velocity);
    }

    public void c(double x2, double y2, double z2, float velocity, float inaccuracy) {
        Vec3D movementToShoot = this.d(x2, y2, z2, velocity, inaccuracy);
        this.i(movementToShoot);
        this.ar = true;
        double d2 = movementToShoot.i();
        this.v((float)(MathHelper.d(movementToShoot.d, movementToShoot.f) * 180.0 / 3.1415927410125732));
        this.w((float)(MathHelper.d(movementToShoot.e, d2) * 180.0 / 3.1415927410125732));
        this.N = this.dL();
        this.O = this.dN();
    }

    public void a(Entity shooter, float x2, float y2, float z2, float velocity, float inaccuracy) {
        float f2 = -MathHelper.a(y2 * ((float)Math.PI / 180)) * MathHelper.b(x2 * ((float)Math.PI / 180));
        float f1 = -MathHelper.a((x2 + z2) * ((float)Math.PI / 180));
        float f22 = MathHelper.b(y2 * ((float)Math.PI / 180)) * MathHelper.b(x2 * ((float)Math.PI / 180));
        this.c(f2, f1, f22, velocity, inaccuracy);
        Vec3D knownMovement = shooter.ah();
        if (Double.isNaN(knownMovement.d) || Double.isNaN(knownMovement.e) || Double.isNaN(knownMovement.f)) {
            knownMovement = new Vec3D(0.0, 0.0, 0.0);
        }
        if (!shooter.dV().paperConfig().misc.disableRelativeProjectileVelocity) {
            this.i(this.dy().b(knownMovement.d, shooter.aJ() ? 0.0 : knownMovement.e, knownMovement.f));
        }
    }

    public static <T extends IProjectile> T a(a<T> factory, WorldServer level, ItemStack spawnedFrom, EntityLiving owner, float z2, float velocity, float innaccuracy) {
        return IProjectile.spawnProjectileFromRotationDelayed(factory, level, spawnedFrom, owner, z2, velocity, innaccuracy).spawn();
    }

    public static <T extends IProjectile> Delayed<T> spawnProjectileFromRotationDelayed(a<T> factory, WorldServer level, ItemStack spawnedFrom, EntityLiving owner, float z2, float velocity, float innaccuracy) {
        return IProjectile.spawnProjectileDelayed(factory.create(level, owner, spawnedFrom), level, spawnedFrom, projectlie -> projectlie.a(owner, owner.dN(), owner.dL(), z2, velocity, innaccuracy));
    }

    public static <T extends IProjectile> T a(a<T> factory, WorldServer level, ItemStack spawnedFrom, EntityLiving owner, double x2, double y2, double z2, float velocity, float inaccuracy) {
        return (T)IProjectile.a(factory.create(level, owner, spawnedFrom), level, spawnedFrom, projectile -> projectile.c(x2, y2, z2, velocity, inaccuracy));
    }

    public static <T extends IProjectile> T a(T projectile, WorldServer level, ItemStack spawnedFrom, double x2, double y2, double z2, float velocity, float inaccuracy) {
        return IProjectile.spawnProjectileUsingShootDelayed(projectile, level, spawnedFrom, x2, y2, z2, velocity, inaccuracy).spawn();
    }

    public static <T extends IProjectile> Delayed<T> spawnProjectileUsingShootDelayed(T projectile, WorldServer level, ItemStack spawnedFrom, double x2, double y2, double z2, float velocity, float inaccuracy) {
        return IProjectile.spawnProjectileDelayed(projectile, level, spawnedFrom, projectile1 -> projectile.c(x2, y2, z2, velocity, inaccuracy));
    }

    public static <T extends IProjectile> T a(T projectile, WorldServer level, ItemStack spawnedFrom) {
        return (T)IProjectile.a(projectile, level, spawnedFrom, projectile1 -> {});
    }

    public static <T extends IProjectile> T a(T projectile, WorldServer level, ItemStack stack, Consumer<T> adapter) {
        return IProjectile.spawnProjectileDelayed(projectile, level, stack, adapter).spawn();
    }

    public static <T extends IProjectile> Delayed<T> spawnProjectileDelayed(T projectile, WorldServer level, ItemStack stack, Consumer<T> adapter) {
        adapter.accept(projectile);
        return new Delayed<T>(projectile, level, stack);
    }

    public void b(WorldServer level, ItemStack spawnedFrom) {
        EntityArrow abstractArrow;
        ItemStack weaponItem;
        EnchantmentManager.a(level, spawnedFrom, this, (Item item) -> {});
        IProjectile iProjectile = this;
        if (iProjectile instanceof EntityArrow && (weaponItem = (abstractArrow = (EntityArrow)iProjectile).dZ()) != null && !weaponItem.f() && !spawnedFrom.h().equals(weaponItem.h())) {
            EnchantmentManager.a(level, weaponItem, this, abstractArrow::b);
        }
    }

    public ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition hitResult) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, hitResult);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.b || !this.hitCancelled) {
            return this.b(hitResult);
        }
        return ProjectileDeflection.a;
    }

    protected ProjectileDeflection b(MovingObjectPosition hitResult) {
        ProjectileDeflection projectileDeflection1;
        MovingObjectPositionBlock blockHitResult;
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)hitResult;
            Entity entity = entityHitResult.a();
            ProjectileDeflection projectileDeflection = entity.a(this);
            if (projectileDeflection != ProjectileDeflection.a) {
                if (entity != this.e && this.a(projectileDeflection, entity, this.p(), false)) {
                    this.e = entity;
                }
                return projectileDeflection;
            }
        } else if (this.C() && hitResult instanceof MovingObjectPositionBlock && (blockHitResult = (MovingObjectPositionBlock)hitResult).f() && this.a(projectileDeflection1 = ProjectileDeflection.b, null, this.p(), false)) {
            this.i(this.dy().c(0.2));
            return projectileDeflection1;
        }
        this.a(hitResult);
        return ProjectileDeflection.a;
    }

    protected boolean C() {
        return false;
    }

    public boolean a(ProjectileDeflection deflection, @Nullable Entity entity, @Nullable Entity owner, boolean deflectedByPlayer) {
        deflection.deflect(this, entity, this.ae);
        if (!this.dV().C) {
            IProjectile iProjectile = this;
            if (iProjectile instanceof EntityArrow) {
                EntityArrow arrow = (EntityArrow)iProjectile;
                arrow.setOwner(owner, false);
            } else {
                this.c(owner);
            }
            this.b(entity, deflectedByPlayer);
        }
        return true;
    }

    protected void b(@Nullable Entity entity, boolean deflectedByPlayer) {
    }

    protected void b(Item item) {
    }

    protected void a(MovingObjectPosition result) {
        MovingObjectPosition.EnumMovingObjectType type = result.d();
        if (type == MovingObjectPosition.EnumMovingObjectType.c) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)result;
            Entity entity = entityHitResult.a();
            if (entity.aq().a(TagsEntity.H) && entity instanceof IProjectile) {
                IProjectile projectile = (IProjectile)entity;
                projectile.a(ProjectileDeflection.c, this.p(), this.p(), true);
            }
            this.a(entityHitResult);
            this.dV().a(GameEvent.J, result.g(), GameEvent.a.a(this, null));
        } else if (type == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock blockHitResult = (MovingObjectPositionBlock)result;
            this.a(blockHitResult);
            BlockPosition blockPos = blockHitResult.b();
            this.dV().a(GameEvent.J, blockPos, GameEvent.a.a(this, this.dV().a_(blockPos)));
        }
    }

    protected void a(MovingObjectPositionEntity result) {
    }

    protected void a(MovingObjectPositionBlock result) {
        if (this.hitCancelled) {
            return;
        }
        IBlockData blockState = this.dV().a_(result.b());
        blockState.a(this.dV(), blockState, result, this);
    }

    public boolean canHitEntityPublic(Entity target) {
        return this.b(target);
    }

    protected boolean b(Entity target) {
        if (!target.bG()) {
            return false;
        }
        Entity owner = this.p();
        if (owner instanceof EntityPlayer && target instanceof EntityPlayer) {
            Player collided = (Player)target.getBukkitEntity();
            Player shooter = (Player)owner.getBukkitEntity();
            if (!shooter.canSee(collided)) {
                return false;
            }
        }
        return owner == null || this.c || !owner.z(target);
    }

    protected void F() {
        Vec3D deltaMovement = this.dy();
        double d2 = deltaMovement.i();
        this.w(IProjectile.f(this.O, (float)(MathHelper.d(deltaMovement.e, d2) * 180.0 / 3.1415927410125732)));
        this.v(IProjectile.f(this.N, (float)(MathHelper.d(deltaMovement.d, deltaMovement.f) * 180.0 / 3.1415927410125732)));
    }

    protected static float f(float currentRotation, float targetRotation) {
        currentRotation += (float)Math.round((targetRotation - currentRotation) / 360.0f) * 360.0f;
        return MathHelper.h(0.2f, currentRotation, targetRotation);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        Entity owner = this.p();
        return new PacketPlayOutSpawnEntity((Entity)this, entity, owner == null ? 0 : owner.ar());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        Vec3D vec3 = new Vec3D(packet.j(), packet.k(), packet.l());
        this.i(vec3);
        Entity entity = this.dV().a(packet.p());
        if (entity != null) {
            this.c(entity);
        }
    }

    @Override
    public boolean c(WorldServer level, BlockPosition pos) {
        Entity owner = this.p();
        return owner instanceof EntityHuman ? owner.c(level, pos) : owner == null || level.O().b(GameRules.c);
    }

    public boolean a(WorldServer level) {
        return this.aq().a(TagsEntity.g) && level.O().b(GameRules.g);
    }

    @Override
    public boolean bH() {
        return this.aq().a(TagsEntity.H);
    }

    @Override
    public float bS() {
        return this.bH() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair a_(EntityLiving entity, DamageSource damageSource) {
        double d2 = this.dy().d;
        double d1 = this.dy().f;
        return DoubleDoubleImmutablePair.of((double)d2, (double)d1);
    }

    @Override
    public int bX() {
        return 2;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!this.d(damageSource)) {
            this.bD();
        }
        return false;
    }

    @FunctionalInterface
    public static interface a<T extends IProjectile> {
        public T create(WorldServer var1, EntityLiving var2, ItemStack var3);
    }

    public record Delayed<T extends IProjectile>(T projectile, WorldServer world, ItemStack projectileStack) {
        public boolean attemptSpawn() {
            if (!this.world.b((Entity)this.projectile)) {
                return false;
            }
            ((IProjectile)this.projectile).b(this.world, this.projectileStack);
            return true;
        }

        public T spawn() {
            this.attemptSpawn();
            return this.projectile();
        }

        public boolean attemptSpawn(CreatureSpawnEvent.SpawnReason reason) {
            if (!this.world.addFreshEntity((Entity)this.projectile, reason)) {
                return false;
            }
            ((IProjectile)this.projectile).b(this.world, this.projectileStack);
            return true;
        }

        public T spawn(CreatureSpawnEvent.SpawnReason reason) {
            this.attemptSpawn(reason);
            return this.projectile();
        }
    }
}

