/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import io.papermc.paper.event.entity.WaterBottleSplashEvent;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class EntityPotion
extends EntityProjectileThrowable {
    public static final double a = 4.0;
    private static final double c = 16.0;
    public static final Predicate<EntityLiving> b = entity -> entity.fr() || entity.bY();
    private static final Predicate<EntityLiving> APPLY_WATER_GET_ENTITIES_PREDICATE = b.or(Axolotl.class::isInstance);

    public EntityPotion(EntityTypes<? extends EntityPotion> entityType, World level) {
        super((EntityTypes<? extends EntityProjectileThrowable>)entityType, level);
    }

    public EntityPotion(World level, EntityLiving owner, ItemStack item) {
        super(EntityTypes.aV, owner, level, item);
    }

    public EntityPotion(World level, double x2, double y2, double z2, ItemStack item) {
        super(EntityTypes.aV, x2, y2, z2, level, item);
    }

    @Override
    protected Item m() {
        return Items.wo;
    }

    @Override
    protected double bd() {
        return 0.05;
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        super.a(result);
        if (!this.dV().C) {
            ItemStack item = this.l();
            EnumDirection direction = result.c();
            BlockPosition blockPos = result.b();
            BlockPosition blockPos1 = blockPos.a(direction);
            PotionContents potionContents = item.a(DataComponents.Q, PotionContents.a);
            if (potionContents.a(Potions.a)) {
                this.a(blockPos1);
                this.a(blockPos1.a(direction.g()));
                for (EnumDirection direction1 : EnumDirection.EnumDirectionLimit.a) {
                    this.a(blockPos1.a(direction1));
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition result) {
        super.a(result);
        this.splash(result);
    }

    public void splash(@Nullable MovingObjectPosition result) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            ItemStack item = this.l();
            PotionContents potionContents = item.a(DataComponents.Q, PotionContents.a);
            boolean showParticles = true;
            showParticles = potionContents.a(Potions.a) ? this.applyWater(serverLevel, result) : (this.s() ? this.makeAreaOfEffectCloud(potionContents, result) : this.applySplash(serverLevel, potionContents.a(), result != null && result.d() == MovingObjectPosition.EnumMovingObjectType.c ? ((MovingObjectPositionEntity)result).a() : null, result));
            if (showParticles) {
                int i2 = potionContents.e().isPresent() && potionContents.e().get().a().c() ? 2007 : 2002;
                serverLevel.c(i2, this.dv(), potionContents.b());
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    private boolean applyWater(WorldServer level, @Nullable MovingObjectPosition result) {
        AxisAlignedBB aabb = this.cR().c(4.0, 2.0, 4.0);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        HashSet<LivingEntity> rehydrate = new HashSet<LivingEntity>();
        HashSet<LivingEntity> extinguish = new HashSet<LivingEntity>();
        for (EntityLiving livingEntity : this.dV().a(EntityLiving.class, aabb, APPLY_WATER_GET_ENTITIES_PREDICATE)) {
            double d2;
            if (livingEntity instanceof Axolotl) {
                Axolotl axolotl = (Axolotl)livingEntity;
                rehydrate.add((LivingEntity)((org.bukkit.entity.Axolotl)axolotl.getBukkitEntity()));
            }
            if (!((d2 = this.g(livingEntity)) < 16.0)) continue;
            if (livingEntity.fr()) {
                affected.put(livingEntity.getBukkitLivingEntity(), 1.0);
            }
            if (!livingEntity.bY() || !livingEntity.bL()) continue;
            extinguish.add(livingEntity.getBukkitLivingEntity());
        }
        WaterBottleSplashEvent event = CraftEventFactory.callWaterBottleSplashEvent(this, result, affected, rehydrate, extinguish);
        if (!event.isCancelled()) {
            for (LivingEntity affectedEntity : event.getToDamage()) {
                ((CraftLivingEntity)affectedEntity).getHandle().a(level, this.dW().c((Entity)this, this.p()), 1.0f);
            }
            for (LivingEntity toExtinguish : event.getToExtinguish()) {
                ((CraftLivingEntity)toExtinguish).getHandle().aN();
            }
            for (LivingEntity toRehydrate : event.getToRehydrate()) {
                EntityLiving entityLiving = ((CraftLivingEntity)toRehydrate).getHandle();
                if (!(entityLiving instanceof Axolotl)) continue;
                Axolotl axolotl = (Axolotl)entityLiving;
                axolotl.x();
            }
        }
        return !event.isCancelled();
    }

    private boolean applySplash(WorldServer level, Iterable<MobEffect> effects, @Nullable Entity entity, @Nullable MovingObjectPosition result) {
        PotionSplashEvent event;
        AxisAlignedBB aabb = this.cR().c(4.0, 2.0, 4.0);
        List<EntityLiving> entitiesOfClass = level.a(EntityLiving.class, aabb);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        if (!entitiesOfClass.isEmpty()) {
            Entity effectSource = this.E();
            for (EntityLiving livingEntity : entitiesOfClass) {
                double d2;
                if (!livingEntity.fL() || !((d2 = this.g(livingEntity)) < 16.0)) continue;
                double d1 = livingEntity == entity ? 1.0 : 1.0 - Math.sqrt(d2) / 4.0;
                affected.put(livingEntity.getBukkitLivingEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, result, affected)).isCancelled() && !entitiesOfClass.isEmpty()) {
            Entity effectSource = this.E();
            for (LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                CraftLivingEntity craftLivingEntity = (CraftLivingEntity)victim;
                EntityLiving livingEntity = craftLivingEntity.getHandle();
                double d1 = event.getIntensity(victim);
                for (MobEffect mobEffectInstance : effects) {
                    Holder<MobEffectList> effect = mobEffectInstance.c();
                    if (effect.a().a()) {
                        effect.a().a(level, this, this.p(), livingEntity, mobEffectInstance.e(), d1);
                        continue;
                    }
                    int i2 = mobEffectInstance.a(i1 -> (int)(d1 * (double)i1 + 0.5));
                    MobEffect mobEffectInstance1 = new MobEffect(effect, i2, mobEffectInstance.e(), mobEffectInstance.f(), mobEffectInstance.g());
                    if (mobEffectInstance1.a(20)) continue;
                    livingEntity.addEffect(mobEffectInstance1, effectSource, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
        return !event.isCancelled();
    }

    private boolean makeAreaOfEffectCloud(PotionContents potionContents, @Nullable MovingObjectPosition result) {
        EntityAreaEffectCloud areaEffectCloud = new EntityAreaEffectCloud(this.dV(), this.dA(), this.dC(), this.dG());
        Entity entity = this.p();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            areaEffectCloud.a(livingEntity);
        }
        areaEffectCloud.a(3.0f);
        areaEffectCloud.b(-0.5f);
        areaEffectCloud.c(10);
        areaEffectCloud.c(-areaEffectCloud.c() / (float)areaEffectCloud.g());
        areaEffectCloud.a(potionContents);
        boolean noEffects = potionContents.c();
        LingeringPotionSplashEvent event = CraftEventFactory.callLingeringPotionSplashEvent(this, result, areaEffectCloud);
        if (!(event.isCancelled() || areaEffectCloud.dQ() || !event.allowsEmptyCreation() && noEffects && !areaEffectCloud.k.c())) {
            this.dV().b(areaEffectCloud);
        } else {
            areaEffectCloud.discard(null);
        }
        return !event.isCancelled();
    }

    public boolean s() {
        return this.l().a(Items.wr);
    }

    private void a(BlockPosition pos) {
        IBlockData blockState = this.dV().a_(pos);
        if (blockState.a(TagsBlock.aN)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, blockState.y().g())) {
                this.dV().a(pos, false, this);
            }
        } else if (AbstractCandleBlock.c(blockState)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, (IBlockData)blockState.b(AbstractCandleBlock.b, false))) {
                AbstractCandleBlock.a(null, blockState, (GeneratorAccess)this.dV(), pos);
            }
        } else if (BlockCampfire.h(blockState) && CraftEventFactory.callEntityChangeBlockEvent(this, pos, (IBlockData)blockState.b(BlockCampfire.c, false))) {
            this.dV().a(null, 1009, pos, 0);
            BlockCampfire.a(this.p(), (GeneratorAccess)this.dV(), pos, blockState);
            this.dV().b(pos, (IBlockData)blockState.b(BlockCampfire.c, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving entity, DamageSource damageSource) {
        double d2 = entity.dt().d - this.dt().d;
        double d1 = entity.dt().f - this.dt().f;
        return DoubleDoubleImmutablePair.of((double)d2, (double)d1);
    }
}

