/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityLlamaSpit
extends IProjectile {
    public EntityLlamaSpit(EntityTypes<? extends EntityLlamaSpit> entityType, World level) {
        super((EntityTypes<? extends IProjectile>)entityType, level);
    }

    public EntityLlamaSpit(World level, EntityLlama spitter) {
        this((EntityTypes<? extends EntityLlamaSpit>)EntityTypes.ay, level);
        this.c(spitter);
        this.a_(spitter.dA() - (double)(spitter.dq() + 1.0f) * 0.5 * (double)MathHelper.a(spitter.aX * ((float)Math.PI / 180)), spitter.dE() - (double)0.1f, spitter.dG() + (double)(spitter.dq() + 1.0f) * 0.5 * (double)MathHelper.b(spitter.aX * ((float)Math.PI / 180)));
    }

    @Override
    protected double bd() {
        return 0.06;
    }

    @Override
    public void h() {
        super.h();
        Vec3D deltaMovement = this.dy();
        MovingObjectPosition hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b);
        this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
        double d2 = this.dA() + deltaMovement.d;
        double d1 = this.dC() + deltaMovement.e;
        double d22 = this.dG() + deltaMovement.f;
        this.F();
        float f2 = 0.99f;
        if (this.dV().a(this.cR()).noneMatch(BlockBase.BlockData::l)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.bm()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.i(deltaMovement.c((double)0.99f));
            this.bf();
            this.a_(d2, d1, d22);
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        Entity entity = this.p();
        if (entity instanceof EntityLiving) {
            WorldServer serverLevel;
            EntityLiving livingEntity = (EntityLiving)entity;
            Entity entity2 = result.a();
            DamageSource damageSource = this.dW().b((Entity)this, livingEntity);
            World world = this.dV();
            if (world instanceof WorldServer && entity2.a(serverLevel = (WorldServer)world, damageSource, 1.0f)) {
                EnchantmentManager.a(serverLevel, entity2, damageSource);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        super.a(result);
        if (!this.dV().C) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        double xa = packet.j();
        double ya = packet.k();
        double za = packet.l();
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = 0.4 + 0.1 * (double)i2;
            this.dV().a(Particles.aj, this.dA(), this.dC(), this.dG(), xa * d2, ya, za * d2);
        }
        this.n(xa, ya, za);
    }
}

