/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> a = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<OptionalInt> b = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.v);
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.k);
    public int d;
    public int e;
    @Nullable
    public EntityLiving f;
    @Nullable
    public UUID spawningEntity;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> entityType, World level) {
        super((EntityTypes<? extends IProjectile>)entityType, level);
    }

    public EntityFireworks(World level, double x2, double y2, double z2, ItemStack stack) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.Z, level);
        this.d = 0;
        this.a_(x2, y2, z2);
        this.al.a(a, stack.v());
        int i2 = 1;
        Fireworks fireworks = stack.a(DataComponents.af);
        if (fireworks != null) {
            i2 += fireworks.a();
        }
        this.n(this.ae.a(0.0, 0.002297), 0.05, this.ae.a(0.0, 0.002297));
        this.e = 10 * i2 + this.ae.a(6) + this.ae.a(7);
    }

    public EntityFireworks(World level, @Nullable Entity shooter, double x2, double y2, double z2, ItemStack stack) {
        this(level, x2, y2, z2, stack);
        this.c(shooter);
    }

    public EntityFireworks(World level, ItemStack stack, EntityLiving shooter) {
        this(level, shooter, shooter.dA(), shooter.dC(), shooter.dG(), stack);
        this.al.a(b, OptionalInt.of(shooter.ar()));
        this.f = shooter;
    }

    public EntityFireworks(World level, ItemStack stack, double x2, double y2, double z2, boolean shotAtAngle) {
        this(level, x2, y2, z2, stack);
        this.al.a(c, shotAtAngle);
    }

    public EntityFireworks(World level, ItemStack stack, Entity shooter, double x2, double y2, double z2, boolean shotAtAngle) {
        this(level, stack, x2, y2, z2, shotAtAngle);
        this.c(shooter);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(a, EntityFireworks.v());
        builder.a(b, OptionalInt.empty());
        builder.a(c, false);
    }

    @Override
    public boolean a(double distance) {
        return distance < 4096.0 && !this.t();
    }

    @Override
    public boolean k(double x2, double y2, double z2) {
        return super.k(x2, y2, z2) && !this.t();
    }

    @Override
    public void inactiveTick() {
        World world;
        ++this.d;
        if (this.d > this.e && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(serverLevel);
            }
        }
        super.inactiveTick();
    }

    @Override
    public void h() {
        World world;
        MovingObjectPosition hitResultOnMoveVector;
        super.h();
        if (this.t()) {
            if (this.f == null) {
                this.al.a(b).ifPresent(target -> {
                    Entity entity = this.dV().a(target);
                    if (entity instanceof EntityLiving) {
                        this.f = (EntityLiving)entity;
                    }
                });
            }
            if (this.f != null) {
                if (this.f.fJ()) {
                    Vec3D lookAngle = this.f.bT();
                    double d2 = 1.5;
                    double d1 = 0.1;
                    Vec3D deltaMovement = this.f.dy();
                    this.f.i(deltaMovement.b(lookAngle.d * 0.1 + (lookAngle.d * 1.5 - deltaMovement.d) * 0.5, lookAngle.e * 0.1 + (lookAngle.e * 1.5 - deltaMovement.e) * 0.5, lookAngle.f * 0.1 + (lookAngle.f * 1.5 - deltaMovement.f) * 0.5));
                    handHoldingItemAngle = this.f.a(Items.vt);
                } else {
                    handHoldingItemAngle = Vec3D.c;
                }
                this.a_(this.f.dA() + handHoldingItemAngle.d, this.f.dC() + handHoldingItemAngle.e, this.f.dG() + handHoldingItemAngle.f);
                this.i(this.f.dy());
            }
            hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b);
        } else {
            if (!this.m()) {
                double d2 = this.P ? 1.0 : 1.15;
                this.i(this.dy().d(d2, 1.0, d2).b(0.0, 0.04, 0.0));
            }
            handHoldingItemAngle = this.dy();
            hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b);
            this.a(EnumMoveType.a, handHoldingItemAngle);
            this.aK();
            this.i(handHoldingItemAngle);
        }
        if (!this.ad && this.bL() && hitResultOnMoveVector.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
            this.ar = true;
        }
        this.F();
        if (this.d == 0 && !this.bb()) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.jp, SoundCategory.i, 3.0f, 1.0f);
        }
        ++this.d;
        if (this.dV().C && this.d % 2 < 2) {
            this.dV().a(Particles.D, this.dA(), this.dC(), this.dG(), this.ae.k() * 0.05, -this.dy().e * 0.5, this.ae.k() * 0.05);
        }
        if (this.d > this.e && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(serverLevel);
            }
        }
    }

    private void b(WorldServer level) {
        level.a((Entity)this, (byte)17);
        this.a(GameEvent.w, this.p());
        this.e(level);
        this.discard(EntityRemoveEvent.Cause.EXPLODE);
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(serverLevel);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        BlockPosition blockPos = new BlockPosition(result.b());
        this.dV().a_(blockPos).a(this.dV(), blockPos, (Entity)this);
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.s() && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(serverLevel);
            }
        }
        super.a(result);
    }

    private boolean s() {
        return !this.u().isEmpty();
    }

    private void e(WorldServer level) {
        float f2 = 0.0f;
        List<FireworkExplosion> explosions = this.u();
        if (!explosions.isEmpty()) {
            f2 = 5.0f + (float)(explosions.size() * 2);
        }
        if (f2 > 0.0f) {
            if (this.f != null) {
                this.f.a(level, this.dW().a(this, this.p()), 5.0f + (float)(explosions.size() * 2));
            }
            double d2 = 5.0;
            Vec3D vec3 = this.dt();
            for (EntityLiving livingEntity : this.dV().a(EntityLiving.class, this.cR().g(5.0))) {
                if (livingEntity == this.f || this.g(livingEntity) > 25.0) continue;
                boolean flag = false;
                for (int i2 = 0; i2 < 2; ++i2) {
                    Vec3D vec31 = new Vec3D(livingEntity.dA(), livingEntity.e(0.5 * (double)i2), livingEntity.dG());
                    MovingObjectPositionBlock hitResult = this.dV().a(new RayTrace(vec3, vec31, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                    if (((MovingObjectPosition)hitResult).d() != MovingObjectPosition.EnumMovingObjectType.a) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f2 * (float)Math.sqrt((5.0 - (double)this.f(livingEntity)) / 5.0);
                livingEntity.a(level, this.dW().a(this, this.p()), f1);
            }
        }
    }

    private boolean t() {
        return this.al.a(b).isPresent();
    }

    public boolean m() {
        return this.al.a(c);
    }

    @Override
    public void b(byte id) {
        if (id == 17 && this.dV().C) {
            Vec3D deltaMovement = this.dy();
            this.dV().a(this.dA(), this.dC(), this.dG(), deltaMovement.d, deltaMovement.e, deltaMovement.f, this.u());
        }
        super.b(id);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Life", this.d);
        compound.a("LifeTime", this.e);
        compound.a("FireworksItem", this.l().a(this.dX()));
        compound.a("ShotAtAngle", this.al.a(c));
        if (this.spawningEntity != null) {
            compound.a("SpawningEntity", this.spawningEntity);
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.d = compound.h("Life");
        this.e = compound.h("LifeTime");
        if (compound.b("FireworksItem", 10)) {
            this.al.a(a, ItemStack.a((HolderLookup.a)this.dX(), (NBTBase)compound.p("FireworksItem")).orElseGet(EntityFireworks::v));
        } else {
            this.al.a(a, EntityFireworks.v());
        }
        if (compound.e("ShotAtAngle")) {
            this.al.a(c, compound.q("ShotAtAngle"));
        }
        if (compound.b("SpawningEntity")) {
            this.spawningEntity = compound.a("SpawningEntity");
        }
    }

    private List<FireworkExplosion> u() {
        ItemStack itemStack = this.al.a(a);
        Fireworks fireworks = itemStack.a(DataComponents.af);
        return fireworks != null ? fireworks.b() : List.of();
    }

    @Override
    public ItemStack l() {
        return this.al.a(a);
    }

    @Override
    public boolean cB() {
        return false;
    }

    public static ItemStack v() {
        return new ItemStack(Items.vt);
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving entity, DamageSource damageSource) {
        double d2 = entity.dt().d - this.dt().d;
        double d1 = entity.dt().f - this.dt().f;
        return DoubleDoubleImmutablePair.of((double)d2, (double)d1);
    }
}

