/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class EntityArrow
extends IProjectile {
    private static final double d = 2.0;
    private static final int e = 7;
    private static final float f = 0.6f;
    private static final float g = 0.99f;
    private static final DataWatcherObject<Byte> h = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> i = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Boolean> j = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.k);
    private static final int k = 1;
    private static final int l = 2;
    @Nullable
    private IBlockData m;
    protected int a;
    public PickupStatus b = PickupStatus.a;
    public int c;
    public int n;
    private double o = 2.0;
    public SoundEffect p = this.s();
    @Nullable
    private IntOpenHashSet q;
    @Nullable
    private List<Entity> r;
    public ItemStack s = this.v();
    @Nullable
    public ItemStack t = null;

    protected EntityArrow(EntityTypes<? extends EntityArrow> entityType, World level) {
        super((EntityTypes<? extends IProjectile>)entityType, level);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entityType, double x2, double y2, double z2, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        this(entityType, x2, y2, z2, level, pickupItemStack, firedFromWeapon, null);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entityType, double x2, double y2, double z2, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, @Nullable EntityLiving ownerEntity) {
        this(entityType, level);
        this.c(ownerEntity);
        this.s = pickupItemStack.v();
        this.b(pickupItemStack.a(DataComponents.g));
        Unit unit = pickupItemStack.d(DataComponents.v);
        if (unit != null) {
            this.b = PickupStatus.c;
        }
        this.a_(x2, y2, z2);
        if (firedFromWeapon != null && level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (firedFromWeapon.f()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.t = firedFromWeapon.v();
            int piercingCount = EnchantmentManager.a(serverLevel, firedFromWeapon, this.s);
            if (piercingCount > 0) {
                this.a((byte)piercingCount);
            }
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entityType, EntityLiving owner, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        this(entityType, owner.dA(), owner.dE() - (double)0.1f, owner.dG(), level, pickupItemStack, firedFromWeapon, owner);
    }

    public void b(SoundEffect soundEvent) {
        this.p = soundEvent;
    }

    @Override
    public boolean a(double distance) {
        double d2 = this.cR().a() * 10.0;
        if (Double.isNaN(d2)) {
            d2 = 1.0;
        }
        return distance < (d2 *= 64.0 * EntityArrow.cK()) * d2;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(h, (byte)0);
        builder.a(i, (byte)0);
        builder.a(j, false);
    }

    @Override
    public void c(double x2, double y2, double z2, float velocity, float inaccuracy) {
        super.c(x2, y2, z2, velocity, inaccuracy);
        this.n = 0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yRot, float xRot, int steps) {
        this.a_(x2, y2, z2);
        this.b(yRot, xRot);
    }

    @Override
    public void l(double x2, double y2, double z2) {
        super.l(x2, y2, z2);
        this.n = 0;
        if (this.l() && MathHelper.f(x2, y2, z2) > 0.0) {
            this.a(false);
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (!this.ak && this.c <= 0 && key.equals(j) && this.l()) {
            this.c = 7;
        }
    }

    @Override
    public void h() {
        VoxelShape collisionShape;
        boolean flag = !this.B();
        Vec3D deltaMovement = this.dy();
        BlockPosition blockPos = this.dv();
        IBlockData blockState = this.dV().a_(blockPos);
        if (!blockState.l() && flag && !(collisionShape = blockState.g(this.dV(), blockPos)).c()) {
            Vec3D vec3 = this.dt();
            for (AxisAlignedBB aabb : collisionShape.e()) {
                if (!aabb.a(blockPos).d(vec3)) continue;
                this.a(true);
                break;
            }
        }
        if (this.c > 0) {
            --this.c;
        }
        if (this.bk() || blockState.a(Blocks.rr)) {
            this.aH();
        }
        if (this.l() && flag) {
            if (!this.dV().B_()) {
                if (this.m != blockState && this.D()) {
                    this.G();
                } else {
                    this.m();
                }
            }
            ++this.a;
            if (this.bL()) {
                this.aK();
            }
        } else {
            if (this.af > 200) {
                this.m();
            }
            this.a = 0;
            Vec3D vec31 = this.dt();
            if (this.bj()) {
                this.b(this.A());
                this.a(vec31);
            }
            if (this.y()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.dV().a(Particles.f, vec31.d + deltaMovement.d * (double)i2 / 4.0, vec31.e + deltaMovement.e * (double)i2 / 4.0, vec31.f + deltaMovement.f * (double)i2 / 4.0, -deltaMovement.d, -deltaMovement.e + 0.2, -deltaMovement.f);
                }
            }
            float f2 = !flag ? (float)(MathHelper.d(-deltaMovement.d, -deltaMovement.f) * 180.0 / 3.1415927410125732) : (float)(MathHelper.d(deltaMovement.d, deltaMovement.f) * 180.0 / 3.1415927410125732);
            float f1 = (float)(MathHelper.d(deltaMovement.e, deltaMovement.i()) * 180.0 / 3.1415927410125732);
            this.w(EntityArrow.f(this.dN(), f1));
            this.v(EntityArrow.f(this.dL(), f2));
            if (flag) {
                MovingObjectPositionBlock blockHitResult = this.dV().b(new RayTrace(vec31, vec31.e(deltaMovement), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                this.b(blockHitResult);
            } else {
                this.b(vec31.e(deltaMovement));
                this.aK();
            }
            if (!this.bj()) {
                this.b(0.99f);
            }
            if (flag && !this.l()) {
                this.bf();
            }
            super.h();
        }
    }

    private void b(MovingObjectPositionBlock hitResult) {
        while (this.bL()) {
            Vec3D vec3 = this.dt();
            MovingObjectPositionEntity entityHitResult = this.c(vec3, hitResult.g());
            Vec3D location = ((MovingObjectPosition)Objects.requireNonNullElse(entityHitResult, hitResult)).g();
            this.b(location);
            this.a(vec3, location);
            if (this.as != null && this.as.e()) {
                this.bW();
            }
            if (entityHitResult == null) {
                if (!this.bL() || hitResult.d() == MovingObjectPosition.EnumMovingObjectType.a) break;
                this.preHitTargetOrDeflectSelf(hitResult);
                this.ar = true;
                break;
            }
            if (!this.bL() || this.ad) continue;
            ProjectileDeflection projectileDeflection = this.preHitTargetOrDeflectSelf(entityHitResult);
            this.ar = true;
            if (this.z() > 0 && projectileDeflection == ProjectileDeflection.a) continue;
        }
    }

    private void b(float intertia) {
        Vec3D deltaMovement = this.dy();
        this.i(deltaMovement.c((double)intertia));
    }

    private void a(Vec3D pos) {
        Vec3D deltaMovement = this.dy();
        for (int i2 = 0; i2 < 4; ++i2) {
            float f2 = 0.25f;
            this.dV().a(Particles.d, pos.d - deltaMovement.d * 0.25, pos.e - deltaMovement.e * 0.25, pos.f - deltaMovement.f * 0.25, deltaMovement.d, deltaMovement.e, deltaMovement.f);
        }
    }

    @Override
    public ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition hitResult) {
        if (hitResult instanceof MovingObjectPositionEntity) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)hitResult;
            if (this.hitCancelled && this.z() > 0) {
                if (this.q == null) {
                    this.q = new IntOpenHashSet(5);
                }
                this.q.add(entityHitResult.a().ar());
            }
        }
        return super.preHitTargetOrDeflectSelf(hitResult);
    }

    @Override
    protected double bd() {
        return 0.05;
    }

    private boolean D() {
        return this.l() && this.dV().b(new AxisAlignedBB(this.dt(), this.dt()).g(0.06));
    }

    private void G() {
        this.a(false);
        Vec3D deltaMovement = this.dy();
        this.i(deltaMovement.d(this.ae.i() * 0.2f, this.ae.i() * 0.2f, this.ae.i() * 0.2f));
        this.n = 0;
    }

    public boolean l() {
        return this.al.a(j);
    }

    protected void a(boolean inGround) {
        this.al.a(j, inGround);
    }

    @Override
    public void a(EnumMoveType type, Vec3D pos) {
        super.a(type, pos);
        if (type != EnumMoveType.a && this.D()) {
            this.G();
        }
    }

    protected void m() {
        ++this.n;
        if (this.n >= (this.b == PickupStatus.c ? this.dV().paperConfig().entities.spawning.creativeArrowDespawnRate.value() : (this.b == PickupStatus.a ? this.dV().paperConfig().entities.spawning.nonPlayerArrowDespawnRate.value() : (this instanceof EntityThrownTrident ? this.dV().spigotConfig.tridentDespawnRate : this.dV().spigotConfig.arrowDespawnRate)))) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    private void H() {
        if (this.r != null) {
            this.r.clear();
        }
        if (this.q != null) {
            this.q.clear();
        }
    }

    @Override
    protected void b(Item item) {
        this.t = null;
    }

    @Override
    public void m(boolean downwards) {
        if (!this.l()) {
            super.m(downwards);
        }
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        if (!this.l()) {
            super.push(x2, y2, z2, pushingEntity);
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        World world;
        super.a(result);
        Entity entity = result.a();
        float f2 = (float)this.dy().g();
        double d2 = this.o;
        Entity owner = this.p();
        DamageSource damageSource = this.dW().a(this, owner != null ? owner : this);
        if (this.dZ() != null && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            d2 = EnchantmentManager.a(serverLevel, this.dZ(), entity, damageSource, (float)d2);
        }
        int ceil = MathHelper.c(MathHelper.a((double)f2 * d2, 0.0, 2.147483647E9));
        if (this.z() > 0) {
            if (this.q == null) {
                this.q = new IntOpenHashSet(5);
            }
            if (this.r == null) {
                this.r = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.q.size() >= this.z() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.q.add(entity.ar());
        }
        if (this.y()) {
            long l2 = this.ae.a(ceil / 2 + 2);
            ceil = (int)Math.min(l2 + (long)ceil, Integer.MAX_VALUE);
        }
        if (owner instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)owner;
            livingEntity.B(entity);
        }
        if (this.y()) {
            damageSource = damageSource.critical();
        }
        boolean flag = entity.aq() == EntityTypes.N;
        int remainingFireTicks = entity.aG();
        if (this.bY() && !flag) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.igniteForSeconds(combustEvent.getDuration(), false);
            }
        }
        if (entity.b(damageSource, (float)ceil)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity1 = (EntityLiving)entity;
                if (!this.dV().C && this.z() <= 0) {
                    livingEntity1.o(livingEntity1.eU() + 1);
                }
                this.a(livingEntity1, damageSource);
                World world2 = this.dV();
                if (world2 instanceof WorldServer) {
                    WorldServer serverLevel1 = (WorldServer)world2;
                    EnchantmentManager.a(serverLevel1, (Entity)livingEntity1, damageSource, this.dZ());
                }
                this.a(livingEntity1);
                if (livingEntity1 != owner && livingEntity1 instanceof EntityHuman && owner instanceof EntityPlayer && !this.bb()) {
                    ((EntityPlayer)owner).f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, 0.0f));
                }
                if (!entity.bL() && this.r != null) {
                    this.r.add(livingEntity1);
                }
                if (!this.dV().C && owner instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)owner;
                    if (this.r != null) {
                        CriterionTriggers.H.a(serverPlayer, this.r, this.t);
                    } else if (!entity.bL()) {
                        CriterionTriggers.H.a(serverPlayer, List.of(entity), this.t);
                    }
                }
            }
            this.a(this.p, 1.0f, 1.2f / (this.ae.i() * 0.2f + 0.9f));
            if (this.z() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else {
            entity.h(remainingFireTicks);
            this.a(ProjectileDeflection.b, entity, this.p(), false);
            this.i(this.dy().c(0.2));
            World world3 = this.dV();
            if (world3 instanceof WorldServer) {
                WorldServer serverLevel2 = (WorldServer)world3;
                if (this.dy().h() < 1.0E-7) {
                    if (this.b == PickupStatus.b) {
                        this.a(serverLevel2, this.u(), 0.1f);
                    }
                    this.discard(EntityRemoveEvent.Cause.HIT);
                }
            }
        }
    }

    protected void a(EntityLiving entity, DamageSource damageSource) {
        float f2;
        World world;
        if (this.t != null && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            f2 = EnchantmentManager.d(serverLevel, this.t, entity, damageSource, 0.0f);
        } else {
            f2 = 0.0f;
        }
        double d2 = f2;
        if (d2 > 0.0) {
            double max = Math.max(0.0, 1.0 - entity.h(GenericAttributes.p));
            Vec3D vec3 = this.dy().d(1.0, 0.0, 1.0).d().c(d2 * 0.6 * max);
            if (vec3.h() > 0.0) {
                entity.push(vec3.d, 0.1, vec3.f, this);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        this.m = this.dV().a_(result.b());
        super.a(result);
        ItemStack weaponItem = this.dZ();
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (weaponItem != null) {
                this.a(serverLevel, result, weaponItem);
            }
        }
        Vec3D deltaMovement = this.dy();
        Vec3D vec3 = new Vec3D(Math.signum(deltaMovement.d), Math.signum(deltaMovement.e), Math.signum(deltaMovement.f));
        Vec3D vec31 = vec3.c((double)0.05f);
        this.b(this.dt().d(vec31));
        this.i(Vec3D.c);
        this.a(this.t(), 1.0f, 1.2f / (this.ae.i() * 0.2f + 0.9f));
        this.a(true);
        this.c = 7;
        this.b(false);
        this.a((byte)0);
        this.b(SoundEffects.aE);
        this.H();
    }

    protected void a(WorldServer level, MovingObjectPositionBlock hitResult, ItemStack stack) {
        EntityLiving livingEntity;
        Vec3D vec3 = hitResult.b().a(hitResult.g());
        Entity entity = this.p();
        EnchantmentManager.a(level, stack, entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : null, this, null, vec3, level.a_(hitResult.b()), item -> {
            this.t = null;
        });
    }

    @Override
    public ItemStack dZ() {
        return this.t;
    }

    protected SoundEffect s() {
        return SoundEffects.aE;
    }

    protected final SoundEffect t() {
        return this.p;
    }

    protected void a(EntityLiving target) {
    }

    @Nullable
    protected MovingObjectPositionEntity c(Vec3D startVec, Vec3D endVec) {
        return ProjectileHelper.a(this.dV(), this, startVec, endVec, this.cR().b(this.dy()).g(1.0), this::b);
    }

    @Override
    protected boolean b(Entity target) {
        EntityHuman player;
        Entity entity;
        return !(target instanceof EntityHuman && (entity = this.p()) instanceof EntityHuman && !(player = (EntityHuman)entity).a((EntityHuman)target) || !super.b(target) || this.q != null && this.q.contains(target.ar()));
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("life", (short)this.n);
        if (this.m != null) {
            compound.a("inBlockState", GameProfileSerializer.a(this.m));
        }
        compound.a("shake", (byte)this.c);
        compound.a("inGround", this.l());
        compound.a("pickup", (byte)this.b.ordinal());
        compound.a("damage", this.o);
        compound.a("crit", this.y());
        compound.a("PierceLevel", this.z());
        compound.a("SoundEvent", BuiltInRegistries.b.b(this.p).toString());
        compound.a("item", this.s.a(this.dX()));
        if (this.t != null) {
            compound.a("weapon", this.t.b(this.dX(), new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.n = compound.g("life");
        if (compound.b("inBlockState", 10)) {
            this.m = GameProfileSerializer.a(this.dV().a(Registries.f), compound.p("inBlockState"));
        }
        this.c = compound.f("shake") & 0xFF;
        this.a(compound.q("inGround"));
        if (compound.b("damage", 99)) {
            this.o = compound.k("damage");
        }
        this.b = PickupStatus.a(compound.f("pickup"));
        this.b(compound.q("crit"));
        this.a(compound.f("PierceLevel"));
        if (compound.b("SoundEvent", 8)) {
            this.p = BuiltInRegistries.b.b(MinecraftKey.c(compound.l("SoundEvent"))).orElse(this.s());
        }
        if (compound.b("item", 10)) {
            this.a(ItemStack.a((HolderLookup.a)this.dX(), (NBTBase)compound.p("item")).orElse(this.v()));
        } else {
            this.a(this.v());
        }
        this.t = compound.b("weapon", 10) ? (ItemStack)ItemStack.a((HolderLookup.a)this.dX(), (NBTBase)compound.p("weapon")).orElse(null) : null;
    }

    @Override
    public void c(@Nullable Entity entity) {
        this.setOwner(entity, true);
    }

    public void setOwner(@Nullable Entity entity, boolean resetPickup) {
        PickupStatus pickupStatus;
        super.c(entity);
        if (!resetPickup) {
            return;
        }
        Entity entity2 = entity;
        int n2 = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHuman.class, OminousItemSpawner.class}, (Object)entity2, n2)) {
                case 0: {
                    EntityHuman player = (EntityHuman)entity2;
                    if (this.b != PickupStatus.a) {
                        n2 = 1;
                        continue block4;
                    }
                    pickupStatus = PickupStatus.b;
                    break block4;
                }
                case 1: {
                    OminousItemSpawner ominousItemSpawner = (OminousItemSpawner)entity2;
                    pickupStatus = PickupStatus.a;
                    break block4;
                }
                default: {
                    pickupStatus = this.b;
                    break block4;
                }
            }
            break;
        }
        this.b = pickupStatus;
    }

    @Override
    public void a_(EntityHuman entity) {
        if (!this.dV().C && (this.l() || this.B()) && this.c <= 0) {
            ItemStack itemstack = this.u();
            if (this.b == PickupStatus.b && !itemstack.f() && entity.gi().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.dV(), this.dA(), this.dC(), this.dG(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)entity.getBukkitEntity(), (org.bukkit.entity.Item)item.getBukkitEntity(), (AbstractArrow)this.getBukkitEntity());
                this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = item.l();
            }
            if (this.b == PickupStatus.b && entity.gi().f(itemstack) || this.b == PickupStatus.c && entity.gj().d) {
                entity.a((Entity)this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean a(EntityHuman player) {
        return switch (this.b.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 1 -> player.gi().f(this.u());
            case 2 -> player.fV();
        };
    }

    public ItemStack u() {
        return this.s.v();
    }

    protected abstract ItemStack v();

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    public ItemStack w() {
        return this.s;
    }

    public void h(double baseDamage) {
        this.o = baseDamage;
    }

    public double x() {
        return this.o;
    }

    @Override
    public boolean cB() {
        return this.aq().a(TagsEntity.H);
    }

    public void b(boolean critArrow) {
        this.a(1, critArrow);
    }

    public void a(byte pierceLevel) {
        this.al.a(i, pierceLevel);
    }

    private void a(int id, boolean value) {
        byte b2 = this.al.a(h);
        if (value) {
            this.al.a(h, (byte)(b2 | id));
        } else {
            this.al.a(h, (byte)(b2 & ~id));
        }
    }

    public void setPickupItemStackPublic(ItemStack pickupItemStack) {
        this.a(pickupItemStack);
    }

    protected void a(ItemStack pickupItemStack) {
        this.s = !pickupItemStack.f() ? pickupItemStack : this.v();
    }

    public boolean y() {
        byte b2 = this.al.a(h);
        return (b2 & 1) != 0;
    }

    public byte z() {
        return this.al.a(i);
    }

    public void a(float velocity) {
        this.h((double)(velocity * 2.0f) + this.ae.a((double)this.dV().am().a() * 0.11, 0.57425));
    }

    protected float A() {
        return 0.6f;
    }

    public void r(boolean noPhysics) {
        this.ad = noPhysics;
        this.a(2, noPhysics);
    }

    public boolean B() {
        return !this.dV().C ? this.ad : (this.al.a(h) & 2) != 0;
    }

    @Override
    public boolean bH() {
        return super.bH() && !this.l();
    }

    @Override
    public SlotAccess a_(int slot) {
        return slot == 0 ? SlotAccess.a(this::w, this::a) : super.a_(slot);
    }

    @Override
    protected boolean C() {
        return true;
    }

    public static final class PickupStatus
    extends Enum<PickupStatus> {
        public static final /* enum */ PickupStatus a = new PickupStatus();
        public static final /* enum */ PickupStatus b = new PickupStatus();
        public static final /* enum */ PickupStatus c = new PickupStatus();
        private static final /* synthetic */ PickupStatus[] d;

        public static PickupStatus[] values() {
            return (PickupStatus[])d.clone();
        }

        public static PickupStatus valueOf(String name) {
            return Enum.valueOf(PickupStatus.class, name);
        }

        public static PickupStatus a(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }

        private static /* synthetic */ PickupStatus[] a() {
            return new PickupStatus[]{a, b, c};
        }

        static {
            d = PickupStatus.a();
        }
    }
}

