/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.ImmutableList;
import io.papermc.paper.inventory.recipe.ItemOrExact;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.ClientboundSetPlayerInventoryPacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class PlayerInventory
implements IInventory,
INamableTileEntity {
    public static final int b = 5;
    public static final int c = 36;
    public static final int d = 9;
    public static final int e = 40;
    public static final int f = -1;
    public final NonNullList<ItemStack> g = NonNullList.a(36, ItemStack.j);
    public final NonNullList<ItemStack> h = NonNullList.a(4, ItemStack.j);
    public final NonNullList<ItemStack> i = NonNullList.a(1, ItemStack.j);
    public final List<NonNullList<ItemStack>> l = ImmutableList.of(this.g, this.h, this.i);
    public int j;
    public final EntityHuman k;
    private int m;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        ArrayList<ItemStack> combined = new ArrayList<ItemStack>(this.g.size() + this.h.size() + this.i.size());
        for (List list : this.l) {
            combined.addAll(list);
        }
        return combined;
    }

    public List<ItemStack> getArmorContents() {
        return this.h;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.k.getBukkitEntity();
    }

    @Override
    public int an_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.k.getBukkitEntity().getLocation();
    }

    public PlayerInventory(EntityHuman player) {
        this.k = player;
    }

    public ItemStack f() {
        return PlayerInventory.d(this.j) ? this.g.get(this.j) : ItemStack.j;
    }

    public static int g() {
        return 9;
    }

    private boolean a(ItemStack destination, ItemStack origin) {
        return !destination.f() && destination.l() && destination.M() < this.e_(destination) && ItemStack.c(destination, origin);
    }

    public int canHold(ItemStack itemStack) {
        int remains = itemStack.M();
        for (int slot = 0; slot < this.g.size(); ++slot) {
            ItemStack itemInSlot = this.a(slot);
            if (itemInSlot.f()) {
                return itemStack.M();
            }
            if (this.a(itemInSlot, itemStack)) {
                remains -= (itemInSlot.k() < this.an_() ? itemInSlot.k() : this.an_()) - itemInSlot.M();
            }
            if (remains > 0) continue;
            return itemStack.M();
        }
        ItemStack itemInOffhand = this.a(this.g.size() + this.h.size());
        if (this.a(itemInOffhand, itemStack)) {
            remains -= (itemInOffhand.k() < this.an_() ? itemInOffhand.k() : this.an_()) - itemInOffhand.M();
        }
        if (remains <= 0) {
            return itemStack.M();
        }
        return itemStack.M() - remains;
    }

    public int h() {
        for (int i2 = 0; i2 < this.g.size(); ++i2) {
            if (!this.g.get(i2).f()) continue;
            return i2;
        }
        return -1;
    }

    public void addAndPickItem(ItemStack stack, int targetSlot) {
        int freeSlot;
        this.j = targetSlot;
        this.j = this.i();
        if (!this.g.get(this.j).f() && (freeSlot = this.h()) != -1) {
            this.g.set(freeSlot, this.g.get(this.j));
        }
        this.g.set(this.j, stack);
    }

    public void pickSlot(int index, int targetSlot) {
        this.j = targetSlot;
        this.j = this.i();
        ItemStack itemStack = this.g.get(this.j);
        this.g.set(this.j, this.g.get(index));
        this.g.set(index, itemStack);
    }

    public static boolean d(int index) {
        return index >= 0 && index < 9;
    }

    public int c(ItemStack stack) {
        for (int i2 = 0; i2 < this.g.size(); ++i2) {
            if (this.g.get(i2).f() || !ItemStack.c(stack, this.g.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    public static boolean d(ItemStack stack) {
        return !stack.n() && !stack.F() && !stack.b(DataComponents.g);
    }

    public int findSlotMatchingCraftingIngredient(ItemOrExact item, ItemStack stack) {
        for (int i2 = 0; i2 < this.g.size(); ++i2) {
            ItemStack itemStack = this.g.get(i2);
            if (itemStack.f() || !item.matches(itemStack) || item instanceof ItemOrExact.Item && !PlayerInventory.d(itemStack) || !stack.f() && !ItemStack.c(stack, itemStack)) continue;
            return i2;
        }
        return -1;
    }

    public int i() {
        int i1;
        for (int i2 = 0; i2 < 9; ++i2) {
            i1 = (this.j + i2) % 9;
            if (!this.g.get(i1).f()) continue;
            return i1;
        }
        for (int ix = 0; ix < 9; ++ix) {
            i1 = (this.j + ix) % 9;
            if (this.g.get(i1).F()) continue;
            return i1;
        }
        return this.j;
    }

    public void e(int selectedHotbarSlot) {
        this.j = selectedHotbarSlot;
    }

    public int a(Predicate<ItemStack> stackPredicate, int maxCount, IInventory inventory) {
        int i2 = 0;
        boolean flag = maxCount == 0;
        i2 += ContainerUtil.a(this, stackPredicate, maxCount - i2, flag);
        i2 += ContainerUtil.a(inventory, stackPredicate, maxCount - i2, flag);
        ItemStack carried = this.k.cd.g();
        i2 += ContainerUtil.a(carried, stackPredicate, maxCount - i2, flag);
        if (carried.f()) {
            this.k.cd.b(ItemStack.j);
        }
        return i2;
    }

    private int j(ItemStack stack) {
        int slotWithRemainingSpace = this.e(stack);
        if (slotWithRemainingSpace == -1) {
            slotWithRemainingSpace = this.h();
        }
        return slotWithRemainingSpace == -1 ? stack.M() : this.d(slotWithRemainingSpace, stack);
    }

    private int d(int slot, ItemStack stack) {
        int i2;
        int min;
        int count = stack.M();
        ItemStack item = this.a(slot);
        if (item.f()) {
            item = stack.c(0);
            this.a(slot, item);
        }
        if ((min = Math.min(count, i2 = this.e_(item) - item.M())) == 0) {
            return count;
        }
        item.g(min);
        item.d(5);
        return count -= min;
    }

    public int e(ItemStack stack) {
        if (this.a(this.a(this.j), stack)) {
            return this.j;
        }
        if (this.a(this.a(40), stack)) {
            return 40;
        }
        for (int i2 = 0; i2 < this.g.size(); ++i2) {
            if (!this.a(this.g.get(i2), stack)) continue;
            return i2;
        }
        return -1;
    }

    public void j() {
        for (NonNullList<ItemStack> list : this.l) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2).f()) continue;
                list.get(i2).a(this.k.dV(), (Entity)this.k, i2, this.j == i2);
            }
        }
    }

    public boolean f(ItemStack stack) {
        return this.c(-1, stack);
    }

    public boolean c(int slot, ItemStack stack) {
        if (stack.f()) {
            return false;
        }
        try {
            int count;
            if (stack.n()) {
                if (slot == -1) {
                    slot = this.h();
                }
                if (slot >= 0) {
                    this.g.set(slot, stack.g());
                    this.g.get(slot).d(5);
                    return true;
                }
                if (this.k.fV()) {
                    stack.e(0);
                    return true;
                }
                return false;
            }
            do {
                count = stack.M();
                if (slot == -1) {
                    stack.e(this.j(stack));
                    continue;
                }
                stack.e(this.d(slot, stack));
            } while (!stack.f() && stack.M() < count);
            if (stack.M() == count && this.k.fV()) {
                stack.e(0);
                return true;
            }
            return stack.M() < count;
        }
        catch (Throwable var6) {
            CrashReport crashReport = CrashReport.a(var6, "Adding item to inventory");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Item being added");
            crashReportCategory.a("Item ID", Item.a(stack.h()));
            crashReportCategory.a("Item data", stack.o());
            crashReportCategory.a("Item name", () -> stack.y().getString());
            throw new ReportedException(crashReport);
        }
    }

    public void g(ItemStack stack) {
        this.a(stack, true);
    }

    public void a(ItemStack stack, boolean sendPacket) {
        while (!stack.f()) {
            EntityHuman entityHuman;
            int slotWithRemainingSpace = this.e(stack);
            if (slotWithRemainingSpace == -1) {
                slotWithRemainingSpace = this.h();
            }
            if (slotWithRemainingSpace == -1) {
                this.k.a(stack, false);
                break;
            }
            int i2 = stack.k() - this.a(slotWithRemainingSpace).M();
            if (!this.c(slotWithRemainingSpace, stack.a(i2)) || !sendPacket || !((entityHuman = this.k) instanceof EntityPlayer)) continue;
            EntityPlayer serverPlayer = (EntityPlayer)entityHuman;
            serverPlayer.f.b(this.f(slotWithRemainingSpace));
        }
    }

    public ClientboundSetPlayerInventoryPacket f(int slot) {
        return new ClientboundSetPlayerInventoryPacket(slot, this.a(slot).v());
    }

    @Override
    public ItemStack a(int index, int count) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> list1 : this.l) {
            if (index < list1.size()) {
                list = list1;
                break;
            }
            index -= list1.size();
        }
        return list != null && !((ItemStack)list.get(index)).f() ? ContainerUtil.a(list, index, count) : ItemStack.j;
    }

    public void h(ItemStack stack) {
        block0: for (NonNullList<ItemStack> list : this.l) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2) != stack) continue;
                list.set(i2, ItemStack.j);
                continue block0;
            }
        }
    }

    @Override
    public ItemStack b(int index) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> list1 : this.l) {
            if (index < list1.size()) {
                list = list1;
                break;
            }
            index -= list1.size();
        }
        if (list != null && !((ItemStack)list.get(index)).f()) {
            ItemStack itemStack = list.get(index);
            list.set(index, ItemStack.j);
            return itemStack;
        }
        return ItemStack.j;
    }

    @Override
    public void a(int index, ItemStack stack) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> list1 : this.l) {
            if (index < list1.size()) {
                list = list1;
                break;
            }
            index -= list1.size();
        }
        if (list != null) {
            list.set(index, stack);
        }
    }

    public float a(IBlockData state) {
        return this.g.get(this.j).a(state);
    }

    public NBTTagList a(NBTTagList listTag) {
        NBTTagCompound compoundTag;
        for (int i2 = 0; i2 < this.g.size(); ++i2) {
            if (this.g.get(i2).f()) continue;
            compoundTag = new NBTTagCompound();
            compoundTag.a("Slot", (byte)i2);
            listTag.add(this.g.get(i2).b(this.k.dX(), compoundTag));
        }
        for (int ix = 0; ix < this.h.size(); ++ix) {
            if (this.h.get(ix).f()) continue;
            compoundTag = new NBTTagCompound();
            compoundTag.a("Slot", (byte)(ix + 100));
            listTag.add(this.h.get(ix).b(this.k.dX(), compoundTag));
        }
        for (int ixx = 0; ixx < this.i.size(); ++ixx) {
            if (this.i.get(ixx).f()) continue;
            compoundTag = new NBTTagCompound();
            compoundTag.a("Slot", (byte)(ixx + 150));
            listTag.add(this.i.get(ixx).b(this.k.dX(), compoundTag));
        }
        return listTag;
    }

    public void b(NBTTagList listTag) {
        this.g.clear();
        this.h.clear();
        this.i.clear();
        for (int i2 = 0; i2 < listTag.size(); ++i2) {
            NBTTagCompound compound = listTag.a(i2);
            int i1 = compound.f("Slot") & 0xFF;
            ItemStack itemStack = ItemStack.a((HolderLookup.a)this.k.dX(), (NBTBase)compound).orElse(ItemStack.j);
            if (i1 >= 0 && i1 < this.g.size()) {
                this.g.set(i1, itemStack);
                continue;
            }
            if (i1 >= 100 && i1 < this.h.size() + 100) {
                this.h.set(i1 - 100, itemStack);
                continue;
            }
            if (i1 < 150 || i1 >= this.i.size() + 150) continue;
            this.i.set(i1 - 150, itemStack);
        }
    }

    @Override
    public int b() {
        return this.g.size() + this.h.size() + this.i.size();
    }

    @Override
    public boolean c() {
        for (ItemStack itemStack : this.g) {
            if (itemStack.f()) continue;
            return false;
        }
        for (ItemStack itemStackx : this.h) {
            if (itemStackx.f()) continue;
            return false;
        }
        for (ItemStack itemStackxx : this.i) {
            if (itemStackxx.f()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack a(int index) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> list1 : this.l) {
            if (index < list1.size()) {
                list = list1;
                break;
            }
            index -= list1.size();
        }
        return list == null ? ItemStack.j : (ItemStack)list.get(index);
    }

    @Override
    public IChatBaseComponent al() {
        return IChatBaseComponent.c("container.inventory");
    }

    public ItemStack g(int slot) {
        return this.h.get(slot);
    }

    public void k() {
        for (List list : this.l) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ItemStack itemStack = (ItemStack)list.get(i2);
                if (itemStack.f()) continue;
                this.k.a(itemStack, true, false);
                list.set(i2, ItemStack.j);
            }
        }
    }

    @Override
    public void e() {
        ++this.m;
    }

    public int l() {
        return this.m;
    }

    @Override
    public boolean a(EntityHuman player) {
        return player.b((Entity)this.k, 4.0);
    }

    public boolean i(ItemStack stack) {
        for (List list : this.l) {
            for (ItemStack itemStack : list) {
                if (itemStack.f() || !ItemStack.c(itemStack, stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean a(TagKey<Item> tag) {
        for (List list : this.l) {
            for (ItemStack itemStack : list) {
                if (itemStack.f() || !itemStack.a(tag)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean b(Predicate<ItemStack> predicate) {
        for (List list : this.l) {
            for (ItemStack itemStack : list) {
                if (!predicate.test(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public void a(PlayerInventory playerInventory) {
        for (int i2 = 0; i2 < this.b(); ++i2) {
            this.a(i2, playerInventory.a(i2));
        }
        this.j = playerInventory.j;
    }

    @Override
    public void a() {
        for (List list : this.l) {
            list.clear();
        }
    }

    public void a(StackedItemContents contents) {
        for (ItemStack itemStack : this.g) {
            contents.a(itemStack);
        }
    }

    public ItemStack a(boolean removeStack) {
        ItemStack selected = this.f();
        return selected.f() ? ItemStack.j : this.a(this.j, removeStack ? selected.M() : 1);
    }
}

